/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.api.placed.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import org.betterx.wover.block.api.BlockHelper;
import org.betterx.wover.feature.impl.placed.modifiers.PlacementModifiersImpl;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class EveryLayer
extends PlacementModifier {
    private static final EveryLayer INSTANCE = new EveryLayer(Integer.MIN_VALUE, Integer.MAX_VALUE, true);
    private static final EveryLayer INSTANCE_MIN_4 = new EveryLayer(4, Integer.MAX_VALUE, true);
    private static final EveryLayer UNDER_INSTANCE = new EveryLayer(Integer.MIN_VALUE, Integer.MAX_VALUE, false);
    private static final EveryLayer UNDER_INSTANCE_MIN_4 = new EveryLayer(4, Integer.MAX_VALUE, false);
    public static final MapCodec<EveryLayer> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("min", (Object)Integer.MIN_VALUE).forGetter(o -> o.minHeight), (App)Codec.INT.optionalFieldOf("max", (Object)Integer.MAX_VALUE).forGetter(o -> o.maxHeight), (App)Codec.BOOL.optionalFieldOf("top", (Object)true).forGetter(o -> o.onTop)).apply((Applicative)instance, EveryLayer::new));
    @ApiStatus.Internal
    public static final MapCodec<EveryLayer> CODEC_LEGACY_UNDER = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("min", (Object)Integer.MIN_VALUE).forGetter(o -> o.minHeight), (App)Codec.INT.optionalFieldOf("max", (Object)Integer.MAX_VALUE).forGetter(o -> o.maxHeight), (App)Codec.BOOL.optionalFieldOf("top", (Object)false).forGetter(o -> o.onTop)).apply((Applicative)instance, EveryLayer::new));
    private final int minHeight;
    private final int maxHeight;
    private final boolean onTop;

    private EveryLayer(int minHeight, int maxHeight, boolean onTop) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.onTop = onTop;
    }

    public static EveryLayer on() {
        return INSTANCE;
    }

    public static EveryLayer onTopMin4() {
        return INSTANCE_MIN_4;
    }

    public static EveryLayer onTopInRange(int minHeight, int maxHeight) {
        return new EveryLayer(minHeight, maxHeight, true);
    }

    public static EveryLayer underneath() {
        return UNDER_INSTANCE;
    }

    public static EveryLayer underneathMin4() {
        return UNDER_INSTANCE_MIN_4;
    }

    public static EveryLayer underneathInRange(int minHeight, int maxHeight) {
        return new EveryLayer(minHeight, maxHeight, false);
    }

    @NotNull
    public Stream<BlockPos> getPositions(PlacementContext ctx, RandomSource random, BlockPos pos) {
        int layerY;
        Stream.Builder<BlockPos> builder = Stream.builder();
        int z = pos.getZ();
        int x = pos.getX();
        int levelHeight = ctx.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z);
        int minLevelHeight = ctx.getMinBuildHeight();
        int y = Math.min(levelHeight, this.maxHeight);
        int minHeight = Math.max(minLevelHeight, this.minHeight);
        do {
            int n = layerY = this.onTop ? EveryLayer.findOnGroundYPosition(ctx, x, y, z, minHeight) : EveryLayer.findUnderGroundYPosition(ctx, x, y, z, minHeight);
            if (layerY == Integer.MAX_VALUE) continue;
            builder.add(new BlockPos(x, layerY, z));
            y = layerY - 1;
        } while (layerY != Integer.MAX_VALUE);
        return builder.build();
    }

    @NotNull
    public PlacementModifierType<EveryLayer> type() {
        return PlacementModifiersImpl.EVERY_LAYER;
    }

    private static int findOnGroundYPosition(PlacementContext ctx, int x, int startY, int z, int minHeight) {
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(x, startY, z);
        BlockState nowState = ctx.getBlockState((BlockPos)mPos);
        for (int y = startY; y >= minHeight + 1; --y) {
            mPos.setY(y - 1);
            BlockState belowState = ctx.getBlockState((BlockPos)mPos);
            if (BlockHelper.isTerrain((BlockState)belowState) && BlockHelper.isFreeOrFluid((BlockState)nowState) && !belowState.is(Blocks.BEDROCK)) {
                return mPos.getY() + 1;
            }
            nowState = belowState;
        }
        return Integer.MAX_VALUE;
    }

    private static int findUnderGroundYPosition(PlacementContext ctx, int x, int startY, int z, int minHeight) {
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(x, startY, z);
        BlockState nowState = ctx.getBlockState((BlockPos)mPos);
        for (int y = startY; y >= minHeight + 1; --y) {
            mPos.setY(y - 1);
            BlockState belowState = ctx.getBlockState((BlockPos)mPos);
            if (BlockHelper.isTerrain((BlockState)nowState) && BlockHelper.isFreeOrFluid((BlockState)belowState) && !nowState.is(Blocks.BEDROCK)) {
                return mPos.getY();
            }
            nowState = belowState;
        }
        return Integer.MAX_VALUE;
    }
}

