/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.api.configured;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import org.betterx.wover.feature.api.FeatureUtils;
import org.betterx.wover.feature.api.configured.configurators.FeatureConfigurator;
import org.betterx.wover.feature.impl.configured.FeatureConfiguratorImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfiguredFeatureKey<B extends FeatureConfigurator<?, ?>> {
    @NotNull
    public final ResourceKey<ConfiguredFeature<?, ?>> key;

    protected ConfiguredFeatureKey(@NotNull ResourceLocation id) {
        this(FeatureConfiguratorImpl.createKey(id));
    }

    protected ConfiguredFeatureKey(@NotNull ResourceKey<ConfiguredFeature<?, ?>> key) {
        this.key = key;
    }

    @Nullable
    public Holder<ConfiguredFeature<?, ?>> getHolder(@Nullable HolderGetter<ConfiguredFeature<?, ?>> getter) {
        return FeatureConfiguratorImpl.getHolder(getter, this.key);
    }

    @Nullable
    public Holder<ConfiguredFeature<?, ?>> getHolder(@NotNull BootstrapContext<?> context) {
        return this.getHolder(context.lookup(Registries.CONFIGURED_FEATURE));
    }

    @Nullable
    public Holder<ConfiguredFeature<?, ?>> getHolder(@NotNull RegistryAccess access) {
        return this.getHolder((HolderGetter<ConfiguredFeature<?, ?>>)access.lookupOrThrow(Registries.CONFIGURED_FEATURE));
    }

    public boolean placeInWorld(@NotNull WorldGenLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        return this.placeInWorld(level.registryAccess(), level, pos, random, null);
    }

    public boolean placeInWorld(@NotNull WorldGenLevel level, @NotNull BlockPos pos, @NotNull RandomSource random, @Nullable ChunkGenerator generator) {
        return this.placeInWorld(level.registryAccess(), level, pos, random, generator);
    }

    public boolean placeInWorld(@Nullable RegistryAccess access, @NotNull WorldGenLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (access == null) {
            return false;
        }
        Holder<ConfiguredFeature<?, ?>> holder = this.getHolder(access);
        if (holder != null) {
            return FeatureUtils.placeInWorld((ConfiguredFeature)holder.value(), level, pos, random, false);
        }
        return false;
    }

    public boolean placeInWorld(@Nullable RegistryAccess access, @NotNull WorldGenLevel level, @NotNull BlockPos pos, @NotNull RandomSource random, @Nullable ChunkGenerator generator) {
        if (access == null) {
            return false;
        }
        Holder<ConfiguredFeature<?, ?>> holder = this.getHolder(access);
        if (holder != null) {
            return FeatureUtils.placeInWorld((ConfiguredFeature)holder.value(), level, pos, random, generator, false);
        }
        return false;
    }

    public abstract B bootstrap(@NotNull BootstrapContext<ConfiguredFeature<?, ?>> var1);
}

