/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.core.impl.registry;

import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6903;
import net.minecraft.class_7877;
import net.minecraft.class_7891;
import org.betterx.wover.core.api.registry.DatapackRegistryBuilder;
import org.betterx.wover.core.api.registry.DatapackRegistryEntrypoint;
import org.betterx.wover.entrypoint.LibWoverCore;
import org.betterx.wover.util.PriorityLinkedList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class DatapackRegistryBuilderImpl {
    public static final int DEFAULT_PRIORITY = 1000;
    public static final int MAX_READONLY_PRIORITY = -1000;
    private static final PriorityLinkedList<Entry<?>> REGISTRIES = new PriorityLinkedList();
    private static boolean didInitEntrypoints = false;

    public static boolean isRegistered(class_2960 registryId) {
        return REGISTRIES.stream().filter(entry -> entry.definesRegistry()).anyMatch(entry -> entry.key.method_29177().equals((Object)registryId));
    }

    public static <T> void register(class_5321<? extends class_2378<T>> key, Consumer<class_7891<T>> bootstrap) {
        DatapackRegistryBuilderImpl.register(key, bootstrap, 1000);
    }

    public static <T> void register(class_5321<? extends class_2378<T>> key, Consumer<class_7891<T>> bootstrap, int priority) {
        LibWoverCore.C.log.debug("Adding dynamic registry bootstrap: " + String.valueOf(key.method_29177()));
        REGISTRIES.add(new Entry<T>(key, null, bootstrap), Math.max(-999, priority));
    }

    public static <T> void registerReadOnly(class_5321<? extends class_2378<T>> key, Consumer<class_7891<T>> bootstrap) {
        DatapackRegistryBuilderImpl.register(key, bootstrap, -1000);
    }

    public static <T> void registerReadOnly(class_5321<? extends class_2378<T>> key, Consumer<class_7891<T>> bootstrap, int priority) {
        DatapackRegistryBuilderImpl.register(key, bootstrap, Math.min(-1000, Integer.MIN_VALUE + priority));
    }

    public static <T> void register(class_5321<? extends class_2378<T>> key, Codec<T> elementCodec, Consumer<class_7891<T>> bootstrap) {
        DatapackRegistryBuilderImpl.register(key, elementCodec, 1000, bootstrap);
    }

    public static <T> void register(class_5321<? extends class_2378<T>> key, Codec<T> elementCodec, int priority, Consumer<class_7891<T>> bootstrap) {
        if (DatapackRegistryBuilderImpl.isRegistered(key.method_29177())) {
            throw new IllegalStateException("Registry with id " + String.valueOf(key.method_29177()) + " was already registered!");
        }
        LibWoverCore.C.log.debug("Adding dynamic registry: " + String.valueOf(key.method_29177()));
        REGISTRIES.add(new Entry<T>(key, elementCodec, bootstrap), priority);
    }

    public static void forEach(BiConsumer<class_5321<? extends class_2378<?>>, Codec<?>> consumer) {
        DatapackRegistryBuilderImpl.initEntrypoints();
        REGISTRIES.forEach(entry -> consumer.accept(entry.key, entry.elementCodec));
    }

    private static void initEntrypoints() {
        if (didInitEntrypoints) {
            return;
        }
        didInitEntrypoints = true;
        LibWoverCore.C.LOG.verbose("Processing wover.datapack.registry Entrypoints");
        FabricLoader.getInstance().getEntrypoints("wover.datapack.registry", DatapackRegistryEntrypoint.class).forEach(entrypoint -> {
            LibWoverCore.C.LOG.verbose("    - Processing Entrypoint: {}", entrypoint.getClass().getName());
            entrypoint.registerDatapackRegistries();
        });
    }

    @ApiStatus.Internal
    public static <E> void bootstrap(class_6903.class_7863 registryInfoLookup, class_5321<? extends class_2378<E>> resourceKey, class_2385<E> writableRegistry) {
        DatapackRegistryBuilderImpl.initEntrypoints();
        LibWoverCore.C.LOG.debug("Bootstrapping registry {}", resourceKey.method_29177());
        REGISTRIES.forEach(entry -> {
            if (entry.key.equals(resourceKey)) {
                LibWoverCore.C.LOG.debug("Calling custom Registry Bootstrap on {}", resourceKey.method_29177());
                entry.bootstrap.accept(entry.getContext(registryInfoLookup, writableRegistry));
            }
        });
    }

    @ApiStatus.Internal
    public static void bootstrap(BiConsumer<class_5321<? extends class_2378<?>>, class_7877.class_7882<? extends Object>> consumer) {
        LibWoverCore.C.LOG.verboseWarning("DID NOT bootstrap VanillaRegistries.");
    }

    private record Entry<T>(class_5321<? extends class_2378<T>> key, @Nullable Codec<T> elementCodec, Consumer<class_7891<T>> bootstrap) {
        public class_7891<T> getContext(class_6903.class_7863 registryInfoLookup, class_2385<T> registry) {
            return DatapackRegistryBuilder.makeContext(registryInfoLookup, registry);
        }

        public boolean definesRegistry() {
            return this.elementCodec != null;
        }
    }
}

