/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.core.impl.registry;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import org.betterx.wover.core.api.registry.OnElementLoad;
import org.betterx.wover.util.PriorityLinkedList;
import org.jetbrains.annotations.ApiStatus;

public class DatapackLoadElementImpl {
    public static final int DEFAULT_PRIORITY = 1000;
    public static final int MAX_READONLY_PRIORITY = -1000;
    private static final Map<class_5321<class_2378<?>>, PriorityLinkedList<OnElementLoad>> WATCHERS = new HashMap();

    public static <E> boolean isRegistered(class_5321<class_2378<E>> registryId) {
        return WATCHERS.containsKey(registryId);
    }

    public static <E, R extends class_2378<E>> PriorityLinkedList<OnElementLoad> getWatchers(class_5321<R> registryId) {
        class_5321<R> rKey = registryId;
        return WATCHERS.computeIfAbsent(rKey, k -> new PriorityLinkedList());
    }

    public static <E> void register(class_5321<class_2378<E>> registryKey, OnElementLoad<E> watcher) {
        DatapackLoadElementImpl.getWatchers(registryKey).add(watcher, 1000);
    }

    public static <E> void register(class_5321<class_2378<E>> registryKey, OnElementLoad<E> watcher, int priority) {
        DatapackLoadElementImpl.getWatchers(registryKey).add(watcher, Math.max(-999, priority));
    }

    @ApiStatus.Internal
    public static <E> void didLoadFromDatapack(class_5321<E> elementKey, E element) {
        if (DatapackLoadElementImpl.isRegistered(elementKey.method_58273())) {
            DatapackLoadElementImpl.getWatchers(elementKey.method_58273()).forEach(watcher -> watcher.didLoadFromDatapack(elementKey, element));
        }
    }
}

