/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.core.impl.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import org.betterx.wover.core.api.registry.CustomBootstrapContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomBootstrapContextImpl<T> {
    private static final Map<class_5321<class_2378<?>>, ContextData<?, ?>> CONTEXT_OBJECTS = new HashMap();

    @NotNull
    private static <T, C extends CustomBootstrapContext<T, C>> ContextData<T, C> getContextObject(class_5321<class_2378<T>> registryKey) {
        return CONTEXT_OBJECTS.computeIfAbsent(registryKey, key -> new ContextData());
    }

    @Nullable
    public static <B, T, C extends CustomBootstrapContext<T, C>> C initContext(@Nullable class_7891<B> lookupContext, @NotNull class_5321<class_2378<T>> registryKey, @NotNull Supplier<C> contextSupplier) {
        ContextData<T, C> contextObject = CustomBootstrapContextImpl.getContextObject(registryKey);
        if (lookupContext == null) {
            return contextObject.bootstrapContext;
        }
        class_7871 biomeGetter = lookupContext.method_46799(registryKey);
        if (biomeGetter != contextObject.lastGetter) {
            contextObject.lastGetter = biomeGetter;
            contextObject.bootstrapContext = (CustomBootstrapContext)contextSupplier.get();
            ((CustomBootstrapContext)contextObject.bootstrapContext).setLookupContext(lookupContext);
            ((CustomBootstrapContext)contextObject.bootstrapContext).onBootstrapContextChange(contextObject.bootstrapContext);
        } else {
            ((CustomBootstrapContext)contextObject.bootstrapContext).setLookupContext(lookupContext);
        }
        return contextObject.bootstrapContext;
    }

    public static <T> void finalize(@NotNull class_5321<class_2378<T>> registryKey) {
        CustomBootstrapContextImpl.getContextObject(registryKey).bootstrapContext = null;
    }

    private static class ContextData<T, C extends CustomBootstrapContext<T, C>> {
        private class_7871<T> lastGetter = null;
        private C bootstrapContext = null;

        private ContextData() {
        }
    }
}

