/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.config.api;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.betterx.wover.entrypoint.LibWoverCore;
import org.jetbrains.annotations.Nullable;

public class DatapackConfigs {
    private static DatapackConfigs INSTANCE = new DatapackConfigs();

    public static DatapackConfigs instance() {
        return INSTANCE;
    }

    public void runForResource(class_3300 manager, class_2960 fileLocation, DatapackConfigReloadHandler handler) {
        Map aSet = manager.method_41265("config", id -> {
            LibWoverCore.C.log.debug("Checking Resource from Datapack: '{}'", id);
            return fileLocation.method_12836().equals(id.method_12836()) && id.method_12832().equals("config/" + fileLocation.method_12832());
        });
        DatapackConfigs.runForSet(handler, null, aSet);
    }

    public void runForConfigPaths(class_3300 manager, List<String> paths, @Nullable DatapackConfigReloadHandler handler, @Nullable DatapackConfigFinished finished) {
        Map aSet = manager.method_41265("config", id -> {
            LibWoverCore.C.log.debug("Checking Resource from Datapack: '{}'", id);
            return paths.contains(id.method_12832());
        });
        DatapackConfigs.runForSet(handler, finished, aSet);
    }

    private static void runForSet(@Nullable DatapackConfigReloadHandler handler, @Nullable DatapackConfigFinished finished, Map<class_2960, List<class_3298>> resources) {
        if (handler != null) {
            for (Map.Entry<class_2960, List<class_3298>> entry : resources.entrySet()) {
                for (class_3298 item : entry.getValue()) {
                    try {
                        BufferedReader reader = item.method_43039();
                        try {
                            JsonObject obj = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                            if (obj == null) continue;
                            handler.onLoad(entry.getKey(), obj);
                        }
                        finally {
                            if (reader == null) continue;
                            ((Reader)reader).close();
                        }
                    }
                    catch (Exception e) {
                        LibWoverCore.C.log.error("Error occurred while loading resource json " + String.valueOf(entry.getKey()), e);
                    }
                }
            }
        }
        if (finished != null) {
            finished.whenFinished();
        }
    }

    @FunctionalInterface
    public static interface DatapackConfigReloadHandler {
        public void onLoad(class_2960 var1, JsonObject var2);
    }

    @FunctionalInterface
    public static interface DatapackConfigFinished {
        public void whenFinished();
    }
}

