/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;

public class CamoBakedModel
implements IDynamicBakedModel {
    public static final ModelProperty<BlockState> CAMO_PROPERTY = new ModelProperty();
    private final BakedModel originalModel;
    private List<BakedQuad> originalModelQuads;

    public CamoBakedModel(BakedModel originalModel) {
        this.originalModel = originalModel;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource random, ModelData modelData, RenderType renderType) {
        BlockState camouflage = (BlockState)modelData.get(CAMO_PROPERTY);
        if (camouflage == null || camouflage.getBlock() == Blocks.AIR) {
            if (this.originalModelQuads == null) {
                this.originalModelQuads = CamoBakedModel.getAllQuads(this.originalModel, state, random, renderType);
            }
            return this.originalModelQuads;
        }
        BakedModel model = ClientUtils.getBlockRenderer().getBlockModel(camouflage);
        return CamoBakedModel.getAllQuads(model, camouflage, random, renderType);
    }

    private static List<BakedQuad> getAllQuads(BakedModel model, BlockState state, RandomSource random, RenderType renderType) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (Direction direction : Direction.values()) {
            quads.addAll(model.getQuads(state, direction, random, ModelData.EMPTY, renderType));
        }
        quads.addAll(model.getQuads(state, null, random, ModelData.EMPTY, renderType));
        return quads;
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData entityData) {
        BlockEntity entity = level.getBlockEntity(pos);
        return entity == null ? ModelData.EMPTY : entity.getModelData();
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        BlockState camouflage = (BlockState)data.get(CAMO_PROPERTY);
        if (camouflage == null || camouflage.getBlock() == Blocks.AIR) {
            return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.translucent()});
        }
        return ClientUtils.getBlockRenderer().getBlockModel(camouflage).getRenderTypes(camouflage, rand, ModelData.EMPTY);
    }

    public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
        return Collections.singletonList(RenderType.translucent());
    }

    public boolean useAmbientOcclusion() {
        return this.originalModel.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.originalModel.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.originalModel.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.originalModel.getParticleIcon();
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        return this.originalModel.applyTransform(transformType, poseStack, applyLeftHandTransform);
    }
}

