/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.gui.preview;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.movingelevators.gui.preview.WorldBlockCapture;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Quaternionf;

public class ElevatorPreviewRenderer {
    public static void renderPreview(WorldBlockCapture capture, AABB cabinBox, AABB previewBox, double x, double y, double scale, float yaw, float pitch, boolean doShading) {
        AABB bounds = capture.getBounds();
        Vec3 center = bounds.getCenter();
        double span = Math.sqrt(bounds.getXsize() * bounds.getXsize() + bounds.getYsize() * bounds.getYsize() + bounds.getZsize() * bounds.getZsize());
        scale /= span;
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().scale(1.0f, -1.0f, 1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack poseStack = new PoseStack();
        poseStack.translate(x, -y, 350.0);
        poseStack.scale((float)scale, (float)scale, (float)scale);
        poseStack.mulPose(new Quaternionf().setAngleAxis((double)(pitch / 180.0f) * Math.PI, 1.0, 0.0, 0.0));
        poseStack.mulPose(new Quaternionf().setAngleAxis((double)(yaw / 180.0f) * Math.PI, 0.0, 1.0, 0.0));
        poseStack.translate(-center.x, -center.y, -center.z);
        if (doShading) {
            Lighting.setupFor3DItems();
        }
        MultiBufferSource.BufferSource renderTypeBuffer = RenderUtils.getMainBufferSource();
        for (BlockPos pos : capture.getBlockLocations()) {
            ElevatorPreviewRenderer.renderBlock(capture, pos, poseStack, (MultiBufferSource)renderTypeBuffer);
        }
        renderTypeBuffer.endBatch();
        RenderSystem.enableDepthTest();
        if (doShading) {
            Lighting.setupForFlatItems();
        }
        RenderUtils.renderBox((PoseStack)poseStack, (AABB)cabinBox, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f, (boolean)true);
        if (previewBox != null) {
            RenderUtils.renderBox((PoseStack)poseStack, (AABB)previewBox, (float)0.0f, (float)0.7f, (float)0.0f, (float)0.8f, (boolean)true);
        }
        RenderSystem.getModelViewStack().popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    private static void renderBlock(WorldBlockCapture capture, BlockPos pos, PoseStack poseStack, MultiBufferSource renderTypeBuffer) {
        BlockEntity blockEntity;
        poseStack.pushPose();
        poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
        BlockState state = capture.getBlockState(pos);
        if (state.getBlock() != Blocks.AIR) {
            BakedModel model = ClientUtils.getBlockRenderer().getBlockModel(state);
            ModelData modelData = ModelData.EMPTY;
            RandomSource random = RandomSource.create((long)42L);
            for (RenderType renderType : model.getRenderTypes(state, random, modelData)) {
                ElevatorPreviewRenderer.renderModel(model, capture, state, pos, poseStack, renderTypeBuffer.getBuffer(renderType), modelData, renderType);
                random.setSeed(42L);
            }
        }
        if ((blockEntity = capture.getBlockEntity(pos)) != null) {
            ClientUtils.getMinecraft().getBlockEntityRenderDispatcher().render(blockEntity, ClientUtils.getPartialTicks(), poseStack, renderTypeBuffer);
        }
        poseStack.popPose();
    }

    private static void renderModel(BakedModel model, WorldBlockCapture capture, BlockState state, BlockPos pos, PoseStack poseStack, VertexConsumer buffer, ModelData modelData, RenderType renderType) {
        RandomSource random = RandomSource.create();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            ElevatorPreviewRenderer.renderQuads(capture, state, pos, poseStack, buffer, model.getQuads(state, direction, random, modelData, renderType));
        }
        random.setSeed(42L);
        ElevatorPreviewRenderer.renderQuads(capture, state, pos, poseStack, buffer, model.getQuads(state, null, random, modelData, renderType));
    }

    private static void renderQuads(WorldBlockCapture capture, BlockState state, BlockPos pos, PoseStack poseStack, VertexConsumer buffer, List<BakedQuad> quads) {
        PoseStack.Pose matrix = poseStack.last();
        for (BakedQuad bakedquad : quads) {
            float red = 1.0f;
            float blue = 1.0f;
            float green = 1.0f;
            float alpha = 1.0f;
            if (bakedquad.isTinted()) {
                int color = ClientUtils.getMinecraft().getBlockColors().getColor(state, (BlockAndTintGetter)capture.getLevel(), pos, bakedquad.getTintIndex());
                red = (float)(color >> 16 & 0xFF) / 255.0f;
                green = (float)(color >> 8 & 0xFF) / 255.0f;
                blue = (float)(color & 0xFF) / 255.0f;
            }
            buffer.putBulkData(matrix, bakedquad, red, green, blue, alpha, 0xF000F0, OverlayTexture.NO_OVERLAY, false);
        }
    }
}

