/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.BlockEntityBaseWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.MovingElevatorsClient;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.gui.CheckBoxWidget;
import com.supermartijn642.movingelevators.gui.ElevatorPreviewWidget;
import com.supermartijn642.movingelevators.gui.LeftRightArrowWidget;
import com.supermartijn642.movingelevators.gui.PlusMinusButtonWidget;
import com.supermartijn642.movingelevators.gui.SliderWidget;
import com.supermartijn642.movingelevators.gui.SynchingTextFieldWidget;
import com.supermartijn642.movingelevators.packets.PacketDecreaseCabinDepth;
import com.supermartijn642.movingelevators.packets.PacketDecreaseCabinDepthOffset;
import com.supermartijn642.movingelevators.packets.PacketDecreaseCabinHeight;
import com.supermartijn642.movingelevators.packets.PacketDecreaseCabinHeightOffset;
import com.supermartijn642.movingelevators.packets.PacketDecreaseCabinSideOffset;
import com.supermartijn642.movingelevators.packets.PacketDecreaseCabinWidth;
import com.supermartijn642.movingelevators.packets.PacketElevatorSpeed;
import com.supermartijn642.movingelevators.packets.PacketIncreaseCabinDepth;
import com.supermartijn642.movingelevators.packets.PacketIncreaseCabinDepthOffset;
import com.supermartijn642.movingelevators.packets.PacketIncreaseCabinHeight;
import com.supermartijn642.movingelevators.packets.PacketIncreaseCabinHeightOffset;
import com.supermartijn642.movingelevators.packets.PacketIncreaseCabinSideOffset;
import com.supermartijn642.movingelevators.packets.PacketIncreaseCabinWidth;
import com.supermartijn642.movingelevators.packets.PacketSetFloorName;
import com.supermartijn642.movingelevators.packets.PacketToggleShowControllerButtons;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ElevatorScreen
extends BlockEntityBaseWidget<ControllerBlockEntity> {
    public static final int MAX_NAME_LENGTH = 11;
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"movingelevators", (String)"textures/gui/gui_background.png");
    private static final ResourceLocation SIZE_ICONS = ResourceLocation.fromNamespaceAndPath((String)"movingelevators", (String)"textures/gui/size_icons2.png");

    public ElevatorScreen(BlockPos entityPos) {
        super(0, 0, 280, 118, ClientUtils.getWorld(), entityPos);
    }

    protected Component getNarrationMessage(ControllerBlockEntity object) {
        return null;
    }

    protected void addWidgets(@NotNull ControllerBlockEntity blockEntity) {
        ((SynchingTextFieldWidget)this.addWidget((Widget)new SynchingTextFieldWidget(6, 31, 84, 11, () -> {
            String name = blockEntity.getFloorName();
            return name == null ? "" : name;
        }, name -> MovingElevators.CHANNEL.sendToServer((BasePacket)new PacketSetFloorName(this.blockEntityPos, (String)name))))).setSuggestion(MovingElevatorsClient.formatFloorDisplayName(null, blockEntity.getGroup().getFloorNumber(blockEntity.getFloorLevel())));
        this.addWidget((Widget)new CheckBoxWidget(42, 60, checked -> TextComponents.translation((String)"movingelevators.elevator_screen.display_buttons", (Object[])new Object[]{checked != false ? TextComponents.translation((String)"movingelevators.elevator_screen.display_buttons.on").color(ChatFormatting.GREEN).get() : TextComponents.translation((String)"movingelevators.elevator_screen.display_buttons.off").color(ChatFormatting.RED).get()}).get(), () -> ((ControllerBlockEntity)((Object)((Object)this.object))).shouldShowButtons(), checked -> MovingElevators.CHANNEL.sendToServer((BasePacket)new PacketToggleShowControllerButtons(this.blockEntityPos))));
        PlusMinusButtonWidget widthSizeIncrease = (PlusMinusButtonWidget)this.addWidget((Widget)new PlusMinusButtonWidget(207, 31, true, (Component)TextComponents.translation((String)"movingelevators.elevator_screen.cabin_width.increase_size").get(), () -> blockEntity.getGroup().canIncreaseCageWidth(), () -> MovingElevators.CHANNEL.sendToServer((BasePacket)new PacketIncreaseCabinWidth(this.blockEntityPos))));
        PlusMinusButtonWidget widthSizeDecrease = (PlusMinusButtonWidget)this.addWidget((Widget)new PlusMinusButtonWidget(230, 31, false, (Component)TextComponents.translation((String)"movingelevators.elevator_screen.cabin_width.decrease_size").get(), () -> blockEntity.getGroup().canDecreaseCageWidth(), () -> MovingElevators.CHANNEL.sendToServer((BasePacket)new PacketDecreaseCabinWidth(this.blockEntityPos))));
        LeftRightArrowWidget widthOffsetDecrease = (LeftRightArrowWidget)this.addWidget((Widget)new LeftRightArrowWidget(247, 31, true, (Component)TextComponents.translation((String)"movingelevators.elevator_screen.cabin_width.decrease_offset").get(), () -> blockEntity.getGroup().canDecreaseCageSideOffset(), () -> MovingElevators.CHANNEL.sendToServer((BasePacket)new PacketDecreaseCabinSideOffset(this.blockEntityPos))));
        LeftRightArrowWidget widthOffsetIncrease = (LeftRightArrowWidget)this.addWidget((Widget)new LeftRightArrowWidget(267, 31, false, (Component)TextComponents.translation((String)"movingelevators.elevator_screen.cabin_width.increase_offset").get(), () -> blockEntity.getGroup().canIncreaseCageSideOffset(), () -> MovingElevators.CHANNEL.sendToServer((BasePacket)new PacketIncreaseCabinSideOffset(this.blockEntityPos))));
        PlusMinusButtonWidget depthSizeIncrease = (PlusMinusButtonWidget)this.addWidget((Widget)new PlusMinusButtonWidget(207, 47, true, (Component)TextComponents.translation((String)"movingelevators.elevator_screen.cabin_depth.increase_size").get(), () -> blockEntity.getGroup().canIncreaseCageDepth(), () -> MovingElevators.CHANNEL.sendToServer((BasePacket)new PacketIncreaseCabinDepth(this.blockEntityPos))));
        PlusMinusButtonWidget depthSizeDecrease = (PlusMinusButtonWidget)this.addWidget((Widget)new PlusMinusButtonWidget(230, 47, false, (Component)TextComponents.translation((String)"movingelevators.elevator_screen.cabin_depth.decrease_size").get(), () -> blockEntity.getGroup().canDecreaseCageDepth(), () -> MovingElevators.CHANNEL.sendToServer((BasePacket)new PacketDecreaseCabinDepth(this.blockEntityPos))));
        LeftRightArrowWidget depthOffsetDecrease = (LeftRightArrowWidget)this.addWidget((Widget)new LeftRightArrowWidget(247, 47, true, (Component)TextComponents.translation((String)"movingelevators.elevator_screen.cabin_depth.decrease_offset").get(), () -> blockEntity.getGroup().canDecreaseCageDepthOffset(), () -> MovingElevators.CHANNEL.sendToServer((BasePacket)new PacketDecreaseCabinDepthOffset(this.blockEntityPos))));
        LeftRightArrowWidget depthOffsetIncrease = (LeftRightArrowWidget)this.addWidget((Widget)new LeftRightArrowWidget(267, 47, false, (Component)TextComponents.translation((String)"movingelevators.elevator_screen.cabin_depth.increase_offset").get(), () -> blockEntity.getGroup().canIncreaseCageDepthOffset(), () -> MovingElevators.CHANNEL.sendToServer((BasePacket)new PacketIncreaseCabinDepthOffset(this.blockEntityPos))));
        PlusMinusButtonWidget heightSizeIncrease = (PlusMinusButtonWidget)this.addWidget((Widget)new PlusMinusButtonWidget(207, 63, true, (Component)TextComponents.translation((String)"movingelevators.elevator_screen.cabin_height.increase_size").get(), () -> blockEntity.getGroup().canIncreaseCageHeight(), () -> MovingElevators.CHANNEL.sendToServer((BasePacket)new PacketIncreaseCabinHeight(this.blockEntityPos))));
        PlusMinusButtonWidget heightSizeDecrease = (PlusMinusButtonWidget)this.addWidget((Widget)new PlusMinusButtonWidget(230, 63, false, (Component)TextComponents.translation((String)"movingelevators.elevator_screen.cabin_height.decrease_size").get(), () -> blockEntity.getGroup().canDecreaseCageHeight(), () -> MovingElevators.CHANNEL.sendToServer((BasePacket)new PacketDecreaseCabinHeight(this.blockEntityPos))));
        LeftRightArrowWidget heightOffsetDecrease = (LeftRightArrowWidget)this.addWidget((Widget)new LeftRightArrowWidget(247, 63, true, (Component)TextComponents.translation((String)"movingelevators.elevator_screen.cabin_height.decrease_offset").get(), () -> blockEntity.getGroup().canDecreaseCageHeightOffset(), () -> MovingElevators.CHANNEL.sendToServer((BasePacket)new PacketDecreaseCabinHeightOffset(this.blockEntityPos))));
        LeftRightArrowWidget heightOffsetIncrease = (LeftRightArrowWidget)this.addWidget((Widget)new LeftRightArrowWidget(267, 63, false, (Component)TextComponents.translation((String)"movingelevators.elevator_screen.cabin_height.increase_offset").get(), () -> blockEntity.getGroup().canIncreaseCageHeightOffset(), () -> MovingElevators.CHANNEL.sendToServer((BasePacket)new PacketIncreaseCabinHeightOffset(this.blockEntityPos))));
        this.addWidget((Widget)new SliderWidget(190, 92, 84, 1, 10, (int)Math.round(blockEntity.getGroup().getTargetSpeed() * 10.0), speed -> TextComponents.translation((String)"movingelevators.elevator_screen.current_speed", (Object[])new Object[]{TextComponents.number((double)((double)speed.intValue() / 10.0), (int)1).get()}).get(), speed -> MovingElevators.CHANNEL.sendToServer((BasePacket)new PacketElevatorSpeed(this.blockEntityPos, (double)speed.intValue() / 10.0))));
        Supplier<BlockPos> previewSizeIncrease = () -> new BlockPos(widthSizeIncrease.active && widthSizeIncrease.isFocused() ? 1 : (widthSizeDecrease.active && widthSizeDecrease.isFocused() ? -1 : 0), heightSizeIncrease.active && heightSizeIncrease.isFocused() ? 1 : (heightSizeDecrease.active && heightSizeDecrease.isFocused() ? -1 : 0), depthSizeIncrease.active && depthSizeIncrease.isFocused() ? 1 : (depthSizeDecrease.active && depthSizeDecrease.isFocused() ? -1 : 0));
        Supplier<BlockPos> previewOffset = () -> new BlockPos(widthOffsetIncrease.active && widthOffsetIncrease.isFocused() ? 1 : (widthOffsetDecrease.active && widthOffsetDecrease.isFocused() ? -1 : 0), heightOffsetIncrease.active && heightOffsetIncrease.isFocused() ? 1 : (heightOffsetDecrease.active && heightOffsetDecrease.isFocused() ? -1 : 0), depthOffsetIncrease.active && depthOffsetIncrease.isFocused() ? 1 : (depthOffsetDecrease.active && depthOffsetDecrease.isFocused() ? -1 : 0));
        this.addWidget((Widget)new ElevatorPreviewWidget(99, 13, 82, 99, () -> (ControllerBlockEntity)((Object)((Object)this.object)), previewSizeIncrease, previewOffset));
    }

    protected void renderBackground(WidgetRenderContext context, int mouseX, int mouseY, ControllerBlockEntity object) {
        ScreenUtils.bindTexture((ResourceLocation)BACKGROUND);
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)0.0f, (float)0.0f, (float)this.width(), (float)this.height());
        super.renderBackground(context, mouseX, mouseY, (Object)object);
    }

    protected void render(WidgetRenderContext context, int mouseX, int mouseY, ControllerBlockEntity blockEntity) {
        ScreenUtils.bindTexture((ResourceLocation)SIZE_ICONS);
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)190.0f, (float)31.0f, (float)11.0f, (float)11.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.33333334f);
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)190.0f, (float)47.0f, (float)11.0f, (float)11.0f, (float)0.0f, (float)0.33333334f, (float)1.0f, (float)0.33333334f);
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)190.0f, (float)63.0f, (float)11.0f, (float)11.0f, (float)0.0f, (float)0.6666667f, (float)1.0f, (float)0.33333334f);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.number((int)blockEntity.getGroup().getCageWidth()).get(), (float)224.0f, (float)34.0f);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.number((int)blockEntity.getGroup().getCageSideOffset()).get(), (float)261.0f, (float)34.0f);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.number((int)blockEntity.getGroup().getCageDepth()).get(), (float)224.0f, (float)50.0f);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.number((int)blockEntity.getGroup().getCageDepthOffset()).get(), (float)261.0f, (float)50.0f);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.number((int)blockEntity.getGroup().getCageHeight()).get(), (float)224.0f, (float)66.0f);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.number((int)blockEntity.getGroup().getCageHeightOffset()).get(), (float)261.0f, (float)66.0f);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"movingelevators.elevator_screen.current_floor").get(), (float)47.0f, (float)3.0f, (int)0xE0E0E0);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"movingelevators.elevator_screen.elevator").get(), (float)232.0f, (float)3.0f, (int)0xE0E0E0);
        ScreenUtils.drawString((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"movingelevators.elevator_screen.floor_name").get(), (float)6.0f, (float)18.0f);
        ScreenUtils.drawString((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"movingelevators.elevator_screen.show_buttons").get(), (float)6.0f, (float)47.0f);
        ScreenUtils.drawString((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"movingelevators.elevator_screen.cabin_size").get(), (float)190.0f, (float)18.0f);
        ScreenUtils.drawString((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"movingelevators.elevator_screen.elevator_speed").get(), (float)190.0f, (float)79.0f);
        super.render(context, mouseX, mouseY, (Object)blockEntity);
    }

    protected void renderTooltips(WidgetRenderContext context, int mouseX, int mouseY, @NotNull ControllerBlockEntity blockEntity) {
        if (mouseX >= 190 && mouseX <= 201 && mouseY >= 31 && mouseY <= 42) {
            ScreenUtils.drawTooltip((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"movingelevators.elevator_screen.cabin_width").get(), (int)mouseX, (int)mouseY);
        } else if (mouseX >= 190 && mouseX <= 201 && mouseY >= 47 && mouseY <= 58) {
            ScreenUtils.drawTooltip((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"movingelevators.elevator_screen.cabin_depth").get(), (int)mouseX, (int)mouseY);
        } else if (mouseX >= 190 && mouseX <= 201 && mouseY >= 63 && mouseY <= 74) {
            ScreenUtils.drawTooltip((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"movingelevators.elevator_screen.cabin_height").get(), (int)mouseX, (int)mouseY);
        }
        super.renderTooltips(context, mouseX, mouseY, (Object)blockEntity);
    }
}

