/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.gui;

import com.supermartijn642.core.gui.widget.BaseWidget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import com.supermartijn642.movingelevators.gui.preview.ElevatorPreviewRenderer;
import com.supermartijn642.movingelevators.gui.preview.WorldBlockCapture;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.AABB;

public class ElevatorPreviewWidget
extends BaseWidget {
    private final Supplier<ControllerBlockEntity> elevatorEntity;
    private final Supplier<BlockPos> previewSizeIncrease;
    private final Supplier<BlockPos> previewOffset;
    private float yaw = 20.0f;
    private float pitch = 30.0f;
    private boolean dragging = false;
    private int mouseStartX;
    private int mouseStartY;

    public ElevatorPreviewWidget(int x, int y, int width, int height, Supplier<ControllerBlockEntity> elevatorEntity, Supplier<BlockPos> previewSizeIncrease, Supplier<BlockPos> previewOffset) {
        super(x, y, width, height);
        this.elevatorEntity = elevatorEntity;
        this.previewSizeIncrease = previewSizeIncrease;
        this.previewOffset = previewOffset;
    }

    public Component getNarrationMessage() {
        return null;
    }

    public void render(WidgetRenderContext context, int mouseX, int mouseY) {
        if (this.dragging) {
            this.yaw = (float)((double)this.yaw + (double)(mouseX - this.mouseStartX) / 100.0 * 360.0);
            this.pitch = (float)((double)this.pitch + (double)(mouseY - this.mouseStartY) / 100.0 * 360.0);
            this.mouseStartX = mouseX;
            this.mouseStartY = mouseY;
        }
        ControllerBlockEntity elevatorEntity = this.elevatorEntity.get();
        ElevatorGroup group = elevatorEntity.getGroup();
        BlockPos anchorPos = group.getCageAnchorBlockPos(elevatorEntity.getBlockPos().getY());
        WorldBlockCapture capture = new WorldBlockCapture(group.level);
        capture.putBlock(elevatorEntity.getBlockPos(), elevatorEntity.getBlockPos());
        for (int x = 0; x < group.getCageSizeX(); ++x) {
            for (int y = 0; y < group.getCageSizeY(); ++y) {
                for (int z = 0; z < group.getCageSizeZ(); ++z) {
                    BlockPos pos = anchorPos.offset(x, y, z);
                    capture.putBlock(pos, pos);
                }
            }
        }
        AABB cabinBox = new AABB((double)anchorPos.getX(), (double)anchorPos.getY(), (double)anchorPos.getZ(), (double)(anchorPos.getX() + group.getCageSizeX()), (double)(anchorPos.getY() + group.getCageSizeY()), (double)(anchorPos.getZ() + group.getCageSizeZ())).inflate(0.1);
        BlockPos previewSizeIncrease = this.previewSizeIncrease.get();
        BlockPos previewOffset = this.previewOffset.get();
        AABB previewBox = null;
        if (!previewSizeIncrease.equals((Object)BlockPos.ZERO) || !previewOffset.equals((Object)BlockPos.ZERO)) {
            int cabinWidth = group.getCageWidth() + previewSizeIncrease.getX();
            int cabinDepth = group.getCageDepth() + previewSizeIncrease.getZ();
            int cabinHeight = group.getCageHeight() + previewSizeIncrease.getY();
            int sideOffset = group.getCageSideOffset() + previewOffset.getX();
            int depthOffset = group.getCageDepthOffset() + previewOffset.getZ();
            int heightOffset = group.getCageHeightOffset() + previewOffset.getY();
            if (sideOffset > 2 + (group.facing == Direction.NORTH || group.facing == Direction.WEST ? (cabinWidth - 1) / 2 : (int)Math.ceil((float)(cabinWidth - 1) / 2.0f))) {
                sideOffset = 2 + (group.facing == Direction.NORTH || group.facing == Direction.WEST ? (cabinWidth - 1) / 2 : (int)Math.ceil((float)(cabinWidth - 1) / 2.0f));
            } else if (sideOffset < -2 - (group.facing == Direction.NORTH || group.facing == Direction.WEST ? (int)Math.ceil((float)(cabinWidth - 1) / 2.0f) : (cabinWidth - 1) / 2)) {
                sideOffset = -2 - (group.facing == Direction.NORTH || group.facing == Direction.WEST ? (int)Math.ceil((float)(cabinWidth - 1) / 2.0f) : (cabinWidth - 1) / 2);
            }
            if (heightOffset < -cabinHeight) {
                heightOffset = -cabinHeight;
            }
            int anchorX = 0;
            int anchorY = elevatorEntity.getBlockPos().getY();
            int anchorZ = 0;
            if (group.facing == Direction.NORTH) {
                anchorX = group.x - cabinWidth / 2 - sideOffset;
                anchorZ = group.z - cabinDepth - depthOffset;
            } else if (group.facing == Direction.SOUTH) {
                anchorX = group.x - cabinWidth / 2 + sideOffset;
                anchorZ = group.z + 1 + depthOffset;
            } else if (group.facing == Direction.WEST) {
                anchorX = group.x - cabinDepth - depthOffset;
                anchorZ = group.z - cabinWidth / 2 + sideOffset;
            } else if (group.facing == Direction.EAST) {
                anchorX = group.x + 1 + depthOffset;
                anchorZ = group.z - cabinWidth / 2 - sideOffset;
            }
            previewBox = new AABB((double)anchorX, (double)(anchorY += heightOffset), (double)anchorZ, (double)(anchorX + (group.facing.getAxis() == Direction.Axis.X ? cabinDepth : cabinWidth)), (double)(anchorY + cabinHeight), (double)(anchorZ + (group.facing.getAxis() == Direction.Axis.Z ? cabinDepth : cabinWidth))).inflate(0.1);
        }
        ElevatorPreviewRenderer.renderPreview(capture, cabinBox, previewBox, (float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f, Math.min(this.width, this.height), this.yaw + group.facing.toYRot(), this.pitch, false);
    }

    public boolean mousePressed(int mouseX, int mouseY, int button, boolean hasBeenHandled) {
        if (!hasBeenHandled && mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height) {
            this.dragging = true;
            this.mouseStartX = mouseX;
            this.mouseStartY = mouseY;
            return true;
        }
        return super.mousePressed(mouseX, mouseY, button, hasBeenHandled);
    }

    public boolean mouseReleased(int mouseX, int mouseY, int button, boolean hasBeenHandled) {
        if (this.dragging) {
            this.dragging = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button, hasBeenHandled);
    }
}

