/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.elevator;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.core.render.RenderWorldEvent;
import com.supermartijn642.movingelevators.elevator.ClientElevatorCage;
import com.supermartijn642.movingelevators.elevator.ElevatorCage;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import com.supermartijn642.movingelevators.elevator.ElevatorGroupCapability;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.NeoForge;

public class ElevatorGroupRenderer {
    public static void registerEventListeners() {
        NeoForge.EVENT_BUS.addListener(ElevatorGroupRenderer::onRender);
    }

    private static boolean isWithinRenderDistance(ElevatorGroup group) {
        GameRenderer renderer = ClientUtils.getMinecraft().gameRenderer;
        if (renderer == null) {
            return false;
        }
        float renderDistance = renderer.getRenderDistance() + 8.0f + (float)group.getCageSizeX() / 2.0f + (float)group.getCageSizeZ() / 2.0f;
        BlockPos playerPos = ClientUtils.getPlayer().blockPosition();
        float distance = (group.x - playerPos.getX()) * (group.x - playerPos.getX()) + (group.z - playerPos.getZ()) * (group.z - playerPos.getZ());
        return distance < renderDistance * renderDistance;
    }

    public static void onRender(RenderWorldEvent e) {
        if (!ClientUtils.getMinecraft().getEntityRenderDispatcher().shouldRenderHitBoxes()) {
            return;
        }
        ElevatorGroupCapability groups = ElevatorGroupCapability.get(ClientUtils.getWorld());
        e.getPoseStack().pushPose();
        Vec3 camera = RenderUtils.getCameraPosition();
        e.getPoseStack().translate(-camera.x, -camera.y, -camera.z);
        for (ElevatorGroup group : groups.getGroups()) {
            if (!ElevatorGroupRenderer.isWithinRenderDistance(group)) continue;
            ElevatorGroupRenderer.renderGroupCageOutlines(e.getPoseStack(), group);
        }
        e.getPoseStack().popPose();
    }

    public static void renderBlocks(PoseStack poseStack, RenderType renderType, MultiBufferSource bufferSource) {
        ElevatorGroupCapability groups = ElevatorGroupCapability.get(ClientUtils.getWorld());
        poseStack.pushPose();
        Vec3 camera = RenderUtils.getCameraPosition();
        poseStack.translate(-camera.x, -camera.y, -camera.z);
        VertexConsumer buffer = null;
        boolean rendered = false;
        for (ElevatorGroup group : groups.getGroups()) {
            if (!group.isMoving() || !ElevatorGroupRenderer.isWithinRenderDistance(group)) continue;
            if (buffer == null) {
                buffer = bufferSource.getBuffer(renderType);
            }
            ElevatorGroupRenderer.renderGroupBlocks(poseStack, group, renderType, buffer, ClientUtils.getPartialTicks());
            rendered = true;
        }
        poseStack.popPose();
        if (rendered && renderType != RenderType.translucent() && bufferSource instanceof MultiBufferSource.BufferSource) {
            ((MultiBufferSource.BufferSource)bufferSource).endBatch(renderType);
        }
    }

    public static void renderBlockEntities(PoseStack poseStack, float partialTicks, MultiBufferSource bufferSource) {
        ElevatorGroupCapability groups = ElevatorGroupCapability.get(ClientUtils.getWorld());
        poseStack.pushPose();
        Vec3 camera = RenderUtils.getCameraPosition();
        poseStack.translate(-camera.x, -camera.y, -camera.z);
        for (ElevatorGroup group : groups.getGroups()) {
            if (!group.isMoving() || !ElevatorGroupRenderer.isWithinRenderDistance(group)) continue;
            ElevatorGroupRenderer.renderGroupBlockEntities(poseStack, group, bufferSource, partialTicks);
        }
        poseStack.popPose();
    }

    public static void renderGroupBlocks(PoseStack poseStack, ElevatorGroup group, RenderType renderType, VertexConsumer buffer, float partialTicks) {
        ClientElevatorCage cage = (ClientElevatorCage)group.getCage();
        double lastY = group.getLastY();
        double currentY = group.getCurrentY();
        double renderY = lastY + (currentY - lastY) * (double)partialTicks;
        Vec3 startPos = group.getCageAnchorPos(renderY);
        BlockPos anchorPos = new BlockPos((int)startPos.x, (int)startPos.y, (int)startPos.z);
        cage.loadRenderInfo(anchorPos, group);
        Level level = ClientElevatorCage.getFakeLevel();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < group.getCageSizeX(); ++x) {
            for (int y = 0; y < group.getCageSizeY(); ++y) {
                for (int z = 0; z < group.getCageSizeZ(); ++z) {
                    if (cage.blockStates[x][y][z] == null) continue;
                    poseStack.pushPose();
                    poseStack.translate(startPos.x + (double)x, startPos.y + (double)y, startPos.z + (double)z);
                    BlockState state = cage.blockStates[x][y][z];
                    if (state.getRenderShape() == RenderShape.MODEL) {
                        BakedModel model = ClientUtils.getBlockRenderer().getBlockModel(state);
                        ModelData modelData = cage.blockEntities[x][y][z] == null ? ModelData.EMPTY : cage.blockEntities[x][y][z].getModelData();
                        if (model.getRenderTypes(state, level.random, modelData = model.getModelData((BlockAndTintGetter)level, (BlockPos)pos, state, modelData)).contains(renderType)) {
                            pos.set(anchorPos.getX() + x, anchorPos.getY() + y, anchorPos.getZ() + z);
                            ClientUtils.getBlockRenderer().renderBatched(state, (BlockPos)pos, (BlockAndTintGetter)level, poseStack, buffer, true, level.random, modelData, renderType);
                        }
                    }
                    poseStack.popPose();
                }
            }
        }
    }

    public static void renderGroupBlockEntities(PoseStack poseStack, ElevatorGroup group, MultiBufferSource buffer, float partialTicks) {
        ClientElevatorCage cage = (ClientElevatorCage)group.getCage();
        double lastY = group.getLastY();
        double currentY = group.getCurrentY();
        double renderY = lastY + (currentY - lastY) * (double)partialTicks;
        Vec3 startPos = group.getCageAnchorPos(renderY);
        BlockPos anchorPos = new BlockPos((int)startPos.x, (int)startPos.y, (int)startPos.z);
        cage.loadRenderInfo(anchorPos, group);
        for (int x = 0; x < group.getCageSizeX(); ++x) {
            for (int y = 0; y < group.getCageSizeY(); ++y) {
                for (int z = 0; z < group.getCageSizeZ(); ++z) {
                    if (cage.blockEntities[x][y][z] == null) continue;
                    poseStack.pushPose();
                    poseStack.translate(startPos.x + (double)x, startPos.y + (double)y, startPos.z + (double)z);
                    BlockEntity entity = cage.blockEntities[x][y][z];
                    ClientUtils.getMinecraft().getBlockEntityRenderDispatcher().render(entity, partialTicks, poseStack, buffer);
                    poseStack.popPose();
                }
            }
        }
    }

    public static void renderGroupCageOutlines(PoseStack poseStack, ElevatorGroup group) {
        for (int floor = 0; floor < group.getFloorCount(); ++floor) {
            BlockPos anchorPos = group.getCageAnchorBlockPos(group.getFloorYLevel(floor));
            AABB cageArea = new AABB((double)anchorPos.getX(), (double)anchorPos.getY(), (double)anchorPos.getZ(), (double)(anchorPos.getX() + group.getCageSizeX()), (double)(anchorPos.getY() + group.getCageSizeY()), (double)(anchorPos.getZ() + group.getCageSizeZ()));
            cageArea.inflate(0.01);
            RenderUtils.renderBox((PoseStack)poseStack, (AABB)cageArea, (float)1.0f, (float)1.0f, (float)1.0f, (boolean)true);
        }
        if (group.isMoving()) {
            ElevatorCage cage = group.getCage();
            double lastY = group.getLastY();
            double currentY = group.getCurrentY();
            double renderY = lastY + (currentY - lastY) * (double)ClientUtils.getPartialTicks();
            Vec3 startPos = group.getCageAnchorPos(renderY);
            RenderUtils.renderBox((PoseStack)poseStack, (AABB)new AABB(startPos, startPos.add((double)group.getCageSizeX(), (double)group.getCageSizeY(), (double)group.getCageSizeZ())), (float)1.0f, (float)0.0f, (float)0.0f, (boolean)true);
            RenderUtils.renderShape((PoseStack)poseStack, (VoxelShape)cage.shape.move(startPos.x, startPos.y, startPos.z), (float)0.19215687f, (float)0.8784314f, (float)0.85882354f, (boolean)true);
        }
    }
}

