/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.elevator;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import com.supermartijn642.movingelevators.extensions.MovingElevatorsLevel;
import com.supermartijn642.movingelevators.packets.PacketAddElevatorGroup;
import com.supermartijn642.movingelevators.packets.PacketRemoveElevatorGroup;
import com.supermartijn642.movingelevators.packets.PacketUpdateElevatorGroups;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.neoforge.common.NeoForge;

public class ElevatorGroupCapability {
    private final Level level;
    private final Map<ElevatorGroupPosition, ElevatorGroup> groups = new HashMap<ElevatorGroupPosition, ElevatorGroup>();
    private final Multimap<ChunkPos, ElevatorGroup> groupsPerChunk = MultimapBuilder.hashKeys().hashSetValues(1).build();

    public static ElevatorGroupCapability get(Level level) {
        return ((MovingElevatorsLevel)level).getElevatorGroupCapability();
    }

    public static void registerEventListeners() {
        NeoForge.EVENT_BUS.addListener(event -> {
            if (!event.getLevel().isClientSide) {
                ElevatorGroupCapability.tickWorldCapability(event.getLevel());
            }
        });
        NeoForge.EVENT_BUS.addListener(event -> ElevatorGroupCapability.onJoinWorld(event.getEntity(), event.getEntity().level()));
        NeoForge.EVENT_BUS.addListener(event -> ElevatorGroupCapability.onJoin(event.getEntity()));
        NeoForge.EVENT_BUS.addListener(event -> ElevatorGroupCapability.onLoadChunk(event.getChunk(), event.getLevel()));
    }

    public static void tickWorldCapability(Level level) {
        ElevatorGroupCapability.get(level).tick();
    }

    public static void onJoinWorld(Player player, Level level) {
        MovingElevators.CHANNEL.sendToPlayer(player, (BasePacket)new PacketUpdateElevatorGroups(ElevatorGroupCapability.get(level).write()));
    }

    public static void onJoin(Player player) {
        MovingElevators.CHANNEL.sendToPlayer(player, (BasePacket)new PacketUpdateElevatorGroups(ElevatorGroupCapability.get(player.level()).write()));
    }

    public static void onLoadChunk(ChunkAccess chunk, LevelAccessor level) {
        if (level instanceof Level) {
            ElevatorGroupCapability.get((Level)level).validateGroupsInChunk(chunk);
        }
    }

    public ElevatorGroupCapability(Level level) {
        this.level = level;
    }

    public ElevatorGroup get(int x, int z, Direction facing) {
        return this.groups.get(new ElevatorGroupPosition(x, z, facing));
    }

    public void add(ControllerBlockEntity controller) {
        ElevatorGroupPosition pos = new ElevatorGroupPosition(controller.getBlockPos(), controller.getFacing());
        ElevatorGroup group = this.groups.computeIfAbsent(pos, p -> new ElevatorGroup(this.level, p.x, p.z, p.facing));
        this.groupsPerChunk.put((Object)pos.chunkPos(), (Object)group);
        group.add(controller);
    }

    public void remove(ControllerBlockEntity controller) {
        ElevatorGroupPosition pos = new ElevatorGroupPosition(controller.getBlockPos(), controller.getFacing());
        ElevatorGroup group = this.groups.get(pos);
        group.remove(controller);
        if (group.getFloorCount() == 0) {
            this.removeGroup(pos);
        }
    }

    public void tick() {
        for (ElevatorGroup group : this.groups.values()) {
            group.update();
        }
    }

    public void updateGroup(ElevatorGroup group) {
        if (!this.level.isClientSide && group != null) {
            MovingElevators.CHANNEL.sendToDimension(this.level.dimension(), (BasePacket)new PacketAddElevatorGroup(this.writeGroup(group)));
        }
    }

    private void removeGroup(ElevatorGroupPosition pos) {
        ElevatorGroup group = this.groups.remove(pos);
        if (group != null) {
            this.groupsPerChunk.remove((Object)pos.chunkPos(), (Object)group);
            if (!this.level.isClientSide) {
                MovingElevators.CHANNEL.sendToDimension(this.level.dimension(), (BasePacket)new PacketRemoveElevatorGroup(group));
            }
        }
    }

    public void removeGroup(int x, int z, Direction facing) {
        if (this.level.isClientSide) {
            this.removeGroup(new ElevatorGroupPosition(x, z, facing));
        }
    }

    public ElevatorGroup getGroup(ControllerBlockEntity entity) {
        return this.groups.get(new ElevatorGroupPosition(entity.getBlockPos().getX(), entity.getBlockPos().getZ(), entity.getFacing()));
    }

    public Collection<ElevatorGroup> getGroups() {
        return this.groups.values();
    }

    public void validateGroupsInChunk(ChunkAccess chunk) {
        if (!this.groupsPerChunk.containsKey((Object)chunk.getPos())) {
            return;
        }
        for (ElevatorGroup group : new ArrayList(this.groupsPerChunk.get((Object)chunk.getPos()))) {
            group.validateControllersExist(chunk);
            if (group.getFloorCount() != 0) continue;
            this.removeGroup(new ElevatorGroupPosition(group.x, group.z, group.facing));
        }
    }

    public CompoundTag write() {
        CompoundTag compound = new CompoundTag();
        for (Map.Entry<ElevatorGroupPosition, ElevatorGroup> entry : this.groups.entrySet()) {
            CompoundTag groupTag = new CompoundTag();
            groupTag.put("group", (Tag)entry.getValue().write());
            groupTag.put("pos", (Tag)entry.getKey().write());
            compound.put(entry.getKey().x + ";" + entry.getKey().z, (Tag)groupTag);
        }
        return compound;
    }

    public void read(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)tag;
            this.groups.clear();
            for (String key : compound.getAllKeys()) {
                this.readGroup(compound.getCompound(key));
            }
        }
    }

    private CompoundTag writeGroup(ElevatorGroup group) {
        CompoundTag tag = new CompoundTag();
        tag.put("group", (Tag)group.write());
        tag.put("pos", (Tag)new ElevatorGroupPosition(group.x, group.z, group.facing).write());
        return tag;
    }

    public void readGroup(CompoundTag tag) {
        if (tag.contains("group") && tag.contains("pos")) {
            ElevatorGroupPosition pos = ElevatorGroupPosition.read(tag.getCompound("pos"));
            ElevatorGroup group = new ElevatorGroup(this.level, pos.x, pos.z, pos.facing);
            group.read(tag.getCompound("group"));
            this.groups.put(pos, group);
            this.groupsPerChunk.put((Object)pos.chunkPos(), (Object)group);
        }
    }

    private static class ElevatorGroupPosition {
        public final int x;
        public final int z;
        public final Direction facing;

        private ElevatorGroupPosition(int x, int z, Direction facing) {
            this.x = x;
            this.z = z;
            this.facing = facing;
        }

        public ElevatorGroupPosition(BlockPos pos, Direction facing) {
            this(pos.getX(), pos.getZ(), facing);
        }

        public ChunkPos chunkPos() {
            return new ChunkPos(SectionPos.blockToSectionCoord((int)this.x), SectionPos.blockToSectionCoord((int)this.z));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElevatorGroupPosition that = (ElevatorGroupPosition)o;
            if (this.x != that.x) {
                return false;
            }
            if (this.z != that.z) {
                return false;
            }
            return this.facing == that.facing;
        }

        public int hashCode() {
            int result = this.x;
            result = 31 * result + this.z;
            result = 31 * result + (this.facing != null ? this.facing.hashCode() : 0);
            return result;
        }

        public CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            tag.putInt("x", this.x);
            tag.putInt("z", this.z);
            tag.putInt("facing", this.facing.get2DDataValue());
            return tag;
        }

        public static ElevatorGroupPosition read(CompoundTag tag) {
            return new ElevatorGroupPosition(tag.getInt("x"), tag.getInt("z"), Direction.from2DDataValue((int)tag.getInt("facing")));
        }
    }
}

