/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.elevator;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.elevator.ElevatorFallDamageHandler;
import com.supermartijn642.movingelevators.packets.PacketOnElevator;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ElevatorCollisionHandler {
    public static void handleEntityCollisions(Level level, AABB bounds, List<AABB> boundingBoxes, Vec3 position, Vec3 motion) {
        bounds = bounds.move(position);
        bounds = new AABB(bounds.minX, bounds.minY + Math.min(0.0, motion.y), bounds.minZ, bounds.maxX, bounds.maxY + Math.max(0.0, motion.y), bounds.maxZ);
        bounds = bounds.inflate(2.0);
        List entities = level.getEntities((Entity)null, bounds, ElevatorCollisionHandler::canCollideWith);
        for (Entity entity : entities) {
            for (AABB box : boundingBoxes) {
                box = box.move(position);
                ElevatorCollisionHandler.handleHorizontalCollision(entity, box);
            }
            for (AABB box : boundingBoxes) {
                box = box.move(position);
                ElevatorCollisionHandler.handleVerticalCollision(entity, box, motion);
            }
        }
    }

    private static void handleHorizontalCollision(Entity entity, AABB box) {
        Vec3 entityPos = entity.position();
        Vec3 oldEntityPos = new Vec3(entity.xo, entity.yo, entity.zo);
        Vec3 entityMotion = entityPos.subtract(oldEntityPos);
        AABB entityBox = entity.getBoundingBox().deflate(1.0E-7);
        AABB oldEntityBox = entity.getBoundingBox().deflate(1.0E-7).move(-entityMotion.x, 0.0, -entityMotion.z);
        if (oldEntityBox.maxY > box.minY && oldEntityBox.minY < box.maxY) {
            if (oldEntityBox.maxX > box.minX && oldEntityBox.minX < box.maxX) {
                if (oldEntityBox.maxZ < box.minZ && entityBox.maxZ > box.minZ) {
                    entity.setPos(entityPos.x, entityPos.y, box.minZ - (double)(entity.getBbWidth() / 2.0f));
                    entity.setDeltaMovement(entity.getDeltaMovement().x, entity.getDeltaMovement().y, 0.0);
                } else if (oldEntityBox.minZ > box.maxZ && entityBox.minZ < box.maxZ) {
                    entity.setPos(entityPos.x, entityPos.y, box.maxZ + (double)(entity.getBbWidth() / 2.0f));
                    entity.setDeltaMovement(entity.getDeltaMovement().x, entity.getDeltaMovement().y, 0.0);
                }
            } else if (oldEntityBox.maxZ > box.minZ && oldEntityBox.minZ < box.maxZ) {
                if (oldEntityBox.maxX < box.minX && entityBox.maxX > box.minX) {
                    entity.setPos(box.minX - (double)(entity.getBbWidth() / 2.0f), entityPos.y, entityPos.z);
                    entity.setDeltaMovement(0.0, entity.getDeltaMovement().y, entity.getDeltaMovement().z);
                } else if (oldEntityBox.minX > box.maxX && entityBox.minX < box.maxX) {
                    entity.setPos(box.maxX + (double)(entity.getBbWidth() / 2.0f), entityPos.y, entityPos.z);
                    entity.setDeltaMovement(0.0, entity.getDeltaMovement().y, entity.getDeltaMovement().z);
                }
            }
        }
    }

    private static void handleVerticalCollision(Entity entity, AABB box, Vec3 motion) {
        AABB newBox = box.move(motion);
        boolean movingUp = motion.y > 0.0;
        Vec3 entityPos = entity.position();
        Vec3 oldEntityPos = new Vec3(entity.xo, entity.yo, entity.zo);
        Vec3 entityMotion = entityPos.subtract(oldEntityPos);
        AABB entityBox = entity.getBoundingBox().deflate(1.0E-7);
        AABB oldEntityBox = entity.getBoundingBox().deflate(1.0E-7).move(-entityMotion.x, -entityMotion.y, -entityMotion.z);
        if (oldEntityBox.maxX > box.minX && oldEntityBox.minX < box.maxX && oldEntityBox.maxZ > box.minZ && oldEntityBox.minZ < box.maxZ) {
            if (oldEntityBox.maxY < box.minY && entityBox.maxY > newBox.minY) {
                entity.setPos(entityPos.x, newBox.minY - (double)entity.getBbHeight(), entityPos.z);
                entity.setDeltaMovement(entity.getDeltaMovement().x, 0.0, entity.getDeltaMovement().z);
            } else if (oldEntityBox.minY > box.maxY && (entityBox.minY < newBox.maxY || !movingUp && ElevatorCollisionHandler.canPullEntity(entity) && oldEntityBox.minY > box.maxY && oldEntityBox.minY < box.maxY + 0.1)) {
                Player controllingPlayer;
                entity.setPos(entityPos.x, newBox.maxY, entityPos.z);
                entity.setDeltaMovement(entity.getDeltaMovement().x, 0.0, entity.getDeltaMovement().z);
                entity.setOnGround(true);
                if (!(entity instanceof LivingEntity) || !ElevatorFallDamageHandler.shouldCancelFallDamage((LivingEntity)entity)) {
                    entity.causeFallDamage(entity.fallDistance, 1.0f, entity.damageSources().fall());
                }
                entity.fallDistance = 0.0f;
                Object object = entity instanceof Player ? (Player)entity : (controllingPlayer = entity.getControllingPassenger() instanceof Player ? (Player)entity.getControllingPassenger() : null);
                if (entity instanceof LivingEntity && controllingPlayer != null) {
                    ElevatorFallDamageHandler.resetElevatorTime((LivingEntity)entity);
                    if (controllingPlayer.isLocalPlayer()) {
                        MovingElevators.CHANNEL.sendToServer((BasePacket)new PacketOnElevator());
                    }
                }
            }
        }
    }

    private static boolean canCollideWith(Entity entity) {
        return !entity.isSpectator() && !entity.noPhysics && !entity.isPassenger() && entity.getPistonPushReaction() == PushReaction.NORMAL;
    }

    private static boolean canPullEntity(Entity entity) {
        return entity.getDeltaMovement().y <= 0.0 && !entity.isNoGravity();
    }
}

