/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.elevator;

import com.supermartijn642.movingelevators.elevator.ClientElevatorCage;
import com.supermartijn642.movingelevators.extensions.MovingElevatorsLevelChunk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Clearable;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ElevatorCage {
    public final int xSize;
    public final int ySize;
    public final int zSize;
    public final BlockState[][][] blockStates;
    public final CompoundTag[][][] blockEntityData;
    public final Tag[][][] blockEntityStacks;
    public final VoxelShape shape;
    public final List<AABB> collisionBoxes;
    public final AABB bounds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ElevatorCage createCageAndClear(Level level, BlockPos startPos, int xSize, int ySize, int zSize) {
        BlockPos pos;
        int z;
        int y;
        int x;
        if (!ElevatorCage.canCreateCage(level, startPos, xSize, ySize, zSize)) {
            return null;
        }
        BlockState[][][] states = new BlockState[xSize][ySize][zSize];
        CompoundTag[][][] entities = new CompoundTag[xSize][ySize][zSize];
        CompoundTag[][][] entityItemStacks = new CompoundTag[xSize][ySize][zSize];
        VoxelShape shape = Shapes.empty();
        for (x = 0; x < xSize; ++x) {
            for (y = 0; y < ySize; ++y) {
                for (z = 0; z < zSize; ++z) {
                    pos = startPos.offset(x, y, z);
                    if (ElevatorCage.canBlockBeIgnored(level, pos)) continue;
                    states[x][y][z] = level.getBlockState(pos);
                    VoxelShape blockShape = states[x][y][z].getCollisionShape((BlockGetter)level, pos);
                    blockShape = blockShape.move((double)x, (double)y, (double)z);
                    shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)blockShape, (BooleanOp)BooleanOp.OR);
                    BlockEntity entity = level.getBlockEntity(pos);
                    if (entity == null) continue;
                    CompoundTag tag = entity.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess());
                    tag.putInt("x", x);
                    tag.putInt("y", y);
                    tag.putInt("z", z);
                    entities[x][y][z] = tag;
                    ItemStack stack = new ItemStack((ItemLike)states[x][y][z].getBlock());
                    entity.saveToItem(stack, (HolderLookup.Provider)level.registryAccess());
                    CustomData customData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
                    if (customData != null) {
                        customData = customData.update(data -> {
                            data.remove("x");
                            data.remove("y");
                            data.remove("z");
                        });
                        stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)customData);
                    }
                    entityItemStacks[x][y][z] = stack.save((HolderLookup.Provider)level.registryAccess());
                }
            }
        }
        for (x = 0; x < xSize; ++x) {
            for (y = 0; y < ySize; ++y) {
                for (z = 0; z < zSize; ++z) {
                    LevelChunk chunk;
                    pos = startPos.offset(x, y, z);
                    if (states[x][y][z] == null) continue;
                    BlockEntity entity = level.getBlockEntity(pos);
                    if (entity != null) {
                        Clearable.tryClear((Object)entity);
                        level.removeBlockEntity(pos);
                    }
                    if ((chunk = level.getChunkAt(pos)) != null) {
                        ((MovingElevatorsLevelChunk)chunk).movingElevatorsSuppressBlockUpdates(true);
                        try {
                            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 20);
                            continue;
                        }
                        finally {
                            ((MovingElevatorsLevelChunk)chunk).movingElevatorsSuppressBlockUpdates(false);
                        }
                    }
                    level.setBlock(pos, Blocks.AIR.defaultBlockState(), 20);
                }
            }
        }
        for (x = 0; x < xSize; ++x) {
            for (y = 0; y < ySize; ++y) {
                for (z = 0; z < zSize; ++z) {
                    pos = startPos.offset(x, y, z);
                    BlockState state = states[x][y][z];
                    if (states[x][y][z] == null) continue;
                    BlockState newState = level.getBlockState(pos);
                    state.onRemove(level, pos, newState, false);
                    level.markAndNotifyBlock(pos, level.getChunkAt(pos), states[x][y][z], newState, 3, 512);
                }
            }
        }
        shape.optimize();
        return level.isClientSide ? new ClientElevatorCage(xSize, ySize, zSize, states, entities, (Tag[][][])entityItemStacks, shape.toAabbs()) : new ElevatorCage(xSize, ySize, zSize, states, entities, (Tag[][][])entityItemStacks, shape.toAabbs());
    }

    public static boolean canCreateCage(Level level, BlockPos startPos, int xSize, int ySize, int zSize) {
        boolean hasBlocks = false;
        for (int x = 0; x < xSize; ++x) {
            for (int y = 0; y < ySize; ++y) {
                for (int z = 0; z < zSize; ++z) {
                    if (ElevatorCage.canBlockBeIgnored(level, startPos.offset(x, y, z))) continue;
                    if (!ElevatorCage.canBlockBeInCage(level, startPos.offset(x, y, z))) {
                        return false;
                    }
                    hasBlocks = true;
                }
            }
        }
        return hasBlocks;
    }

    public static boolean canBlockBeIgnored(Level level, BlockPos pos) {
        return level.isEmptyBlock(pos) || level.getBlockState(pos).is(Blocks.LIGHT);
    }

    public static boolean canBlockBeInCage(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return state.getFluidState().isEmpty() && state.getDestroySpeed((BlockGetter)level, pos) >= 0.0f;
    }

    public ElevatorCage(int xSize, int ySize, int zSize, BlockState[][][] states, CompoundTag[][][] blockEntityData, Tag[][][] blockEntityStacks, List<AABB> collisionBoxes) {
        this.blockEntityData = blockEntityData;
        this.blockEntityStacks = blockEntityStacks;
        if (states.length != xSize || states[0].length != ySize || states[0][0].length != zSize) {
            throw new IllegalArgumentException("Given size and block state array do not match!");
        }
        this.xSize = xSize;
        this.ySize = ySize;
        this.zSize = zSize;
        this.blockStates = states;
        this.collisionBoxes = Collections.unmodifiableList(collisionBoxes);
        VoxelShape shape = Shapes.empty();
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        double maxZ = 0.0;
        for (AABB box : collisionBoxes) {
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.create((AABB)box), (BooleanOp)BooleanOp.OR);
            minX = Math.min(minX, box.minX);
            minY = Math.min(minY, box.minY);
            minZ = Math.min(minZ, box.minZ);
            maxX = Math.max(maxX, box.maxX);
            maxY = Math.max(maxY, box.maxY);
            maxZ = Math.max(maxZ, box.maxZ);
        }
        this.shape = shape.optimize();
        this.bounds = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void place(Level level, BlockPos startPos) {
        BlockPos pos;
        int z;
        int y;
        int x;
        BlockState[][][] oldStates = new BlockState[this.xSize][this.ySize][this.zSize];
        for (x = 0; x < this.xSize; ++x) {
            for (y = 0; y < this.ySize; ++y) {
                for (z = 0; z < this.zSize; ++z) {
                    BlockState state = this.blockStates[x][y][z];
                    if (state == null) continue;
                    pos = startPos.offset(x, y, z);
                    BlockState currentState = level.getBlockState(pos);
                    if (ElevatorCage.canBlockBeIgnored(level, pos) || currentState.getDestroySpeed((BlockGetter)level, pos) >= 0.0f) {
                        BlockEntity entity;
                        LevelChunk chunk;
                        oldStates[x][y][z] = currentState;
                        if (!level.isEmptyBlock(pos)) {
                            level.destroyBlock(pos, true);
                        }
                        if ((chunk = level.getChunkAt(pos)) != null) {
                            ((MovingElevatorsLevelChunk)chunk).movingElevatorsSuppressBlockUpdates(true);
                            try {
                                level.setBlock(pos, state, 20);
                            }
                            finally {
                                ((MovingElevatorsLevelChunk)chunk).movingElevatorsSuppressBlockUpdates(false);
                            }
                        } else {
                            level.setBlock(pos, state, 20);
                        }
                        if (this.blockEntityData[x][y][z] == null || (entity = BlockEntity.loadStatic((BlockPos)pos, (BlockState)state, (CompoundTag)this.blockEntityData[x][y][z], (HolderLookup.Provider)level.registryAccess())) == null) continue;
                        level.setBlockEntity(entity);
                        continue;
                    }
                    Tag itemTag = this.blockEntityStacks[x][y][z];
                    ItemStack stack = itemTag == null ? new ItemStack((ItemLike)state.getBlock()) : ItemStack.parse((HolderLookup.Provider)level.registryAccess(), (Tag)itemTag).orElse(new ItemStack((ItemLike)state.getBlock()));
                    Containers.dropItemStack((Level)level, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (ItemStack)stack);
                }
            }
        }
        for (x = 0; x < this.xSize; ++x) {
            for (y = 0; y < this.ySize; ++y) {
                for (z = 0; z < this.zSize; ++z) {
                    BlockState previousState = oldStates[x][y][z];
                    if (previousState == null) continue;
                    pos = startPos.offset(x, y, z);
                    BlockState state = level.getBlockState(pos);
                    state.onPlace(level, pos, previousState, true);
                    boolean isOnTheBoundary = x == 0 || x == this.xSize - 1 || y == 0 || y == this.ySize - 1 || z == 0 || z == this.zSize - 1;
                    int flags = isOnTheBoundary ? 3 : 22;
                    level.markAndNotifyBlock(pos, level.getChunkAt(pos), previousState, state, flags, 512);
                    if (!level.isClientSide && state.getBlock() instanceof ButtonBlock && state.hasProperty((Property)ButtonBlock.POWERED) && ((Boolean)state.getValue((Property)ButtonBlock.POWERED)).booleanValue()) {
                        state.tick((ServerLevel)level, pos, level.random);
                    }
                    if (!level.isClientSide && state.getBlock() instanceof PressurePlateBlock && state.hasProperty((Property)PressurePlateBlock.POWERED) && ((Boolean)state.getValue((Property)PressurePlateBlock.POWERED)).booleanValue()) {
                        state.tick((ServerLevel)level, pos, level.random);
                    }
                    if (!state.is(Blocks.REDSTONE_WIRE)) continue;
                    boolean[] updateDirections = new boolean[6];
                    updateDirections[4] = x == 0;
                    updateDirections[5] = x == this.xSize - 1;
                    updateDirections[0] = y == 0;
                    updateDirections[1] = y == this.ySize - 1;
                    updateDirections[2] = z == 0;
                    updateDirections[3] = z == this.zSize - 1;
                    for (int i = 0; i < updateDirections.length; ++i) {
                        if (!updateDirections[i]) continue;
                        Direction direction = Direction.values()[i];
                        level.updateNeighborsAt(pos.relative(direction), Blocks.REDSTONE_WIRE);
                    }
                }
            }
        }
    }

    public List<ItemStack> getDrops(HolderLookup.Provider provider) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (int x = 0; x < this.xSize; ++x) {
            for (int y = 0; y < this.ySize; ++y) {
                for (int z = 0; z < this.zSize; ++z) {
                    if (this.blockStates[x][y][z] == null) continue;
                    if (this.blockEntityStacks[x][y][z] != null) {
                        drops.add(ItemStack.parse((HolderLookup.Provider)provider, (Tag)this.blockEntityStacks[x][y][z]).orElse(new ItemStack((ItemLike)this.blockStates[x][y][z].getBlock())));
                        continue;
                    }
                    drops.add(new ItemStack((ItemLike)this.blockStates[x][y][z].getBlock()));
                }
            }
        }
        return drops;
    }

    public CompoundTag write() {
        CompoundTag compound = new CompoundTag();
        compound.putInt("xSize", this.xSize);
        compound.putInt("ySize", this.ySize);
        compound.putInt("zSize", this.zSize);
        int[] stateIds = new int[this.xSize * this.ySize * this.zSize];
        ListTag entityData = new ListTag();
        for (int x = 0; x < this.xSize; ++x) {
            for (int y = 0; y < this.ySize; ++y) {
                for (int z = 0; z < this.zSize; ++z) {
                    int index = x * this.ySize * this.zSize + y * this.zSize + z;
                    BlockState state = this.blockStates[x][y][z];
                    stateIds[index] = Block.getId((BlockState)(state == null || state.getBlock() == Blocks.AIR ? Blocks.AIR.defaultBlockState() : state));
                    if (this.blockEntityData[x][y][z] == null) continue;
                    CompoundTag tag = new CompoundTag();
                    tag.putInt("x", x);
                    tag.putInt("y", y);
                    tag.putInt("z", z);
                    tag.put("data", (Tag)this.blockEntityData[x][y][z]);
                    tag.put("stack", this.blockEntityStacks[x][y][z]);
                    entityData.add((Object)tag);
                }
            }
        }
        compound.putIntArray("blockStates", stateIds);
        compound.put("entityData", (Tag)entityData);
        ListTag collisionBoxList = new ListTag();
        this.collisionBoxes.forEach(box -> collisionBoxList.add((Object)ElevatorCage.writeBox(box)));
        compound.put("collisionBoxes", (Tag)collisionBoxList);
        return compound;
    }

    public static ElevatorCage read(CompoundTag compound, boolean isClientSide) {
        int xSize = compound.getInt("xSize");
        int ySize = compound.getInt("ySize");
        int zSize = compound.getInt("zSize");
        int[] stateIds = compound.getIntArray("blockStates");
        BlockState[][][] blockStates = new BlockState[xSize][ySize][zSize];
        for (int x = 0; x < xSize; ++x) {
            for (int y = 0; y < ySize; ++y) {
                for (int z = 0; z < zSize; ++z) {
                    int index = x * ySize * zSize + y * zSize + z;
                    BlockState state = Block.stateById((int)stateIds[index]);
                    blockStates[x][y][z] = state.getBlock() == Blocks.AIR ? null : state;
                }
            }
        }
        CompoundTag[][][] entityTags = new CompoundTag[xSize][ySize][zSize];
        CompoundTag[][][] stackTags = new CompoundTag[xSize][ySize][zSize];
        if (compound.contains("entityData", 9)) {
            ListTag entityData = compound.getList("entityData", 10);
            for (Tag tag : entityData) {
                int x = ((CompoundTag)tag).getInt("x");
                int y = ((CompoundTag)tag).getInt("y");
                int z = ((CompoundTag)tag).getInt("z");
                entityTags[x][y][z] = ((CompoundTag)tag).getCompound("data");
                stackTags[x][y][z] = ((CompoundTag)tag).getCompound("stack");
            }
        }
        ListTag collisionBoxList = compound.getList("collisionBoxes", 10);
        List<AABB> collisionBoxes = collisionBoxList.stream().map(CompoundTag.class::cast).map(ElevatorCage::readBox).collect(Collectors.toList());
        return isClientSide ? new ClientElevatorCage(xSize, ySize, zSize, blockStates, entityTags, (Tag[][][])stackTags, collisionBoxes) : new ElevatorCage(xSize, ySize, zSize, blockStates, entityTags, (Tag[][][])stackTags, collisionBoxes);
    }

    private static CompoundTag writeBox(AABB box) {
        CompoundTag compound = new CompoundTag();
        compound.putDouble("x1", box.minX);
        compound.putDouble("y1", box.minY);
        compound.putDouble("z1", box.minZ);
        compound.putDouble("x2", box.maxX);
        compound.putDouble("y2", box.maxY);
        compound.putDouble("z2", box.maxZ);
        return compound;
    }

    private static AABB readBox(CompoundTag compound) {
        return new AABB(compound.getDouble("x1"), compound.getDouble("y1"), compound.getDouble("z1"), compound.getDouble("x2"), compound.getDouble("y2"), compound.getDouble("z2"));
    }
}

