/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.elevator;

import com.supermartijn642.movingelevators.elevator.ClientElevatorCage;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.ScheduledTick;
import org.jetbrains.annotations.Nullable;

public class ElevatorCabinLevel
extends Level {
    private Level level;
    private ClientElevatorCage cage;
    private ElevatorGroup group;
    private BlockPos minPos;
    private BlockPos maxPos;

    protected ElevatorCabinLevel(Level clientLevel) {
        super(null, clientLevel.dimension(), clientLevel.registryAccess(), clientLevel.dimensionTypeRegistration(), null, true, false, 0L, 512);
        this.level = clientLevel;
    }

    public void setCabinAndPos(Level clientLevel, ClientElevatorCage cage, ElevatorGroup group, BlockPos anchorPos) {
        this.level = clientLevel;
        this.cage = cage;
        this.group = group;
        this.minPos = anchorPos;
        this.maxPos = anchorPos.offset(cage.xSize - 1, cage.ySize - 1, cage.zSize - 1);
    }

    public ElevatorGroup getElevatorGroup() {
        return this.group;
    }

    private boolean isInBounds(BlockPos pos) {
        return pos.getX() >= this.minPos.getX() && pos.getX() <= this.maxPos.getX() && pos.getY() >= this.minPos.getY() && pos.getY() <= this.maxPos.getY() && pos.getZ() >= this.minPos.getZ() && pos.getZ() <= this.maxPos.getZ();
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos) {
        return this.isInBounds(pos) ? this.cage.blockEntities[pos.getX() - this.minPos.getX()][pos.getY() - this.minPos.getY()][pos.getZ() - this.minPos.getZ()] : null;
    }

    public BlockState getBlockState(BlockPos pos) {
        if (this.isInBounds(pos)) {
            BlockState state = this.cage.blockStates[pos.getX() - this.minPos.getX()][pos.getY() - this.minPos.getY()][pos.getZ() - this.minPos.getZ()];
            return state == null ? Blocks.AIR.defaultBlockState() : state;
        }
        return Blocks.AIR.defaultBlockState();
    }

    public void sendBlockUpdated(BlockPos pos, BlockState state, BlockState newState, int flags) {
    }

    public void playSeededSound(@Nullable Player player, double x, double y, double z, Holder<SoundEvent> sound, SoundSource source, float pitch, float volume, long l) {
    }

    public void playSeededSound(@Nullable Player player, Entity entity, Holder<SoundEvent> sound, SoundSource source, float pitch, float volume, long l) {
    }

    public String gatherChunkSourceStats() {
        return "";
    }

    @Nullable
    public Entity getEntity(int entityId) {
        return null;
    }

    @Nullable
    public MapItemSavedData getMapData(MapId id) {
        return this.level.getMapData(id);
    }

    public void setMapData(MapId id, MapItemSavedData savedData) {
    }

    public MapId getFreeMapId() {
        return new MapId(0);
    }

    public void destroyBlockProgress(int i, BlockPos pos, int j) {
    }

    public Scoreboard getScoreboard() {
        return this.level.getScoreboard();
    }

    public RecipeManager getRecipeManager() {
        return this.level.getRecipeManager();
    }

    protected LevelEntityGetter<Entity> getEntities() {
        return new LevelEntityGetter<Entity>(this){

            @Nullable
            public Entity get(int entityId) {
                return null;
            }

            @Nullable
            public Entity get(UUID id) {
                return null;
            }

            public Iterable<Entity> getAll() {
                return Collections.emptyList();
            }

            public <U extends Entity> void get(EntityTypeTest<Entity, U> entityTypeTest, AbortableIterationConsumer<U> abortableIterationConsumer) {
            }

            public void get(AABB aabb, Consumer<Entity> consumer) {
            }

            public <U extends Entity> void get(EntityTypeTest<Entity, U> entityTypeTest, AABB aabb, AbortableIterationConsumer<U> abortableIterationConsumer) {
            }
        };
    }

    public PotionBrewing potionBrewing() {
        return null;
    }

    public void setDayTimeFraction(float v) {
    }

    public float getDayTimeFraction() {
        return this.level.getDayTimeFraction();
    }

    public float getDayTimePerTick() {
        return this.level.getDayTimePerTick();
    }

    public void setDayTimePerTick(float v) {
    }

    public LevelTickAccess<Block> getBlockTicks() {
        return new LevelTickAccess<Block>(this){

            public boolean willTickThisTick(BlockPos pos, Block block) {
                return false;
            }

            public void schedule(ScheduledTick<Block> scheduledTick) {
            }

            public boolean hasScheduledTick(BlockPos pos, Block block) {
                return false;
            }

            public int count() {
                return 0;
            }
        };
    }

    public LevelTickAccess<Fluid> getFluidTicks() {
        return new LevelTickAccess<Fluid>(this){

            public boolean willTickThisTick(BlockPos pos, Fluid fluid) {
                return false;
            }

            public void schedule(ScheduledTick<Fluid> scheduledTick) {
            }

            public boolean hasScheduledTick(BlockPos pos, Fluid fluid) {
                return false;
            }

            public int count() {
                return 0;
            }
        };
    }

    public ChunkSource getChunkSource() {
        return this.level.getChunkSource();
    }

    public void levelEvent(@Nullable Player player, int i, BlockPos pos, int j) {
    }

    public void gameEvent(Holder<GameEvent> gameEvent, Vec3 vec3, GameEvent.Context context) {
    }

    public float getShade(Direction side, boolean bl) {
        return this.level.getShade(side, bl);
    }

    public List<? extends Player> players() {
        return Collections.emptyList();
    }

    public Holder<Biome> getUncachedNoiseBiome(int i, int j, int k) {
        return this.level.getUncachedNoiseBiome(i, j, k);
    }

    public FeatureFlagSet enabledFeatures() {
        return this.level.enabledFeatures();
    }

    public boolean setBlock(BlockPos pos, BlockState state, int i) {
        return false;
    }

    public long dayTime() {
        return this.level.dayTime();
    }

    public long getDayTime() {
        return this.level.getDayTime();
    }

    public TickRateManager tickRateManager() {
        return this.level.tickRateManager();
    }

    public long getGameTime() {
        return this.level.getGameTime();
    }

    public float getTimeOfDay(float f) {
        return this.level.getTimeOfDay(f);
    }

    public ProfilerFiller getProfiler() {
        return this.level.getProfiler();
    }

    public Supplier<ProfilerFiller> getProfilerSupplier() {
        return this.level.getProfilerSupplier();
    }
}

