/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.item.BaseBlockItem;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.movingelevators.blocks.RemoteControllerBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class RemoteControllerBlockItem
extends BaseBlockItem {
    public RemoteControllerBlockItem(Block block, ItemProperties properties) {
        super(block, properties);
    }

    public BaseBlockItem.ItemUseResult interact(ItemStack stack, Player player, InteractionHand hand, Level level) {
        if (player.isShiftKeyDown()) {
            if (stack.has(RemoteControllerBlock.TARGET)) {
                if (!level.isClientSide) {
                    stack.remove(RemoteControllerBlock.TARGET);
                    player.displayClientMessage((Component)TextComponents.translation((String)"movingelevators.remote_controller.clear").get(), true);
                }
                return BaseBlockItem.ItemUseResult.success((ItemStack)stack);
            }
        } else {
            if (!level.isClientSide) {
                RemoteControllerBlock.Target target = (RemoteControllerBlock.Target)stack.get(RemoteControllerBlock.TARGET);
                if (target != null) {
                    MutableComponent x = TextComponents.number((int)target.pos().getX()).color(ChatFormatting.GOLD).get();
                    MutableComponent y = TextComponents.number((int)target.pos().getY()).color(ChatFormatting.GOLD).get();
                    MutableComponent z = TextComponents.number((int)target.pos().getZ()).color(ChatFormatting.GOLD).get();
                    MutableComponent dimension = TextComponents.dimension((ResourceKey)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)target.dimension())).color(ChatFormatting.GOLD).get();
                    player.displayClientMessage((Component)TextComponents.translation((String)"movingelevators.remote_controller.tooltip.bound", (Object[])new Object[]{x, y, z, dimension}).get(), true);
                } else {
                    player.displayClientMessage((Component)TextComponents.translation((String)"movingelevators.remote_controller.tooltip").get(), true);
                }
            }
            return BaseBlockItem.ItemUseResult.success((ItemStack)stack);
        }
        return super.interact(stack, player, hand, level);
    }

    public BaseBlockItem.InteractionFeedback interactWithBlock(ItemStack stack, Player player, InteractionHand hand, Level level, BlockPos hitPos, Direction hitSide, Vec3 hitLocation) {
        RemoteControllerBlock.Target target = (RemoteControllerBlock.Target)stack.get(RemoteControllerBlock.TARGET);
        if (target == null) {
            if (player != null && !level.isClientSide) {
                player.displayClientMessage((Component)TextComponents.translation((String)"movingelevators.remote_controller.not_bound").color(ChatFormatting.RED).get(), true);
            }
            return BaseBlockItem.InteractionFeedback.CONSUME;
        }
        if (!target.dimension().equals((Object)level.dimension().location())) {
            if (player != null && !level.isClientSide) {
                player.displayClientMessage((Component)TextComponents.translation((String)"movingelevators.remote_controller.wrong_dimension").color(ChatFormatting.RED).get(), true);
            }
            return BaseBlockItem.InteractionFeedback.CONSUME;
        }
        return super.interactWithBlock(stack, player, hand, level, hitPos, hitSide, hitLocation);
    }
}

