/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.movingelevators.blocks.CamoBlockEntity;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlock;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntity;
import com.supermartijn642.movingelevators.blocks.RemoteControllerBlockEntity;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RemoteControllerBlock
extends ElevatorInputBlock {
    public static final DataComponentType<Target> TARGET = DataComponentType.builder().persistent(RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("dimension").forGetter(Target::dimension), (App)BlockPos.CODEC.fieldOf("pos").forGetter(Target::pos), (App)Direction.CODEC.fieldOf("facing").forGetter(Target::facing)).apply((Applicative)instance, Target::new))).networkSynchronized(StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, Target::dimension, (StreamCodec)BlockPos.STREAM_CODEC, Target::pos, (StreamCodec)Direction.STREAM_CODEC, Target::facing, Target::new)).build();

    public RemoteControllerBlock(BlockProperties properties) {
        super(properties, (BiFunction<BlockPos, BlockState, ? extends ElevatorInputBlockEntity>)((BiFunction<BlockPos, BlockState, ElevatorInputBlockEntity>)RemoteControllerBlockEntity::new));
    }

    @Override
    protected boolean onRightClick(BlockState state, Level level, CamoBlockEntity blockEntity, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        if (super.onRightClick(state, level, blockEntity, pos, player, hand, hitSide, hitLocation)) {
            return true;
        }
        if (blockEntity instanceof RemoteControllerBlockEntity) {
            if (level.isClientSide) {
                BlockPos controllerPos = ((RemoteControllerBlockEntity)blockEntity).getControllerPos();
                MutableComponent x = TextComponents.number((int)controllerPos.getX()).color(ChatFormatting.GOLD).get();
                MutableComponent y = TextComponents.number((int)controllerPos.getY()).color(ChatFormatting.GOLD).get();
                MutableComponent z = TextComponents.number((int)controllerPos.getZ()).color(ChatFormatting.GOLD).get();
                player.displayClientMessage((Component)TextComponents.translation((String)"movingelevators.remote_controller.controller_location", (Object[])new Object[]{x, y, z}).get(), true);
            }
            return true;
        }
        return false;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof RemoteControllerBlockEntity) {
            Target target = (Target)stack.get(TARGET);
            if (target == null) {
                return;
            }
            ((RemoteControllerBlockEntity)entity).setValues(placer == null ? Direction.NORTH : placer.getDirection().getOpposite(), target.pos, target.facing);
        }
    }

    protected void appendItemInformation(ItemStack stack, Consumer<Component> info, boolean advanced) {
        Target target = (Target)stack.get(TARGET);
        if (target == null) {
            info.accept((Component)TextComponents.translation((String)"movingelevators.remote_controller.tooltip").color(ChatFormatting.AQUA).get());
        } else {
            MutableComponent x = TextComponents.number((int)target.pos.getX()).color(ChatFormatting.GOLD).get();
            MutableComponent y = TextComponents.number((int)target.pos.getY()).color(ChatFormatting.GOLD).get();
            MutableComponent z = TextComponents.number((int)target.pos.getZ()).color(ChatFormatting.GOLD).get();
            MutableComponent dimension = TextComponents.dimension((ResourceKey)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)target.dimension)).color(ChatFormatting.GOLD).get();
            info.accept((Component)TextComponents.translation((String)"movingelevators.remote_controller.tooltip.bound", (Object[])new Object[]{x, y, z, dimension}).get());
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        Object entity = level.getBlockEntity(pos);
        if (entity instanceof RemoteControllerBlockEntity && (entity = ((RemoteControllerBlockEntity)((Object)entity)).getController()) != null && ((ControllerBlockEntity)((Object)entity)).hasGroup() && ((ControllerBlockEntity)((Object)entity)).getGroup().isCageAvailableAt((ControllerBlockEntity)((Object)entity))) {
            return 15;
        }
        return 0;
    }

    public record Target(ResourceLocation dimension, BlockPos pos, Direction facing) {
    }
}

