/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.core.render.CustomBlockEntityRenderer;
import com.supermartijn642.movingelevators.MovingElevatorsClient;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntity;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class ElevatorInputBlockEntityRenderer<T extends ElevatorInputBlockEntity>
implements CustomBlockEntityRenderer<T> {
    public void render(T entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        if (((ElevatorInputBlockEntity)((Object)entity)).getFacing() == null || entity instanceof ControllerBlockEntity && !((ControllerBlockEntity)((Object)entity)).shouldShowButtons()) {
            return;
        }
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.cutout());
        Direction facing = ((ElevatorInputBlockEntity)((Object)entity)).getFacing();
        combinedLight = LevelRenderer.getLightColor((BlockAndTintGetter)entity.getLevel(), (BlockPos)entity.getBlockPos().relative(facing));
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(new Quaternionf().setAngleAxis((double)((180.0f - facing.toYRot()) / 180.0f) * Math.PI, 0.0, 1.0, 0.0));
        poseStack.translate(-0.5, -0.5, -0.51);
        boolean canReceiveInput = ((ElevatorInputBlockEntity)((Object)entity)).canReceiveInput();
        boolean renderUp = canReceiveInput && ((ElevatorInputBlockEntity)((Object)entity)).canMoveUp();
        boolean renderDown = canReceiveInput && ((ElevatorInputBlockEntity)((Object)entity)).canMoveDown();
        this.drawOverlayPart(poseStack, buffer, combinedLight, combinedOverlay, facing, 0.0f, 0.0f, 1.0f, 1.0f, 0, renderUp ? 64 : 87, 23, 23);
        this.drawOverlayPart(poseStack, buffer, combinedLight, combinedOverlay, facing, 0.0f, 0.0f, 1.0f, 1.0f, 23, canReceiveInput ? 64 : 87, 23, 23);
        this.drawOverlayPart(poseStack, buffer, combinedLight, combinedOverlay, facing, 0.0f, 0.0f, 1.0f, 1.0f, 46, renderDown ? 64 : 87, 23, 23);
        poseStack.popPose();
    }

    private void drawOverlayPart(PoseStack poseStack, VertexConsumer buffer, int combinedLight, int combinedOverlay, Direction facing, float x, float y, float width, float height, int tX, int tY, int tWidth, int tHeight) {
        Matrix4f matrix = poseStack.last().pose();
        TextureAtlasSprite overlaySprite = MovingElevatorsClient.OVERLAY_SPRITE;
        float minU = overlaySprite.getU((float)tX / 128.0f);
        float maxU = overlaySprite.getU((float)(tX + tWidth) / 128.0f);
        float minV = overlaySprite.getV((float)tY / 128.0f);
        float maxV = overlaySprite.getV((float)(tY + tHeight) / 128.0f);
        buffer.addVertex(matrix, x, y + height, 0.0f).setColor(255, 255, 255, 255).setUv(maxU, minV).setLight(combinedLight).setNormal(poseStack.last(), (float)facing.getStepX(), (float)facing.getStepY(), (float)facing.getStepZ()).setOverlay(combinedOverlay);
        buffer.addVertex(matrix, x + width, y + height, 0.0f).setColor(255, 255, 255, 255).setUv(minU, minV).setLight(combinedLight).setNormal(poseStack.last(), (float)facing.getStepX(), (float)facing.getStepY(), (float)facing.getStepZ()).setOverlay(combinedOverlay);
        buffer.addVertex(matrix, x + width, y, 0.0f).setColor(255, 255, 255, 255).setUv(minU, maxV).setLight(combinedLight).setNormal(poseStack.last(), (float)facing.getStepX(), (float)facing.getStepY(), (float)facing.getStepZ()).setOverlay(combinedOverlay);
        buffer.addVertex(matrix, x, y, 0.0f).setColor(255, 255, 255, 255).setUv(maxU, maxV).setLight(combinedLight).setNormal(poseStack.last(), (float)facing.getStepX(), (float)facing.getStepY(), (float)facing.getStepZ()).setOverlay(combinedOverlay);
    }
}

