/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.movingelevators.blocks.CamoBlock;
import com.supermartijn642.movingelevators.blocks.CamoBlockEntity;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntity;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ElevatorInputBlock
extends CamoBlock {
    public ElevatorInputBlock(BlockProperties properties, BiFunction<BlockPos, BlockState, ? extends ElevatorInputBlockEntity> entitySupplier) {
        super(properties, entitySupplier);
    }

    @Override
    protected boolean onRightClick(BlockState state, Level level, CamoBlockEntity blockEntity, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        ElevatorInputBlockEntity inputEntity;
        if (blockEntity instanceof ElevatorInputBlockEntity && (inputEntity = (ElevatorInputBlockEntity)blockEntity).getFacing() == hitSide && inputEntity.hasGroup()) {
            if (!level.isClientSide) {
                double y = hitLocation.y - (double)pos.getY();
                inputEntity.getGroup().onButtonPress(y > 0.6666666666666666, y < 0.3333333333333333, inputEntity.getFloorLevel());
            }
            return true;
        }
        return super.onRightClick(state, level, blockEntity, pos, player, hand, hitSide, hitLocation);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof ElevatorInputBlockEntity) {
            ((ElevatorInputBlockEntity)entity).redstone = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.above());
        }
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction side) {
        return true;
    }
}

