/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.CustomBlockEntityRenderer;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.movingelevators.MovingElevatorsClient;
import com.supermartijn642.movingelevators.blocks.DisplayBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class DisplayBlockEntityRenderer
implements CustomBlockEntityRenderer<DisplayBlockEntity> {
    private static final double TEXT_RENDER_DISTANCE = 225.0;

    public void render(DisplayBlockEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        double platformY;
        if (!entity.isBottomDisplay() || !entity.getInputBlockEntity().hasGroup()) {
            return;
        }
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.cutout());
        int height = entity.hasDisplayOnTop() ? 2 : 1;
        Level level = entity.getLevel();
        Direction facing = entity.getFacing();
        ElevatorGroup group = entity.getElevatorGroup();
        BlockPos frontPos = entity.getBlockPos().relative(facing);
        if (height == 1) {
            combinedLight = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)frontPos);
        } else if (level.getBlockState(frontPos).emissiveRendering((BlockGetter)level, frontPos) || level.getBlockState(frontPos.above()).emissiveRendering((BlockGetter)level, frontPos.above())) {
            combinedLight = 0xF000F0;
        } else {
            int skyLight = Math.max(level.getBrightness(LightLayer.SKY, frontPos), level.getBrightness(LightLayer.SKY, frontPos.above()));
            int blockLight = Math.max(level.getBrightness(LightLayer.BLOCK, frontPos), level.getBrightness(LightLayer.BLOCK, frontPos.above()));
            int blockStateLight = Math.max(level.getBlockState(frontPos).getLightEmission((BlockGetter)level, frontPos), level.getBlockState(frontPos.above()).getLightEmission((BlockGetter)level, frontPos.above()));
            blockLight = Math.max(blockLight, blockStateLight);
            combinedLight = skyLight << 20 | blockLight << 4;
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(new Quaternionf().setAngleAxis((double)((180.0f - facing.toYRot()) / 180.0f) * Math.PI, 0.0, 1.0, 0.0));
        poseStack.translate(-0.5, -0.5, -0.51);
        if (height == 1) {
            this.drawOverlayPart(poseStack, buffer, combinedLight, combinedOverlay, facing, 0.0f, 0.0f, 1.0f, 1.0f, 0, 0, 32, 32);
        } else {
            this.drawOverlayPart(poseStack, buffer, combinedLight, combinedOverlay, facing, 0.0f, 0.0f, 1.0f, 2.0f, 32, 0, 32, 64);
        }
        int index = group.getFloorNumber(entity.getInputBlockEntity().getFloorLevel());
        int button_count = height == 1 ? 3 : 7;
        int below = index;
        int above = group.getFloorCount() - index - 1;
        if (below < above) {
            below = Math.min(below, button_count);
            above = Math.min(above, button_count * 2 - below);
        } else {
            above = Math.min(above, button_count);
            below = Math.min(below, button_count * 2 - above);
        }
        int startIndex = index - below;
        int total = below + 1 + above;
        poseStack.pushPose();
        poseStack.translate(0.0, 0.5 * (double)height - (double)((float)total * 0.125f) / 2.0, -0.002);
        poseStack.scale(1.0f, 0.125f, 1.0f);
        for (int i = 0; i < total; ++i) {
            DyeColor labelColor = group.getFloorDisplayColor(startIndex + i);
            this.drawOverlayPart(poseStack, buffer, combinedLight, combinedOverlay, facing, 0.0f, 0.0f, 1.0f, 1.0f, startIndex + i == index ? 96 : 64, labelColor.getId() * 4, 32, 4);
            poseStack.translate(0.0f, 1.0f, 0.0f);
        }
        poseStack.popPose();
        if (group.isMoving() && (platformY = group.getCurrentY()) >= (double)group.getFloorYLevel(0) && platformY < (double)group.getFloorYLevel(group.getFloorCount() - 1)) {
            double yOffset = 0.5 * (double)height - (double)((float)total * 0.125f) / 2.0;
            for (int i = 0; i < group.getFloorCount() - 1; ++i) {
                int belowY = group.getFloorYLevel(i);
                int aboveY = group.getFloorYLevel(i + 1);
                if (!(platformY >= (double)belowY) || !(platformY < (double)aboveY)) continue;
                yOffset += ((double)i + (platformY - (double)belowY) / (double)(aboveY - belowY)) * 0.125;
            }
            poseStack.pushPose();
            poseStack.translate(0.078125, yOffset, -0.003);
            poseStack.scale(0.125f, 0.125f, 1.0f);
            this.drawOverlayPart(poseStack, buffer, combinedLight, combinedOverlay, facing, 0.0f, 0.0f, 1.0f, 1.0f, 0, 32, 10, 10);
            poseStack.popPose();
        }
        Vec3 buttonPos = new Vec3((double)entity.getBlockPos().getX() + 0.5, (double)entity.getBlockPos().getY() + 0.5 * (double)height - (double)((float)total * 0.125f) / 2.0, (double)entity.getBlockPos().getZ() + 0.5);
        Vec3 cameraPos = RenderUtils.getCameraPosition();
        poseStack.pushPose();
        poseStack.translate(0.0, 0.5 * (double)height - (double)((float)total * 0.125f) / 2.0, -0.002);
        poseStack.scale(1.0f, 0.125f, 1.0f);
        for (int i = 0; i < total; ++i) {
            boolean drawText;
            boolean bl = drawText = cameraPos.distanceToSqr(buttonPos) < 225.0;
            if (drawText) {
                poseStack.pushPose();
                poseStack.translate(0.578125, 0.0, 0.0);
                this.drawString(poseStack, bufferSource, combinedLight, MovingElevatorsClient.formatFloorDisplayName(group.getFloorDisplayName(startIndex + i), startIndex + i));
                poseStack.popPose();
            }
            poseStack.translate(0.0f, 1.0f, 0.0f);
            buttonPos = buttonPos.add(0.0, 0.125, 0.0);
        }
        poseStack.popPose();
        poseStack.popPose();
    }

    private void drawOverlayPart(PoseStack poseStack, VertexConsumer buffer, int combinedLight, int combinedOverlay, Direction facing, float x, float y, float width, float height, int tX, int tY, int tWidth, int tHeight) {
        Matrix4f matrix = poseStack.last().pose();
        TextureAtlasSprite overlaySprite = MovingElevatorsClient.OVERLAY_SPRITE;
        float minU = overlaySprite.getU((float)tX / 128.0f);
        float maxU = overlaySprite.getU((float)(tX + tWidth) / 128.0f);
        float minV = overlaySprite.getV((float)tY / 128.0f);
        float maxV = overlaySprite.getV((float)(tY + tHeight) / 128.0f);
        buffer.addVertex(matrix, x, y + height, 0.0f).setColor(255, 255, 255, 255).setUv(maxU, minV).setLight(combinedLight).setNormal(poseStack.last(), (float)facing.getStepX(), (float)facing.getStepY(), (float)facing.getStepZ()).setOverlay(combinedOverlay);
        buffer.addVertex(matrix, x + width, y + height, 0.0f).setColor(255, 255, 255, 255).setUv(minU, minV).setLight(combinedLight).setNormal(poseStack.last(), (float)facing.getStepX(), (float)facing.getStepY(), (float)facing.getStepZ()).setOverlay(combinedOverlay);
        buffer.addVertex(matrix, x + width, y, 0.0f).setColor(255, 255, 255, 255).setUv(minU, maxV).setLight(combinedLight).setNormal(poseStack.last(), (float)facing.getStepX(), (float)facing.getStepY(), (float)facing.getStepZ()).setOverlay(combinedOverlay);
        buffer.addVertex(matrix, x, y, 0.0f).setColor(255, 255, 255, 255).setUv(maxU, maxV).setLight(combinedLight).setNormal(poseStack.last(), (float)facing.getStepX(), (float)facing.getStepY(), (float)facing.getStepZ()).setOverlay(combinedOverlay);
    }

    private void drawString(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, String s) {
        if (s == null) {
            return;
        }
        Font fontRenderer = ClientUtils.getMinecraft().font;
        poseStack.pushPose();
        poseStack.translate(0.0, 0.07, -0.005);
        poseStack.scale(-0.01f, -0.08f, 1.0f);
        float f = (float)(-fontRenderer.width(s)) / 2.0f;
        Objects.requireNonNull(fontRenderer);
        fontRenderer.drawInBatch(s, f, (float)(-9), -1, false, poseStack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, combinedLight);
        poseStack.popPose();
    }
}

