/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.movingelevators.blocks.CamoBlock;
import com.supermartijn642.movingelevators.blocks.CamoBlockEntity;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.blocks.DisplayBlockEntity;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class DisplayBlock
extends CamoBlock {
    public static final int BUTTON_COUNT = 3;
    public static final int BUTTON_COUNT_BIG = 7;
    public static final float BUTTON_HEIGHT = 0.125f;

    public DisplayBlock(BlockProperties properties) {
        super(properties, DisplayBlockEntity::new);
    }

    @Override
    protected boolean onRightClick(BlockState state, Level level, CamoBlockEntity blockEntity, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        DisplayBlockEntity displayEntity;
        if (blockEntity instanceof DisplayBlockEntity && (displayEntity = (DisplayBlockEntity)blockEntity).getFacing() == hitSide) {
            if (!level.isClientSide) {
                int displayCat = displayEntity.getDisplayCategory();
                Vec3 hitVec = hitLocation.subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                double hitHorizontal = hitSide.getAxis() == Direction.Axis.Z ? hitVec.x : hitVec.z;
                double hitY = hitVec.y;
                if (hitHorizontal > 0.0625 && hitHorizontal < 0.9375) {
                    BlockEntity blockEntity2;
                    BlockPos inputEntityPos = null;
                    int button_count = -1;
                    int height = -1;
                    if (displayCat == 1) {
                        if (hitY > 0.0625 && hitY < 0.9375) {
                            inputEntityPos = pos.below();
                            button_count = 3;
                            height = 1;
                        }
                    } else if (displayCat == 2) {
                        if (hitY > 0.0625) {
                            inputEntityPos = pos.below();
                            button_count = 7;
                            height = 2;
                        }
                    } else if (displayCat == 3 && hitY < 0.9375) {
                        inputEntityPos = pos.below(2);
                        button_count = 7;
                        height = 2;
                        hitY += 1.0;
                    }
                    if (inputEntityPos != null && (blockEntity2 = level.getBlockEntity(inputEntityPos)) instanceof ElevatorInputBlockEntity && ((ElevatorInputBlockEntity)blockEntity2).hasGroup()) {
                        int above;
                        ElevatorInputBlockEntity inputEntity = (ElevatorInputBlockEntity)blockEntity2;
                        ElevatorGroup group = inputEntity.getGroup();
                        int index = inputEntity.getGroup().getFloorNumber(inputEntity.getFloorLevel());
                        int below = index;
                        if (below < (above = group.getFloorCount() - index - 1)) {
                            below = Math.min(below, button_count);
                            above = Math.min(above, button_count * 2 - below);
                        } else {
                            above = Math.min(above, button_count);
                            below = Math.min(below, button_count * 2 - above);
                        }
                        int startIndex = index - below;
                        int total = below + 1 + above;
                        int floorOffset = (int)Math.floor((hitY - (double)((float)height - (float)total * 0.125f) / 2.0) / 0.125) + startIndex - index;
                        if (player == null || player.getItemInHand(hand).isEmpty() || !(player.getItemInHand(hand).getItem() instanceof DyeItem)) {
                            inputEntity.getGroup().onDisplayPress(inputEntity.getFloorLevel(), floorOffset);
                        } else {
                            DyeColor color = ((DyeItem)player.getItemInHand(hand).getItem()).getDyeColor();
                            int floor = group.getFloorNumber(inputEntity.getFloorLevel()) + floorOffset;
                            ControllerBlockEntity elevatorEntity = group.getEntityForFloor(floor);
                            if (elevatorEntity != null) {
                                elevatorEntity.setDisplayLabelColor(color);
                            }
                        }
                    }
                }
            }
            return true;
        }
        return super.onRightClick(state, level, blockEntity, pos, player, hand, hitSide, hitLocation);
    }

    protected void appendItemInformation(ItemStack stack, Consumer<Component> info, boolean advanced) {
        info.accept((Component)TextComponents.translation((String)"movingelevators.elevator_display.tooltip").color(ChatFormatting.AQUA).get());
    }
}

