/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.movingelevators.MovingElevatorsClient;
import com.supermartijn642.movingelevators.blocks.CamoBlockEntity;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlock;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntity;
import com.supermartijn642.movingelevators.blocks.RemoteControllerBlock;
import com.supermartijn642.movingelevators.blocks.RemoteControllerBlockItem;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ControllerBlock
extends ElevatorInputBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public ControllerBlock(BlockProperties properties) {
        super(properties, (BiFunction<BlockPos, BlockState, ? extends ElevatorInputBlockEntity>)((BiFunction<BlockPos, BlockState, ElevatorInputBlockEntity>)ControllerBlockEntity::new));
    }

    @Override
    protected boolean onRightClick(BlockState state, Level level, CamoBlockEntity blockEntity, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        if (player != null && player.getItemInHand(hand).getItem() instanceof RemoteControllerBlockItem && blockEntity instanceof ControllerBlockEntity) {
            if (!level.isClientSide) {
                ItemStack stack = player.getItemInHand(hand);
                stack.set(RemoteControllerBlock.TARGET, (Object)new RemoteControllerBlock.Target(level.dimension().location(), pos, ((ControllerBlockEntity)blockEntity).getFacing()));
                player.displayClientMessage((Component)TextComponents.translation((String)"movingelevators.remote_controller.bind").get(), true);
            }
            return true;
        }
        if (super.onRightClick(state, level, blockEntity, pos, player, hand, hitSide, hitLocation)) {
            return true;
        }
        if (state.getValue((Property)FACING) != hitSide) {
            if (level.isClientSide) {
                MovingElevatorsClient.openElevatorScreen(pos);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof ControllerBlockEntity && ((ControllerBlockEntity)entity).hasGroup() && ((ControllerBlockEntity)entity).getGroup().isCageAvailableAt((ControllerBlockEntity)entity)) {
            return 15;
        }
        return 0;
    }

    protected void appendItemInformation(ItemStack stack, Consumer<Component> info, boolean advanced) {
        info.accept((Component)TextComponents.translation((String)"movingelevators.elevator_controller.tooltip").color(ChatFormatting.AQUA).get());
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean p_60519_) {
        BlockEntity entity;
        if (state.hasBlockEntity() && (!state.is(newState.getBlock()) || !newState.hasBlockEntity()) && (entity = level.getBlockEntity(pos)) instanceof ControllerBlockEntity) {
            ((ControllerBlockEntity)entity).onRemove();
        }
        super.onRemove(state, level, pos, newState, p_60519_);
    }
}

