/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.block.EntityHoldingBlock;
import com.supermartijn642.movingelevators.blocks.CamoBlockEntity;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CamoBlock
extends BaseBlock
implements EntityHoldingBlock {
    private final BiFunction<BlockPos, BlockState, ? extends CamoBlockEntity> entitySupplier;

    public CamoBlock(BlockProperties properties, BiFunction<BlockPos, BlockState, ? extends CamoBlockEntity> entitySupplier) {
        super(false, properties.dynamicShape());
        this.entitySupplier = entitySupplier;
    }

    protected BaseBlock.InteractionFeedback interact(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CamoBlockEntity) {
            this.onRightClick(state, level, (CamoBlockEntity)blockEntity, pos, player, hand, hitSide, hitLocation);
        }
        return BaseBlock.InteractionFeedback.SUCCESS;
    }

    protected boolean onRightClick(BlockState state, Level level, CamoBlockEntity blockEntity, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        if (player.isShiftKeyDown() && player.getItemInHand(hand).isEmpty()) {
            blockEntity.setCamoState(null);
            return true;
        }
        if (!player.isShiftKeyDown() && blockEntity.canBeCamoStack(player.getItemInHand(hand))) {
            Item item = player.getItemInHand(hand).getItem();
            if (item instanceof BlockItem) {
                Block block = ((BlockItem)item).getBlock();
                BlockState state1 = block.getStateForPlacement(new BlockPlaceContext(new UseOnContext(player, hand, new BlockHitResult(hitLocation, hitSide, pos, false))));
                if (state1 == null) {
                    state1 = block.defaultBlockState();
                }
                blockEntity.setCamoState(state1);
            }
            return true;
        }
        return false;
    }

    public BlockEntity createNewBlockEntity(BlockPos pos, BlockState state) {
        return (BlockEntity)this.entitySupplier.apply(pos, state);
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity = reader.getBlockEntity(pos);
        return blockEntity instanceof CamoBlockEntity && ((CamoBlockEntity)blockEntity).hasCamoState() ? ((CamoBlockEntity)blockEntity).getCamoState().getVisualShape(reader, pos, context) : BlockShape.fullCube().getUnderlying();
    }

    public int getLightEmission(BlockState state, BlockGetter reader, BlockPos pos) {
        BlockEntity blockEntity = reader.getBlockEntity(pos);
        return blockEntity instanceof CamoBlockEntity && ((CamoBlockEntity)blockEntity).hasCamoState() ? ((CamoBlockEntity)blockEntity).getCamoState().getLightEmission(reader, pos) : super.getLightEmission(state, reader, pos);
    }

    public float getShadeBrightness(BlockState state, BlockGetter reader, BlockPos pos) {
        BlockEntity blockEntity = reader.getBlockEntity(pos);
        return blockEntity instanceof CamoBlockEntity && ((CamoBlockEntity)blockEntity).hasCamoState() ? ((CamoBlockEntity)blockEntity).getCamoState().getShadeBrightness(reader, pos) : super.getShadeBrightness(state, reader, pos);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        BlockEntity blockEntity = reader.getBlockEntity(pos);
        return blockEntity instanceof CamoBlockEntity && ((CamoBlockEntity)blockEntity).hasCamoState() ? ((CamoBlockEntity)blockEntity).getCamoState().propagatesSkylightDown(reader, pos) : super.propagatesSkylightDown(state, reader, pos);
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return BlockShape.empty().getUnderlying();
    }

    public int getLightBlock(BlockState state, BlockGetter reader, BlockPos pos) {
        LevelChunk chunk;
        BlockEntity entity = reader instanceof Level ? ((chunk = ((Level)reader).getChunkSource().getChunkNow(SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()))) == null ? reader.getBlockEntity(pos) : chunk.getBlockEntity(pos)) : reader.getBlockEntity(pos);
        return entity instanceof CamoBlockEntity && ((CamoBlockEntity)entity).hasCamoState() ? ((CamoBlockEntity)entity).getCamoState().getLightBlock(reader, pos) : reader.getMaxLightLevel();
    }
}

