/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.solarcooker.init;

import com.mojang.blaze3d.vertex.PoseStack;
import de.cech12.solarcooker.Constants;
import de.cech12.solarcooker.blockentity.SolarCookerBlockEntity;
import de.cech12.solarcooker.item.ReflectorItem;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.createItems((String)"solarcooker");

    private static DeferredHolder<Item, Item> item(String name, Supplier<Item> itemSupplier) {
        return ITEMS.register(name, itemSupplier);
    }

    private static DeferredHolder<Item, Item> fromBlock(String name, Supplier<Block> block) {
        return ModItems.item(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static DeferredHolder<Item, Item> solarCookerItem() {
        return ModItems.item("solar_cooker", () -> new BlockItem(Constants.SOLAR_COOKER_BLOCK.get(), new Item.Properties()){

            public void initializeClient(@Nonnull Consumer<IClientItemExtensions> consumer) {
                consumer.accept(new IClientItemExtensions(this){
                    final BlockEntityWithoutLevelRenderer myRenderer = new BlockEntityWithoutLevelRenderer(this, Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels()){
                        private SolarCookerBlockEntity blockEntity;

                        public void renderByItem(@Nonnull ItemStack stack, @Nonnull ItemDisplayContext displayContext, @Nonnull PoseStack matrix, @Nonnull MultiBufferSource buffer, int x, int y) {
                            if (this.blockEntity == null) {
                                this.blockEntity = new SolarCookerBlockEntity(BlockPos.ZERO, Constants.SOLAR_COOKER_BLOCK.get().defaultBlockState());
                            }
                            Minecraft.getInstance().getBlockEntityRenderDispatcher().renderItem((BlockEntity)this.blockEntity, matrix, buffer, x, y);
                        }
                    };

                    public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                        return this.myRenderer;
                    }
                });
            }
        });
    }

    static {
        Constants.SOLAR_COOKER_ITEM = ModItems.solarCookerItem();
        Constants.REFLECTOR_ITEM = ModItems.item("reflector", () -> new ReflectorItem(new Item.Properties()));
        Constants.SHINING_DIAMOND_BLOCK_ITEM = ModItems.fromBlock("shining_diamond_block", Constants.SHINING_DIAMOND_BLOCK_BLOCK);
    }
}

