/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.solarcooker.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.cech12.solarcooker.Constants;
import de.cech12.solarcooker.block.AbstractSolarCookerBlock;
import de.cech12.solarcooker.blockentity.SolarCookerBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SolarCookerBlockEntityRenderer
implements BlockEntityRenderer<SolarCookerBlockEntity> {
    public static final ResourceLocation TEXTURE = Constants.id("textures/entity/solar_cooker.png");
    public static final ResourceLocation TEXTURE_REFLECTOR = Constants.id("textures/entity/solar_cooker_reflector.png");
    private static final LayerDefinition innerCube = SolarCookerBlockEntityRenderer.createInnerLayerDefinition();
    private static final LayerDefinition reflectorLeftCube = SolarCookerBlockEntityRenderer.createReflectorLayerDefinition(true);
    private static final LayerDefinition reflectorRightCube = SolarCookerBlockEntityRenderer.createReflectorLayerDefinition(false);
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart inner;
    private final ModelPart lock;
    private final ModelPart reflectorLeft;
    private final ModelPart reflectorRight;

    private static LayerDefinition createInnerLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("inner", CubeListBuilder.create().texOffs(0, 43).addBox(3.0f, 2.0f, 3.0f, 10.0f, 8.0f, 10.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    private static LayerDefinition createReflectorLayerDefinition(boolean left) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        float offset = left ? 0.0f : 13.998f;
        float rotation = left ? 0.0f : (float)Math.PI;
        partdefinition.addOrReplaceChild("reflector", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 6.999f, 1.0f, 13.998f), PartPose.offsetAndRotation((float)(1.001f + offset), (float)10.001f, (float)(1.001f + offset), (float)0.0f, (float)rotation, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)42, (int)15);
    }

    public SolarCookerBlockEntityRenderer(BlockEntityRendererProvider.Context rendererProvider) {
        ModelPart modelpart = rendererProvider.bakeLayer(ModelLayers.CHEST);
        this.bottom = modelpart.getChild("bottom");
        this.lid = modelpart.getChild("lid");
        this.lock = modelpart.getChild("lock");
        this.inner = innerCube.bakeRoot().getChild("inner");
        this.reflectorLeft = reflectorLeftCube.bakeRoot().getChild("reflector");
        this.reflectorRight = reflectorRightCube.bakeRoot().getChild("reflector");
    }

    public void render(SolarCookerBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Level world = blockEntity.getLevel();
        boolean isInWorld = world != null;
        BlockState blockstate = isInWorld ? blockEntity.getBlockState() : (BlockState)Constants.SOLAR_COOKER_BLOCK.get().defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.SOUTH);
        Block block = blockstate.getBlock();
        if (block instanceof AbstractSolarCookerBlock) {
            matrixStackIn.pushPose();
            float f = ((Direction)blockstate.getValue((Property)AbstractSolarCookerBlock.FACING)).toYRot();
            matrixStackIn.translate(0.5, 0.5, 0.5);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(-f));
            matrixStackIn.translate(-0.5, -0.5, -0.5);
            VertexConsumer vertexConsumer = bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)TEXTURE));
            float lidAngle = blockEntity.getOpenNess(partialTicks);
            this.renderModels(matrixStackIn, vertexConsumer, lidAngle, combinedLightIn, combinedOverlayIn);
            if (lidAngle > 0.0f) {
                ItemStack stack;
                if (blockEntity.hasLeftReflector() || blockEntity.hasRightReflector()) {
                    vertexConsumer = bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)TEXTURE_REFLECTOR));
                    this.renderReflectors(matrixStackIn, vertexConsumer, blockEntity.hasLeftReflector(), blockEntity.hasRightReflector(), lidAngle, combinedLightIn, combinedOverlayIn);
                }
                if (isInWorld && !(stack = blockEntity.getItem(0)).isEmpty()) {
                    matrixStackIn.pushPose();
                    matrixStackIn.translate(0.5, 0.4, 0.5);
                    Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, world, 0);
                    matrixStackIn.popPose();
                }
            }
            matrixStackIn.popPose();
        }
    }

    private void renderModels(PoseStack matrixStackIn, VertexConsumer bufferIn, float lidAngle, int combinedLightIn, int combinedOverlayIn) {
        this.lock.xRot = this.lid.xRot = -(lidAngle * 1.5707964f);
        this.lid.render(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        this.lock.render(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        this.bottom.render(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        this.inner.render(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    private void renderReflectors(PoseStack matrixStackIn, VertexConsumer bufferIn, boolean hasLeftReflector, boolean hasRightReflector, float lidAngle, int combinedLightIn, int combinedOverlayIn) {
        float angle = lidAngle * 1.7453294f;
        if (hasLeftReflector) {
            this.reflectorLeft.zRot = angle;
            this.reflectorLeft.render(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        }
        if (hasRightReflector) {
            this.reflectorRight.zRot = -angle;
            this.reflectorRight.render(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        }
    }
}

