/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.surface.impl.conditions;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.class_5819;
import net.minecraft.class_5862;
import net.minecraft.class_5863;
import net.minecraft.class_6686;
import net.minecraft.class_7243;
import net.minecraft.class_7384;
import org.betterx.wover.math.api.noise.OpenSimplexNoise;
import org.betterx.wover.surface.api.conditions.SurfaceRulesContext;
import org.betterx.wover.surface.api.conditions.VolumeNoiseCondition;
import org.betterx.wover.surface.api.conditions.VolumeThresholdCondition;

public class VolumeThresholdConditionImpl
extends VolumeNoiseCondition
implements VolumeThresholdCondition {
    private static final Map<Long, Context> NOISES = Maps.newHashMap();
    public static final MapCodec<VolumeThresholdConditionImpl> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.LONG.fieldOf("seed").forGetter(p -> p.noiseContext.seed), (App)Codec.DOUBLE.fieldOf("threshold").orElse((Object)0.0).forGetter(p -> p.threshold), (App)class_5863.field_29007.fieldOf("roughness").orElse((Object)class_5862.method_33908((float)0.0f)).forGetter(p -> p.roughness), (App)Codec.DOUBLE.fieldOf("scale_x").orElse((Object)0.1).forGetter(p -> p.scaleX), (App)Codec.DOUBLE.fieldOf("scale_y").orElse((Object)0.1).forGetter(p -> p.scaleY), (App)Codec.DOUBLE.fieldOf("scale_z").orElse((Object)0.1).forGetter(p -> p.scaleZ)).apply((Applicative)instance, VolumeThresholdConditionImpl::new));
    public static final class_7243<VolumeThresholdConditionImpl> KEY_CODEC = class_7243.method_42116(CODEC);
    public final Context noiseContext;
    public final double threshold;
    public final class_5863 roughness;
    public final double scaleX;
    public final double scaleY;
    public final double scaleZ;

    @Override
    public VolumeThresholdCondition.Context getNoiseContext() {
        return this.noiseContext;
    }

    @Override
    public double getScaleX() {
        return this.scaleX;
    }

    @Override
    public double getScaleY() {
        return this.scaleY;
    }

    @Override
    public double getScaleZ() {
        return this.scaleZ;
    }

    @Override
    public class_5863 getRoughness() {
        return this.roughness;
    }

    public VolumeThresholdConditionImpl(long noiseSeed, double threshold, class_5863 roughness, double scaleX, double scaleY, double scaleZ) {
        this.threshold = threshold;
        this.roughness = roughness;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
        this.noiseContext = NOISES.computeIfAbsent(noiseSeed, seed -> new Context((long)seed));
    }

    public double getValue(SurfaceRulesContext context) {
        return this.getValue(context.getBlockX(), context.getBlockY(), context.getBlockZ());
    }

    public double getValue(int xx, int yy, int zz) {
        double x = (double)xx * this.scaleX;
        double y = (double)yy * this.scaleY;
        double z = (double)zz * this.scaleZ;
        if (this.noiseContext.lastX == x && this.noiseContext.lastY == y && this.noiseContext.lastZ == z) {
            return this.noiseContext.lastValue + (double)this.roughness.method_33920(this.noiseContext.random);
        }
        double value = this.noiseContext.noise.eval(x, y, z);
        this.noiseContext.lastX = x;
        this.noiseContext.lastZ = z;
        this.noiseContext.lastY = y;
        this.noiseContext.lastValue = value;
        return value + (double)this.roughness.method_33920(this.noiseContext.random);
    }

    @Override
    public boolean test(SurfaceRulesContext context) {
        return this.getValue(context) > this.threshold;
    }

    public class_7243<? extends class_6686.class_6693> method_39064() {
        return KEY_CODEC;
    }

    public static class Context
    implements VolumeThresholdCondition.Context {
        public final OpenSimplexNoise noise;
        public final class_5819 random;
        public final long seed;
        double lastX = -2.147483648E9;
        double lastY = -2.147483648E9;
        double lastZ = -2.147483648E9;
        double lastValue = 0.0;

        @Override
        public OpenSimplexNoise getNoise() {
            return this.noise;
        }

        @Override
        public class_5819 getRandom() {
            return this.random;
        }

        @Override
        public long getSeed() {
            return this.seed;
        }

        Context(long seed) {
            this.seed = seed;
            this.noise = new OpenSimplexNoise(seed);
            this.random = new class_7384(seed * 3L + 1L);
        }
    }
}

