/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.surface.impl.conditions;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.class_5819;
import net.minecraft.class_5862;
import net.minecraft.class_5863;
import net.minecraft.class_6686;
import net.minecraft.class_7243;
import net.minecraft.class_7384;
import org.betterx.wover.math.api.noise.OpenSimplexNoise;
import org.betterx.wover.surface.api.conditions.SurfaceNoiseCondition;
import org.betterx.wover.surface.api.conditions.SurfaceRulesContext;

public class ThresholdConditionImpl
extends SurfaceNoiseCondition {
    private static final Map<Long, Context> NOISES = Maps.newHashMap();
    public static final MapCodec<ThresholdConditionImpl> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.LONG.fieldOf("seed").forGetter(p -> p.noiseContext.seed), (App)Codec.DOUBLE.fieldOf("threshold").orElse((Object)0.0).forGetter(p -> p.threshold), (App)class_5863.field_29007.fieldOf("roughness").orElse((Object)class_5862.method_33908((float)0.0f)).forGetter(p -> p.roughness), (App)Codec.DOUBLE.fieldOf("scale_x").orElse((Object)0.1).forGetter(p -> p.scaleX), (App)Codec.DOUBLE.fieldOf("scale_z").orElse((Object)0.1).forGetter(p -> p.scaleZ)).apply((Applicative)instance, ThresholdConditionImpl::new));
    public static final class_7243<ThresholdConditionImpl> KEY_CODEC = class_7243.method_42116(CODEC);
    private final Context noiseContext;
    private final double threshold;
    private final class_5863 roughness;
    private final double scaleX;
    private final double scaleZ;

    public ThresholdConditionImpl(long noiseSeed, double threshold, class_5863 roughness, double scaleX, double scaleZ) {
        this.threshold = threshold;
        this.roughness = roughness;
        this.scaleX = scaleX;
        this.scaleZ = scaleZ;
        this.noiseContext = NOISES.computeIfAbsent(noiseSeed, Context::new);
    }

    @Override
    public boolean test(SurfaceRulesContext context) {
        double x = (double)context.getBlockX() * this.scaleX;
        double z = (double)context.getBlockZ() * this.scaleZ;
        if (this.noiseContext.lastX == x && this.noiseContext.lastZ == z) {
            return this.noiseContext.lastValue + (double)this.roughness.method_33920(this.noiseContext.random) > this.threshold;
        }
        double value = this.noiseContext.noise.eval(x, z);
        this.noiseContext.lastX = x;
        this.noiseContext.lastZ = z;
        this.noiseContext.lastValue = value;
        return value + (double)this.roughness.method_33920(this.noiseContext.random) > this.threshold;
    }

    public class_7243<? extends class_6686.class_6693> method_39064() {
        return KEY_CODEC;
    }

    static class Context {
        public final OpenSimplexNoise noise;
        public final class_5819 random;
        public final long seed;
        public double lastX = -2.147483648E9;
        public double lastZ = -2.147483648E9;
        public double lastValue = 0.0;

        Context(long seed) {
            this.seed = seed;
            this.noise = new OpenSimplexNoise(seed);
            this.random = new class_7384(seed * 2L);
        }
    }
}

