/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.surface.impl;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_32;
import net.minecraft.class_3283;
import net.minecraft.class_5219;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_6686;
import net.minecraft.class_6880;
import net.minecraft.class_7659;
import net.minecraft.class_7780;
import net.minecraft.class_7924;
import org.betterx.wover.common.surface.api.InjectableSurfaceRules;
import org.betterx.wover.common.surface.api.SurfaceRuleProvider;
import org.betterx.wover.entrypoint.LibWoverSurface;
import org.betterx.wover.state.api.WorldState;
import org.betterx.wover.surface.api.SurfaceRuleRegistry;
import org.jetbrains.annotations.ApiStatus;

public class SurfaceRuleUtil {
    private static List<class_6686.class_6708> getRulesForBiome(class_5321<class_1959> biomeKey) {
        class_2378 registry = null;
        if (WorldState.registryAccess() != null) {
            registry = WorldState.registryAccess().method_33310(SurfaceRuleRegistry.SURFACE_RULES_REGISTRY).orElse(null);
        }
        if (registry == null) {
            LibWoverSurface.C.LOG.warn("No Surface Rule Registry found. Skipping Surface Rule Injection for Biome {}", new Object[]{biomeKey.method_29177()});
            return List.of();
        }
        List<class_6686.class_6708> list = registry.method_10220().filter(a -> a != null && a.biomeID != null && a.biomeID.equals((Object)biomeKey.method_29177())).sorted((a, b) -> b.priority - a.priority).map(a -> a.ruleSource).toList();
        if (list.size() == 0) {
            return List.of();
        }
        return List.of(class_6686.method_39049((class_6686.class_6693)class_6686.method_39055((class_5321[])new class_5321[]{biomeKey}), (class_6686.class_6708)new class_6686.class_6710(list)));
    }

    private static List<class_6686.class_6708> getRulesForBiomes(List<Optional<class_5321<class_1959>>> biomes) {
        List<class_5321> biomeIDs = biomes.stream().filter(Optional::isPresent).map(Optional::orElseThrow).toList();
        return biomeIDs.stream().map(SurfaceRuleUtil::getRulesForBiome).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedList::new));
    }

    private static class_6686.class_6708 mergeSurfaceRules(class_5321<class_5363> dimensionKey, class_6686.class_6708 org, class_1966 source, List<class_6686.class_6708> additionalRules) {
        if (additionalRules == null || additionalRules.isEmpty()) {
            return null;
        }
        Stopwatch sw = Stopwatch.createStarted();
        int count = additionalRules.size();
        if (org instanceof class_6686.class_6710) {
            class_6686.class_6710 sequenceRule = (class_6686.class_6710)org;
            List existingSequence = sequenceRule.comp_209();
            if ((additionalRules = additionalRules.stream().filter(r -> !existingSequence.contains(r)).collect(Collectors.toList())).isEmpty()) {
                return null;
            }
            if (dimensionKey.equals((Object)class_5363.field_25413)) {
                ArrayList<Object> combined = new ArrayList<Object>(existingSequence.size() + additionalRules.size());
                for (class_6686.class_6708 rule : existingSequence) {
                    class_6686.class_6718 testRule;
                    if (rule instanceof class_6686.class_6718 && (testRule = (class_6686.class_6718)rule).comp_215() instanceof class_6686.class_6689) {
                        combined.addAll(additionalRules);
                    }
                    combined.add(rule);
                }
                additionalRules = combined;
            } else {
                additionalRules.addAll(existingSequence);
            }
        } else if (!additionalRules.contains(org)) {
            additionalRules.add(org);
        }
        LibWoverSurface.C.LOG.verbose("Merged {} additional Surface Rules for Dimension {} => {} ({}) using {}", new Object[]{count, dimensionKey.method_29177(), additionalRules.size(), sw.stop(), source});
        return new class_6686.class_6710(additionalRules);
    }

    @ApiStatus.Internal
    public static void injectNoiseBasedSurfaceRules(class_5321<class_5363> dimensionKey, class_6880<class_5284> noiseSettings, class_1966 loadedBiomeSource) {
        Object o = noiseSettings.comp_349();
        if (o instanceof SurfaceRuleProvider) {
            SurfaceRuleProvider srp = (SurfaceRuleProvider)o;
            class_6686.class_6708 originalRules = srp.wover_getOriginalSurfaceRules();
            srp.wover_overwriteSurfaceRules(SurfaceRuleUtil.mergeSurfaceRules(dimensionKey, originalRules, loadedBiomeSource, SurfaceRuleUtil.getRulesForBiomes(loadedBiomeSource.method_28443().stream().map(class_6880::method_40230).toList())));
        }
    }

    static void injectSurfaceRulesToAllDimensions(class_32.class_5143 ignoredStorageAccess, class_3283 ignoredPackRepository, class_7780<class_7659> registries, class_5219 ignoredWorldData) {
        class_2378 dimensionRegistry = registries.method_45926().method_30530(class_7924.field_41224);
        for (Map.Entry entry : dimensionRegistry.method_29722()) {
            class_5321 dimensionKey = (class_5321)entry.getKey();
            class_5363 stem = (class_5363)entry.getValue();
            class_2794 class_27942 = stem.comp_1013();
            if (!(class_27942 instanceof InjectableSurfaceRules)) continue;
            InjectableSurfaceRules generator = (InjectableSurfaceRules)class_27942;
            generator.wover_injectSurfaceRules(dimensionRegistry, dimensionKey);
        }
    }
}

