/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.math.api.noise;

import java.util.Random;
import net.minecraft.class_2338;
import org.betterx.wover.math.api.MathHelper;

public class VoronoiNoise {
    private static final Random RANDOM = new Random();
    final int seed;

    public VoronoiNoise() {
        this(0);
    }

    public VoronoiNoise(int seed) {
        this.seed = seed;
    }

    private int getSeed(int x, int y, int z) {
        int h = this.seed + x * 374761393 + y * 668265263 + z;
        h = (h ^ h >> 13) * 1274126177;
        return h ^ h >> 16;
    }

    public double sample(double x, double y, double z) {
        int ix = MathHelper.floor(x);
        int iy = MathHelper.floor(y);
        int iz = MathHelper.floor(z);
        float px = (float)(x - (double)ix);
        float py = (float)(y - (double)iy);
        float pz = (float)(z - (double)iz);
        float d = 10.0f;
        for (int pox = -1; pox < 2; ++pox) {
            for (int poy = -1; poy < 2; ++poy) {
                for (int poz = -1; poz < 2; ++poz) {
                    RANDOM.setSeed(this.getSeed(pox + ix, poy + iy, poz + iz));
                    float pointX = (float)pox + RANDOM.nextFloat();
                    float pointY = (float)poy + RANDOM.nextFloat();
                    float pointZ = (float)poz + RANDOM.nextFloat();
                    float d2 = MathHelper.lengthSqr(pointX - px, pointY - py, pointZ - pz);
                    if (!(d2 < d)) continue;
                    d = d2;
                }
            }
        }
        return Math.sqrt(d);
    }

    public Random getRandom(double x, double y, double z) {
        int ix = MathHelper.floor(x);
        int iy = MathHelper.floor(y);
        int iz = MathHelper.floor(z);
        float px = (float)(x - (double)ix);
        float py = (float)(y - (double)iy);
        float pz = (float)(z - (double)iz);
        float d = 10.0f;
        int posX = 0;
        int posY = 0;
        int posZ = 0;
        for (int pox = -1; pox < 2; ++pox) {
            for (int poy = -1; poy < 2; ++poy) {
                for (int poz = -1; poz < 2; ++poz) {
                    RANDOM.setSeed(this.getSeed(pox + ix, poy + iy, poz + iz));
                    float pointX = (float)pox + RANDOM.nextFloat();
                    float pointY = (float)poy + RANDOM.nextFloat();
                    float pointZ = (float)poz + RANDOM.nextFloat();
                    float d2 = MathHelper.lengthSqr(pointX - px, pointY - py, pointZ - pz);
                    if (!(d2 < d)) continue;
                    d = d2;
                    posX = pox;
                    posY = poy;
                    posZ = poz;
                }
            }
        }
        int seed = MathHelper.getSeed(posY += iy, posX += ix, posZ += iz);
        RANDOM.setSeed(seed);
        return RANDOM;
    }

    public class_2338[] getPos(double x, double y, double z, double scale) {
        int ix = MathHelper.floor(x);
        int iy = MathHelper.floor(y);
        int iz = MathHelper.floor(z);
        float px = (float)(x - (double)ix);
        float py = (float)(y - (double)iy);
        float pz = (float)(z - (double)iz);
        float d = 10.0f;
        float selX = 0.0f;
        float selY = 0.0f;
        float selZ = 0.0f;
        float selXPre = 0.0f;
        float selYPre = 0.0f;
        float selZPre = 0.0f;
        for (int pox = -1; pox < 2; ++pox) {
            for (int poy = -1; poy < 2; ++poy) {
                for (int poz = -1; poz < 2; ++poz) {
                    RANDOM.setSeed(this.getSeed(pox + ix, poy + iy, poz + iz));
                    float pointX = (float)pox + RANDOM.nextFloat();
                    float pointY = (float)poy + RANDOM.nextFloat();
                    float pointZ = (float)poz + RANDOM.nextFloat();
                    float d2 = MathHelper.lengthSqr(pointX - px, pointY - py, pointZ - pz);
                    if (!(d2 < d)) continue;
                    d = d2;
                    selXPre = selX;
                    selYPre = selY;
                    selZPre = selZ;
                    selX = pointX;
                    selY = pointY;
                    selZ = pointZ;
                }
            }
        }
        class_2338 p1 = new class_2338((int)(((double)ix + (double)selX) * scale), (int)(((double)iy + (double)selY) * scale), (int)(((double)iz + (double)selZ) * scale));
        class_2338 p2 = new class_2338((int)(((double)ix + (double)selXPre) * scale), (int)(((double)iy + (double)selYPre) * scale), (int)(((double)iz + (double)selZPre) * scale));
        return new class_2338[]{p1, p2};
    }
}

