/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.chococraft.ChococraftExpectPlatform;
import net.chococraft.common.blocks.GysahlGreenBlock;
import net.chococraft.common.blocks.StrawBlock;
import net.chococraft.common.entity.properties.ChocoboColor;
import net.chococraft.common.items.ChocoboSaddleItem;
import net.chococraft.common.items.ChocoboSpawnEggItem;
import net.chococraft.common.items.ChocopediaItem;
import net.chococraft.common.items.CustomBlockNamedItem;
import net.chococraft.common.items.armor.ModArmorMaterial;
import net.chococraft.registry.ModFoods;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;

public class ModRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"chococraft", (ResourceKey)Registries.BLOCK);
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"chococraft", (ResourceKey)Registries.ITEM);
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((String)"chococraft", (ResourceKey)Registries.CREATIVE_MODE_TAB);
    public static final RegistrySupplier<Block> GYSAHL_GREEN = BLOCKS.register("gysahl_green", () -> new GysahlGreenBlock(BlockBehaviour.Properties.of().mapColor(MapColor.GRASS).noCollission().randomTicks().instabreak().sound(SoundType.CROP)));
    public static final RegistrySupplier<Block> STRAW = BLOCKS.register("straw", () -> new StrawBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).sound(SoundType.GRASS)));
    public static final RegistrySupplier<Item> CHOCOBO_SADDLE = ITEMS.register("chocobo_saddle", () -> new ChocoboSaddleItem(ModRegistry.itemBuilder(), 0));
    public static final RegistrySupplier<Item> CHOCOBO_SADDLE_BAGS = ITEMS.register("chocobo_saddle_bags", () -> new ChocoboSaddleItem(ModRegistry.itemBuilder(), 18));
    public static final RegistrySupplier<Item> CHOCOBO_SADDLE_PACK = ITEMS.register("chocobo_saddle_pack", () -> new ChocoboSaddleItem(ModRegistry.itemBuilder(), 45));
    public static final RegistrySupplier<Item> YELLOW_CHOCOBO_SPAWN_EGG = ITEMS.register("yellow_chocobo_spawn_egg", () -> new ChocoboSpawnEggItem(ModRegistry.itemBuilder(), ChocoboColor.YELLOW));
    public static final RegistrySupplier<Item> GREEN_CHOCOBO_SPAWN_EGG = ITEMS.register("green_chocobo_spawn_egg", () -> new ChocoboSpawnEggItem(ModRegistry.itemBuilder(), ChocoboColor.GREEN));
    public static final RegistrySupplier<Item> BLUE_CHOCOBO_SPAWN_EGG = ITEMS.register("blue_chocobo_spawn_egg", () -> new ChocoboSpawnEggItem(ModRegistry.itemBuilder(), ChocoboColor.BLUE));
    public static final RegistrySupplier<Item> WHITE_CHOCOBO_SPAWN_EGG = ITEMS.register("white_chocobo_spawn_egg", () -> new ChocoboSpawnEggItem(ModRegistry.itemBuilder(), ChocoboColor.WHITE));
    public static final RegistrySupplier<Item> BLACK_CHOCOBO_SPAWN_EGG = ITEMS.register("black_chocobo_spawn_egg", () -> new ChocoboSpawnEggItem(ModRegistry.itemBuilder(), ChocoboColor.BLACK));
    public static final RegistrySupplier<Item> GOLD_CHOCOBO_SPAWN_EGG = ITEMS.register("gold_chocobo_spawn_egg", () -> new ChocoboSpawnEggItem(ModRegistry.itemBuilder(), ChocoboColor.GOLD));
    public static final RegistrySupplier<Item> PINK_CHOCOBO_SPAWN_EGG = ITEMS.register("pink_chocobo_spawn_egg", () -> new ChocoboSpawnEggItem(ModRegistry.itemBuilder(), ChocoboColor.PINK));
    public static final RegistrySupplier<Item> RED_CHOCOBO_SPAWN_EGG = ITEMS.register("red_chocobo_spawn_egg", () -> new ChocoboSpawnEggItem(ModRegistry.itemBuilder(), ChocoboColor.RED));
    public static final RegistrySupplier<Item> PURPLE_CHOCOBO_SPAWN_EGG = ITEMS.register("purple_chocobo_spawn_egg", () -> new ChocoboSpawnEggItem(ModRegistry.itemBuilder(), ChocoboColor.PURPLE));
    public static final RegistrySupplier<Item> FLAME_CHOCOBO_SPAWN_EGG = ITEMS.register("flame_chocobo_spawn_egg", () -> new ChocoboSpawnEggItem(ModRegistry.itemBuilder(), ChocoboColor.FLAME));
    public static final RegistrySupplier<Item> GYSAHL_GREEN_SEEDS = ITEMS.register("gysahl_green_seeds", () -> new CustomBlockNamedItem((Supplier<Block>)GYSAHL_GREEN, ModRegistry.itemBuilder()));
    public static final RegistrySupplier<Item> GYSAHL_GREEN_ITEM = ITEMS.register("gysahl_green", () -> new Item(ModRegistry.itemBuilder().food(ModFoods.GYSAHL_GREEN)));
    public static final RegistrySupplier<Item> CHOCOBO_WHISTLE = ITEMS.register("chocobo_whistle", () -> new Item(ModRegistry.itemBuilder()));
    public static final RegistrySupplier<Item> CHOCOBO_FEATHER = ITEMS.register("chocobo_feather", () -> new Item(ModRegistry.itemBuilder()));
    public static final RegistrySupplier<Item> LOVERLY_GYSAHL_GREEN = ITEMS.register("loverly_gysahl_green", () -> new Item(ModRegistry.itemBuilder()));
    public static final RegistrySupplier<Item> GOLD_GYSAHL = ITEMS.register("gold_gysahl", () -> new Item(ModRegistry.itemBuilder()));
    public static final RegistrySupplier<Item> RED_GYSAHL = ITEMS.register("red_gysahl", () -> new Item(ModRegistry.itemBuilder()));
    public static final RegistrySupplier<Item> PINK_GYSAHL = ITEMS.register("pink_gysahl", () -> new Item(ModRegistry.itemBuilder()));
    public static final RegistrySupplier<Item> CHOCOBO_DRUMSTICK_RAW = ITEMS.register("chocobo_drumstick_raw", () -> new Item(ModRegistry.itemBuilder().food(ModFoods.CHOCOBO_DRUMSTICK_RAW)));
    public static final RegistrySupplier<Item> CHOCOBO_DRUMSTICK_COOKED = ITEMS.register("chocobo_drumstick_cooked", () -> new Item(ModRegistry.itemBuilder().food(ModFoods.CHOCOBO_DRUMSTICK_COOKED)));
    public static final RegistrySupplier<Item> PICKLED_GYSAHL_RAW = ITEMS.register("pickled_gysahl_raw", () -> new Item(ModRegistry.itemBuilder().food(ModFoods.PICKLED_GYSAHL_RAW)));
    public static final RegistrySupplier<Item> PICKLED_GYSAHL_COOKED = ITEMS.register("pickled_gysahl_cooked", () -> new Item(ModRegistry.itemBuilder().food(ModFoods.PICKLED_GYSAHL_COOKED)));
    public static final RegistrySupplier<Item> CHOCOPEDIA = ITEMS.register("chocopedia", () -> new ChocopediaItem(ModRegistry.itemBuilder()));
    public static final RegistrySupplier<Item> GYSAHL_CAKE = ITEMS.register("gysahl_cake", () -> new Item(ModRegistry.itemBuilder().stacksTo(8)));
    public static final RegistrySupplier<Item> CHOCO_DISGUISE_HELMET = ITEMS.register("choco_disguise_helmet", () -> ChococraftExpectPlatform.constructChocoDisguise(ModArmorMaterial.CHOCO_DISGUISE, ArmorItem.Type.HELMET, ModRegistry.itemBuilder().durability(ArmorItem.Type.HELMET.getDurability(6))));
    public static final RegistrySupplier<Item> CHOCO_DISGUISE_CHESTPLATE = ITEMS.register("choco_disguise_chestplate", () -> ChococraftExpectPlatform.constructChocoDisguise(ModArmorMaterial.CHOCO_DISGUISE, ArmorItem.Type.CHESTPLATE, ModRegistry.itemBuilder().durability(ArmorItem.Type.CHESTPLATE.getDurability(6))));
    public static final RegistrySupplier<Item> CHOCO_DISGUISE_LEGGINGS = ITEMS.register("choco_disguise_leggings", () -> ChococraftExpectPlatform.constructChocoDisguise(ModArmorMaterial.CHOCO_DISGUISE, ArmorItem.Type.LEGGINGS, ModRegistry.itemBuilder().durability(ArmorItem.Type.LEGGINGS.getDurability(6))));
    public static final RegistrySupplier<Item> CHOCO_DISGUISE_BOOTS = ITEMS.register("choco_disguise_boots", () -> ChococraftExpectPlatform.constructChocoDisguise(ModArmorMaterial.CHOCO_DISGUISE, ArmorItem.Type.BOOTS, ModRegistry.itemBuilder().durability(ArmorItem.Type.BOOTS.getDurability(6))));
    public static final RegistrySupplier<Item> STRAW_ITEM = ITEMS.register("straw", () -> new BlockItem((Block)STRAW.get(), ModRegistry.itemBuilder()));

    private static Item.Properties itemBuilder() {
        return new Item.Properties();
    }

    public static void registerCompostables() {
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)GYSAHL_GREEN_SEEDS.get()), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)GYSAHL_GREEN_ITEM.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)LOVERLY_GYSAHL_GREEN.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)GOLD_GYSAHL.get()), 0.65f);
    }
}

