/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.blocks;

import net.chococraft.registry.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class GysahlGreenBlock
extends CropBlock {
    public static final int MAX_AGE = 4;
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)4);

    public GysahlGreenBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
    }

    protected ItemLike getBaseSeedId() {
        return () -> ModRegistry.GYSAHL_GREEN_SEEDS.get();
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        boolean canSurvive = super.canSurvive(state, level, pos);
        if (level instanceof WorldGenLevel && (Integer)state.getValue((Property)AGE) == 4) {
            BlockPos blockPos2 = pos.below();
            return this.mayPlaceOn(level.getBlockState(blockPos2), (BlockGetter)level, blockPos2);
        }
        return canSurvive;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return super.mayPlaceOn(state, level, pos) || state.is(BlockTags.DIRT);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 4;
    }
}

