/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.widget;

import icyllis.modernui.core.Context;
import icyllis.modernui.graphics.Rect;
import icyllis.modernui.util.ArrayMap;
import icyllis.modernui.util.Pools;
import icyllis.modernui.util.SparseArray;
import icyllis.modernui.view.Gravity;
import icyllis.modernui.view.MeasureSpec;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewGroup;
import java.util.ArrayDeque;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RelativeLayout
extends ViewGroup {
    public static final int TRUE = -1;
    public static final int LEFT_OF = 0;
    public static final int RIGHT_OF = 1;
    public static final int ABOVE = 2;
    public static final int BELOW = 3;
    public static final int ALIGN_BASELINE = 4;
    public static final int ALIGN_LEFT = 5;
    public static final int ALIGN_TOP = 6;
    public static final int ALIGN_RIGHT = 7;
    public static final int ALIGN_BOTTOM = 8;
    public static final int ALIGN_PARENT_LEFT = 9;
    public static final int ALIGN_PARENT_TOP = 10;
    public static final int ALIGN_PARENT_RIGHT = 11;
    public static final int ALIGN_PARENT_BOTTOM = 12;
    public static final int CENTER_IN_PARENT = 13;
    public static final int CENTER_HORIZONTAL = 14;
    public static final int CENTER_VERTICAL = 15;
    public static final int START_OF = 16;
    public static final int END_OF = 17;
    public static final int ALIGN_START = 18;
    public static final int ALIGN_END = 19;
    public static final int ALIGN_PARENT_START = 20;
    public static final int ALIGN_PARENT_END = 21;
    private static final int VERB_COUNT = 22;
    private static final int[] RULES_VERTICAL = new int[]{2, 3, 4, 6, 8};
    private static final int[] RULES_HORIZONTAL = new int[]{0, 1, 5, 7, 16, 17, 18, 19};
    private static final int VALUE_NOT_SET = Integer.MIN_VALUE;
    private View mBaselineView = null;
    private int mGravity = 0x800033;
    private final Rect mContentBounds = new Rect();
    private final Rect mSelfBounds = new Rect();
    private int mIgnoreGravity = -1;
    private boolean mDirtyHierarchy;
    private View[] mSortedHorizontalChildren;
    private View[] mSortedVerticalChildren;
    private final DependencyGraph mGraph = new DependencyGraph();
    private static final int DEFAULT_WIDTH = 65536;

    public RelativeLayout(Context context) {
        super(context);
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        return false;
    }

    public void setIgnoreGravity(int viewId) {
        this.mIgnoreGravity = viewId;
    }

    public int getIgnoreGravity() {
        return this.mIgnoreGravity;
    }

    public int getGravity() {
        return this.mGravity;
    }

    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            if ((gravity & 0x800007) == 0) {
                gravity |= 0x800003;
            }
            if ((gravity & 0x70) == 0) {
                gravity |= 0x30;
            }
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    public void setHorizontalGravity(int horizontalGravity) {
        int gravity = horizontalGravity & 0x800007;
        if ((this.mGravity & 0x800007) != gravity) {
            this.mGravity = this.mGravity & 0xFF7FFFF8 | gravity;
            this.requestLayout();
        }
    }

    public void setVerticalGravity(int verticalGravity) {
        int gravity = verticalGravity & 0x70;
        if ((this.mGravity & 0x70) != gravity) {
            this.mGravity = this.mGravity & 0xFFFFFF8F | gravity;
            this.requestLayout();
        }
    }

    @Override
    public int getBaseline() {
        return this.mBaselineView != null ? this.mBaselineView.getBaseline() : super.getBaseline();
    }

    @Override
    public void requestLayout() {
        super.requestLayout();
        this.mDirtyHierarchy = true;
    }

    private void sortChildren() {
        int count = this.getChildCount();
        if (this.mSortedVerticalChildren == null || this.mSortedVerticalChildren.length != count) {
            this.mSortedVerticalChildren = new View[count];
        }
        if (this.mSortedHorizontalChildren == null || this.mSortedHorizontalChildren.length != count) {
            this.mSortedHorizontalChildren = new View[count];
        }
        DependencyGraph graph = this.mGraph;
        graph.clear();
        for (int i = 0; i < count; ++i) {
            graph.add(this.getChildAt(i));
        }
        graph.getSortedViews(this.mSortedVerticalChildren, RULES_VERTICAL);
        graph.getSortedViews(this.mSortedHorizontalChildren, RULES_HORIZONTAL);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int[] rules;
        LayoutParams params;
        View child;
        LayoutParams params2;
        if (this.mDirtyHierarchy) {
            this.mDirtyHierarchy = false;
            this.sortChildren();
        }
        int myWidth = -1;
        int myHeight = -1;
        int width = 0;
        int height = 0;
        int widthMode = MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = MeasureSpec.getMode(heightMeasureSpec);
        int widthSize = MeasureSpec.getSize(widthMeasureSpec);
        int heightSize = MeasureSpec.getSize(heightMeasureSpec);
        if (widthMode != 0) {
            myWidth = widthSize;
        }
        if (heightMode != 0) {
            myHeight = heightSize;
        }
        if (widthMode == 0x40000000) {
            width = myWidth;
        }
        if (heightMode == 0x40000000) {
            height = myHeight;
        }
        Object ignore = null;
        int gravity = this.mGravity & 0x800007;
        boolean horizontalGravity = gravity != 0x800003 && gravity != 0;
        gravity = this.mGravity & 0x70;
        boolean verticalGravity = gravity != 48 && gravity != 0;
        int left = Integer.MAX_VALUE;
        int top = Integer.MAX_VALUE;
        int right = Integer.MIN_VALUE;
        int bottom = Integer.MIN_VALUE;
        boolean offsetHorizontalAxis = false;
        boolean offsetVerticalAxis = false;
        if ((horizontalGravity || verticalGravity) && this.mIgnoreGravity != -1) {
            ignore = this.findViewById(this.mIgnoreGravity);
        }
        boolean isWrapContentWidth = widthMode != 0x40000000;
        boolean isWrapContentHeight = heightMode != 0x40000000;
        int layoutDirection = this.getLayoutDirection();
        if (this.isLayoutRtl() && myWidth == -1) {
            myWidth = 65536;
        }
        for (View child2 : this.mSortedHorizontalChildren) {
            if (child2.getVisibility() == 8) continue;
            params2 = (LayoutParams)child2.getLayoutParams();
            int[] rules2 = params2.getRules(layoutDirection);
            this.applyHorizontalSizeRules(params2, myWidth, rules2);
            this.measureChildHorizontal(child2, params2, myWidth, myHeight);
            if (!this.positionChildHorizontal(child2, params2, myWidth, isWrapContentWidth)) continue;
            offsetHorizontalAxis = true;
        }
        View[] views = this.mSortedVerticalChildren;
        int count = views.length;
        for (int i = 0; i < count; ++i) {
            View child2;
            child2 = views[i];
            if (child2.getVisibility() == 8) continue;
            params2 = (LayoutParams)child2.getLayoutParams();
            this.applyVerticalSizeRules(params2, myHeight, child2.getBaseline());
            this.measureChild(child2, params2, myWidth, myHeight);
            if (this.positionChildVertical(child2, params2, myHeight, isWrapContentHeight)) {
                offsetVerticalAxis = true;
            }
            if (isWrapContentWidth) {
                width = this.isLayoutRtl() ? Math.max(width, myWidth - params2.mLeft + params2.leftMargin) : Math.max(width, params2.mRight + params2.rightMargin);
            }
            if (isWrapContentHeight) {
                height = Math.max(height, params2.mBottom + params2.bottomMargin);
            }
            if (child2 != ignore || verticalGravity) {
                left = Math.min(left, params2.mLeft - params2.leftMargin);
                top = Math.min(top, params2.mTop - params2.topMargin);
            }
            if (child2 == ignore && !horizontalGravity) continue;
            right = Math.max(right, params2.mRight + params2.rightMargin);
            bottom = Math.max(bottom, params2.mBottom + params2.bottomMargin);
        }
        View baselineView = null;
        LayoutParams baselineParams = null;
        for (int i = 0; i < count; ++i) {
            View child3 = views[i];
            if (child3.getVisibility() == 8) continue;
            LayoutParams childParams = (LayoutParams)child3.getLayoutParams();
            if (baselineView != null && baselineParams != null && this.compareLayoutPosition(childParams, baselineParams) >= 0) continue;
            baselineView = child3;
            baselineParams = childParams;
        }
        this.mBaselineView = baselineView;
        if (isWrapContentWidth) {
            width += this.mPaddingRight;
            ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
            if (layoutParams != null && layoutParams.width >= 0) {
                width = Math.max(width, layoutParams.width);
            }
            width = Math.max(width, this.getSuggestedMinimumWidth());
            width = RelativeLayout.resolveSize(width, widthMeasureSpec);
            if (offsetHorizontalAxis) {
                for (int i = 0; i < count; ++i) {
                    child = views[i];
                    if (child.getVisibility() == 8) continue;
                    params = (LayoutParams)child.getLayoutParams();
                    rules = params.getRules(layoutDirection);
                    if (rules[13] != 0 || rules[14] != 0) {
                        RelativeLayout.centerHorizontal(child, params, width);
                        continue;
                    }
                    if (rules[11] == 0) continue;
                    int childWidth = child.getMeasuredWidth();
                    params.mLeft = width - this.mPaddingRight - childWidth;
                    params.mRight = params.mLeft + childWidth;
                }
            }
        }
        if (isWrapContentHeight) {
            height += this.mPaddingBottom;
            ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
            if (layoutParams != null && layoutParams.height >= 0) {
                height = Math.max(height, layoutParams.height);
            }
            height = Math.max(height, this.getSuggestedMinimumHeight());
            height = RelativeLayout.resolveSize(height, heightMeasureSpec);
            if (offsetVerticalAxis) {
                for (int i = 0; i < count; ++i) {
                    child = views[i];
                    if (child.getVisibility() == 8) continue;
                    params = (LayoutParams)child.getLayoutParams();
                    rules = params.getRules(layoutDirection);
                    if (rules[13] != 0 || rules[15] != 0) {
                        RelativeLayout.centerVertical(child, params, height);
                        continue;
                    }
                    if (rules[12] == 0) continue;
                    int childHeight = child.getMeasuredHeight();
                    params.mTop = height - this.mPaddingBottom - childHeight;
                    params.mBottom = params.mTop + childHeight;
                }
            }
        }
        if (horizontalGravity || verticalGravity) {
            Rect selfBounds = this.mSelfBounds;
            selfBounds.set(this.mPaddingLeft, this.mPaddingTop, width - this.mPaddingRight, height - this.mPaddingBottom);
            Rect contentBounds = this.mContentBounds;
            Gravity.apply(this.mGravity, right - left, bottom - top, selfBounds, contentBounds, layoutDirection);
            int horizontalOffset = contentBounds.left - left;
            int verticalOffset = contentBounds.top - top;
            if (horizontalOffset != 0 || verticalOffset != 0) {
                for (int i = 0; i < count; ++i) {
                    View child4 = views[i];
                    if (child4.getVisibility() == 8 || child4 == ignore) continue;
                    LayoutParams params3 = (LayoutParams)child4.getLayoutParams();
                    if (horizontalGravity) {
                        params3.mLeft += horizontalOffset;
                        params3.mRight += horizontalOffset;
                    }
                    if (!verticalGravity) continue;
                    params3.mTop += verticalOffset;
                    params3.mBottom += verticalOffset;
                }
            }
        }
        if (this.isLayoutRtl()) {
            int offsetWidth = myWidth - width;
            for (int i = 0; i < count; ++i) {
                View child5 = views[i];
                if (child5.getVisibility() == 8) continue;
                LayoutParams params4 = (LayoutParams)child5.getLayoutParams();
                params4.mLeft -= offsetWidth;
                params4.mRight -= offsetWidth;
            }
        }
        this.setMeasuredDimension(width, height);
    }

    private int compareLayoutPosition(@Nonnull LayoutParams p1, @Nonnull LayoutParams p2) {
        int topDiff = p1.mTop - p2.mTop;
        if (topDiff != 0) {
            return topDiff;
        }
        return p1.mLeft - p2.mLeft;
    }

    private void measureChild(@Nonnull View child, @Nonnull LayoutParams params, int myWidth, int myHeight) {
        int childWidthMeasureSpec = this.getChildMeasureSpec(params.mLeft, params.mRight, params.width, params.leftMargin, params.rightMargin, this.mPaddingLeft, this.mPaddingRight, myWidth);
        int childHeightMeasureSpec = this.getChildMeasureSpec(params.mTop, params.mBottom, params.height, params.topMargin, params.bottomMargin, this.mPaddingTop, this.mPaddingBottom, myHeight);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    private void measureChildHorizontal(View child, LayoutParams params, int myWidth, int myHeight) {
        int childHeightMeasureSpec;
        int childWidthMeasureSpec = this.getChildMeasureSpec(params.mLeft, params.mRight, params.width, params.leftMargin, params.rightMargin, this.mPaddingLeft, this.mPaddingRight, myWidth);
        if (myHeight < 0) {
            childHeightMeasureSpec = params.height >= 0 ? MeasureSpec.makeMeasureSpec(params.height, 0x40000000) : MeasureSpec.makeMeasureSpec(0, 0);
        } else {
            int maxHeight = Math.max(0, myHeight - this.mPaddingTop - this.mPaddingBottom - params.topMargin - params.bottomMargin);
            int heightMode = params.height == -1 ? 0x40000000 : Integer.MIN_VALUE;
            childHeightMeasureSpec = MeasureSpec.makeMeasureSpec(maxHeight, heightMode);
        }
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    private int getChildMeasureSpec(int childStart, int childEnd, int childSize, int startMargin, int endMargin, int startPadding, int endPadding, int mySize) {
        int childSpecSize;
        int childSpecMode;
        boolean isUnspecified;
        boolean bl = isUnspecified = mySize < 0;
        if (isUnspecified) {
            int childSpecMode2;
            int childSpecSize2;
            if (childStart != Integer.MIN_VALUE && childEnd != Integer.MIN_VALUE) {
                childSpecSize2 = Math.max(0, childEnd - childStart);
                childSpecMode2 = 0x40000000;
            } else if (childSize >= 0) {
                childSpecSize2 = childSize;
                childSpecMode2 = 0x40000000;
            } else {
                childSpecSize2 = 0;
                childSpecMode2 = 0;
            }
            return MeasureSpec.makeMeasureSpec(childSpecSize2, childSpecMode2);
        }
        int tempStart = childStart;
        int tempEnd = childEnd;
        if (tempStart == Integer.MIN_VALUE) {
            tempStart = startPadding + startMargin;
        }
        if (tempEnd == Integer.MIN_VALUE) {
            tempEnd = mySize - endPadding - endMargin;
        }
        int maxAvailable = tempEnd - tempStart;
        if (childStart != Integer.MIN_VALUE && childEnd != Integer.MIN_VALUE) {
            childSpecMode = 0x40000000;
            childSpecSize = Math.max(0, maxAvailable);
        } else if (childSize >= 0) {
            childSpecMode = 0x40000000;
            childSpecSize = maxAvailable >= 0 ? Math.min(maxAvailable, childSize) : childSize;
        } else if (childSize == -1) {
            childSpecMode = 0x40000000;
            childSpecSize = Math.max(0, maxAvailable);
        } else if (childSize == -2) {
            if (maxAvailable >= 0) {
                childSpecMode = Integer.MIN_VALUE;
                childSpecSize = maxAvailable;
            } else {
                childSpecMode = 0;
                childSpecSize = 0;
            }
        } else {
            childSpecMode = 0;
            childSpecSize = 0;
        }
        return MeasureSpec.makeMeasureSpec(childSpecSize, childSpecMode);
    }

    private boolean positionChildHorizontal(View child, LayoutParams params, int myWidth, boolean wrapContent) {
        int layoutDirection = this.getLayoutDirection();
        int[] rules = params.getRules(layoutDirection);
        if (params.mLeft == Integer.MIN_VALUE && params.mRight != Integer.MIN_VALUE) {
            params.mLeft = params.mRight - child.getMeasuredWidth();
        } else if (params.mLeft != Integer.MIN_VALUE && params.mRight == Integer.MIN_VALUE) {
            params.mRight = params.mLeft + child.getMeasuredWidth();
        } else if (params.mLeft == Integer.MIN_VALUE) {
            if (rules[13] != 0 || rules[14] != 0) {
                if (!wrapContent) {
                    RelativeLayout.centerHorizontal(child, params, myWidth);
                } else {
                    this.positionAtEdge(child, params, myWidth);
                }
                return true;
            }
            this.positionAtEdge(child, params, myWidth);
        }
        return rules[21] != 0;
    }

    private void positionAtEdge(View child, LayoutParams params, int myWidth) {
        if (this.isLayoutRtl()) {
            params.mRight = myWidth - this.mPaddingRight - params.rightMargin;
            params.mLeft = params.mRight - child.getMeasuredWidth();
        } else {
            params.mLeft = this.mPaddingLeft + params.leftMargin;
            params.mRight = params.mLeft + child.getMeasuredWidth();
        }
    }

    private boolean positionChildVertical(View child, LayoutParams params, int myHeight, boolean wrapContent) {
        int[] rules = params.getRules();
        if (params.mTop == Integer.MIN_VALUE && params.mBottom != Integer.MIN_VALUE) {
            params.mTop = params.mBottom - child.getMeasuredHeight();
        } else if (params.mTop != Integer.MIN_VALUE && params.mBottom == Integer.MIN_VALUE) {
            params.mBottom = params.mTop + child.getMeasuredHeight();
        } else if (params.mTop == Integer.MIN_VALUE) {
            if (rules[13] != 0 || rules[15] != 0) {
                if (!wrapContent) {
                    RelativeLayout.centerVertical(child, params, myHeight);
                } else {
                    params.mTop = this.mPaddingTop + params.topMargin;
                    params.mBottom = params.mTop + child.getMeasuredHeight();
                }
                return true;
            }
            params.mTop = this.mPaddingTop + params.topMargin;
            params.mBottom = params.mTop + child.getMeasuredHeight();
        }
        return rules[12] != 0;
    }

    private void applyHorizontalSizeRules(LayoutParams childParams, int myWidth, int[] rules) {
        childParams.mLeft = Integer.MIN_VALUE;
        childParams.mRight = Integer.MIN_VALUE;
        LayoutParams anchorParams = this.getRelatedViewParams(rules, 0);
        if (anchorParams != null) {
            childParams.mRight = anchorParams.mLeft - (anchorParams.leftMargin + childParams.rightMargin);
        } else if (childParams.alignWithParent && rules[0] != 0 && myWidth >= 0) {
            childParams.mRight = myWidth - this.mPaddingRight - childParams.rightMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 1);
        if (anchorParams != null) {
            childParams.mLeft = anchorParams.mRight + (anchorParams.rightMargin + childParams.leftMargin);
        } else if (childParams.alignWithParent && rules[1] != 0) {
            childParams.mLeft = this.mPaddingLeft + childParams.leftMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 5);
        if (anchorParams != null) {
            childParams.mLeft = anchorParams.mLeft + childParams.leftMargin;
        } else if (childParams.alignWithParent && rules[5] != 0) {
            childParams.mLeft = this.mPaddingLeft + childParams.leftMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 7);
        if (anchorParams != null) {
            childParams.mRight = anchorParams.mRight - childParams.rightMargin;
        } else if (childParams.alignWithParent && rules[7] != 0 && myWidth >= 0) {
            childParams.mRight = myWidth - this.mPaddingRight - childParams.rightMargin;
        }
        if (0 != rules[9]) {
            childParams.mLeft = this.mPaddingLeft + childParams.leftMargin;
        }
        if (0 != rules[11] && myWidth >= 0) {
            childParams.mRight = myWidth - this.mPaddingRight - childParams.rightMargin;
        }
    }

    private void applyVerticalSizeRules(LayoutParams childParams, int myHeight, int myBaseline) {
        int[] rules = childParams.getRules();
        int baselineOffset = this.getRelatedViewBaselineOffset(rules);
        if (baselineOffset != -1) {
            if (myBaseline != -1) {
                baselineOffset -= myBaseline;
            }
            childParams.mTop = baselineOffset;
            childParams.mBottom = Integer.MIN_VALUE;
            return;
        }
        childParams.mTop = Integer.MIN_VALUE;
        childParams.mBottom = Integer.MIN_VALUE;
        LayoutParams anchorParams = this.getRelatedViewParams(rules, 2);
        if (anchorParams != null) {
            childParams.mBottom = anchorParams.mTop - (anchorParams.topMargin + childParams.bottomMargin);
        } else if (childParams.alignWithParent && rules[2] != 0 && myHeight >= 0) {
            childParams.mBottom = myHeight - this.mPaddingBottom - childParams.bottomMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 3);
        if (anchorParams != null) {
            childParams.mTop = anchorParams.mBottom + (anchorParams.bottomMargin + childParams.topMargin);
        } else if (childParams.alignWithParent && rules[3] != 0) {
            childParams.mTop = this.mPaddingTop + childParams.topMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 6);
        if (anchorParams != null) {
            childParams.mTop = anchorParams.mTop + childParams.topMargin;
        } else if (childParams.alignWithParent && rules[6] != 0) {
            childParams.mTop = this.mPaddingTop + childParams.topMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 8);
        if (anchorParams != null) {
            childParams.mBottom = anchorParams.mBottom - childParams.bottomMargin;
        } else if (childParams.alignWithParent && rules[8] != 0 && myHeight >= 0) {
            childParams.mBottom = myHeight - this.mPaddingBottom - childParams.bottomMargin;
        }
        if (0 != rules[10]) {
            childParams.mTop = this.mPaddingTop + childParams.topMargin;
        }
        if (0 != rules[12] && myHeight >= 0) {
            childParams.mBottom = myHeight - this.mPaddingBottom - childParams.bottomMargin;
        }
    }

    @Nullable
    private View getRelatedView(int[] rules, int relation) {
        int id2 = rules[relation];
        if (id2 != 0) {
            DependencyGraph.Node node = this.mGraph.mKeyNodes.get(id2);
            if (node == null) {
                return null;
            }
            View v = node.view;
            while (v.getVisibility() == 8) {
                rules = ((LayoutParams)v.getLayoutParams()).getRules(v.getLayoutDirection());
                node = this.mGraph.mKeyNodes.get(rules[relation]);
                if (node == null || v == node.view) {
                    return null;
                }
                v = node.view;
            }
            return v;
        }
        return null;
    }

    @Nullable
    private LayoutParams getRelatedViewParams(int[] rules, int relation) {
        ViewGroup.LayoutParams params;
        View v = this.getRelatedView(rules, relation);
        if (v != null && (params = v.getLayoutParams()) instanceof LayoutParams) {
            return (LayoutParams)v.getLayoutParams();
        }
        return null;
    }

    private int getRelatedViewBaselineOffset(int[] rules) {
        ViewGroup.LayoutParams params;
        int baseline;
        View v = this.getRelatedView(rules, 4);
        if (v != null && (baseline = v.getBaseline()) != -1 && (params = v.getLayoutParams()) instanceof LayoutParams) {
            LayoutParams anchorParams = (LayoutParams)v.getLayoutParams();
            return anchorParams.mTop + baseline;
        }
        return -1;
    }

    private static void centerHorizontal(View child, LayoutParams params, int myWidth) {
        int left;
        int childWidth = child.getMeasuredWidth();
        params.mLeft = left = (myWidth - childWidth) / 2;
        params.mRight = left + childWidth;
    }

    private static void centerVertical(View child, LayoutParams params, int myHeight) {
        int top;
        int childHeight = child.getMeasuredHeight();
        params.mTop = top = (myHeight - childHeight) / 2;
        params.mBottom = top + childHeight;
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams st = (LayoutParams)child.getLayoutParams();
            child.layout(st.mLeft, st.mTop, st.mRight, st.mBottom);
        }
    }

    @Override
    @Nonnull
    protected ViewGroup.LayoutParams generateLayoutParams(@Nonnull ViewGroup.LayoutParams lp) {
        if (lp instanceof LayoutParams) {
            return new LayoutParams((LayoutParams)lp);
        }
        if (lp instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)lp);
        }
        return new LayoutParams(lp);
    }

    @Override
    @Nonnull
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    @Override
    protected boolean checkLayoutParams(@Nullable ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    private static class DependencyGraph {
        private final ArrayList<Node> mNodes = new ArrayList();
        private final SparseArray<Node> mKeyNodes = new SparseArray();
        private final ArrayDeque<Node> mRoots = new ArrayDeque();

        private DependencyGraph() {
        }

        void clear() {
            for (Node node : this.mNodes) {
                node.release();
            }
            this.mNodes.clear();
            this.mKeyNodes.clear();
            this.mRoots.clear();
        }

        void add(@Nonnull View view) {
            int id2 = view.getId();
            Node node = Node.acquire(view);
            if (id2 != -1) {
                this.mKeyNodes.put(id2, node);
            }
            this.mNodes.add(node);
        }

        void getSortedViews(View[] sorted, int ... rules) {
            Node node;
            ArrayDeque<Node> roots = this.findRoots(rules);
            int index = 0;
            while ((node = roots.pollLast()) != null) {
                View view = node.view;
                int key = view.getId();
                sorted[index++] = view;
                ArrayMap<Node, DependencyGraph> dependents = node.dependents;
                int count = dependents.size();
                for (int i = 0; i < count; ++i) {
                    Node dependent = dependents.keyAt(i);
                    SparseArray<Node> dependencies = dependent.dependencies;
                    dependencies.remove(key);
                    if (dependencies.size() != 0) continue;
                    roots.add(dependent);
                }
            }
            if (index < sorted.length) {
                throw new IllegalStateException("Circular dependencies cannot exist in RelativeLayout");
            }
        }

        @Nonnull
        private ArrayDeque<Node> findRoots(int[] rulesFilter) {
            ArrayList<Node> nodes = this.mNodes;
            for (Node node : nodes) {
                node.dependents.clear();
                node.dependencies.clear();
            }
            for (Node node : nodes) {
                LayoutParams layoutParams = (LayoutParams)node.view.getLayoutParams();
                int[] rules = layoutParams.mRules;
                for (int i : rulesFilter) {
                    Node dependency;
                    int rule = rules[i];
                    if (rule == -1 || (dependency = this.mKeyNodes.get(rule)) == null || dependency == node) continue;
                    dependency.dependents.put(node, this);
                    node.dependencies.put(rule, dependency);
                }
            }
            ArrayDeque<Node> roots = this.mRoots;
            roots.clear();
            for (Node node : nodes) {
                if (!node.dependencies.isEmpty()) continue;
                roots.addLast(node);
            }
            return roots;
        }

        static class Node {
            View view;
            final ArrayMap<Node, DependencyGraph> dependents = new ArrayMap();
            final SparseArray<Node> dependencies = new SparseArray();
            private static final Pools.Pool<Node> sPool = Pools.newSynchronizedPool(100);

            Node() {
            }

            @Nonnull
            static Node acquire(View view) {
                Node node = sPool.acquire();
                if (node == null) {
                    node = new Node();
                }
                node.view = view;
                return node;
            }

            void release() {
                this.view = null;
                this.dependents.clear();
                this.dependencies.clear();
                sPool.release(this);
            }
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        private final int[] mRules = new int[22];
        private final int[] mInitialRules = new int[22];
        private transient int mLeft;
        private transient int mTop;
        private transient int mRight;
        private transient int mBottom;
        private boolean mNeedsLayoutResolution;
        private boolean mRulesChanged = false;
        public boolean alignWithParent;

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(@Nonnull ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(@Nonnull ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(@Nonnull LayoutParams source) {
            super(source);
            this.mNeedsLayoutResolution = source.mNeedsLayoutResolution;
            this.mRulesChanged = source.mRulesChanged;
            this.alignWithParent = source.alignWithParent;
            System.arraycopy(source.mRules, 0, this.mRules, 0, 22);
            System.arraycopy(source.mInitialRules, 0, this.mInitialRules, 0, 22);
        }

        public void addRule(int verb) {
            this.addRule(verb, -1);
        }

        public void addRule(int verb, int subject) {
            if (!this.mNeedsLayoutResolution && this.isRelativeRule(verb) && this.mInitialRules[verb] != 0 && subject == 0) {
                this.mNeedsLayoutResolution = true;
            }
            this.mRules[verb] = subject;
            this.mInitialRules[verb] = subject;
            this.mRulesChanged = true;
        }

        public void removeRule(int verb) {
            this.addRule(verb, 0);
        }

        public int getRule(int verb) {
            return this.mRules[verb];
        }

        private boolean hasRelativeRules() {
            return this.mInitialRules[16] != 0 || this.mInitialRules[17] != 0 || this.mInitialRules[18] != 0 || this.mInitialRules[19] != 0 || this.mInitialRules[20] != 0 || this.mInitialRules[21] != 0;
        }

        private boolean isRelativeRule(int rule) {
            return rule == 16 || rule == 17 || rule == 18 || rule == 19 || rule == 20 || rule == 21;
        }

        private void resolveRules(int layoutDirection) {
            boolean isLayoutRtl = layoutDirection == 1;
            System.arraycopy(this.mInitialRules, 0, this.mRules, 0, 22);
            if (!(this.mRules[18] == 0 && this.mRules[19] == 0 || this.mRules[5] == 0 && this.mRules[7] == 0)) {
                this.mRules[5] = 0;
                this.mRules[7] = 0;
            }
            if (this.mRules[18] != 0) {
                this.mRules[isLayoutRtl ? 7 : 5] = this.mRules[18];
                this.mRules[18] = 0;
            }
            if (this.mRules[19] != 0) {
                this.mRules[isLayoutRtl ? 5 : 7] = this.mRules[19];
                this.mRules[19] = 0;
            }
            if (!(this.mRules[16] == 0 && this.mRules[17] == 0 || this.mRules[0] == 0 && this.mRules[1] == 0)) {
                this.mRules[0] = 0;
                this.mRules[1] = 0;
            }
            if (this.mRules[16] != 0) {
                this.mRules[isLayoutRtl ? 1 : 0] = this.mRules[16];
                this.mRules[16] = 0;
            }
            if (this.mRules[17] != 0) {
                this.mRules[isLayoutRtl ? 0 : 1] = this.mRules[17];
                this.mRules[17] = 0;
            }
            if (!(this.mRules[20] == 0 && this.mRules[21] == 0 || this.mRules[9] == 0 && this.mRules[11] == 0)) {
                this.mRules[9] = 0;
                this.mRules[11] = 0;
            }
            if (this.mRules[20] != 0) {
                this.mRules[isLayoutRtl ? 11 : 9] = this.mRules[20];
                this.mRules[20] = 0;
            }
            if (this.mRules[21] != 0) {
                this.mRules[isLayoutRtl ? 9 : 11] = this.mRules[21];
                this.mRules[21] = 0;
            }
            this.mRulesChanged = false;
            this.mNeedsLayoutResolution = false;
        }

        public int[] getRules(int layoutDirection) {
            this.resolveLayoutDirection(layoutDirection);
            return this.mRules;
        }

        public int[] getRules() {
            return this.mRules;
        }

        @Override
        public void resolveLayoutDirection(int layoutDirection) {
            if ((this.mNeedsLayoutResolution || this.hasRelativeRules()) && (this.mRulesChanged || layoutDirection != this.getLayoutDirection())) {
                this.resolveRules(layoutDirection);
            }
            super.resolveLayoutDirection(layoutDirection);
        }
    }
}

