/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.widget;

import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.annotation.Nullable;
import icyllis.modernui.core.Context;
import icyllis.modernui.graphics.BlendMode;
import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.graphics.ColorFilter;
import icyllis.modernui.graphics.Image;
import icyllis.modernui.graphics.Matrix;
import icyllis.modernui.graphics.drawable.Drawable;
import icyllis.modernui.graphics.drawable.ImageDrawable;
import icyllis.modernui.util.ColorStateList;
import icyllis.modernui.view.MeasureSpec;
import icyllis.modernui.view.View;

public class ImageView
extends View {
    private final Matrix mMatrix = new Matrix();
    private ScaleType mScaleType = ScaleType.FIT_CENTER;
    private boolean mAdjustViewBounds = false;
    private int mMaxWidth = Integer.MAX_VALUE;
    private int mMaxHeight = Integer.MAX_VALUE;
    private ColorFilter mImageColorFilter = null;
    private boolean mHasImageColorFilter = false;
    private int mImageAlpha = 255;
    private boolean mHasImageAlpha = false;
    private Drawable mDrawable = null;
    private ImageDrawable mRecycleImageDrawable = null;
    private ColorStateList mDrawableTintList = null;
    private BlendMode mDrawableBlendMode = null;
    private boolean mHasDrawableTint = false;
    private boolean mHasDrawableBlendMode = false;
    private int[] mState = null;
    private boolean mMergeState = false;
    private boolean mHasLevelSet = false;
    private int mLevel = 0;
    private int mDrawableWidth;
    private int mDrawableHeight;
    private Matrix mDrawMatrix = null;
    private boolean mCropToPadding = false;
    private int mBaseline = -1;
    private boolean mBaselineAlignBottom = false;

    public ImageView(Context context) {
        super(context);
    }

    @Override
    protected boolean verifyDrawable(@NonNull Drawable dr) {
        return this.mDrawable == dr || super.verifyDrawable(dr);
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mDrawable != null) {
            this.mDrawable.jumpToCurrentState();
        }
    }

    @Override
    public void invalidateDrawable(@NonNull Drawable dr) {
        if (dr == this.mDrawable) {
            int w = dr.getIntrinsicWidth();
            int h = dr.getIntrinsicHeight();
            if (w != this.mDrawableWidth || h != this.mDrawableHeight) {
                this.mDrawableWidth = w;
                this.mDrawableHeight = h;
                this.configureBounds();
            }
            this.invalidate();
        } else {
            super.invalidateDrawable(dr);
        }
    }

    @Override
    public boolean hasOverlappingRendering() {
        return this.getBackground() != null && this.getBackground().getCurrent() != null;
    }

    public boolean getAdjustViewBounds() {
        return this.mAdjustViewBounds;
    }

    public void setAdjustViewBounds(boolean adjustViewBounds) {
        this.mAdjustViewBounds = adjustViewBounds;
        if (adjustViewBounds) {
            this.setScaleType(ScaleType.FIT_CENTER);
        }
    }

    public int getMaxWidth() {
        return this.mMaxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.mMaxWidth = maxWidth;
    }

    public int getMaxHeight() {
        return this.mMaxHeight;
    }

    public void setMaxHeight(int maxHeight) {
        this.mMaxHeight = maxHeight;
    }

    @Nullable
    public Drawable getDrawable() {
        if (this.mDrawable == this.mRecycleImageDrawable) {
            this.mRecycleImageDrawable = null;
        }
        return this.mDrawable;
    }

    public void setImageDrawable(@Nullable Drawable drawable) {
        if (this.mDrawable != drawable) {
            int oldWidth = this.mDrawableWidth;
            int oldHeight = this.mDrawableHeight;
            this.updateDrawable(drawable);
            if (oldWidth != this.mDrawableWidth || oldHeight != this.mDrawableHeight) {
                this.requestLayout();
            }
            this.invalidate();
        }
    }

    public void setImageTintList(@Nullable ColorStateList tint) {
        this.mDrawableTintList = tint;
        this.mHasDrawableTint = true;
        this.applyImageTint();
    }

    @Nullable
    public ColorStateList getImageTintList() {
        return this.mDrawableTintList;
    }

    public void setImageTintBlendMode(@Nullable BlendMode blendMode) {
        this.mDrawableBlendMode = blendMode;
        this.mHasDrawableBlendMode = true;
        this.applyImageTint();
    }

    @Nullable
    public BlendMode getImageTintBlendMode() {
        return this.mDrawableBlendMode;
    }

    private void applyImageTint() {
        if (this.mDrawable != null && (this.mHasDrawableTint || this.mHasDrawableBlendMode)) {
            this.mDrawable = this.mDrawable.mutate();
            if (this.mHasDrawableTint) {
                this.mDrawable.setTintList(this.mDrawableTintList);
            }
            if (this.mHasDrawableBlendMode) {
                this.mDrawable.setTintBlendMode(this.mDrawableBlendMode);
            }
            if (this.mDrawable.isStateful()) {
                this.mDrawable.setState(this.getDrawableState());
            }
        }
    }

    public void setImage(@Nullable Image image) {
        this.mDrawable = null;
        if (this.mRecycleImageDrawable == null) {
            this.mRecycleImageDrawable = new ImageDrawable(this.getContext().getResources(), image);
        } else {
            this.mRecycleImageDrawable.setImage(image);
        }
        this.setImageDrawable(this.mRecycleImageDrawable);
    }

    public void setImageState(int[] state, boolean merge) {
        this.mState = state;
        this.mMergeState = merge;
        if (this.mDrawable != null) {
            this.refreshDrawableState();
            this.resizeFromDrawable();
        }
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.resizeFromDrawable();
    }

    public void setImageLevel(int level) {
        this.mLevel = level;
        this.mHasLevelSet = true;
        if (this.mDrawable != null) {
            this.mDrawable.setLevel(level);
            this.resizeFromDrawable();
        }
    }

    public void setScaleType(@NonNull ScaleType scaleType) {
        if (this.mScaleType != scaleType) {
            this.mScaleType = scaleType;
            this.requestLayout();
            this.invalidate();
        }
    }

    @NonNull
    public ScaleType getScaleType() {
        return this.mScaleType;
    }

    public Matrix getImageMatrix() {
        if (this.mDrawMatrix == null) {
            return new Matrix();
        }
        return this.mDrawMatrix;
    }

    public void setImageMatrix(@Nullable Matrix matrix) {
        if (matrix != null && matrix.isIdentity()) {
            matrix = null;
        }
        if (matrix == null && !this.mMatrix.isIdentity() || matrix != null && !this.mMatrix.equals(matrix)) {
            this.mMatrix.set(matrix);
            this.configureBounds();
            this.invalidate();
        }
    }

    public boolean getCropToPadding() {
        return this.mCropToPadding;
    }

    public void setCropToPadding(boolean cropToPadding) {
        if (this.mCropToPadding != cropToPadding) {
            this.mCropToPadding = cropToPadding;
            this.requestLayout();
            this.invalidate();
        }
    }

    @Override
    @NonNull
    public int[] onCreateDrawableState(int extraSpace) {
        if (this.mState == null) {
            return super.onCreateDrawableState(extraSpace);
        }
        if (!this.mMergeState) {
            return this.mState;
        }
        return ImageView.mergeDrawableStates(super.onCreateDrawableState(extraSpace + this.mState.length), this.mState);
    }

    private void updateDrawable(@Nullable Drawable d) {
        if (d != this.mRecycleImageDrawable && this.mRecycleImageDrawable != null) {
            this.mRecycleImageDrawable.setImage(null);
        }
        boolean sameDrawable = false;
        if (this.mDrawable != null) {
            sameDrawable = this.mDrawable == d;
            this.mDrawable.setCallback(null);
            this.unscheduleDrawable(this.mDrawable);
            if (!sameDrawable && this.isAttachedToWindow()) {
                this.mDrawable.setVisible(false, false);
            }
        }
        this.mDrawable = d;
        if (d != null) {
            d.setCallback(this);
            d.setLayoutDirection(this.getLayoutDirection());
            if (d.isStateful()) {
                d.setState(this.getDrawableState());
            }
            if (!sameDrawable) {
                boolean visible = this.isAttachedToWindow() && this.getWindowVisibility() == 0 && this.isShown();
                d.setVisible(visible, true);
            }
            if (this.mHasLevelSet) {
                d.setLevel(this.mLevel);
            }
            this.mDrawableWidth = d.getIntrinsicWidth();
            this.mDrawableHeight = d.getIntrinsicHeight();
            this.applyImageTint();
            this.applyColorFilter();
            this.applyAlpha();
            this.configureBounds();
        } else {
            this.mDrawableHeight = -1;
            this.mDrawableWidth = -1;
        }
    }

    private void resizeFromDrawable() {
        Drawable d = this.mDrawable;
        if (d != null) {
            int h;
            int w = d.getIntrinsicWidth();
            if (w < 0) {
                w = this.mDrawableWidth;
            }
            if ((h = d.getIntrinsicHeight()) < 0) {
                h = this.mDrawableHeight;
            }
            if (w != this.mDrawableWidth || h != this.mDrawableHeight) {
                this.mDrawableWidth = w;
                this.mDrawableHeight = h;
                this.requestLayout();
            }
        }
    }

    @Override
    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        if (this.mDrawable != null) {
            this.mDrawable.setLayoutDirection(layoutDirection);
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightSize;
        int widthSize;
        int w;
        int h;
        float desiredAspect = 0.0f;
        boolean resizeWidth = false;
        boolean resizeHeight = false;
        int widthSpecMode = MeasureSpec.getMode(widthMeasureSpec);
        int heightSpecMode = MeasureSpec.getMode(heightMeasureSpec);
        if (this.mDrawable == null) {
            this.mDrawableWidth = -1;
            this.mDrawableHeight = -1;
            h = 0;
            w = 0;
        } else {
            w = this.mDrawableWidth;
            h = this.mDrawableHeight;
            if (w <= 0) {
                w = 1;
            }
            if (h <= 0) {
                h = 1;
            }
            if (this.mAdjustViewBounds) {
                resizeWidth = widthSpecMode != 0x40000000;
                resizeHeight = heightSpecMode != 0x40000000;
                desiredAspect = (float)w / (float)h;
            }
        }
        int pleft = this.mPaddingLeft;
        int pright = this.mPaddingRight;
        int ptop = this.mPaddingTop;
        int pbottom = this.mPaddingBottom;
        if (resizeWidth || resizeHeight) {
            float actualAspect;
            widthSize = this.resolveAdjustedSize(w + pleft + pright, this.mMaxWidth, widthMeasureSpec);
            heightSize = this.resolveAdjustedSize(h + ptop + pbottom, this.mMaxHeight, heightMeasureSpec);
            if (desiredAspect != 0.0f && (double)Math.abs((actualAspect = (float)(widthSize - pleft - pright) / (float)(heightSize - ptop - pbottom)) - desiredAspect) > 1.0E-7) {
                boolean done = false;
                if (resizeWidth) {
                    int newWidth = (int)(desiredAspect * (float)(heightSize - ptop - pbottom)) + pleft + pright;
                    if (!resizeHeight) {
                        widthSize = this.resolveAdjustedSize(newWidth, this.mMaxWidth, widthMeasureSpec);
                    }
                    if (newWidth <= widthSize) {
                        widthSize = newWidth;
                        done = true;
                    }
                }
                if (!done && resizeHeight) {
                    int newHeight = (int)((float)(widthSize - pleft - pright) / desiredAspect) + ptop + pbottom;
                    if (!resizeWidth) {
                        heightSize = this.resolveAdjustedSize(newHeight, this.mMaxHeight, heightMeasureSpec);
                    }
                    if (newHeight <= heightSize) {
                        heightSize = newHeight;
                    }
                }
            }
        } else {
            w += pleft + pright;
            h += ptop + pbottom;
            w = Math.max(w, this.getSuggestedMinimumWidth());
            h = Math.max(h, this.getSuggestedMinimumHeight());
            widthSize = ImageView.resolveSizeAndState(w, widthMeasureSpec, 0);
            heightSize = ImageView.resolveSizeAndState(h, heightMeasureSpec, 0);
        }
        this.setMeasuredDimension(widthSize, heightSize);
    }

    private int resolveAdjustedSize(int desiredSize, int maxSize, int measureSpec) {
        int result = desiredSize;
        int specMode = MeasureSpec.getMode(measureSpec);
        int specSize = MeasureSpec.getSize(measureSpec);
        switch (specMode) {
            case 0: {
                result = Math.min(desiredSize, maxSize);
                break;
            }
            case -2147483648: {
                result = Math.min(Math.min(desiredSize, specSize), maxSize);
                break;
            }
            case 0x40000000: {
                result = specSize;
            }
        }
        return result;
    }

    @Override
    protected void onSizeChanged(int width, int height, int prevWidth, int prevHeight) {
        super.onSizeChanged(width, height, prevWidth, prevHeight);
        this.configureBounds();
    }

    private void configureBounds() {
        boolean fits;
        if (this.mDrawable == null || !this.isAttachedToWindow()) {
            return;
        }
        int dwidth = this.mDrawableWidth;
        int dheight = this.mDrawableHeight;
        int vwidth = this.getWidth() - this.mPaddingLeft - this.mPaddingRight;
        int vheight = this.getHeight() - this.mPaddingTop - this.mPaddingBottom;
        boolean bl = fits = !(dwidth >= 0 && vwidth != dwidth || dheight >= 0 && vheight != dheight);
        if (dwidth <= 0 || dheight <= 0 || ScaleType.FIT_XY == this.mScaleType) {
            this.mDrawable.setBounds(0, 0, vwidth, vheight);
            this.mDrawMatrix = null;
        } else {
            this.mDrawable.setBounds(0, 0, dwidth, dheight);
            if (ScaleType.MATRIX == this.mScaleType) {
                this.mDrawMatrix = this.mMatrix.isIdentity() ? null : this.mMatrix;
            } else if (fits) {
                this.mDrawMatrix = null;
            } else if (ScaleType.CENTER == this.mScaleType) {
                this.mDrawMatrix = this.mMatrix;
                this.mDrawMatrix.setTranslate(Math.round((float)(vwidth - dwidth) * 0.5f), Math.round((float)(vheight - dheight) * 0.5f));
            } else if (ScaleType.CENTER_CROP == this.mScaleType) {
                float scale;
                this.mDrawMatrix = this.mMatrix;
                float dx = 0.0f;
                float dy = 0.0f;
                if (dwidth * vheight > vwidth * dheight) {
                    scale = (float)vheight / (float)dheight;
                    dx = ((float)vwidth - (float)dwidth * scale) * 0.5f;
                } else {
                    scale = (float)vwidth / (float)dwidth;
                    dy = ((float)vheight - (float)dheight * scale) * 0.5f;
                }
                this.mDrawMatrix.setScaleTranslate(scale, scale, Math.round(dx), Math.round(dy));
            } else if (ScaleType.CENTER_INSIDE == this.mScaleType) {
                this.mDrawMatrix = this.mMatrix;
                float scale = dwidth <= vwidth && dheight <= vheight ? 1.0f : Math.min((float)vwidth / (float)dwidth, (float)vheight / (float)dheight);
                float dx = Math.round(((float)vwidth - (float)dwidth * scale) * 0.5f);
                float dy = Math.round(((float)vheight - (float)dheight * scale) * 0.5f);
                this.mDrawMatrix.setScaleTranslate(scale, scale, dx, dy);
            } else {
                this.mDrawMatrix = this.mMatrix;
                float tx = 0.0f;
                float sx = (float)vwidth / (float)dwidth;
                float ty = 0.0f;
                float sy = (float)vheight / (float)dheight;
                boolean xLarger = false;
                if (this.mScaleType != ScaleType.FIT_XY) {
                    if (sx > sy) {
                        xLarger = true;
                        sx = sy;
                    } else {
                        sy = sx;
                    }
                }
                if (this.mScaleType == ScaleType.FIT_CENTER || this.mScaleType == ScaleType.FIT_END) {
                    float diff = xLarger ? (float)vwidth - (float)dwidth * sy : (float)vheight - (float)dheight * sy;
                    if (this.mScaleType == ScaleType.FIT_CENTER) {
                        diff *= 0.5f;
                    }
                    if (xLarger) {
                        tx += diff;
                    } else {
                        ty += diff;
                    }
                }
                this.mDrawMatrix.setScaleTranslate(sx, sy, tx, ty);
            }
        }
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable drawable = this.mDrawable;
        if (drawable != null && drawable.isStateful() && drawable.setState(this.getDrawableState())) {
            this.invalidateDrawable(drawable);
        }
    }

    @Override
    public void drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.mDrawable != null) {
            this.mDrawable.setHotspot(x, y);
        }
    }

    public void animateTransform(@Nullable Matrix matrix) {
        if (this.mDrawable == null) {
            return;
        }
        if (matrix == null) {
            int vwidth = this.getWidth() - this.mPaddingLeft - this.mPaddingRight;
            int vheight = this.getHeight() - this.mPaddingTop - this.mPaddingBottom;
            this.mDrawable.setBounds(0, 0, vwidth, vheight);
            this.mDrawMatrix = null;
        } else {
            this.mDrawable.setBounds(0, 0, this.mDrawableWidth, this.mDrawableHeight);
            if (this.mDrawMatrix == null) {
                this.mDrawMatrix = new Matrix();
            }
            this.mDrawMatrix.set(matrix);
        }
        this.invalidate();
    }

    @Override
    protected void onDraw(@NonNull Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDrawable == null) {
            return;
        }
        if (this.mDrawableWidth == 0 || this.mDrawableHeight == 0) {
            return;
        }
        if (this.mDrawMatrix == null && this.mPaddingTop == 0 && this.mPaddingLeft == 0) {
            this.mDrawable.draw(canvas);
        } else {
            int saveCount = canvas.getSaveCount();
            canvas.save();
            if (this.mCropToPadding) {
                int scrollX = this.mScrollX;
                int scrollY = this.mScrollY;
                canvas.clipRect(scrollX + this.mPaddingLeft, scrollY + this.mPaddingTop, scrollX + this.getWidth() - this.mPaddingRight, scrollY + this.getHeight() - this.mPaddingBottom);
            }
            canvas.translate(this.mPaddingLeft, this.mPaddingTop);
            if (this.mDrawMatrix != null) {
                canvas.concat(this.mDrawMatrix);
            }
            this.mDrawable.draw(canvas);
            canvas.restoreToCount(saveCount);
        }
    }

    @Override
    public int getBaseline() {
        if (this.mBaselineAlignBottom) {
            return this.getMeasuredHeight();
        }
        return this.mBaseline;
    }

    public void setBaseline(int baseline) {
        if (this.mBaseline != baseline) {
            this.mBaseline = baseline;
            this.requestLayout();
        }
    }

    public void setBaselineAlignBottom(boolean aligned) {
        if (this.mBaselineAlignBottom != aligned) {
            this.mBaselineAlignBottom = aligned;
            this.requestLayout();
        }
    }

    public boolean getBaselineAlignBottom() {
        return this.mBaselineAlignBottom;
    }

    @Nullable
    public ColorFilter getColorFilter() {
        return this.mImageColorFilter;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        if (this.mImageColorFilter != colorFilter) {
            this.mImageColorFilter = colorFilter;
            this.mHasImageColorFilter = true;
            this.applyColorFilter();
            this.invalidate();
        }
    }

    public int getImageAlpha() {
        return this.mImageAlpha;
    }

    public void setImageAlpha(int alpha) {
        if (this.mImageAlpha != (alpha += alpha >> 7)) {
            this.mImageAlpha = alpha;
            this.mHasImageAlpha = true;
            this.applyAlpha();
            this.invalidate();
        }
    }

    private void applyColorFilter() {
        if (this.mDrawable != null && this.mHasImageColorFilter) {
            this.mDrawable = this.mDrawable.mutate();
            this.mDrawable.setColorFilter(this.mImageColorFilter);
        }
    }

    private void applyAlpha() {
        if (this.mDrawable != null && this.mHasImageAlpha) {
            this.mDrawable = this.mDrawable.mutate();
            this.mDrawable.setAlpha(this.mImageAlpha);
        }
    }

    @Override
    public void onVisibilityAggregated(boolean isVisible) {
        super.onVisibilityAggregated(isVisible);
        if (this.mDrawable != null) {
            this.mDrawable.setVisible(isVisible, false);
        }
    }

    public static enum ScaleType {
        MATRIX,
        FIT_XY,
        FIT_START,
        FIT_CENTER,
        FIT_END,
        CENTER,
        CENTER_CROP,
        CENTER_INSIDE;

    }
}

