/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.widget;

import icyllis.modernui.core.Context;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewGroup;
import icyllis.modernui.widget.BaseAdapter;
import icyllis.modernui.widget.Filter;
import icyllis.modernui.widget.Filterable;
import icyllis.modernui.widget.TextView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ArrayAdapter<T>
extends BaseAdapter
implements Filterable {
    private final Object mLock = new Object();
    private final Context mContext;
    private List<T> mObjects;
    private boolean mNotifyOnChange = true;
    private ArrayList<T> mOriginalValues;
    private ArrayFilter mFilter;

    public ArrayAdapter(Context context, @Nonnull T[] objects) {
        this(context, Arrays.asList(objects));
    }

    public ArrayAdapter(Context context, @Nonnull List<T> objects) {
        this.mContext = context;
        this.mObjects = objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@Nullable T object) {
        Object object2 = this.mLock;
        synchronized (object2) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.add(object);
            } else {
                this.mObjects.add(object);
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(@Nonnull Collection<? extends T> collection) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.addAll(collection);
            } else {
                this.mObjects.addAll(collection);
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(@Nonnull T[] items) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOriginalValues != null) {
                Collections.addAll(this.mOriginalValues, items);
            } else {
                Collections.addAll(this.mObjects, items);
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(@Nullable T object, int index) {
        Object object2 = this.mLock;
        synchronized (object2) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.add(index, object);
            } else {
                this.mObjects.add(index, object);
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@Nullable T object) {
        Object object2 = this.mLock;
        synchronized (object2) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.remove(object);
            } else {
                this.mObjects.remove(object);
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.clear();
            } else {
                this.mObjects.clear();
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(@Nonnull Comparator<? super T> comparator) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOriginalValues != null) {
                this.mOriginalValues.sort(comparator);
            } else {
                this.mObjects.sort(comparator);
            }
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.mNotifyOnChange = true;
    }

    public void setNotifyOnChange(boolean notifyOnChange) {
        this.mNotifyOnChange = notifyOnChange;
    }

    @Override
    public int getCount() {
        return this.mObjects.size();
    }

    public T getItem(int position) {
        return this.mObjects.get(position);
    }

    public int getPosition(@Nullable T item) {
        return this.mObjects.indexOf(item);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    @Nonnull
    public View getView(int position, @Nullable View convertView, @Nonnull ViewGroup parent) {
        return this.createViewInner(position, convertView);
    }

    @Nonnull
    private View createViewInner(int position, @Nullable View convertView) {
        TextView tv = convertView == null ? new TextView(this.mContext) : (TextView)convertView;
        T item = this.getItem(position);
        if (item instanceof CharSequence) {
            tv.setText((CharSequence)item);
        } else {
            tv.setText(String.valueOf(item));
        }
        tv.setTextSize(14.0f);
        tv.setTextAlignment(5);
        int dp4 = tv.dp(4.0f);
        tv.setPadding(dp4, dp4, dp4, dp4);
        return tv;
    }

    @Override
    public View getDropDownView(int position, @Nullable View convertView, @Nonnull ViewGroup parent) {
        return this.createViewInner(position, convertView);
    }

    @Override
    @Nonnull
    public Filter getFilter() {
        if (this.mFilter == null) {
            this.mFilter = new ArrayFilter();
        }
        return this.mFilter;
    }

    private class ArrayFilter
    extends Filter {
        private ArrayFilter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nonnull
        protected Filter.FilterResults performFiltering(CharSequence prefix) {
            Filter.FilterResults results = new Filter.FilterResults();
            if (ArrayAdapter.this.mOriginalValues == null) {
                Object object = ArrayAdapter.this.mLock;
                synchronized (object) {
                    ArrayAdapter.this.mOriginalValues = new ArrayList(ArrayAdapter.this.mObjects);
                }
            }
            if (prefix == null || prefix.length() == 0) {
                ArrayList list;
                Object object = ArrayAdapter.this.mLock;
                synchronized (object) {
                    list = new ArrayList(ArrayAdapter.this.mOriginalValues);
                }
                results.values = list;
                results.count = list.size();
            } else {
                ArrayList values;
                String prefixString = prefix.toString().toLowerCase();
                Object object = ArrayAdapter.this.mLock;
                synchronized (object) {
                    values = new ArrayList(ArrayAdapter.this.mOriginalValues);
                }
                ArrayList newValues = new ArrayList();
                block9: for (Object value : values) {
                    String[] words;
                    String valueText = value.toString().toLowerCase();
                    if (valueText.startsWith(prefixString)) {
                        newValues.add(value);
                        continue;
                    }
                    for (String word : words = valueText.split(" ")) {
                        if (!word.startsWith(prefixString)) continue;
                        newValues.add(value);
                        continue block9;
                    }
                }
                results.values = newValues;
                results.count = newValues.size();
            }
            return results;
        }

        @Override
        protected void publishResults(CharSequence constraint, @Nonnull Filter.FilterResults results) {
            ArrayAdapter.this.mObjects = (List)results.values;
            if (results.count > 0) {
                ArrayAdapter.this.notifyDataSetChanged();
            } else {
                ArrayAdapter.this.notifyDataSetInvalidated();
            }
        }
    }
}

