/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.view;

import icyllis.modernui.animation.LayoutTransition;
import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.annotation.Nullable;
import icyllis.modernui.annotation.UiThread;
import icyllis.modernui.core.Context;
import icyllis.modernui.core.Core;
import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.graphics.Paint;
import icyllis.modernui.graphics.Point;
import icyllis.modernui.graphics.PointF;
import icyllis.modernui.graphics.Rect;
import icyllis.modernui.graphics.RectF;
import icyllis.modernui.util.Pools;
import icyllis.modernui.view.ActionMode;
import icyllis.modernui.view.AttachInfo;
import icyllis.modernui.view.FocusFinder;
import icyllis.modernui.view.KeyEvent;
import icyllis.modernui.view.MeasureSpec;
import icyllis.modernui.view.MotionEvent;
import icyllis.modernui.view.PointerIcon;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewManager;
import icyllis.modernui.view.ViewParent;
import icyllis.modernui.view.ViewRoot;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;

@UiThread
public abstract class ViewGroup
extends View
implements ViewParent,
ViewManager {
    private static final int ARRAY_CAPACITY_INCREMENT = 12;
    static final int FLAG_CLIP_CHILDREN = 1;
    private static final int FLAG_CLIP_TO_PADDING = 2;
    private static final int FLAG_PADDING_NOT_NULL = 32;
    static final int FLAG_USE_CHILD_DRAWING_ORDER = 1024;
    private static final int FLAG_NOTIFY_CHILDREN_ON_DRAWABLE_STATE_CHANGE = 65536;
    private static final int FLAG_ADD_STATES_FROM_CHILDREN = 8192;
    public static final int FOCUS_BEFORE_DESCENDANTS = 131072;
    public static final int FOCUS_AFTER_DESCENDANTS = 262144;
    public static final int FOCUS_BLOCK_DESCENDANTS = 393216;
    private static final int FLAG_MASK_FOCUSABILITY = 393216;
    @ApiStatus.Internal
    protected static final int FLAG_DISALLOW_INTERCEPT = 524288;
    private static final int FLAG_PREVENT_DISPATCH_ATTACHED_TO_WINDOW = 0x400000;
    static final int FLAG_IS_TRANSITION_GROUP = 0x1000000;
    static final int FLAG_IS_TRANSITION_GROUP_SET = 0x2000000;
    static final int FLAG_TOUCHSCREEN_BLOCKS_FOCUS = 0x4000000;
    private static final int[] DESCENDANT_FOCUSABILITY_FLAGS = new int[]{131072, 262144, 393216};
    protected static final int CLIP_TO_PADDING_MASK = 34;
    private int mGroupFlags;
    private View[] mChildren;
    private int mChildrenCount;
    View mFocused;
    private View mDefaultFocus;
    View mFocusedInCluster;
    boolean mSuppressLayout = false;
    private boolean mLayoutCalledWhileSuppressed = false;
    private float[] mTempPosition;
    private TouchTarget mTouchTarget;
    private HoverTarget mFirstHoverTarget;
    private boolean mHoveredSelf;
    private View mTooltipHoverTarget;
    private boolean mTooltipHoveredSelf;
    private static final ThreadLocal<FloatBuffer> sDebugDrawBuffer = ThreadLocal.withInitial(() -> FloatBuffer.allocate(96));
    private LayoutTransition mTransition;
    private ArrayList<View> mDisappearingChildren;
    private ArrayList<View> mTransitioningViews;
    private ArrayList<View> mVisibilityChangingChildren;
    private ArrayList<View> mPreSortedChildren;
    private int mChildCountWithTransientState = 0;
    private int mNestedScrollAxesTouch;
    private int mNestedScrollAxesNonTouch;
    private IntArrayList mTransientIndices = null;
    private List<View> mTransientViews = null;
    private final LayoutTransitionListener mLayoutTransitionListener = new LayoutTransitionListener();

    public ViewGroup(Context context) {
        super(context);
        this.mGroupFlags |= 1;
        this.setDescendantFocusability(131072);
        this.mChildren = new View[12];
        this.mChildrenCount = 0;
    }

    @ApiStatus.Internal
    protected void onDebugDraw(@NonNull Canvas canvas) {
        Paint paint = Paint.obtain();
        int childrenCount = this.mChildrenCount;
        View[] children = this.mChildren;
        FloatBuffer positions = null;
        paint.setRGBA(1.0f, 0.0f, 0.0f, 1.0f);
        for (int i = 0; i < childrenCount; ++i) {
            View child = children[i];
            if (child.getVisibility() == 8) continue;
            if (positions == null) {
                positions = sDebugDrawBuffer.get();
            }
            positions.clear();
            float x1 = (float)child.getLeft() + 0.5f;
            float y1 = (float)child.getTop() + 0.5f;
            float x2 = (float)child.getRight() - 0.5f;
            float y2 = (float)child.getBottom() - 0.5f;
            positions.put(x1).put(y1).put(x2).put(y1).put(x2).put(y2).put(x1).put(y2).put(x1).put(y1);
            canvas.drawMesh(Canvas.VertexMode.LINE_STRIP, positions.flip(), null, null, null, null, paint);
        }
        paint.setRGBA(1.0f, 0.0f, 1.0f, 0.25f);
        this.onDebugDrawMargins(canvas, paint);
        paint.setRGBA(0.25f, 0.5f, 1.0f, 1.0f);
        int lineLength = this.dp(4.0f);
        int lineWidth = this.dp(0.5f);
        for (int i = 0; i < childrenCount; ++i) {
            View child = children[i];
            if (child.getVisibility() == 8) continue;
            if (positions == null) {
                positions = sDebugDrawBuffer.get();
            }
            positions.clear();
            int x1 = child.getLeft();
            int y1 = child.getTop();
            int x2 = child.getRight();
            int y2 = child.getBottom();
            ViewGroup.fillCorner(x1, y1, lineLength, lineLength, lineWidth, positions);
            ViewGroup.fillCorner(x1, y2, lineLength, -lineLength, lineWidth, positions);
            ViewGroup.fillCorner(x2, y1, -lineLength, lineLength, lineWidth, positions);
            ViewGroup.fillCorner(x2, y2, -lineLength, -lineLength, lineWidth, positions);
            canvas.drawMesh(Canvas.VertexMode.TRIANGLES, positions.flip(), null, null, null, null, paint);
        }
        paint.recycle();
    }

    @ApiStatus.Internal
    protected void onDebugDrawMargins(@NonNull Canvas canvas, Paint paint) {
        int childrenCount = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < childrenCount; ++i) {
            View child = children[i];
            child.getLayoutParams().onDebugDraw(child, canvas, paint);
        }
    }

    private static void fillRect(int x1, int y1, int x2, int y2, FloatBuffer positions) {
        if (x1 != x2 && y1 != y2) {
            int tmp;
            if (x1 > x2) {
                tmp = x1;
                x1 = x2;
                x2 = tmp;
            }
            if (y1 > y2) {
                tmp = y1;
                y1 = y2;
                y2 = tmp;
            }
            positions.put(x1).put(y2).put(x2).put(y2).put(x1).put(y1).put(x1).put(y1).put(x2).put(y2).put(x2).put(y1);
        }
    }

    private static void fillCorner(int x1, int y1, int dx, int dy, int lw, FloatBuffer positions) {
        ViewGroup.fillRect(x1, y1, x1 + dx, y1 + lw * (dy >= 0 ? 1 : -1), positions);
        ViewGroup.fillRect(x1, y1, x1 + lw * (dx >= 0 ? 1 : -1), y1 + dy, positions);
    }

    @Override
    protected void dispatchDraw(@NonNull Canvas canvas) {
        View child;
        boolean clipToPadding;
        int clipSaveCount = 0;
        boolean bl = clipToPadding = (this.mGroupFlags & 0x22) == 34;
        if (clipToPadding) {
            clipSaveCount = canvas.save();
            canvas.clipRect(this.mScrollX + this.mPaddingLeft, this.mScrollY + this.mPaddingTop, this.mScrollX + this.mRight - this.mLeft - this.mPaddingRight, this.mScrollY + this.mBottom - this.mTop - this.mPaddingBottom);
        }
        int childrenCount = this.mChildrenCount;
        View[] children = this.mChildren;
        int transientCount = this.mTransientIndices == null ? 0 : this.mTransientIndices.size();
        int transientIndex = transientCount != 0 ? 0 : -1;
        ArrayList<View> preorderedList = this.buildOrderedChildList();
        boolean customOrder = preorderedList == null && this.isChildrenDrawingOrderEnabled();
        for (int i = 0; i < childrenCount; ++i) {
            while (transientIndex >= 0 && this.mTransientIndices.getInt(transientIndex) == i) {
                View transientChild = this.mTransientViews.get(transientIndex);
                if ((transientChild.mViewFlags & 0xC) == 0) {
                    this.drawChild(canvas, transientChild, 0L);
                }
                if (++transientIndex < transientCount) continue;
                transientIndex = -1;
            }
            int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
            child = ViewGroup.getAndVerifyPreorderedView(preorderedList, children, childIndex);
            if ((child.mViewFlags & 0xC) != 0) continue;
            this.drawChild(canvas, child, 0L);
        }
        while (transientIndex >= 0) {
            View transientChild = this.mTransientViews.get(transientIndex);
            if ((transientChild.mViewFlags & 0xC) == 0) {
                this.drawChild(canvas, transientChild, 0L);
            }
            if (++transientIndex < transientCount) continue;
            break;
        }
        if (preorderedList != null) {
            preorderedList.clear();
        }
        if (this.mDisappearingChildren != null) {
            ArrayList<View> disappearingChildren = this.mDisappearingChildren;
            for (int i = disappearingChildren.size() - 1; i >= 0; --i) {
                child = disappearingChildren.get(i);
                this.drawChild(canvas, child, 0L);
            }
        }
        if (this.isShowingLayoutBounds()) {
            this.onDebugDraw(canvas);
        }
        if (clipToPadding) {
            canvas.restoreToCount(clipSaveCount);
        }
    }

    protected void drawChild(@NonNull Canvas canvas, @NonNull View child, long drawingTime) {
        child.draw(canvas, this, (this.mGroupFlags & 1) != 0);
    }

    @Override
    public final void layout(int l, int t, int r, int b) {
        if (!(this.mSuppressLayout || this.mTransition != null && this.mTransition.isChangingLayout())) {
            if (this.mTransition != null) {
                this.mTransition.layoutChange(this);
            }
            super.layout(l, t, r, b);
        } else {
            this.mLayoutCalledWhileSuppressed = true;
        }
    }

    @Override
    protected abstract void onLayout(boolean var1, int var2, int var3, int var4, int var5);

    private int getAndVerifyPreorderedIndex(int childrenCount, int i, boolean customOrder) {
        int childIndex;
        if (customOrder) {
            int childIndex1 = this.getChildDrawingOrder(childrenCount, i);
            if (childIndex1 >= childrenCount) {
                throw new IndexOutOfBoundsException("getChildDrawingOrder() returned invalid index " + childIndex1 + " (child count is " + childrenCount + ")");
            }
            childIndex = childIndex1;
        } else {
            childIndex = i;
        }
        return childIndex;
    }

    @Override
    protected boolean dispatchHoverEvent(@NonNull MotionEvent event) {
        boolean newHoveredSelf;
        int action = event.getAction();
        boolean intercepted = this.onInterceptHoverEvent(event);
        event.setAction(action);
        boolean handled = false;
        HoverTarget firstOldHoverTarget = this.mFirstHoverTarget;
        this.mFirstHoverTarget = null;
        if (!intercepted && action != 10 && this.mChildrenCount != 0) {
            float x = event.getX();
            float y = event.getY();
            View[] children = this.mChildren;
            int childrenCount = this.mChildrenCount;
            ArrayList<View> preorderedList = this.buildOrderedChildList();
            boolean customOrder = preorderedList == null && this.isChildrenDrawingOrderEnabled();
            HoverTarget lastHoverTarget = null;
            for (int i = childrenCount - 1; i >= 0; --i) {
                boolean wasHovered;
                int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
                View child = ViewGroup.getAndVerifyPreorderedView(preorderedList, children, childIndex);
                if (!child.canReceivePointerEvents() || !this.isTransformedTouchPointInView(x, y, child, null)) continue;
                HoverTarget hoverTarget = firstOldHoverTarget;
                HoverTarget predecessor = null;
                while (true) {
                    if (hoverTarget == null) {
                        hoverTarget = HoverTarget.obtain(child);
                        wasHovered = false;
                        break;
                    }
                    if (hoverTarget.child == child) {
                        if (predecessor != null) {
                            predecessor.next = hoverTarget.next;
                        } else {
                            firstOldHoverTarget = hoverTarget.next;
                        }
                        hoverTarget.next = null;
                        wasHovered = true;
                        break;
                    }
                    predecessor = hoverTarget;
                    hoverTarget = hoverTarget.next;
                }
                if (lastHoverTarget != null) {
                    lastHoverTarget.next = hoverTarget;
                } else {
                    this.mFirstHoverTarget = hoverTarget;
                }
                lastHoverTarget = hoverTarget;
                if (action == 9) {
                    if (!wasHovered) {
                        handled = this.dispatchTransformedGenericPointerEvent(event, child);
                    }
                } else if (action == 7) {
                    if (!wasHovered) {
                        event.setAction(9);
                        handled = this.dispatchTransformedGenericPointerEvent(event, child);
                        event.setAction(action);
                    }
                    handled |= this.dispatchTransformedGenericPointerEvent(event, child);
                }
                if (handled) break;
            }
            if (preorderedList != null) {
                preorderedList.clear();
            }
        }
        while (firstOldHoverTarget != null) {
            View child = firstOldHoverTarget.child;
            if (action == 10) {
                handled |= this.dispatchTransformedGenericPointerEvent(event, child);
            } else {
                if (action == 7) {
                    boolean hoverExitPending = event.isHoverExitPending();
                    event.setHoverExitPending(true);
                    this.dispatchTransformedGenericPointerEvent(event, child);
                    event.setHoverExitPending(hoverExitPending);
                }
                event.setAction(10);
                this.dispatchTransformedGenericPointerEvent(event, child);
                event.setAction(action);
            }
            HoverTarget nextOldHoverTarget = firstOldHoverTarget.next;
            firstOldHoverTarget.recycle();
            firstOldHoverTarget = nextOldHoverTarget;
        }
        boolean bl = newHoveredSelf = !handled && action != 10 && !event.isHoverExitPending();
        if (newHoveredSelf == this.mHoveredSelf) {
            if (newHoveredSelf) {
                handled = super.dispatchHoverEvent(event);
            }
        } else {
            if (this.mHoveredSelf) {
                if (action == 10) {
                    handled |= super.dispatchHoverEvent(event);
                } else {
                    if (action == 7) {
                        super.dispatchHoverEvent(event);
                    }
                    event.setAction(10);
                    super.dispatchHoverEvent(event);
                    event.setAction(action);
                }
                this.mHoveredSelf = false;
            }
            if (newHoveredSelf) {
                if (action == 9) {
                    handled = super.dispatchHoverEvent(event);
                    this.mHoveredSelf = true;
                } else if (action == 7) {
                    event.setAction(9);
                    handled = super.dispatchHoverEvent(event);
                    event.setAction(action);
                    handled |= super.dispatchHoverEvent(event);
                    this.mHoveredSelf = true;
                }
            }
        }
        return handled;
    }

    private void exitHoverTargets() {
        if (this.mHoveredSelf || this.mFirstHoverTarget != null) {
            long now = Core.timeNanos();
            MotionEvent event = MotionEvent.obtain(now, 10, 0.0f, 0.0f, 0);
            this.dispatchHoverEvent(event);
            event.recycle();
        }
    }

    private void cancelHoverTarget(View view) {
        HoverTarget predecessor = null;
        HoverTarget target = this.mFirstHoverTarget;
        while (target != null) {
            HoverTarget next = target.next;
            if (target.child == view) {
                if (predecessor == null) {
                    this.mFirstHoverTarget = next;
                } else {
                    predecessor.next = next;
                }
                target.recycle();
                long now = Core.timeNanos();
                MotionEvent event = MotionEvent.obtain(now, 10, 0.0f, 0.0f, 0);
                view.dispatchHoverEvent(event);
                event.recycle();
                return;
            }
            predecessor = target;
            target = next;
        }
    }

    @Override
    boolean dispatchTooltipHoverEvent(@NonNull MotionEvent event) {
        int action = event.getAction();
        switch (action) {
            case 9: {
                break;
            }
            case 7: {
                View newTarget = null;
                int childrenCount = this.mChildrenCount;
                if (childrenCount != 0) {
                    float x = event.getX();
                    float y = event.getY();
                    ArrayList<View> preorderedList = this.buildOrderedChildList();
                    boolean customOrder = preorderedList == null && this.isChildrenDrawingOrderEnabled();
                    View[] children = this.mChildren;
                    for (int i = childrenCount - 1; i >= 0; --i) {
                        int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
                        View child = ViewGroup.getAndVerifyPreorderedView(preorderedList, children, childIndex);
                        if (!child.canReceivePointerEvents() || !this.isTransformedTouchPointInView(x, y, child, null) || !this.dispatchTransformedTooltipHoverEvent(event, child)) continue;
                        newTarget = child;
                        break;
                    }
                    if (preorderedList != null) {
                        preorderedList.clear();
                    }
                }
                if (this.mTooltipHoverTarget != newTarget) {
                    if (this.mTooltipHoverTarget != null) {
                        event.setAction(10);
                        this.mTooltipHoverTarget.dispatchTooltipHoverEvent(event);
                        event.setAction(action);
                    }
                    this.mTooltipHoverTarget = newTarget;
                }
                if (this.mTooltipHoverTarget != null) {
                    if (this.mTooltipHoveredSelf) {
                        this.mTooltipHoveredSelf = false;
                        event.setAction(10);
                        super.dispatchTooltipHoverEvent(event);
                        event.setAction(action);
                    }
                    return true;
                }
                this.mTooltipHoveredSelf = super.dispatchTooltipHoverEvent(event);
                return this.mTooltipHoveredSelf;
            }
            case 10: {
                if (this.mTooltipHoverTarget != null) {
                    this.mTooltipHoverTarget.dispatchTooltipHoverEvent(event);
                    this.mTooltipHoverTarget = null;
                    break;
                }
                if (!this.mTooltipHoveredSelf) break;
                super.dispatchTooltipHoverEvent(event);
                this.mTooltipHoveredSelf = false;
            }
        }
        return false;
    }

    boolean dispatchTransformedTooltipHoverEvent(MotionEvent event, View child) {
        boolean result;
        if (!child.hasIdentityMatrix()) {
            MotionEvent transformedEvent = this.getTransformedMotionEvent(event, child);
            result = child.dispatchTooltipHoverEvent(transformedEvent);
            transformedEvent.recycle();
        } else {
            float offsetX = this.mScrollX - child.mLeft;
            float offsetY = this.mScrollY - child.mTop;
            event.offsetLocation(offsetX, offsetY);
            result = child.dispatchTooltipHoverEvent(event);
            event.offsetLocation(-offsetX, -offsetY);
        }
        return result;
    }

    private void exitTooltipHoverTargets() {
        if (this.mTooltipHoveredSelf || this.mTooltipHoverTarget != null) {
            long now = Core.timeNanos();
            MotionEvent event = MotionEvent.obtain(now, 10, 0.0f, 0.0f, 0);
            this.dispatchTooltipHoverEvent(event);
            event.recycle();
        }
    }

    boolean dispatchTransformedGenericPointerEvent(@NonNull MotionEvent event, @NonNull View child) {
        boolean handled;
        if (!child.hasIdentityMatrix()) {
            MotionEvent transformedEvent = this.getTransformedMotionEvent(event, child);
            handled = child.dispatchGenericMotionEvent(transformedEvent);
            transformedEvent.recycle();
        } else {
            float offsetX = this.mScrollX - child.mLeft;
            float offsetY = this.mScrollY - child.mTop;
            event.offsetLocation(offsetX, offsetY);
            handled = child.dispatchGenericMotionEvent(event);
            event.offsetLocation(-offsetX, -offsetY);
        }
        return handled;
    }

    @NonNull
    private MotionEvent getTransformedMotionEvent(@NonNull MotionEvent event, @NonNull View child) {
        float offsetX = this.mScrollX - child.mLeft;
        float offsetY = this.mScrollY - child.mTop;
        MotionEvent transformedEvent = event.copy();
        transformedEvent.offsetLocation(offsetX, offsetY);
        if (!child.hasIdentityMatrix()) {
            transformedEvent.transform(child.getInverseMatrix());
        }
        return transformedEvent;
    }

    public boolean onInterceptHoverEvent(@NonNull MotionEvent event) {
        int action = event.getAction();
        float x = event.getX();
        float y = event.getY();
        return (action == 7 || action == 9) && this.isOnScrollbar(x, y);
    }

    @Override
    protected boolean dispatchGenericPointerEvent(@NonNull MotionEvent event) {
        int childrenCount = this.mChildrenCount;
        if (childrenCount != 0) {
            float x = event.getX();
            float y = event.getY();
            ArrayList<View> preorderedList = this.buildOrderedChildList();
            boolean customOrder = preorderedList == null && this.isChildrenDrawingOrderEnabled();
            View[] children = this.mChildren;
            for (int i = childrenCount - 1; i >= 0; --i) {
                int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
                View child = ViewGroup.getAndVerifyPreorderedView(preorderedList, children, childIndex);
                if (!child.canReceivePointerEvents() || !this.isTransformedTouchPointInView(x, y, child, null) || !this.dispatchTransformedGenericPointerEvent(event, child)) continue;
                if (preorderedList != null) {
                    preorderedList.clear();
                }
                return true;
            }
            if (preorderedList != null) {
                preorderedList.clear();
            }
        }
        return super.dispatchGenericPointerEvent(event);
    }

    private static View getAndVerifyPreorderedView(@Nullable ArrayList<View> preorderedList, View[] children, int childIndex) {
        View child;
        if (preorderedList != null) {
            child = preorderedList.get(childIndex);
            if (child == null) {
                throw new RuntimeException("Invalid preorderedList contained null child at index " + childIndex);
            }
        } else {
            child = children[childIndex];
        }
        return child;
    }

    private static boolean resetCancelNextUpFlag(@NonNull View view) {
        if ((view.mPrivateFlags & 0x4000000) != 0) {
            view.mPrivateFlags &= 0xFBFFFFFF;
            return true;
        }
        return false;
    }

    private void clearTouchTargets() {
        TouchTarget target = this.mTouchTarget;
        if (target != null) {
            target.recycle();
            this.mTouchTarget = null;
        }
    }

    private void resetTouchState() {
        this.clearTouchTargets();
        ViewGroup.resetCancelNextUpFlag(this);
        this.mGroupFlags &= 0xFFF7FFFF;
    }

    private void cancelAndClearTouchTargets(@Nullable MotionEvent event) {
        TouchTarget target = this.mTouchTarget;
        if (target != null) {
            boolean syntheticEvent = false;
            if (event == null) {
                long time = Core.timeNanos();
                event = MotionEvent.obtain(time, 3, 0.0f, 0.0f, 0);
                syntheticEvent = true;
            }
            ViewGroup.resetCancelNextUpFlag(target.child);
            this.dispatchTransformedTouchEvent(event, target.child, true);
            this.clearTouchTargets();
            if (syntheticEvent) {
                event.recycle();
            }
        }
    }

    private void cancelTouchTarget(View view) {
        TouchTarget target = this.mTouchTarget;
        if (target != null && target.child == view) {
            this.mTouchTarget = null;
            target.recycle();
            long now = Core.timeNanos();
            MotionEvent event = MotionEvent.obtain(now, 3, 0.0f, 0.0f, 0);
            view.dispatchTouchEvent(event);
            event.recycle();
        }
    }

    @Override
    public boolean dispatchTouchEvent(@NonNull MotionEvent ev) {
        boolean intercepted;
        boolean handled = false;
        int action = ev.getAction();
        if (action == 0) {
            this.cancelAndClearTouchTargets(ev);
            this.resetTouchState();
        }
        if (action == 0 || this.mTouchTarget != null) {
            boolean allowIntercept;
            boolean bl = allowIntercept = (this.mGroupFlags & 0x80000) == 0;
            if (allowIntercept) {
                intercepted = this.onInterceptTouchEvent(ev);
                ev.setAction(action);
            } else {
                intercepted = false;
            }
        } else {
            intercepted = true;
        }
        boolean canceled = ViewGroup.resetCancelNextUpFlag(this) || action == 3;
        Object newTouchTarget = null;
        boolean dispatchedToNewTarget = false;
        if (!canceled && !intercepted && action == 0 && this.mChildrenCount > 0) {
            int childrenCount = this.mChildrenCount;
            float x = ev.getX();
            float y = ev.getY();
            ArrayList<View> preorderedList = this.buildOrderedChildList();
            boolean customOrder = preorderedList == null && this.isChildrenDrawingOrderEnabled();
            View[] children = this.mChildren;
            for (int i = childrenCount - 1; i >= 0; --i) {
                int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
                View child = ViewGroup.getAndVerifyPreorderedView(preorderedList, children, childIndex);
                if (!child.canReceivePointerEvents() || !this.isTransformedTouchPointInView(x, y, child, null)) continue;
                ViewGroup.resetCancelNextUpFlag(child);
                if (!this.dispatchTransformedTouchEvent(ev, child, false)) continue;
                this.mTouchTarget = TouchTarget.obtain(child);
                dispatchedToNewTarget = true;
                break;
            }
            if (preorderedList != null) {
                preorderedList.clear();
            }
        }
        if (this.mTouchTarget == null) {
            handled = this.dispatchTransformedTouchEvent(ev, null, canceled);
        } else if (dispatchedToNewTarget) {
            handled = true;
        } else {
            boolean cancelChild;
            TouchTarget target = this.mTouchTarget;
            boolean bl = cancelChild = ViewGroup.resetCancelNextUpFlag(target.child) || intercepted;
            if (this.dispatchTransformedTouchEvent(ev, target.child, cancelChild)) {
                handled = true;
            }
            if (cancelChild) {
                this.mTouchTarget = null;
                target.recycle();
            }
        }
        if (canceled || action == 1) {
            this.resetTouchState();
        }
        return handled;
    }

    public boolean isTransitionGroup() {
        if ((this.mGroupFlags & 0x2000000) != 0) {
            return (this.mGroupFlags & 0x1000000) != 0;
        }
        return this.getBackground() != null || this.getTransitionName() != null;
    }

    public void setTransitionGroup(boolean isTransitionGroup) {
        this.mGroupFlags |= 0x2000000;
        this.mGroupFlags = isTransitionGroup ? (this.mGroupFlags |= 0x1000000) : (this.mGroupFlags &= 0xFEFFFFFF);
    }

    @Override
    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (disallowIntercept == ((this.mGroupFlags & 0x80000) != 0)) {
            return;
        }
        this.mGroupFlags = disallowIntercept ? (this.mGroupFlags |= 0x80000) : (this.mGroupFlags &= 0xFFF7FFFF);
        if (this.mParent != null) {
            this.mParent.requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    public boolean onInterceptTouchEvent(@NonNull MotionEvent ev) {
        return ev.getAction() == 0 && ev.isButtonPressed(1) && this.isOnScrollbarThumb(ev.getX(), ev.getY());
    }

    @Override
    public boolean requestFocus(int direction, @Nullable Rect previouslyFocusedRect) {
        int descendantFocusability = this.getDescendantFocusability();
        boolean result = switch (descendantFocusability) {
            case 393216 -> super.requestFocus(direction, previouslyFocusedRect);
            case 131072 -> {
                boolean took = super.requestFocus(direction, previouslyFocusedRect);
                yield took || this.onRequestFocusInDescendants(direction, previouslyFocusedRect);
            }
            case 262144 -> {
                boolean took = this.onRequestFocusInDescendants(direction, previouslyFocusedRect);
                yield took || super.requestFocus(direction, previouslyFocusedRect);
            }
            default -> throw new IllegalStateException("descendant focusability must be one of FOCUS_BEFORE_DESCENDANTS, FOCUS_AFTER_DESCENDANTS, FOCUS_BLOCK_DESCENDANTS but is " + descendantFocusability);
        };
        if (result && !this.isLayoutValid() && (this.mPrivateFlags & 1) == 0) {
            this.mPrivateFlags |= 1;
        }
        return result;
    }

    protected boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        int end;
        int increment;
        int count = this.mChildrenCount;
        if ((direction & 2) != 0) {
            index = 0;
            increment = 1;
            end = count;
        } else {
            index = count - 1;
            increment = -1;
            end = -1;
        }
        View[] children = this.mChildren;
        for (int i = index; i != end; i += increment) {
            View child = children[i];
            if ((child.mViewFlags & 0xC) != 0 || !child.requestFocus(direction, previouslyFocusedRect)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean restoreDefaultFocus() {
        if (this.mDefaultFocus != null && this.getDescendantFocusability() != 393216 && (this.mDefaultFocus.mViewFlags & 0xC) == 0 && this.mDefaultFocus.restoreDefaultFocus()) {
            return true;
        }
        return super.restoreDefaultFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean restoreFocusInCluster(int direction) {
        if (this.isKeyboardNavigationCluster()) {
            boolean blockedFocus = this.getTouchscreenBlocksFocus();
            try {
                this.setTouchscreenBlocksFocusNoRefocus(false);
                boolean bl = this.restoreFocusInClusterInternal(direction);
                return bl;
            }
            finally {
                this.setTouchscreenBlocksFocusNoRefocus(blockedFocus);
            }
        }
        return this.restoreFocusInClusterInternal(direction);
    }

    private boolean restoreFocusInClusterInternal(int direction) {
        if (this.mFocusedInCluster != null && this.getDescendantFocusability() != 393216 && (this.mFocusedInCluster.mViewFlags & 0xC) == 0 && this.mFocusedInCluster.restoreFocusInCluster(direction)) {
            return true;
        }
        return super.restoreFocusInCluster(direction);
    }

    @Override
    boolean restoreFocusNotInCluster() {
        if (this.mFocusedInCluster != null) {
            return this.restoreFocusInCluster(130);
        }
        if (this.isKeyboardNavigationCluster() || (this.mViewFlags & 0xC) != 0) {
            return false;
        }
        int descendentFocusability = this.getDescendantFocusability();
        if (descendentFocusability == 393216) {
            return super.requestFocus(130, null);
        }
        if (descendentFocusability == 131072 && super.requestFocus(130, null)) {
            return true;
        }
        for (int i = 0; i < this.mChildrenCount; ++i) {
            View child = this.mChildren[i];
            if (child.isKeyboardNavigationCluster() || !child.restoreFocusNotInCluster()) continue;
            return true;
        }
        if (descendentFocusability == 262144 && !this.hasFocusableChild(false)) {
            return super.requestFocus(130, null);
        }
        return false;
    }

    @Override
    @ApiStatus.Internal
    public void dispatchStartTemporaryDetach() {
        super.dispatchStartTemporaryDetach();
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchStartTemporaryDetach();
        }
    }

    @Override
    @ApiStatus.Internal
    public void dispatchFinishTemporaryDetach() {
        super.dispatchFinishTemporaryDetach();
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchFinishTemporaryDetach();
        }
    }

    @Override
    final void dispatchAttachedToWindow(AttachInfo info, int visibility) {
        this.mGroupFlags |= 0x400000;
        super.dispatchAttachedToWindow(info, visibility);
        this.mGroupFlags &= 0xFFBFFFFF;
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            child.dispatchAttachedToWindow(info, this.combineVisibility(visibility, child.getVisibility()));
        }
        int transientCount = this.mTransientIndices == null ? 0 : this.mTransientIndices.size();
        for (int i = 0; i < transientCount; ++i) {
            View view = this.mTransientViews.get(i);
            view.dispatchAttachedToWindow(info, this.combineVisibility(visibility, view.getVisibility()));
        }
    }

    @Override
    final void dispatchDetachedFromWindow() {
        this.cancelAndClearTouchTargets(null);
        this.exitHoverTargets();
        this.mLayoutCalledWhileSuppressed = false;
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchDetachedFromWindow();
        }
        this.clearDisappearingChildren();
        int transientCount = this.mTransientViews == null ? 0 : this.mTransientIndices.size();
        for (int i = 0; i < transientCount; ++i) {
            View view = this.mTransientViews.get(i);
            view.dispatchDetachedFromWindow();
        }
        super.dispatchDetachedFromWindow();
    }

    private float[] getTempLocationF() {
        if (this.mTempPosition == null) {
            this.mTempPosition = new float[2];
        }
        return this.mTempPosition;
    }

    boolean dispatchTransformedTouchEvent(@NonNull MotionEvent event, @Nullable View child, boolean cancel) {
        boolean handled;
        int oldAction = event.getAction();
        if (cancel || oldAction == 3) {
            event.setAction(3);
            boolean handled2 = child == null ? super.dispatchTouchEvent(event) : child.dispatchTouchEvent(event);
            event.setAction(oldAction);
            return handled2;
        }
        if (child == null || child.hasIdentityMatrix()) {
            if (child == null) {
                handled = super.dispatchTouchEvent(event);
            } else {
                float offsetX = this.mScrollX - child.mLeft;
                float offsetY = this.mScrollY - child.mTop;
                event.offsetLocation(offsetX, offsetY);
                handled = child.dispatchTouchEvent(event);
                event.offsetLocation(-offsetX, -offsetY);
            }
        } else {
            MotionEvent transformedEvent = event.copy();
            float offsetX = this.mScrollX - child.mLeft;
            float offsetY = this.mScrollY - child.mTop;
            transformedEvent.offsetLocation(offsetX, offsetY);
            if (!child.hasIdentityMatrix()) {
                transformedEvent.transform(child.getInverseMatrix());
            }
            handled = child.dispatchTouchEvent(transformedEvent);
            transformedEvent.recycle();
        }
        return handled;
    }

    boolean isTransformedTouchPointInView(float x, float y, @NonNull View child, @Nullable PointF outLocalPoint) {
        float[] point = this.getTempLocationF();
        point[0] = x;
        point[1] = y;
        this.transformPointToViewLocal(point, child);
        boolean isInView = child.pointInView(point[0], point[1]);
        if (isInView && outLocalPoint != null) {
            outLocalPoint.set(point[0], point[1]);
        }
        return isInView;
    }

    @ApiStatus.Internal
    protected void transformPointToViewLocal(@NonNull float[] point, @NonNull View child) {
        point[0] = point[0] + (float)(this.mScrollX - child.mLeft);
        point[1] = point[1] + (float)(this.mScrollY - child.mTop);
        if (!child.hasIdentityMatrix()) {
            child.getInverseMatrix().mapPoint(point);
        }
    }

    @Override
    public boolean dispatchKeyEvent(@NonNull KeyEvent event) {
        if ((this.mPrivateFlags & 0x12) == 18) {
            return super.dispatchKeyEvent(event);
        }
        if (this.mFocused != null && (this.mFocused.mPrivateFlags & 0x10) == 16) {
            return this.mFocused.dispatchKeyEvent(event);
        }
        return false;
    }

    @Override
    public boolean dispatchKeyShortcutEvent(@NonNull KeyEvent event) {
        if ((this.mPrivateFlags & 0x12) == 18) {
            return super.dispatchKeyShortcutEvent(event);
        }
        if (this.mFocused != null && (this.mFocused.mPrivateFlags & 0x10) == 16) {
            return this.mFocused.dispatchKeyShortcutEvent(event);
        }
        return false;
    }

    @Override
    public PointerIcon onResolvePointerIcon(@NonNull MotionEvent event) {
        float y;
        float x = event.getX();
        if (this.isOnScrollbarThumb(x, y = event.getY()) || this.isDraggingScrollBar()) {
            return PointerIcon.getSystemIcon(1000);
        }
        int childrenCount = this.mChildrenCount;
        if (childrenCount != 0) {
            ArrayList<View> preorderedList = this.buildOrderedChildList();
            boolean customOrder = preorderedList == null && this.isChildrenDrawingOrderEnabled();
            View[] children = this.mChildren;
            for (int i = childrenCount - 1; i >= 0; --i) {
                PointerIcon pointerIcon;
                int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
                View child = ViewGroup.getAndVerifyPreorderedView(preorderedList, children, childIndex);
                if (!child.canReceivePointerEvents() || !this.isTransformedTouchPointInView(x, y, child, null) || (pointerIcon = this.dispatchResolvePointerIcon(event, child)) == null) continue;
                if (preorderedList != null) {
                    preorderedList.clear();
                }
                return pointerIcon;
            }
            if (preorderedList != null) {
                preorderedList.clear();
            }
        }
        return super.onResolvePointerIcon(event);
    }

    @Nullable
    PointerIcon dispatchResolvePointerIcon(MotionEvent event, @NonNull View child) {
        PointerIcon pointerIcon;
        if (!child.hasIdentityMatrix()) {
            MotionEvent transformedEvent = this.getTransformedMotionEvent(event, child);
            pointerIcon = child.onResolvePointerIcon(transformedEvent);
            transformedEvent.recycle();
        } else {
            float offsetX = this.mScrollX - child.mLeft;
            float offsetY = this.mScrollY - child.mTop;
            event.offsetLocation(offsetX, offsetY);
            pointerIcon = child.onResolvePointerIcon(event);
            event.offsetLocation(-offsetX, -offsetY);
        }
        return pointerIcon;
    }

    @ApiStatus.Internal
    public void addTransientView(View view, int index) {
        int oldSize;
        if (index < 0 || view == null) {
            return;
        }
        if (view.mParent != null) {
            throw new IllegalStateException("The specified view already has a parent " + view.mParent);
        }
        if (this.mTransientIndices == null) {
            this.mTransientIndices = new IntArrayList();
            this.mTransientViews = new ArrayList<View>();
        }
        if ((oldSize = this.mTransientIndices.size()) > 0) {
            int insertionIndex;
            for (insertionIndex = 0; insertionIndex < oldSize && index >= this.mTransientIndices.getInt(insertionIndex); ++insertionIndex) {
            }
            this.mTransientIndices.add(insertionIndex, index);
            this.mTransientViews.add(insertionIndex, view);
        } else {
            this.mTransientIndices.add(index);
            this.mTransientViews.add(view);
        }
        view.mParent = this;
        if (this.mAttachInfo != null) {
            view.dispatchAttachedToWindow(this.mAttachInfo, this.mViewFlags & 0xC);
        }
        this.invalidate();
    }

    @ApiStatus.Internal
    public void removeTransientView(View view) {
        if (this.mTransientViews == null) {
            return;
        }
        int size = this.mTransientViews.size();
        for (int i = 0; i < size; ++i) {
            if (view != this.mTransientViews.get(i)) continue;
            this.mTransientViews.remove(i);
            this.mTransientIndices.removeInt(i);
            view.mParent = null;
            if (view.mAttachInfo != null) {
                view.dispatchDetachedFromWindow();
            }
            this.invalidate();
            return;
        }
    }

    @ApiStatus.Internal
    public int getTransientViewCount() {
        return this.mTransientIndices == null ? 0 : this.mTransientIndices.size();
    }

    @ApiStatus.Internal
    public int getTransientViewIndex(int position) {
        if (position < 0 || this.mTransientIndices == null || position >= this.mTransientIndices.size()) {
            return -1;
        }
        return this.mTransientIndices.getInt(position);
    }

    @ApiStatus.Internal
    public View getTransientView(int position) {
        if (this.mTransientViews == null || position >= this.mTransientViews.size()) {
            return null;
        }
        return this.mTransientViews.get(position);
    }

    public void addView(@NonNull View child) {
        this.addView(child, -1);
    }

    public void addView(@NonNull View child, int index) {
        LayoutParams params = child.getLayoutParams();
        if (params == null) {
            params = this.generateDefaultLayoutParams();
        }
        this.addView(child, index, params);
    }

    public void addView(@NonNull View child, int width, int height) {
        LayoutParams params = this.generateDefaultLayoutParams();
        params.width = width;
        params.height = height;
        this.addView(child, -1, params);
    }

    @Override
    public void addView(@NonNull View child, @NonNull LayoutParams params) {
        this.addView(child, -1, params);
    }

    public void addView(@NonNull View child, int index, @NonNull LayoutParams params) {
        this.requestLayout();
        this.invalidate();
        this.addViewInner(child, index, params, false);
    }

    @Override
    public void updateViewLayout(@NonNull View view, @NonNull LayoutParams params) {
        if (!this.checkLayoutParams(params)) {
            throw new IllegalArgumentException("Invalid LayoutParams supplied to " + this);
        }
        if (view.mParent != this) {
            throw new IllegalArgumentException("Given view not a child of " + this);
        }
        view.setLayoutParams(params);
    }

    protected boolean addViewInLayout(@NonNull View child, int index, @NonNull LayoutParams params) {
        return this.addViewInLayout(child, index, params, false);
    }

    protected boolean addViewInLayout(@NonNull View child, int index, @NonNull LayoutParams params, boolean preventRequestLayout) {
        child.mParent = null;
        this.addViewInner(child, index, params, preventRequestLayout);
        return true;
    }

    protected void cleanupLayoutState(@NonNull View child) {
        child.mPrivateFlags &= 0xFFFFEFFF;
    }

    private void addViewInner(@NonNull View child, int index, @NonNull LayoutParams params, boolean preventRequestLayout) {
        AttachInfo attachInfo;
        if (this.mTransition != null) {
            this.mTransition.cancel(3);
        }
        if (child.getParent() != null) {
            throw new IllegalStateException("The specified child already has a parent. You must call removeView() on the child's parent first.");
        }
        if (this.mTransition != null) {
            this.mTransition.addChild(this, child);
        }
        if (!this.checkLayoutParams(params)) {
            params = this.generateLayoutParams(params);
        }
        if (preventRequestLayout) {
            child.mLayoutParams = params;
        } else {
            child.setLayoutParams(params);
        }
        if (index < 0) {
            index = this.mChildrenCount;
        }
        this.addInArray(child, index);
        if (preventRequestLayout) {
            child.assignParent(this);
        } else {
            child.mParent = this;
        }
        boolean childHasFocus = child.hasFocus();
        if (childHasFocus) {
            this.requestChildFocus(child, child.findFocus());
        }
        if ((attachInfo = this.mAttachInfo) != null && (this.mGroupFlags & 0x400000) == 0) {
            child.dispatchAttachedToWindow(this.mAttachInfo, this.mViewFlags & 0xC);
        }
        if (child.isLayoutDirectionInherited()) {
            child.resetRtlProperties();
        }
        this.onViewAdded(child);
        if ((child.mViewFlags & 0x400000) == 0x400000) {
            this.mGroupFlags |= 0x10000;
        }
        if (child.hasTransientState()) {
            this.childHasTransientStateChanged(child, true);
        }
        if (this.mTransientIndices != null) {
            int transientCount = this.mTransientIndices.size();
            for (int i = 0; i < transientCount; ++i) {
                int oldIndex = this.mTransientIndices.getInt(i);
                if (index > oldIndex) continue;
                this.mTransientIndices.set(i, oldIndex + 1);
            }
        }
    }

    protected void onViewAdded(View child) {
    }

    protected void onViewRemoved(View child) {
    }

    public int indexOfChild(View child) {
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            if (children[i] != child) continue;
            return i;
        }
        return -1;
    }

    public View getChildAt(int index) {
        if (index < 0 || index >= this.mChildrenCount) {
            return null;
        }
        return this.mChildren[index];
    }

    public int getChildCount() {
        return this.mChildrenCount;
    }

    private void addInArray(View child, int index) {
        View[] children = this.mChildren;
        int count = this.mChildrenCount;
        int size = children.length;
        if (index == count) {
            if (size == count) {
                this.mChildren = new View[size + 12];
                System.arraycopy(children, 0, this.mChildren, 0, size);
                children = this.mChildren;
            }
            children[this.mChildrenCount++] = child;
        } else if (index < count) {
            if (size == count) {
                this.mChildren = new View[size + 12];
                System.arraycopy(children, 0, this.mChildren, 0, index);
                System.arraycopy(children, index, this.mChildren, index + 1, count - index);
                children = this.mChildren;
            } else {
                System.arraycopy(children, index, children, index + 1, count - index);
            }
            children[index] = child;
            ++this.mChildrenCount;
        } else {
            throw new IndexOutOfBoundsException("index=" + index + " count=" + count);
        }
    }

    private void removeFromArray(int index) {
        int count;
        View[] children = this.mChildren;
        if (this.mTransitioningViews == null || !this.mTransitioningViews.contains(children[index])) {
            children[index].mParent = null;
        }
        if (index == (count = this.mChildrenCount--) - 1) {
            children[this.mChildrenCount] = null;
        } else if (index < count) {
            System.arraycopy(children, index + 1, children, index, count - index - 1);
            children[--this.mChildrenCount] = null;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    private void removeFromArray(int start, int count) {
        int end;
        View[] children = this.mChildren;
        int childrenCount = this.mChildrenCount;
        if ((start = Math.max(0, start)) == (end = Math.min(childrenCount, start + count))) {
            return;
        }
        if (end == childrenCount) {
            for (int i = start; i < end; ++i) {
                children[i].mParent = null;
                children[i] = null;
            }
        } else {
            int i;
            for (i = start; i < end; ++i) {
                children[i].mParent = null;
            }
            System.arraycopy(children, end, children, start, childrenCount - end);
            for (i = childrenCount - (end - start); i < childrenCount; ++i) {
                children[i] = null;
            }
        }
        this.mChildrenCount -= end - start;
    }

    @Override
    public void removeView(@NonNull View view) {
        if (this.removeViewInternal(view)) {
            this.requestLayout();
            this.invalidate();
        }
    }

    public void removeViewInLayout(@NonNull View view) {
        this.removeViewInternal(view);
    }

    public void removeViewsInLayout(int start, int count) {
        this.removeViewsInternal(start, count);
    }

    public void removeViewAt(int index) {
        this.removeViewInternal(index, this.getChildAt(index));
        this.requestLayout();
        this.invalidate();
    }

    public void removeViews(int start, int count) {
        this.removeViewsInternal(start, count);
        this.requestLayout();
        this.invalidate();
    }

    private boolean removeViewInternal(View view) {
        int index = this.indexOfChild(view);
        if (index >= 0) {
            this.removeViewInternal(index, view);
            return true;
        }
        return false;
    }

    private void removeViewInternal(int index, View view) {
        if (this.mTransition != null) {
            this.mTransition.removeChild(this, view);
        }
        boolean clearChildFocus = false;
        if (view == this.mFocused) {
            view.unFocus(null);
            clearChildFocus = true;
        }
        if (view == this.mFocusedInCluster) {
            this.clearFocusedInCluster(view);
        }
        this.cancelTouchTarget(view);
        this.cancelHoverTarget(view);
        if (this.mTransitioningViews != null && this.mTransitioningViews.contains(view)) {
            this.addDisappearingView(view);
        } else if (view.mAttachInfo != null) {
            view.dispatchDetachedFromWindow();
        }
        if (view.hasTransientState()) {
            this.childHasTransientStateChanged(view, false);
        }
        this.removeFromArray(index);
        if (view == this.mDefaultFocus) {
            this.clearDefaultFocus(view);
        }
        if (clearChildFocus) {
            this.clearChildFocus(view);
            if (!this.rootViewRequestFocus()) {
                this.notifyGlobalFocusCleared(this);
            }
        }
        this.onViewRemoved(view);
        int transientCount = this.mTransientIndices == null ? 0 : this.mTransientIndices.size();
        for (int i = 0; i < transientCount; ++i) {
            int oldIndex = this.mTransientIndices.getInt(i);
            if (index >= oldIndex) continue;
            this.mTransientIndices.set(i, oldIndex - 1);
        }
    }

    public void setLayoutTransition(LayoutTransition transition) {
        if (this.mTransition != null) {
            LayoutTransition previousTransition = this.mTransition;
            previousTransition.cancel();
            previousTransition.removeTransitionListener(this.mLayoutTransitionListener);
        }
        this.mTransition = transition;
        if (this.mTransition != null) {
            this.mTransition.addTransitionListener(this.mLayoutTransitionListener);
        }
    }

    public LayoutTransition getLayoutTransition() {
        return this.mTransition;
    }

    private void removeViewsInternal(int start, int count) {
        int end = start + count;
        if (start < 0 || count < 0 || end > this.mChildrenCount) {
            throw new IndexOutOfBoundsException();
        }
        View focused = this.mFocused;
        boolean detach = this.mAttachInfo != null;
        boolean clearChildFocus = false;
        View clearDefaultFocus = null;
        View[] children = this.mChildren;
        for (int i = start; i < end; ++i) {
            View view = children[i];
            if (this.mTransition != null) {
                this.mTransition.removeChild(this, view);
            }
            if (view == focused) {
                view.unFocus(null);
                clearChildFocus = true;
            }
            if (view == this.mDefaultFocus) {
                clearDefaultFocus = view;
            }
            if (view == this.mFocusedInCluster) {
                this.clearFocusedInCluster(view);
            }
            this.cancelTouchTarget(view);
            this.cancelHoverTarget(view);
            if (this.mTransitioningViews != null && this.mTransitioningViews.contains(view)) {
                this.addDisappearingView(view);
            } else if (detach) {
                view.dispatchDetachedFromWindow();
            }
            if (view.hasTransientState()) {
                this.childHasTransientStateChanged(view, false);
            }
            this.onViewRemoved(view);
        }
        this.removeFromArray(start, count);
        if (clearDefaultFocus != null) {
            this.clearDefaultFocus(clearDefaultFocus);
        }
        if (clearChildFocus) {
            this.clearChildFocus(focused);
            if (!this.rootViewRequestFocus()) {
                this.notifyGlobalFocusCleared(focused);
            }
        }
    }

    public void removeAllViews() {
        this.removeAllViewsInLayout();
        this.requestLayout();
        this.invalidate();
    }

    public void removeAllViewsInLayout() {
        int count = this.mChildrenCount;
        if (count <= 0) {
            return;
        }
        View[] children = this.mChildren;
        this.mChildrenCount = 0;
        View focused = this.mFocused;
        boolean detach = this.mAttachInfo != null;
        boolean clearChildFocus = false;
        for (int i = count - 1; i >= 0; --i) {
            View view = children[i];
            if (this.mTransition != null) {
                this.mTransition.removeChild(this, view);
            }
            if (view == focused) {
                view.unFocus(null);
                clearChildFocus = true;
            }
            this.cancelTouchTarget(view);
            this.cancelHoverTarget(view);
            if (this.mTransitioningViews != null && this.mTransitioningViews.contains(view)) {
                this.addDisappearingView(view);
            } else if (detach) {
                view.dispatchDetachedFromWindow();
            }
            if (view.hasTransientState()) {
                this.childHasTransientStateChanged(view, false);
            }
            this.onViewRemoved(view);
            view.mParent = null;
            children[i] = null;
        }
        if (this.mDefaultFocus != null) {
            this.clearDefaultFocus(this.mDefaultFocus);
        }
        if (this.mFocusedInCluster != null) {
            this.clearFocusedInCluster(this.mFocusedInCluster);
        }
        if (clearChildFocus) {
            this.clearChildFocus(focused);
            if (!this.rootViewRequestFocus()) {
                this.notifyGlobalFocusCleared(focused);
            }
        }
    }

    protected void removeDetachedView(@NonNull View child, boolean animate) {
        if (this.mTransition != null) {
            this.mTransition.removeChild(this, child);
        }
        if (child == this.mFocused) {
            child.clearFocus();
        }
        if (child == this.mDefaultFocus) {
            this.clearDefaultFocus(child);
        }
        if (child == this.mFocusedInCluster) {
            this.clearFocusedInCluster(child);
        }
        this.cancelTouchTarget(child);
        this.cancelHoverTarget(child);
        if (this.mTransitioningViews != null && this.mTransitioningViews.contains(child)) {
            this.addDisappearingView(child);
        } else if (child.mAttachInfo != null) {
            child.dispatchDetachedFromWindow();
        }
        if (child.hasTransientState()) {
            this.childHasTransientStateChanged(child, false);
        }
        this.onViewRemoved(child);
    }

    protected void attachViewToParent(View child, int index, LayoutParams params) {
        child.mLayoutParams = params;
        if (index < 0) {
            index = this.mChildrenCount;
        }
        this.addInArray(child, index);
        child.mParent = this;
        child.mPrivateFlags = child.mPrivateFlags & 0xFFDFFFFF & 0xFFFF7FFF | 0x20 | Integer.MIN_VALUE;
        this.mPrivateFlags |= Integer.MIN_VALUE;
        if (child.hasFocus()) {
            this.requestChildFocus(child, child.findFocus());
        }
        this.dispatchVisibilityAggregated(this.isAttachedToWindow() && this.getWindowVisibility() == 0 && this.isShown());
    }

    protected void detachViewFromParent(View child) {
        this.removeFromArray(this.indexOfChild(child));
    }

    protected void detachViewFromParent(int index) {
        this.removeFromArray(index);
    }

    protected void detachViewsFromParent(int start, int count) {
        this.removeFromArray(Math.max(0, start), Math.min(this.mChildrenCount, count));
    }

    protected void detachAllViewsFromParent() {
        int count = this.mChildrenCount;
        if (count <= 0) {
            return;
        }
        View[] children = this.mChildren;
        this.mChildrenCount = 0;
        for (int i = count - 1; i >= 0; --i) {
            children[i].mParent = null;
            children[i] = null;
        }
    }

    public int getDescendantFocusability() {
        return this.mGroupFlags & 0x60000;
    }

    public void setDescendantFocusability(int focusability) {
        switch (focusability) {
            case 131072: 
            case 262144: 
            case 393216: {
                break;
            }
            default: {
                throw new IllegalArgumentException("must be one of FOCUS_BEFORE_DESCENDANTS, FOCUS_AFTER_DESCENDANTS, FOCUS_BLOCK_DESCENDANTS");
            }
        }
        this.mGroupFlags &= 0xFFF9FFFF;
        this.mGroupFlags |= focusability & 0x60000;
    }

    @Override
    void handleFocusGainInternal(int direction, @Nullable Rect previouslyFocusedRect) {
        if (this.mFocused != null) {
            this.mFocused.unFocus(this);
            this.mFocused = null;
            this.mFocusedInCluster = null;
        }
        super.handleFocusGainInternal(direction, previouslyFocusedRect);
    }

    @Override
    public void requestChildFocus(View child, View focused) {
        if (this.getDescendantFocusability() == 393216) {
            return;
        }
        super.unFocus(focused);
        if (this.mFocused != child) {
            if (this.mFocused != null) {
                this.mFocused.unFocus(focused);
            }
            this.mFocused = child;
        }
        if (this.mParent != null) {
            this.mParent.requestChildFocus(this, focused);
        }
    }

    void setDefaultFocus(View child) {
        if (this.mDefaultFocus != null && this.mDefaultFocus.isFocusedByDefault()) {
            return;
        }
        this.mDefaultFocus = child;
        if (this.mParent instanceof ViewGroup) {
            ((ViewGroup)this.mParent).setDefaultFocus(this);
        }
    }

    void clearDefaultFocus(View child) {
        if (this.mDefaultFocus != child && this.mDefaultFocus != null && this.mDefaultFocus.isFocusedByDefault()) {
            return;
        }
        this.mDefaultFocus = null;
        for (int i = 0; i < this.mChildrenCount; ++i) {
            View sibling = this.mChildren[i];
            if (sibling.isFocusedByDefault()) {
                this.mDefaultFocus = sibling;
                return;
            }
            if (this.mDefaultFocus != null || !sibling.hasDefaultFocus()) continue;
            this.mDefaultFocus = sibling;
        }
        if (this.mParent instanceof ViewGroup) {
            ((ViewGroup)this.mParent).clearDefaultFocus(this);
        }
    }

    @Override
    boolean hasDefaultFocus() {
        return this.mDefaultFocus != null || super.hasDefaultFocus();
    }

    void clearFocusedInCluster(View child) {
        if (this.mFocusedInCluster != child) {
            return;
        }
        this.clearFocusedInCluster();
    }

    void clearFocusedInCluster() {
        View top = this.findKeyboardNavigationCluster();
        ViewParent parent = this;
        do {
            parent.mFocusedInCluster = null;
        } while (parent != top && (parent = parent.getParent()) instanceof ViewGroup);
    }

    @Override
    public void dispatchWindowFocusChanged(boolean hasFocus) {
        super.dispatchWindowFocusChanged(hasFocus);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchWindowFocusChanged(hasFocus);
        }
    }

    @Override
    public void addFocusables(@NonNull ArrayList<View> views, int direction, int focusableMode) {
        int i;
        int focusableCount = views.size();
        int descendantFocusability = this.getDescendantFocusability();
        if (descendantFocusability == 393216) {
            super.addFocusables(views, direction, focusableMode);
            return;
        }
        if (descendantFocusability == 131072) {
            super.addFocusables(views, direction, focusableMode);
        }
        int count = 0;
        View[] children = new View[this.mChildrenCount];
        for (i = 0; i < this.mChildrenCount; ++i) {
            View child = this.mChildren[i];
            if ((child.mViewFlags & 0xC) != 0) continue;
            children[count++] = child;
        }
        FocusFinder.sort(children, 0, count, this, this.isLayoutRtl());
        for (i = 0; i < count; ++i) {
            children[i].addFocusables(views, direction, focusableMode);
        }
        if (descendantFocusability == 262144 && focusableCount == views.size()) {
            super.addFocusables(views, direction, focusableMode);
        }
    }

    @Override
    public void addTouchables(@NonNull ArrayList<View> views) {
        super.addTouchables(views);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            if ((child.mViewFlags & 0xC) != 0) continue;
            child.addTouchables(views);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addKeyboardNavigationClusters(@NonNull Collection<View> views, int direction) {
        int i;
        int focusableCount = views.size();
        if (this.isKeyboardNavigationCluster()) {
            boolean blockedFocus = this.getTouchscreenBlocksFocus();
            try {
                this.setTouchscreenBlocksFocusNoRefocus(false);
                super.addKeyboardNavigationClusters(views, direction);
            }
            finally {
                this.setTouchscreenBlocksFocusNoRefocus(blockedFocus);
            }
        } else {
            super.addKeyboardNavigationClusters(views, direction);
        }
        if (focusableCount != views.size()) {
            return;
        }
        if (this.getDescendantFocusability() == 393216) {
            return;
        }
        int count = 0;
        View[] visibleChildren = new View[this.mChildrenCount];
        for (i = 0; i < this.mChildrenCount; ++i) {
            View child = this.mChildren[i];
            if ((child.mViewFlags & 0xC) != 0) continue;
            visibleChildren[count++] = child;
        }
        FocusFinder.sort(visibleChildren, 0, count, this, this.isLayoutRtl());
        for (i = 0; i < count; ++i) {
            visibleChildren[i].addKeyboardNavigationClusters(views, direction);
        }
    }

    public void setTouchscreenBlocksFocus(boolean touchscreenBlocksFocus) {
        if (touchscreenBlocksFocus) {
            View newFocus;
            View focusedChild;
            this.mGroupFlags |= 0x4000000;
            if (this.hasFocus() && !this.isKeyboardNavigationCluster() && !(focusedChild = this.getDeepestFocusedChild()).isFocusableInTouchMode() && (newFocus = this.focusSearch(2)) != null) {
                newFocus.requestFocus();
            }
        } else {
            this.mGroupFlags &= 0xFBFFFFFF;
        }
    }

    private void setTouchscreenBlocksFocusNoRefocus(boolean touchscreenBlocksFocus) {
        this.mGroupFlags = touchscreenBlocksFocus ? (this.mGroupFlags |= 0x4000000) : (this.mGroupFlags &= 0xFBFFFFFF);
    }

    public boolean getTouchscreenBlocksFocus() {
        return (this.mGroupFlags & 0x4000000) != 0;
    }

    boolean shouldBlockFocusForTouchscreen() {
        return this.getTouchscreenBlocksFocus() && (!this.isKeyboardNavigationCluster() || !this.hasFocus() && this.findKeyboardNavigationCluster() == this);
    }

    @Override
    public void childHasTransientStateChanged(View child, boolean childHasTransientState) {
        boolean oldHasTransientState = this.hasTransientState();
        this.mChildCountWithTransientState = childHasTransientState ? ++this.mChildCountWithTransientState : --this.mChildCountWithTransientState;
        boolean newHasTransientState = this.hasTransientState();
        if (this.mParent != null && oldHasTransientState != newHasTransientState) {
            this.mParent.childHasTransientStateChanged(this, newHasTransientState);
        }
    }

    @Override
    public boolean hasTransientState() {
        return this.mChildCountWithTransientState > 0 || super.hasTransientState();
    }

    @Override
    public void clearChildFocus(View child) {
        this.mFocused = null;
        if (this.mParent != null) {
            this.mParent.clearChildFocus(this);
        }
    }

    @Override
    public void clearFocus() {
        if (this.mFocused == null) {
            super.clearFocus();
        } else {
            View focused = this.mFocused;
            this.mFocused = null;
            focused.clearFocus();
        }
    }

    @Override
    void unFocus(View focused) {
        if (this.mFocused == null) {
            super.unFocus(focused);
        } else {
            this.mFocused.unFocus(focused);
            this.mFocused = null;
        }
    }

    @Override
    boolean hasFocusable(boolean allowAutoFocus, boolean dispatchExplicit) {
        if ((this.mViewFlags & 0xC) != 0) {
            return false;
        }
        if ((allowAutoFocus || this.getFocusable() != 16) && this.isFocusable()) {
            return true;
        }
        int descendantFocusability = this.getDescendantFocusability();
        if (descendantFocusability != 393216) {
            return this.hasFocusableChild(dispatchExplicit);
        }
        return false;
    }

    boolean hasFocusableChild(boolean dispatchExplicit) {
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            if ((!dispatchExplicit || !child.hasExplicitFocusable()) && (dispatchExplicit || !child.hasFocusable())) continue;
            return true;
        }
        return false;
    }

    public View getFocusedChild() {
        return this.mFocused;
    }

    View getDeepestFocusedChild() {
        ViewGroup v = this;
        while (v != null) {
            if (v.isFocused()) {
                return v;
            }
            v = v instanceof ViewGroup ? v.getFocusedChild() : null;
        }
        return null;
    }

    @Override
    public boolean hasFocus() {
        return (this.mPrivateFlags & 2) != 0 || this.mFocused != null;
    }

    @Override
    @Nullable
    public View findFocus() {
        if (this.isFocused()) {
            return this;
        }
        if (this.mFocused != null) {
            return this.mFocused.findFocus();
        }
        return null;
    }

    public final void offsetDescendantRectToMyCoords(View descendant, Rect rect) {
        this.offsetRectBetweenParentAndChild(descendant, rect, true, false);
    }

    public final void offsetRectIntoDescendantCoords(View descendant, Rect rect) {
        this.offsetRectBetweenParentAndChild(descendant, rect, false, false);
    }

    void offsetRectBetweenParentAndChild(View descendant, Rect rect, boolean offsetFromChildToParent, boolean clipToBounds) {
        if (descendant == this) {
            return;
        }
        ViewParent theParent = descendant.mParent;
        while (theParent instanceof View && theParent != this) {
            if (offsetFromChildToParent) {
                rect.offset(descendant.mLeft - descendant.mScrollX, descendant.mTop - descendant.mScrollY);
                if (clipToBounds) {
                    p = (View)((Object)theParent);
                    intersected = rect.intersect(0, 0, p.mRight - p.mLeft, p.mBottom - p.mTop);
                    if (!intersected) {
                        rect.setEmpty();
                    }
                }
            } else {
                if (clipToBounds) {
                    p = (View)((Object)theParent);
                    intersected = rect.intersect(0, 0, p.mRight - p.mLeft, p.mBottom - p.mTop);
                    if (!intersected) {
                        rect.setEmpty();
                    }
                }
                rect.offset(descendant.mScrollX - descendant.mLeft, descendant.mScrollY - descendant.mTop);
            }
            descendant = (View)((Object)theParent);
            theParent = descendant.mParent;
        }
        if (theParent == this) {
            if (offsetFromChildToParent) {
                rect.offset(descendant.mLeft - descendant.mScrollX, descendant.mTop - descendant.mScrollY);
            } else {
                rect.offset(descendant.mScrollX - descendant.mLeft, descendant.mScrollY - descendant.mTop);
            }
        } else {
            throw new IllegalArgumentException("parameter must be a descendant of this view");
        }
    }

    public void offsetChildrenTopAndBottom(int offset) {
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].offsetTopAndBottom(offset);
        }
    }

    @Override
    public boolean getChildVisibleRect(View child, Rect r, @Nullable Point offset) {
        return this.getChildVisibleRect(child, r, offset, false);
    }

    @ApiStatus.Internal
    public boolean getChildVisibleRect(@NonNull View child, Rect r, @Nullable Point offset, boolean forceParentCheck) {
        RectF rect = this.mAttachInfo != null ? this.mAttachInfo.mTmpTransformRect : new RectF();
        rect.set(r);
        if (!child.hasIdentityMatrix()) {
            child.getMatrix().mapRect(rect);
        }
        int dx = child.mLeft - this.mScrollX;
        int dy = child.mTop - this.mScrollY;
        rect.offset(dx, dy);
        if (offset != null) {
            if (!child.hasIdentityMatrix()) {
                float[] position = this.mAttachInfo != null ? this.mAttachInfo.mTmpTransformLocation : new float[2];
                position[0] = offset.x;
                position[1] = offset.y;
                child.getMatrix().mapPoint(position);
                offset.x = Math.round(position[0]);
                offset.y = Math.round(position[1]);
            }
            offset.x += dx;
            offset.y += dy;
        }
        int width = this.mRight - this.mLeft;
        int height = this.mBottom - this.mTop;
        boolean rectIsVisible = true;
        if (this.mParent == null || this.mParent instanceof ViewGroup && ((ViewGroup)this.mParent).getClipChildren()) {
            rectIsVisible = rect.intersect(0.0f, 0.0f, width, height);
        }
        if ((forceParentCheck || rectIsVisible) && (this.mGroupFlags & 0x22) == 34) {
            rectIsVisible = rect.intersect(this.mPaddingLeft, this.mPaddingTop, width - this.mPaddingRight, height - this.mPaddingBottom);
        }
        r.set((int)Math.floor(rect.left), (int)Math.floor(rect.top), (int)Math.ceil(rect.right), (int)Math.ceil(rect.bottom));
        if ((forceParentCheck || rectIsVisible) && this.mParent != null) {
            rectIsVisible = this.mParent instanceof ViewGroup ? ((ViewGroup)this.mParent).getChildVisibleRect(this, r, offset, forceParentCheck) : this.mParent.getChildVisibleRect(this, r, offset);
        }
        return rectIsVisible;
    }

    @Override
    public View focusSearch(View focused, int direction) {
        if (this.isRootNamespace()) {
            return FocusFinder.getInstance().findNextFocus(this, focused, direction);
        }
        if (this.mParent != null) {
            return this.mParent.focusSearch(focused, direction);
        }
        return null;
    }

    @Override
    public boolean requestChildRectangleOnScreen(View child, Rect rectangle, boolean immediate) {
        return false;
    }

    @Override
    public void focusableViewAvailable(View v) {
        if (!(this.mParent == null || this.getDescendantFocusability() == 393216 || (this.mViewFlags & 0xC) != 0 || this.isFocused() && this.getDescendantFocusability() != 262144)) {
            this.mParent.focusableViewAvailable(v);
        }
    }

    @Override
    public boolean showContextMenuForChild(View originalView, float x, float y) {
        return this.mParent != null && this.mParent.showContextMenuForChild(originalView, x, y);
    }

    @Override
    public ActionMode startActionModeForChild(View originalView, ActionMode.Callback callback, int type) {
        if (this.mParent != null) {
            return this.mParent.startActionModeForChild(originalView, callback, type);
        }
        return null;
    }

    public void setClipToPadding(boolean clipToPadding) {
        if (this.hasBooleanFlag(2) != clipToPadding) {
            this.setBooleanFlag(2, clipToPadding);
            this.invalidate();
        }
    }

    public boolean getClipToPadding() {
        return this.hasBooleanFlag(2);
    }

    @Override
    public void dispatchSetSelected(boolean selected) {
        View[] children = this.mChildren;
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            children[i].setSelected(selected);
        }
    }

    @Override
    public void dispatchSetActivated(boolean activated) {
        View[] children = this.mChildren;
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            children[i].setActivated(activated);
        }
    }

    @Override
    protected void dispatchSetPressed(boolean pressed) {
        View[] children = this.mChildren;
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            if (pressed && (child.isClickable() || child.isLongClickable())) continue;
            child.setPressed(pressed);
        }
    }

    @Override
    public void dispatchDrawableHotspotChanged(float x, float y) {
        int count = this.mChildrenCount;
        if (count == 0) {
            return;
        }
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            boolean duplicatesState;
            View child = children[i];
            boolean nonActionable = !child.isClickable() && !child.isLongClickable();
            boolean bl = duplicatesState = (child.mViewFlags & 0x400000) != 0;
            if (!nonActionable && !duplicatesState) continue;
            float[] point = this.getTempLocationF();
            point[0] = x;
            point[1] = y;
            this.transformPointToViewLocal(point, child);
            child.drawableHotspotChanged(point[0], point[1]);
        }
    }

    @Override
    @Nullable
    protected <T extends View> T findViewByPredicateTraversal(@NonNull Predicate<View> predicate, @Nullable View childToSkip) {
        if (predicate.test(this)) {
            return (T)this;
        }
        View[] where = this.mChildren;
        int len = this.mChildrenCount;
        for (int i = 0; i < len; ++i) {
            View v = where[i];
            if (v == childToSkip || (v.mPrivateFlags & 8) != 0 || (v = v.findViewByPredicate(predicate)) == null) continue;
            return (T)v;
        }
        return null;
    }

    @Override
    @Nullable
    protected <T extends View> T findViewTraversal(int id2) {
        if (id2 == this.mID) {
            return (T)this;
        }
        View[] views = this.mChildren;
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            Object v = views[i].findViewTraversal(id2);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    @Override
    public void bringChildToFront(View child) {
        int index = this.indexOfChild(child);
        if (index >= 0) {
            this.removeFromArray(index);
            this.addInArray(child, this.mChildrenCount);
            child.mParent = this;
            this.requestLayout();
            this.invalidate();
        }
    }

    protected boolean hasBooleanFlag(int flag) {
        return (this.mGroupFlags & flag) == flag;
    }

    protected void setBooleanFlag(int flag, boolean value) {
        this.mGroupFlags = value ? (this.mGroupFlags |= flag) : (this.mGroupFlags &= ~flag);
    }

    protected boolean isChildrenDrawingOrderEnabled() {
        return (this.mGroupFlags & 0x400) == 1024;
    }

    protected void setChildrenDrawingOrderEnabled(boolean enabled) {
        this.setBooleanFlag(1024, enabled);
    }

    protected int getChildDrawingOrder(int childCount, int drawingPosition) {
        return drawingPosition;
    }

    public final int getChildDrawingOrder(int drawingPosition) {
        return this.getChildDrawingOrder(this.getChildCount(), drawingPosition);
    }

    private boolean hasChildWithZ() {
        for (int i = 0; i < this.mChildrenCount; ++i) {
            if (this.mChildren[i].getZ() == 0.0f) continue;
            return true;
        }
        return false;
    }

    @Nullable
    ArrayList<View> buildOrderedChildList() {
        int childrenCount = this.mChildrenCount;
        if (childrenCount <= 1 || !this.hasChildWithZ()) {
            return null;
        }
        if (this.mPreSortedChildren == null) {
            this.mPreSortedChildren = new ArrayList(childrenCount);
        } else {
            this.mPreSortedChildren.clear();
            this.mPreSortedChildren.ensureCapacity(childrenCount);
        }
        boolean customOrder = this.isChildrenDrawingOrderEnabled();
        for (int i = 0; i < childrenCount; ++i) {
            int insertIndex;
            int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
            View nextChild = this.mChildren[childIndex];
            float currentZ = nextChild.getZ();
            for (insertIndex = i; insertIndex > 0 && this.mPreSortedChildren.get(insertIndex - 1).getZ() > currentZ; --insertIndex) {
            }
            this.mPreSortedChildren.add(insertIndex, nextChild);
        }
        return this.mPreSortedChildren;
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if ((this.mGroupFlags & 0x10000) != 0) {
            if ((this.mGroupFlags & 0x2000) != 0) {
                throw new IllegalStateException("addStateFromChildren cannot be enabled if a child has duplicateParentState set to true");
            }
            View[] children = this.mChildren;
            int count = this.mChildrenCount;
            for (int i = 0; i < count; ++i) {
                View child = children[i];
                if ((child.mViewFlags & 0x400000) == 0) continue;
                child.refreshDrawableState();
            }
        }
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        View[] children = this.mChildren;
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            children[i].jumpDrawablesToCurrentState();
        }
    }

    @Override
    @NonNull
    protected int[] onCreateDrawableState(int extraSpace) {
        if ((this.mGroupFlags & 0x2000) == 0) {
            return super.onCreateDrawableState(extraSpace);
        }
        int need = 0;
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            int[] childState = this.getChildAt(i).getDrawableState();
            if (childState == null) continue;
            need += childState.length;
        }
        int[] state = super.onCreateDrawableState(extraSpace + need);
        for (int i = 0; i < n; ++i) {
            int[] childState = this.getChildAt(i).getDrawableState();
            if (childState == null) continue;
            ViewGroup.mergeDrawableStates(state, childState);
        }
        return state;
    }

    public void setAddStatesFromChildren(boolean addsStates) {
        this.mGroupFlags = addsStates ? (this.mGroupFlags |= 0x2000) : (this.mGroupFlags &= 0xFFFFDFFF);
        this.refreshDrawableState();
    }

    public boolean addStatesFromChildren() {
        return (this.mGroupFlags & 0x2000) != 0;
    }

    @Override
    public void childDrawableStateChanged(View child) {
        if ((this.mGroupFlags & 0x2000) != 0) {
            this.refreshDrawableState();
        }
    }

    @ApiStatus.Internal
    public void requestTransitionStart(LayoutTransition transition) {
        ViewRoot viewAncestor;
        ViewRoot viewRoot = viewAncestor = this.mAttachInfo != null ? this.mAttachInfo.mViewRoot : null;
        if (viewAncestor != null) {
            viewAncestor.requestTransitionStart(transition);
        }
    }

    @Override
    @ApiStatus.Internal
    public boolean resolveRtlPropertiesIfNeeded() {
        boolean result = super.resolveRtlPropertiesIfNeeded();
        if (result) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                if (!child.isLayoutDirectionInherited()) continue;
                child.resolveRtlPropertiesIfNeeded();
            }
        }
        return result;
    }

    @Override
    @ApiStatus.Internal
    public boolean resolveLayoutDirection() {
        boolean result = super.resolveLayoutDirection();
        if (result) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                if (!child.isLayoutDirectionInherited()) continue;
                child.resolveLayoutDirection();
            }
        }
        return result;
    }

    @Override
    @ApiStatus.Internal
    public boolean resolveTextDirection() {
        boolean result = super.resolveTextDirection();
        if (result) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                if (!child.isTextDirectionInherited()) continue;
                child.resolveTextDirection();
            }
        }
        return result;
    }

    @Override
    @ApiStatus.Internal
    public boolean resolveTextAlignment() {
        boolean result = super.resolveTextAlignment();
        if (result) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                if (!child.isTextAlignmentInherited()) continue;
                child.resolveTextAlignment();
            }
        }
        return result;
    }

    @Override
    @ApiStatus.Internal
    public void resolvePadding() {
        super.resolvePadding();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!child.isLayoutDirectionInherited() || child.isPaddingResolved()) continue;
            child.resolvePadding();
        }
    }

    @Override
    @ApiStatus.Internal
    protected void resolveDrawables() {
        super.resolveDrawables();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!child.isLayoutDirectionInherited() || child.areDrawablesResolved()) continue;
            child.resolveDrawables();
        }
    }

    @Override
    @ApiStatus.Internal
    public void resolveLayoutParams() {
        super.resolveLayoutParams();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            child.resolveLayoutParams();
        }
    }

    @Override
    @ApiStatus.Internal
    void resetResolvedLayoutDirection() {
        super.resetResolvedLayoutDirection();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!child.isLayoutDirectionInherited()) continue;
            child.resetResolvedLayoutDirection();
        }
    }

    @Override
    @ApiStatus.Internal
    void resetResolvedTextDirection() {
        super.resetResolvedTextDirection();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!child.isTextDirectionInherited()) continue;
            child.resetResolvedTextDirection();
        }
    }

    @Override
    @ApiStatus.Internal
    void resetResolvedTextAlignment() {
        super.resetResolvedTextAlignment();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!child.isTextAlignmentInherited()) continue;
            child.resetResolvedTextAlignment();
        }
    }

    @Override
    @ApiStatus.Internal
    void resetResolvedPadding() {
        super.resetResolvedPadding();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!child.isLayoutDirectionInherited()) continue;
            child.resetResolvedPadding();
        }
    }

    @Override
    @ApiStatus.Internal
    protected void resetResolvedDrawables() {
        super.resetResolvedDrawables();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!child.isLayoutDirectionInherited()) continue;
            child.resetResolvedDrawables();
        }
    }

    public boolean getClipChildren() {
        return (this.mGroupFlags & 1) != 0;
    }

    public void setClipChildren(boolean clipChildren) {
        boolean previousValue;
        boolean bl = previousValue = (this.mGroupFlags & 1) == 1;
        if (clipChildren != previousValue) {
            this.setBooleanFlag(1, clipChildren);
            this.invalidate();
        }
    }

    @Override
    void dispatchCancelPendingInputEvents() {
        super.dispatchCancelPendingInputEvents();
        View[] children = this.mChildren;
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchCancelPendingInputEvents();
        }
    }

    protected void measureChildren(int widthMeasureSpec, int heightMeasureSpec) {
        int size = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < size; ++i) {
            View child = children[i];
            if (child.getVisibility() == 8) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
        }
    }

    protected void measureChild(@NonNull View child, int parentWidthSpec, int parentHeightSpec) {
        LayoutParams lp = child.getLayoutParams();
        int childWidthMeasureSpec = ViewGroup.getChildMeasureSpec(parentWidthSpec, this.mPaddingLeft + this.mPaddingRight, lp.width);
        int childHeightMeasureSpec = ViewGroup.getChildMeasureSpec(parentHeightSpec, this.mPaddingTop + this.mPaddingBottom, lp.height);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    protected void measureChildWithMargins(@NonNull View child, int parentWidthSpec, int widthUsed, int parentHeightSpec, int heightUsed) {
        MarginLayoutParams lp = (MarginLayoutParams)child.getLayoutParams();
        int childWidthMeasureSpec = ViewGroup.getChildMeasureSpec(parentWidthSpec, this.mPaddingLeft + this.mPaddingRight + lp.leftMargin + lp.rightMargin + widthUsed, lp.width);
        int childHeightMeasureSpec = ViewGroup.getChildMeasureSpec(parentHeightSpec, this.mPaddingTop + this.mPaddingBottom + lp.topMargin + lp.bottomMargin + heightUsed, lp.height);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    public static int getChildMeasureSpec(int spec, int padding, int childDimension) {
        int specSize = MeasureSpec.getSize(spec);
        int size = Math.max(0, specSize - padding);
        int resultSize = 0;
        int resultMode = 0;
        switch (MeasureSpec.getMode(spec)) {
            case 0x40000000: {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = 0x40000000;
                    break;
                }
                if (childDimension == -1) {
                    resultSize = size;
                    resultMode = 0x40000000;
                    break;
                }
                if (childDimension != -2) break;
                resultSize = size;
                resultMode = Integer.MIN_VALUE;
                break;
            }
            case -2147483648: {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = 0x40000000;
                    break;
                }
                if (childDimension == -1) {
                    resultSize = size;
                    resultMode = Integer.MIN_VALUE;
                    break;
                }
                if (childDimension != -2) break;
                resultSize = size;
                resultMode = Integer.MIN_VALUE;
                break;
            }
            case 0: {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = 0x40000000;
                    break;
                }
                if (childDimension == -1) {
                    resultSize = size;
                    break;
                }
                if (childDimension != -2) break;
                resultSize = size;
            }
        }
        return MeasureSpec.makeMeasureSpec(resultSize, resultMode);
    }

    public void clearDisappearingChildren() {
        ArrayList<View> disappearingChildren = this.mDisappearingChildren;
        if (disappearingChildren != null) {
            for (View view : disappearingChildren) {
                if (view.mAttachInfo == null) continue;
                view.dispatchDetachedFromWindow();
            }
            disappearingChildren.clear();
            this.invalidate();
        }
    }

    private void addDisappearingView(View v) {
        ArrayList<View> disappearingChildren = this.mDisappearingChildren;
        if (disappearingChildren == null) {
            disappearingChildren = this.mDisappearingChildren = new ArrayList();
        }
        disappearingChildren.add(v);
    }

    boolean isViewTransitioning(View view) {
        return this.mTransitioningViews != null && this.mTransitioningViews.contains(view);
    }

    public void startViewTransition(@NonNull View view) {
        if (view.mParent == this) {
            if (this.mTransitioningViews == null) {
                this.mTransitioningViews = new ArrayList();
            }
            this.mTransitioningViews.add(view);
        }
    }

    public void endViewTransition(View view) {
        if (this.mTransitioningViews != null) {
            this.mTransitioningViews.remove(view);
            ArrayList<View> disappearingChildren = this.mDisappearingChildren;
            if (disappearingChildren != null && disappearingChildren.contains(view)) {
                disappearingChildren.remove(view);
                if (this.mVisibilityChangingChildren != null && this.mVisibilityChangingChildren.contains(view)) {
                    this.mVisibilityChangingChildren.remove(view);
                } else {
                    if (view.mAttachInfo != null) {
                        view.dispatchDetachedFromWindow();
                    }
                    if (view.mParent != null) {
                        view.mParent = null;
                    }
                }
                this.invalidate();
            }
        }
    }

    public void suppressLayout(boolean suppress) {
        this.mSuppressLayout = suppress;
        if (!suppress && this.mLayoutCalledWhileSuppressed) {
            this.requestLayout();
            this.mLayoutCalledWhileSuppressed = false;
        }
    }

    public boolean isLayoutSuppressed() {
        return this.mSuppressLayout;
    }

    @Override
    @ApiStatus.Internal
    protected void internalSetPadding(int left, int top, int right, int bottom) {
        super.internalSetPadding(left, top, right, bottom);
        this.mGroupFlags = (this.mPaddingLeft | this.mPaddingTop | this.mPaddingRight | this.mPaddingBottom) != 0 ? (this.mGroupFlags |= 0x20) : (this.mGroupFlags &= 0xFFFFFFDF);
    }

    @ApiStatus.Internal
    protected void onChildVisibilityChanged(View child, int oldVisibility, int newVisibility) {
        if (this.mTransition != null) {
            if (newVisibility == 0) {
                this.mTransition.showChild(this, child, oldVisibility);
            } else {
                this.mTransition.hideChild(this, child, newVisibility);
                if (this.mTransitioningViews != null && this.mTransitioningViews.contains(child)) {
                    if (this.mVisibilityChangingChildren == null) {
                        this.mVisibilityChangingChildren = new ArrayList();
                    }
                    this.mVisibilityChangingChildren.add(child);
                    this.addDisappearingView(child);
                }
            }
        }
    }

    @Override
    protected void dispatchVisibilityChanged(@NonNull View changedView, int visibility) {
        super.dispatchVisibilityChanged(changedView, visibility);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchVisibilityChanged(changedView, visibility);
        }
    }

    @Override
    public void dispatchWindowVisibilityChanged(int visibility) {
        super.dispatchWindowVisibilityChanged(visibility);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchWindowVisibilityChanged(visibility);
        }
    }

    @Override
    boolean dispatchVisibilityAggregated(boolean isVisible) {
        isVisible = super.dispatchVisibilityAggregated(isVisible);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            if (children[i].getVisibility() != 0) continue;
            children[i].dispatchVisibilityAggregated(isVisible);
        }
        return isVisible;
    }

    public boolean shouldDelayChildPressedState() {
        return true;
    }

    @Override
    public boolean onStartNestedScroll(@NonNull View child, @NonNull View target, int axes, int type) {
        return false;
    }

    @Override
    public void onNestedScrollAccepted(@NonNull View child, @NonNull View target, int axes, int type) {
        if (type == 1) {
            this.mNestedScrollAxesNonTouch = axes;
        } else {
            this.mNestedScrollAxesTouch = axes;
        }
    }

    @Override
    public void onStopNestedScroll(@NonNull View target, int type) {
        this.stopNestedScroll(type);
        if (type == 1) {
            this.mNestedScrollAxesNonTouch = 0;
        } else {
            this.mNestedScrollAxesTouch = 0;
        }
    }

    @Override
    public void onNestedScroll(@NonNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type, @NonNull int[] consumed) {
        this.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, null, type, consumed);
    }

    @Override
    public void onNestedPreScroll(@NonNull View target, int dx, int dy, @NonNull int[] consumed, int type) {
        this.dispatchNestedPreScroll(dx, dy, consumed, null, type);
    }

    @Override
    public boolean onNestedFling(@NonNull View target, float velocityX, float velocityY, boolean consumed) {
        return this.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    @Override
    public boolean onNestedPreFling(@NonNull View target, float velocityX, float velocityY) {
        return this.dispatchNestedPreFling(velocityX, velocityY);
    }

    @Override
    public int getNestedScrollAxes() {
        return this.mNestedScrollAxesTouch | this.mNestedScrollAxesNonTouch;
    }

    @ApiStatus.Internal
    protected void onSetLayoutParams(View child, LayoutParams layoutParams) {
        this.requestLayout();
    }

    @NonNull
    protected LayoutParams generateLayoutParams(@NonNull LayoutParams p) {
        return p;
    }

    @NonNull
    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    protected boolean checkLayoutParams(@Nullable LayoutParams p) {
        return p != null;
    }

    private class LayoutTransitionListener
    implements LayoutTransition.TransitionListener {
        private LayoutTransitionListener() {
        }

        @Override
        public void startTransition(LayoutTransition transition, ViewGroup container, View view, int transitionType) {
            if (transitionType == 3) {
                ViewGroup.this.startViewTransition(view);
            }
        }

        @Override
        public void endTransition(LayoutTransition transition, ViewGroup container, View view, int transitionType) {
            if (ViewGroup.this.mLayoutCalledWhileSuppressed && !transition.isChangingLayout()) {
                ViewGroup.this.requestLayout();
                ViewGroup.this.mLayoutCalledWhileSuppressed = false;
            }
            if (transitionType == 3 && ViewGroup.this.mTransitioningViews != null) {
                ViewGroup.this.endViewTransition(view);
            }
        }
    }

    public static class LayoutParams {
        public static final int MATCH_PARENT = -1;
        public static final int WRAP_CONTENT = -2;
        public int width;
        public int height;

        public LayoutParams(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public LayoutParams(@NonNull LayoutParams source) {
            this.width = source.width;
            this.height = source.height;
        }

        @ApiStatus.Internal
        LayoutParams() {
        }

        public void resolveLayoutDirection(int layoutDirection) {
        }

        @ApiStatus.Internal
        public void onDebugDraw(View view, Canvas canvas, Paint paint) {
        }
    }

    private static final class HoverTarget {
        private static final int MAX_RECYCLED = 32;
        private static final Object sRecyclerLock = new Object();
        private static HoverTarget sRecyclerTop;
        private static int sRecyclerUsed;
        public View child;
        public HoverTarget next;

        private HoverTarget() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public static HoverTarget obtain(@NonNull View child) {
            HoverTarget target;
            Object object = sRecyclerLock;
            synchronized (object) {
                if (sRecyclerTop == null) {
                    target = new HoverTarget();
                } else {
                    target = sRecyclerTop;
                    sRecyclerTop = target.next;
                    --sRecyclerUsed;
                    target.next = null;
                }
            }
            target.child = child;
            return target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recycle() {
            if (this.child == null) {
                throw new IllegalStateException(this + " already recycled");
            }
            Object object = sRecyclerLock;
            synchronized (object) {
                if (sRecyclerUsed < 32) {
                    ++sRecyclerUsed;
                    this.next = sRecyclerTop;
                    sRecyclerTop = this;
                } else {
                    this.next = null;
                }
                this.child = null;
            }
        }
    }

    private static final class TouchTarget {
        private static final Pools.Pool<TouchTarget> sPool = Pools.newSynchronizedPool(12);
        public View child;

        private TouchTarget() {
        }

        @NonNull
        public static TouchTarget obtain(@NonNull View child) {
            TouchTarget target = sPool.acquire();
            if (target == null) {
                target = new TouchTarget();
            }
            target.child = child;
            return target;
        }

        public void recycle() {
            if (this.child == null) {
                throw new IllegalStateException(this + " already recycled");
            }
            sPool.release(this);
            this.child = null;
        }
    }

    public static class MarginLayoutParams
    extends LayoutParams {
        public int leftMargin;
        public int topMargin;
        public int rightMargin;
        public int bottomMargin;
        private int startMargin = Integer.MIN_VALUE;
        private int endMargin = Integer.MIN_VALUE;
        @ApiStatus.Internal
        public static final int DEFAULT_MARGIN_RELATIVE = Integer.MIN_VALUE;
        @ApiStatus.Internal
        byte mMarginFlags;
        private static final int LAYOUT_DIRECTION_MASK = 3;
        private static final int LEFT_MARGIN_UNDEFINED_MASK = 4;
        private static final int RIGHT_MARGIN_UNDEFINED_MASK = 8;
        private static final int RTL_COMPATIBILITY_MODE_MASK = 16;
        private static final int NEED_RESOLUTION_MASK = 32;
        private static final int DEFAULT_MARGIN_RESOLVED = 0;
        private static final int UNDEFINED_MARGIN = Integer.MIN_VALUE;

        public MarginLayoutParams(int width, int height) {
            super(width, height);
            this.mMarginFlags = (byte)(this.mMarginFlags | 4);
            this.mMarginFlags = (byte)(this.mMarginFlags | 8);
        }

        public MarginLayoutParams(@NonNull MarginLayoutParams source) {
            super(source);
            this.leftMargin = source.leftMargin;
            this.topMargin = source.topMargin;
            this.rightMargin = source.rightMargin;
            this.bottomMargin = source.bottomMargin;
            this.startMargin = source.startMargin;
            this.endMargin = source.endMargin;
            this.mMarginFlags = source.mMarginFlags;
        }

        public MarginLayoutParams(LayoutParams source) {
            super(source);
            this.mMarginFlags = (byte)(this.mMarginFlags | 4);
            this.mMarginFlags = (byte)(this.mMarginFlags | 8);
        }

        @ApiStatus.Internal
        public final void copyMarginsFrom(@NonNull MarginLayoutParams source) {
            this.leftMargin = source.leftMargin;
            this.topMargin = source.topMargin;
            this.rightMargin = source.rightMargin;
            this.bottomMargin = source.bottomMargin;
            this.startMargin = source.startMargin;
            this.endMargin = source.endMargin;
            this.mMarginFlags = source.mMarginFlags;
        }

        public void setMargins(int left, int top, int right, int bottom) {
            this.leftMargin = left;
            this.topMargin = top;
            this.rightMargin = right;
            this.bottomMargin = bottom;
            this.mMarginFlags = (byte)(this.mMarginFlags & 0xFFFFFFFB);
            this.mMarginFlags = (byte)(this.mMarginFlags & 0xFFFFFFF7);
            this.mMarginFlags = this.isMarginRelative() ? (byte)(this.mMarginFlags | 0x20) : (byte)(this.mMarginFlags & 0xFFFFFFDF);
        }

        public void setMarginsRelative(int start, int top, int end, int bottom) {
            this.startMargin = start;
            this.topMargin = top;
            this.endMargin = end;
            this.bottomMargin = bottom;
            this.mMarginFlags = (byte)(this.mMarginFlags | 0x20);
        }

        public void setMarginStart(int start) {
            this.startMargin = start;
            this.mMarginFlags = (byte)(this.mMarginFlags | 0x20);
        }

        public int getMarginStart() {
            if (this.startMargin != Integer.MIN_VALUE) {
                return this.startMargin;
            }
            if ((this.mMarginFlags & 0x20) == 32) {
                this.doResolveMargins();
            }
            if (this.isLayoutRtl()) {
                return this.rightMargin;
            }
            return this.leftMargin;
        }

        public void setMarginEnd(int end) {
            this.endMargin = end;
            this.mMarginFlags = (byte)(this.mMarginFlags | 0x20);
        }

        public int getMarginEnd() {
            if (this.endMargin != Integer.MIN_VALUE) {
                return this.endMargin;
            }
            if ((this.mMarginFlags & 0x20) == 32) {
                this.doResolveMargins();
            }
            if (this.isLayoutRtl()) {
                return this.leftMargin;
            }
            return this.rightMargin;
        }

        public boolean isMarginRelative() {
            return this.startMargin != Integer.MIN_VALUE || this.endMargin != Integer.MIN_VALUE;
        }

        public void setLayoutDirection(int layoutDirection) {
            if (layoutDirection != 0 && layoutDirection != 1) {
                return;
            }
            if (layoutDirection != (this.mMarginFlags & 3)) {
                this.mMarginFlags = (byte)(this.mMarginFlags & 0xFFFFFFFC);
                this.mMarginFlags = (byte)(this.mMarginFlags | layoutDirection & 3);
                this.mMarginFlags = this.isMarginRelative() ? (byte)(this.mMarginFlags | 0x20) : (byte)(this.mMarginFlags & 0xFFFFFFDF);
            }
        }

        public int getLayoutDirection() {
            return this.mMarginFlags & 3;
        }

        @Override
        public void resolveLayoutDirection(int layoutDirection) {
            this.setLayoutDirection(layoutDirection);
            if (!this.isMarginRelative() || (this.mMarginFlags & 0x20) != 32) {
                return;
            }
            this.doResolveMargins();
        }

        private void doResolveMargins() {
            if ((this.mMarginFlags & 0x10) == 16) {
                if ((this.mMarginFlags & 4) == 4 && this.startMargin > Integer.MIN_VALUE) {
                    this.leftMargin = this.startMargin;
                }
                if ((this.mMarginFlags & 8) == 8 && this.endMargin > Integer.MIN_VALUE) {
                    this.rightMargin = this.endMargin;
                }
            } else if (this.isLayoutRtl()) {
                this.leftMargin = this.endMargin > Integer.MIN_VALUE ? this.endMargin : 0;
                this.rightMargin = this.startMargin > Integer.MIN_VALUE ? this.startMargin : 0;
            } else {
                this.leftMargin = this.startMargin > Integer.MIN_VALUE ? this.startMargin : 0;
                this.rightMargin = this.endMargin > Integer.MIN_VALUE ? this.endMargin : 0;
            }
            this.mMarginFlags = (byte)(this.mMarginFlags & 0xFFFFFFDF);
        }

        @ApiStatus.Internal
        public boolean isLayoutRtl() {
            return (this.mMarginFlags & 3) == 1;
        }

        @Override
        @ApiStatus.Internal
        public void onDebugDraw(View view, Canvas canvas, Paint paint) {
            FloatBuffer positions = sDebugDrawBuffer.get().clear();
            int x2 = view.getLeft();
            int y2 = view.getTop();
            int x3 = view.getRight();
            int y3 = view.getBottom();
            int x1 = x2 - this.leftMargin;
            int y1 = y2 - this.topMargin;
            int x4 = x3 + this.rightMargin;
            int y4 = y3 + this.bottomMargin;
            ViewGroup.fillRect(x1, y1, x4, y2, positions);
            ViewGroup.fillRect(x1, y2, x2, y3, positions);
            ViewGroup.fillRect(x3, y2, x4, y3, positions);
            ViewGroup.fillRect(x1, y3, x4, y4, positions);
            canvas.drawMesh(Canvas.VertexMode.TRIANGLES, positions.flip(), null, null, null, null, paint);
        }
    }
}

