/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.view;

import icyllis.modernui.ModernUI;
import icyllis.modernui.animation.AnimationUtils;
import icyllis.modernui.animation.StateListAnimator;
import icyllis.modernui.annotation.CallSuper;
import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.annotation.Nullable;
import icyllis.modernui.annotation.UiThread;
import icyllis.modernui.core.Context;
import icyllis.modernui.core.Core;
import icyllis.modernui.core.Handler;
import icyllis.modernui.graphics.AlphaFilterCanvas;
import icyllis.modernui.graphics.ArcCanvas;
import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.graphics.Matrix;
import icyllis.modernui.graphics.Paint;
import icyllis.modernui.graphics.Point;
import icyllis.modernui.graphics.Rect;
import icyllis.modernui.graphics.RectF;
import icyllis.modernui.graphics.RenderNode;
import icyllis.modernui.graphics.drawable.Drawable;
import icyllis.modernui.text.TextUtils;
import icyllis.modernui.util.FloatProperty;
import icyllis.modernui.util.IntProperty;
import icyllis.modernui.util.SparseArray;
import icyllis.modernui.util.StateSet;
import icyllis.modernui.view.ActionMode;
import icyllis.modernui.view.AttachInfo;
import icyllis.modernui.view.ContextMenu;
import icyllis.modernui.view.DragEvent;
import icyllis.modernui.view.FocusFinder;
import icyllis.modernui.view.Gravity;
import icyllis.modernui.view.HandlerActionQueue;
import icyllis.modernui.view.KeyEvent;
import icyllis.modernui.view.MeasureSpec;
import icyllis.modernui.view.MotionEvent;
import icyllis.modernui.view.PointerIcon;
import icyllis.modernui.view.ScrollBar;
import icyllis.modernui.view.ScrollCache;
import icyllis.modernui.view.TooltipPopup;
import icyllis.modernui.view.ViewConfiguration;
import icyllis.modernui.view.ViewGroup;
import icyllis.modernui.view.ViewParent;
import icyllis.modernui.view.ViewRoot;
import icyllis.modernui.view.ViewTreeObserver;
import icyllis.modernui.view.menu.MenuBuilder;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;

@UiThread
public class View
implements Drawable.Callback {
    protected static final Marker VIEW_MARKER = MarkerManager.getMarker((String)"View");
    public static final int NO_ID = -1;
    public static final int NOT_FOCUSABLE = 0;
    public static final int FOCUSABLE = 1;
    public static final int FOCUSABLE_AUTO = 16;
    private static final int FOCUSABLE_MASK = 17;
    public static final int VISIBLE = 0;
    public static final int INVISIBLE = 4;
    public static final int GONE = 8;
    static final int VISIBILITY_MASK = 12;
    static final int ENABLED = 0;
    static final int DISABLED = 32;
    static final int ENABLED_MASK = 32;
    static final int WILL_NOT_DRAW = 128;
    static final int DRAW_MASK = 128;
    static final int SCROLLBARS_NONE = 0;
    static final int SCROLLBARS_HORIZONTAL = 256;
    static final int SCROLLBARS_VERTICAL = 512;
    static final int SCROLLBARS_MASK = 768;
    static final int FADING_EDGE_NONE = 0;
    static final int FADING_EDGE_HORIZONTAL = 4096;
    static final int FADING_EDGE_VERTICAL = 8192;
    static final int FADING_EDGE_MASK = 12288;
    static final int CLICKABLE = 16384;
    static final int FOCUSABLE_IN_TOUCH_MODE = 262144;
    static final int LONG_CLICKABLE = 0x200000;
    static final int DUPLICATE_PARENT_STATE = 0x400000;
    static final int CONTEXT_CLICKABLE = 0x800000;
    public static final int SCROLLBARS_INSIDE_OVERLAY = 0;
    public static final int SCROLLBARS_INSIDE_INSET = 0x1000000;
    public static final int SCROLLBARS_OUTSIDE_OVERLAY = 0x2000000;
    public static final int SCROLLBARS_OUTSIDE_INSET = 0x3000000;
    static final int SCROLLBARS_INSET_MASK = 0x1000000;
    static final int SCROLLBARS_OUTSIDE_MASK = 0x2000000;
    static final int SCROLLBARS_STYLE_MASK = 0x3000000;
    public static final int SOUND_EFFECTS_ENABLED = 0x8000000;
    public static final int HAPTIC_FEEDBACK_ENABLED = 0x10000000;
    static final int TOOLTIP = 0x40000000;
    public static final int FOCUSABLES_ALL = 0;
    public static final int FOCUSABLES_TOUCH_MODE = 1;
    public static final int FOCUS_BACKWARD = 1;
    public static final int FOCUS_FORWARD = 2;
    public static final int FOCUS_LEFT = 17;
    public static final int FOCUS_UP = 33;
    public static final int FOCUS_RIGHT = 66;
    public static final int FOCUS_DOWN = 130;
    public static final int MEASURED_SIZE_MASK = 0xFFFFFF;
    public static final int MEASURED_STATE_MASK = -16777216;
    public static final int MEASURED_HEIGHT_STATE_SHIFT = 16;
    public static final int MEASURED_STATE_TOO_SMALL = 0x1000000;
    protected static final int[] EMPTY_STATE_SET = StateSet.WILD_CARD;
    protected static final int[] ENABLED_STATE_SET;
    protected static final int[] FOCUSED_STATE_SET;
    protected static final int[] SELECTED_STATE_SET;
    protected static final int[] PRESSED_STATE_SET;
    protected static final int[] WINDOW_FOCUSED_STATE_SET;
    protected static final int[] ENABLED_FOCUSED_STATE_SET;
    protected static final int[] ENABLED_SELECTED_STATE_SET;
    protected static final int[] ENABLED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] FOCUSED_SELECTED_STATE_SET;
    protected static final int[] FOCUSED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] SELECTED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] ENABLED_FOCUSED_SELECTED_STATE_SET;
    protected static final int[] ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_SELECTED_STATE_SET;
    protected static final int[] PRESSED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_FOCUSED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_FOCUSED_SELECTED_STATE_SET;
    protected static final int[] PRESSED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_ENABLED_STATE_SET;
    protected static final int[] PRESSED_ENABLED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_ENABLED_SELECTED_STATE_SET;
    protected static final int[] PRESSED_ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_ENABLED_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET;
    protected static final int[] PRESSED_ENABLED_FOCUSED_SELECTED_STATE_SET;
    protected static final int[] PRESSED_ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    private static final ThreadLocal<Rect> sThreadLocal;
    private static final AtomicInteger sNextGeneratedId;
    static final int PFLAG_WANTS_FOCUS = 1;
    static final int PFLAG_FOCUSED = 2;
    static final int PFLAG_SELECTED = 4;
    static final int PFLAG_IS_ROOT_NAMESPACE = 8;
    static final int PFLAG_HAS_BOUNDS = 16;
    static final int PFLAG_DRAWN = 32;
    static final int PFLAG_DRAW_ANIMATION = 64;
    static final int PFLAG_SKIP_DRAW = 128;
    static final int PFLAG_REQUEST_TRANSPARENT_REGIONS = 512;
    static final int PFLAG_DRAWABLE_STATE_DIRTY = 1024;
    static final int PFLAG_MEASURED_DIMENSION_SET = 2048;
    static final int PFLAG_FORCE_LAYOUT = 4096;
    static final int PFLAG_LAYOUT_REQUIRED = 8192;
    private static final int PFLAG_PRESSED = 16384;
    static final int PFLAG_DRAWING_CACHE_VALID = 32768;
    static final int PFLAG_ANIMATION_STARTED = 65536;
    private static final int PFLAG_SAVE_STATE_CALLED = 131072;
    static final int PFLAG_ALPHA_SET = 262144;
    static final int PFLAG_SCROLL_CONTAINER = 524288;
    static final int PFLAG_SCROLL_CONTAINER_ADDED = 0x100000;
    static final int PFLAG_DIRTY = 0x200000;
    static final int PFLAG_DIRTY_MASK = 0x200000;
    static final int PFLAG_OPAQUE_BACKGROUND = 0x800000;
    static final int PFLAG_OPAQUE_SCROLLBARS = 0x1000000;
    static final int PFLAG_OPAQUE_MASK = 0x1800000;
    private static final int PFLAG_PREPRESSED = 0x2000000;
    static final int PFLAG_CANCEL_NEXT_UP_EVENT = 0x4000000;
    private static final int PFLAG_AWAKEN_SCROLL_BARS_ON_ATTACH = 0x8000000;
    private static final int PFLAG_HOVERED = 0x10000000;
    static final int PFLAG_ACTIVATED = 0x40000000;
    static final int PFLAG_INVALIDATED = Integer.MIN_VALUE;
    static final int PFLAG2_DRAG_CAN_ACCEPT = 1;
    static final int PFLAG2_DRAG_HOVERED = 2;
    @ApiStatus.Internal
    public static final int LAYOUT_DIRECTION_UNDEFINED = -1;
    public static final int LAYOUT_DIRECTION_LTR = 0;
    public static final int LAYOUT_DIRECTION_RTL = 1;
    public static final int LAYOUT_DIRECTION_INHERIT = 2;
    public static final int LAYOUT_DIRECTION_LOCALE = 3;
    static final int PFLAG2_LAYOUT_DIRECTION_MASK_SHIFT = 2;
    static final int PFLAG2_LAYOUT_DIRECTION_MASK = 12;
    static final int PFLAG2_LAYOUT_DIRECTION_RESOLVED_RTL = 16;
    static final int PFLAG2_LAYOUT_DIRECTION_RESOLVED = 32;
    static final int PFLAG2_LAYOUT_DIRECTION_RESOLVED_MASK = 48;
    private static final int[] LAYOUT_DIRECTION_FLAGS;
    private static final int LAYOUT_DIRECTION_DEFAULT = 2;
    static final int LAYOUT_DIRECTION_RESOLVED_DEFAULT = 0;
    public static final int TEXT_DIRECTION_INHERIT = 0;
    public static final int TEXT_DIRECTION_FIRST_STRONG = 1;
    public static final int TEXT_DIRECTION_ANY_RTL = 2;
    public static final int TEXT_DIRECTION_LTR = 3;
    public static final int TEXT_DIRECTION_RTL = 4;
    public static final int TEXT_DIRECTION_LOCALE = 5;
    public static final int TEXT_DIRECTION_FIRST_STRONG_LTR = 6;
    public static final int TEXT_DIRECTION_FIRST_STRONG_RTL = 7;
    private static final int TEXT_DIRECTION_DEFAULT = 0;
    static final int TEXT_DIRECTION_RESOLVED_DEFAULT = 1;
    static final int PFLAG2_TEXT_DIRECTION_MASK_SHIFT = 6;
    static final int PFLAG2_TEXT_DIRECTION_MASK = 448;
    private static final int[] PFLAG2_TEXT_DIRECTION_FLAGS;
    static final int PFLAG2_TEXT_DIRECTION_RESOLVED = 512;
    static final int PFLAG2_TEXT_DIRECTION_RESOLVED_MASK_SHIFT = 10;
    static final int PFLAG2_TEXT_DIRECTION_RESOLVED_MASK = 7168;
    static final int PFLAG2_TEXT_DIRECTION_RESOLVED_DEFAULT = 1024;
    public static final int TEXT_ALIGNMENT_INHERIT = 0;
    public static final int TEXT_ALIGNMENT_GRAVITY = 1;
    public static final int TEXT_ALIGNMENT_TEXT_START = 2;
    public static final int TEXT_ALIGNMENT_TEXT_END = 3;
    public static final int TEXT_ALIGNMENT_CENTER = 4;
    public static final int TEXT_ALIGNMENT_VIEW_START = 5;
    public static final int TEXT_ALIGNMENT_VIEW_END = 6;
    private static final int TEXT_ALIGNMENT_DEFAULT = 1;
    static final int TEXT_ALIGNMENT_RESOLVED_DEFAULT = 1;
    static final int PFLAG2_TEXT_ALIGNMENT_MASK_SHIFT = 13;
    static final int PFLAG2_TEXT_ALIGNMENT_MASK = 57344;
    private static final int[] PFLAG2_TEXT_ALIGNMENT_FLAGS;
    static final int PFLAG2_TEXT_ALIGNMENT_RESOLVED = 65536;
    static final int PFLAG2_TEXT_ALIGNMENT_RESOLVED_MASK_SHIFT = 17;
    static final int PFLAG2_TEXT_ALIGNMENT_RESOLVED_MASK = 917504;
    private static final int PFLAG2_TEXT_ALIGNMENT_RESOLVED_DEFAULT = 131072;
    static final int PFLAG2_VIEW_QUICK_REJECTED = 0x10000000;
    static final int PFLAG2_PADDING_RESOLVED = 0x20000000;
    static final int PFLAG2_DRAWABLE_RESOLVED = 0x40000000;
    static final int PFLAG2_HAS_TRANSIENT_STATE = Integer.MIN_VALUE;
    static final int ALL_RTL_PROPERTIES_RESOLVED = 1610678816;
    static final int PFLAG3_VIEW_IS_ANIMATING_TRANSFORM = 1;
    static final int PFLAG3_VIEW_IS_ANIMATING_ALPHA = 2;
    static final int PFLAG3_IS_LAID_OUT = 4;
    static final int PFLAG3_MEASURE_NEEDED_BEFORE_LAYOUT = 8;
    static final int PFLAG3_CALLED_SUPER = 16;
    static final int PFLAG3_APPLYING_INSETS = 32;
    static final int PFLAG3_FITTING_SYSTEM_WINDOWS = 64;
    static final int PFLAG3_NESTED_SCROLLING_ENABLED = 128;
    static final int PFLAG3_SCROLL_INDICATOR_TOP = 256;
    static final int PFLAG3_SCROLL_INDICATOR_BOTTOM = 512;
    static final int PFLAG3_SCROLL_INDICATOR_LEFT = 1024;
    static final int PFLAG3_SCROLL_INDICATOR_RIGHT = 2048;
    static final int PFLAG3_SCROLL_INDICATOR_START = 4096;
    static final int PFLAG3_SCROLL_INDICATOR_END = 8192;
    static final int DRAG_MASK = 3;
    static final int SCROLL_INDICATORS_NONE = 0;
    static final int SCROLL_INDICATORS_PFLAG3_MASK = 16128;
    static final int SCROLL_INDICATORS_TO_PFLAGS3_LSHIFT = 8;
    public static final int SCROLL_INDICATOR_TOP = 1;
    public static final int SCROLL_INDICATOR_BOTTOM = 2;
    public static final int SCROLL_INDICATOR_LEFT = 4;
    public static final int SCROLL_INDICATOR_RIGHT = 8;
    public static final int SCROLL_INDICATOR_START = 16;
    public static final int SCROLL_INDICATOR_END = 32;
    private static final int PFLAG3_CLUSTER = 32768;
    private static final int PFLAG3_FINGER_DOWN = 131072;
    private static final int PFLAG3_FOCUSED_BY_DEFAULT = 262144;
    private static final int PFLAG3_OVERLAPPING_RENDERING_FORCED_VALUE = 0x800000;
    private static final int PFLAG3_HAS_OVERLAPPING_RENDERING_FORCED = 0x1000000;
    static final int PFLAG3_TEMPORARY_DETACH = 0x2000000;
    private static final int PFLAG3_NO_REVEAL_ON_FOCUS = 0x4000000;
    private static final int PFLAG3_SCREEN_READER_FOCUSABLE = 0x10000000;
    private static final int PFLAG3_AGGREGATED_VISIBLE = 0x20000000;
    private static final int PFLAG4_ALLOW_CLICK_WHEN_DISABLED = 4096;
    private static final int PFLAG4_DETACHED = 8192;
    private static final int PFLAG4_HAS_TRANSLATION_TRANSIENT_STATE = 16384;
    public static final int OVER_SCROLL_ALWAYS = 0;
    public static final int OVER_SCROLL_IF_CONTENT_SCROLLS = 1;
    public static final int OVER_SCROLL_NEVER = 2;
    public static final int SCROLL_AXIS_NONE = 0;
    public static final int SCROLL_AXIS_HORIZONTAL = 1;
    public static final int SCROLL_AXIS_VERTICAL = 2;
    public static final int TYPE_TOUCH = 0;
    public static final int TYPE_NON_TOUCH = 1;
    private int mOverScrollMode;
    int mPrivateFlags;
    int mPrivateFlags2;
    int mPrivateFlags3;
    int mPrivateFlags4;
    ViewParent mParent;
    AttachInfo mAttachInfo;
    int mTransientStateCount = 0;
    int mWindowAttachCount;
    ViewGroup.LayoutParams mLayoutParams;
    int mViewFlags;
    private SparseArray<Object> mKeyedTags;
    int mID = -1;
    final RenderNode mRenderNode = new RenderNode();
    private float mAlpha = 1.0f;
    private float mTransitionAlpha = 1.0f;
    int mLeft;
    int mRight;
    int mTop;
    int mBottom;
    protected int mScrollX;
    protected int mScrollY;
    protected int mPaddingLeft = 0;
    protected int mPaddingRight = 0;
    protected int mPaddingTop;
    protected int mPaddingBottom;
    private MatchIdPredicate mMatchIdPredicate;
    int mUserPaddingRight;
    int mUserPaddingBottom;
    int mUserPaddingLeft;
    int mUserPaddingStart;
    int mUserPaddingEnd;
    int mUserPaddingLeftInitial;
    int mUserPaddingRightInitial;
    private static final int UNDEFINED_PADDING = Integer.MIN_VALUE;
    private boolean mLeftPaddingDefined = false;
    private boolean mRightPaddingDefined = false;
    int mMeasuredWidth;
    int mMeasuredHeight;
    int mOldWidthMeasureSpec = Integer.MIN_VALUE;
    int mOldHeightMeasureSpec = Integer.MIN_VALUE;
    private Drawable mBackground;
    private boolean mBackgroundSizeChanged;
    private ForegroundInfo mForegroundInfo;
    private Drawable mScrollIndicatorDrawable;
    boolean mDefaultFocusHighlightEnabled = true;
    private Drawable mDefaultFocusHighlight;
    private Drawable mDefaultFocusHighlightCache;
    private boolean mDefaultFocusHighlightSizeChanged;
    private String mTransitionName;
    ListenerInfo mListenerInfo;
    TooltipInfo mTooltipInfo;
    private float mLongClickX = Float.NaN;
    private float mLongClickY = Float.NaN;
    private Context mContext;
    private ScrollCache mScrollCache;
    private int[] mDrawableState = null;
    private StateListAnimator mStateListAnimator;
    private int mNextFocusLeftId = -1;
    private int mNextFocusRightId = -1;
    private int mNextFocusUpId = -1;
    private int mNextFocusDownId = -1;
    int mNextFocusForwardId = -1;
    int mNextClusterForwardId = -1;
    private CheckForLongPress mPendingCheckForLongPress;
    private CheckForTap mPendingCheckForTap;
    private PerformClick mPerformClick;
    private UnsetPressedState mUnsetPressedState;
    private boolean mHasPerformedLongPress;
    private boolean mInContextButtonPress;
    private boolean mIgnoreNextUpEvent;
    private int mMinHeight;
    private int mMinWidth;
    private ViewTreeObserver mFloatingTreeObserver;
    private ViewParent mNestedScrollingParentTouch;
    private ViewParent mNestedScrollingParentNonTouch;
    private int[] mTempNestedScrollConsumed;
    private HandlerActionQueue mRunQueue;
    public static final FloatProperty<View> ALPHA;
    public static final FloatProperty<View> TRANSLATION_X;
    public static final FloatProperty<View> TRANSLATION_Y;
    public static final FloatProperty<View> TRANSLATION_Z;
    public static final FloatProperty<View> X;
    public static final FloatProperty<View> Y;
    public static final FloatProperty<View> Z;
    public static final FloatProperty<View> ROTATION;
    public static final FloatProperty<View> ROTATION_X;
    public static final FloatProperty<View> ROTATION_Y;
    public static final FloatProperty<View> SCALE_X;
    public static final FloatProperty<View> SCALE_Y;
    public static final IntProperty<View> LEFT;
    public static final IntProperty<View> TOP;
    public static final IntProperty<View> RIGHT;
    public static final IntProperty<View> BOTTOM;
    public static final IntProperty<View> SCROLL_X;
    public static final IntProperty<View> SCROLL_Y;

    public View(Context context) {
        this.mContext = context;
        this.mViewFlags = 0x18000010;
        this.mPrivateFlags2 = 140296;
        this.setOverScrollMode(1);
        this.mUserPaddingStart = Integer.MIN_VALUE;
        this.mUserPaddingEnd = Integer.MIN_VALUE;
    }

    public final boolean isShowingLayoutBounds() {
        return this.mAttachInfo != null && this.mAttachInfo.mDebugLayout;
    }

    final void draw(@NonNull Canvas canvas, @NonNull ViewGroup group, boolean clip) {
        boolean identity = this.hasIdentityMatrix();
        if (clip && identity && canvas.quickReject(this.mLeft, this.mTop, this.mRight, this.mBottom)) {
            return;
        }
        float alpha = this.mAlpha * this.mTransitionAlpha;
        if (alpha <= 0.001f) {
            return;
        }
        this.computeScroll();
        int sx = this.mScrollX;
        int sy = this.mScrollY;
        int saveCount = canvas.save();
        canvas.translate(this.mLeft, this.mTop);
        if (this.mRenderNode.getAnimationMatrix() != null) {
            canvas.concat(this.mRenderNode.getAnimationMatrix());
        }
        if (!identity) {
            canvas.concat(this.getMatrix());
        }
        boolean hasSpace = true;
        if (clip) {
            hasSpace = canvas.clipRect(0.0f, 0.0f, this.mRight - this.mLeft, this.mBottom - this.mTop);
        }
        canvas.translate(-sx, -sy);
        if (hasSpace) {
            if (alpha < 0.999f && canvas instanceof ArcCanvas) {
                ArcCanvas ac = (ArcCanvas)canvas;
                try (AlphaFilterCanvas afc = new AlphaFilterCanvas(ac.getCanvas(), alpha);){
                    ArcCanvas filterCanvas = new ArcCanvas(afc);
                    if ((this.mPrivateFlags & 0x80) == 128) {
                        this.dispatchDraw(filterCanvas);
                    }
                    this.draw(filterCanvas);
                }
            } else if ((this.mPrivateFlags & 0x80) == 128) {
                this.dispatchDraw(canvas);
            } else {
                this.draw(canvas);
            }
        }
        canvas.restoreToCount(saveCount);
    }

    @CallSuper
    public void draw(@NonNull Canvas canvas) {
        this.drawBackground(canvas);
        this.onDraw(canvas);
        this.dispatchDraw(canvas);
        this.onDrawForeground(canvas);
    }

    private void drawBackground(@NonNull Canvas canvas) {
        int scrollY;
        int scrollX;
        Drawable background = this.mBackground;
        if (background == null) {
            return;
        }
        if (this.mBackgroundSizeChanged) {
            background.setBounds(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
            this.mBackgroundSizeChanged = false;
        }
        if (((scrollX = this.mScrollX) | (scrollY = this.mScrollY)) == 0) {
            background.draw(canvas);
        } else {
            canvas.translate(scrollX, scrollY);
            background.draw(canvas);
            canvas.translate(-scrollX, -scrollY);
        }
    }

    protected void onDraw(@NonNull Canvas canvas) {
    }

    protected void dispatchDraw(@NonNull Canvas canvas) {
    }

    public void onDrawForeground(@NonNull Canvas canvas) {
        Drawable foreground;
        this.onDrawScrollIndicators(canvas);
        this.onDrawScrollBars(canvas);
        Drawable drawable = foreground = this.mForegroundInfo != null ? this.mForegroundInfo.mDrawable : null;
        if (foreground != null) {
            if (this.mForegroundInfo.mBoundsChanged) {
                this.mForegroundInfo.mBoundsChanged = false;
                Rect selfBounds = this.mForegroundInfo.mSelfBounds;
                Rect overlayBounds = this.mForegroundInfo.mOverlayBounds;
                if (this.mForegroundInfo.mInsidePadding) {
                    selfBounds.set(0, 0, this.getWidth(), this.getHeight());
                } else {
                    selfBounds.set(this.getPaddingLeft(), this.getPaddingTop(), this.getWidth() - this.getPaddingRight(), this.getHeight() - this.getPaddingBottom());
                }
                int ld = this.getLayoutDirection();
                Gravity.apply(this.mForegroundInfo.mGravity, foreground.getIntrinsicWidth(), foreground.getIntrinsicHeight(), selfBounds, overlayBounds, ld);
                foreground.setBounds(overlayBounds);
            }
            foreground.draw(canvas);
        }
    }

    private void onDrawScrollIndicators(@NonNull Canvas c) {
        boolean canScrollRight;
        int rightMask;
        boolean canScrollLeft;
        int rightRtl;
        int leftRtl;
        boolean canScrollDown;
        boolean canScrollUp;
        if ((this.mPrivateFlags3 & 0x3F00) == 0) {
            return;
        }
        Drawable dr = this.mScrollIndicatorDrawable;
        if (dr == null) {
            return;
        }
        if (this.mAttachInfo == null) {
            return;
        }
        int h = dr.getIntrinsicHeight();
        int w = dr.getIntrinsicWidth();
        Rect rect = this.mAttachInfo.mTmpInvalRect;
        this.getScrollIndicatorBounds(rect);
        if ((this.mPrivateFlags3 & 0x100) != 0 && (canScrollUp = this.canScrollVertically(-1))) {
            dr.setBounds(rect.left, rect.top, rect.right, rect.top + h);
            dr.draw(c);
        }
        if ((this.mPrivateFlags3 & 0x200) != 0 && (canScrollDown = this.canScrollVertically(1))) {
            dr.setBounds(rect.left, rect.bottom - h, rect.right, rect.bottom);
            dr.draw(c);
        }
        if (this.getLayoutDirection() == 1) {
            leftRtl = 8192;
            rightRtl = 4096;
        } else {
            leftRtl = 4096;
            rightRtl = 8192;
        }
        int leftMask = 0x400 | leftRtl;
        if ((this.mPrivateFlags3 & leftMask) != 0 && (canScrollLeft = this.canScrollHorizontally(-1))) {
            dr.setBounds(rect.left, rect.top, rect.left + w, rect.bottom);
            dr.draw(c);
        }
        if ((this.mPrivateFlags3 & (rightMask = 0x800 | rightRtl)) != 0 && (canScrollRight = this.canScrollHorizontally(1))) {
            dr.setBounds(rect.right - w, rect.top, rect.right, rect.bottom);
            dr.draw(c);
        }
    }

    protected final void onDrawScrollBars(@NonNull Canvas canvas) {
        boolean drawVerticalScrollBar;
        ScrollCache cache = this.mScrollCache;
        if (cache == null || cache.mState == 0) {
            return;
        }
        boolean invalidate = false;
        if (cache.mState == 2) {
            long currentTime = AnimationUtils.currentAnimationTimeMillis();
            float fraction = (float)(currentTime - cache.mFadeStartTime) / (float)cache.mFadeDuration;
            if (fraction >= 1.0f) {
                cache.mState = 0;
                return;
            }
            int alpha = 255 - (int)(fraction * 255.0f);
            cache.mScrollBar.mutate().setAlpha(alpha);
            invalidate = true;
        } else {
            cache.mScrollBar.mutate().setAlpha(255);
        }
        boolean drawHorizontalScrollBar = this.isHorizontalScrollBarEnabled();
        boolean bl = drawVerticalScrollBar = this.isVerticalScrollBarEnabled() && !this.isVerticalScrollBarHidden();
        if (drawVerticalScrollBar || drawHorizontalScrollBar) {
            ScrollBar scrollBar = cache.mScrollBar;
            if (drawHorizontalScrollBar) {
                scrollBar.setParameters(this.computeHorizontalScrollRange(), this.computeHorizontalScrollOffset(), this.computeHorizontalScrollExtent(), false);
                Rect bounds = cache.mScrollBarBounds;
                this.getHorizontalScrollBarBounds(bounds, null);
                scrollBar.setBounds(bounds.left, bounds.top, bounds.right, bounds.bottom);
                scrollBar.draw(canvas);
                if (invalidate) {
                    this.invalidate();
                }
            }
            if (drawVerticalScrollBar) {
                scrollBar.setParameters(this.computeVerticalScrollRange(), this.computeVerticalScrollOffset(), this.computeVerticalScrollExtent(), true);
                Rect bounds = cache.mScrollBarBounds;
                this.getVerticalScrollBarBounds(bounds, null);
                scrollBar.setBounds(bounds.left, bounds.top, bounds.right, bounds.bottom);
                scrollBar.draw(canvas);
                if (invalidate) {
                    this.invalidate();
                }
            }
        }
    }

    public void layout(int l, int t, int r, int b) {
        int oldL = this.mLeft;
        int oldT = this.mTop;
        int oldB = this.mBottom;
        int oldR = this.mRight;
        boolean changed = this.setFrame(l, t, r, b);
        if (changed || (this.mPrivateFlags & 0x2000) != 0) {
            this.onLayout(changed, l, t, r, b);
            this.mPrivateFlags &= 0xFFFFDFFF;
            ListenerInfo li = this.mListenerInfo;
            if (li != null && li.mOnLayoutChangeListeners != null) {
                for (OnLayoutChangeListener listener : li.mOnLayoutChangeListeners) {
                    listener.onLayoutChange(this, l, t, r, b, oldL, oldT, oldR, oldB);
                }
            }
        }
        boolean wasLayoutValid = this.isLayoutValid();
        this.mPrivateFlags &= 0xFFFFEFFF;
        this.mPrivateFlags3 |= 4;
        if (!wasLayoutValid && this.isFocused()) {
            this.mPrivateFlags &= 0xFFFFFFFE;
            if (this.canTakeFocus()) {
                this.clearParentsWantFocus();
            } else if (this.getViewRoot() == null || !this.getViewRoot().isInLayout()) {
                this.clearFocusInternal(null, true, false);
                this.clearParentsWantFocus();
            } else if (this.hasNoParentWantsFocus()) {
                this.clearFocusInternal(null, true, false);
            }
        } else if ((this.mPrivateFlags & 1) != 0) {
            this.mPrivateFlags &= 0xFFFFFFFE;
            View focused = this.findFocus();
            if (focused != null && !this.restoreDefaultFocus() && this.hasNoParentWantsFocus()) {
                focused.clearFocusInternal(null, true, false);
            }
        }
    }

    private boolean hasNoParentWantsFocus() {
        ViewParent parent = this.mParent;
        while (parent instanceof ViewGroup) {
            ViewGroup pv = (ViewGroup)parent;
            if ((pv.mPrivateFlags & 1) != 0) {
                return false;
            }
            parent = pv.mParent;
        }
        return true;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
    }

    protected boolean setFrame(int left, int top, int right, int bottom) {
        if (this.mLeft != left || this.mRight != right || this.mTop != top || this.mBottom != bottom) {
            int drawn = this.mPrivateFlags & 0x20;
            int oldWidth = this.mRight - this.mLeft;
            int oldHeight = this.mBottom - this.mTop;
            int newWidth = right - left;
            int newHeight = bottom - top;
            boolean sizeChanged = newWidth != oldWidth || newHeight != oldHeight;
            this.invalidate();
            this.mLeft = left;
            this.mTop = top;
            this.mRight = right;
            this.mBottom = bottom;
            this.mRenderNode.setPosition(this.mLeft, this.mTop, this.mRight, this.mBottom);
            this.mPrivateFlags |= 0x10;
            if (sizeChanged) {
                this.sizeChange(newWidth, newHeight, oldWidth, oldHeight);
            }
            this.mPrivateFlags |= 0x20;
            this.mPrivateFlags |= drawn;
            this.mDefaultFocusHighlightSizeChanged = true;
            this.mBackgroundSizeChanged = true;
            if (this.mForegroundInfo != null) {
                this.mForegroundInfo.mBoundsChanged = true;
            }
            return true;
        }
        return false;
    }

    protected void onSizeChanged(int width, int height, int prevWidth, int prevHeight) {
    }

    public final void measure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean needsLayout;
        boolean bl = needsLayout = (this.mPrivateFlags & 0x1000) == 4096;
        if (!needsLayout) {
            boolean specChanged = widthMeasureSpec != this.mOldWidthMeasureSpec || heightMeasureSpec != this.mOldHeightMeasureSpec;
            boolean isSpecExactly = MeasureSpec.getMode(widthMeasureSpec) == 0x40000000 && MeasureSpec.getMode(heightMeasureSpec) == 0x40000000;
            boolean matchesSpecSize = this.getMeasuredWidth() == MeasureSpec.getSize(widthMeasureSpec) && this.getMeasuredHeight() == MeasureSpec.getSize(heightMeasureSpec);
            boolean bl2 = needsLayout = specChanged && (!isSpecExactly || !matchesSpecSize);
        }
        if (needsLayout) {
            this.mPrivateFlags &= 0xFFFFF7FF;
            this.resolveRtlPropertiesIfNeeded();
            this.onMeasure(widthMeasureSpec, heightMeasureSpec);
            if ((this.mPrivateFlags & 0x800) == 0) {
                throw new IllegalStateException(this.getClass().getName() + "#onMeasure() did not set the measured dimensionby calling setMeasuredDimension()");
            }
            this.mPrivateFlags |= 0x2000;
        }
        this.mOldWidthMeasureSpec = widthMeasureSpec;
        this.mOldHeightMeasureSpec = heightMeasureSpec;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(View.getDefaultSize(this.mMinWidth, widthMeasureSpec), View.getDefaultSize(this.mMinHeight, heightMeasureSpec));
    }

    protected final void setMeasuredDimension(int measuredWidth, int measuredHeight) {
        this.mMeasuredWidth = measuredWidth;
        this.mMeasuredHeight = measuredHeight;
        this.mPrivateFlags |= 0x800;
    }

    public final int getMeasuredWidth() {
        return this.mMeasuredWidth & 0xFFFFFF;
    }

    public final int getMeasuredWidthAndState() {
        return this.mMeasuredWidth;
    }

    public final int getMeasuredHeight() {
        return this.mMeasuredHeight & 0xFFFFFF;
    }

    public final int getMeasuredHeightAndState() {
        return this.mMeasuredHeight;
    }

    public final int getMeasuredState() {
        return this.mMeasuredWidth & 0xFF000000 | this.mMeasuredHeight >> 16 & 0xFFFFFF00;
    }

    public ViewGroup.LayoutParams getLayoutParams() {
        return this.mLayoutParams;
    }

    public void setLayoutParams(@NonNull ViewGroup.LayoutParams params) {
        this.mLayoutParams = Objects.requireNonNull(params);
        this.resolveLayoutParams();
        if (this.mParent instanceof ViewGroup) {
            ((ViewGroup)this.mParent).onSetLayoutParams(this, params);
        }
        this.requestLayout();
    }

    @ApiStatus.Internal
    public void resolveLayoutParams() {
        if (this.mLayoutParams != null) {
            this.mLayoutParams.resolveLayoutDirection(this.getLayoutDirection());
        }
    }

    public static int combineMeasuredStates(int curState, int newState) {
        return curState | newState;
    }

    public static int resolveSize(int size, int measureSpec) {
        return View.resolveSizeAndState(size, measureSpec, 0) & 0xFFFFFF;
    }

    public static int resolveSizeAndState(int size, int measureSpec, int childMeasuredState) {
        int specMode = MeasureSpec.getMode(measureSpec);
        int specSize = MeasureSpec.getSize(measureSpec);
        return (switch (specMode) {
            case Integer.MIN_VALUE -> {
                if (specSize < size) {
                    yield specSize | 0x1000000;
                }
                yield size;
            }
            case 0x40000000 -> specSize;
            default -> size;
        }) | childMeasuredState & 0xFF000000;
    }

    public static int getDefaultSize(int size, int measureSpec) {
        int specMode = MeasureSpec.getMode(measureSpec);
        int specSize = MeasureSpec.getSize(measureSpec);
        return switch (specMode) {
            case Integer.MIN_VALUE, 0x40000000 -> specSize;
            default -> size;
        };
    }

    public final int dp(float value) {
        float f = value * this.getContext().getResources().getDisplayMetrics().density;
        int res = (int)(f >= 0.0f ? f + 0.5f : f - 0.5f);
        if (res != 0) {
            return res;
        }
        if (value == 0.0f) {
            return 0;
        }
        if (value > 0.0f) {
            return 1;
        }
        return -1;
    }

    public final int sp(float value) {
        float f = value * this.getContext().getResources().getDisplayMetrics().scaledDensity;
        int res = (int)(f >= 0.0f ? f + 0.5f : f - 0.5f);
        if (res != 0) {
            return res;
        }
        if (value == 0.0f) {
            return 0;
        }
        if (value > 0.0f) {
            return 1;
        }
        return -1;
    }

    protected int getSuggestedMinimumHeight() {
        return this.mBackground == null ? this.mMinHeight : Math.max(this.mMinHeight, this.mBackground.getMinimumHeight());
    }

    protected int getSuggestedMinimumWidth() {
        return this.mBackground == null ? this.mMinWidth : Math.max(this.mMinWidth, this.mBackground.getMinimumWidth());
    }

    public int getMinimumWidth() {
        return this.mMinWidth;
    }

    public void setMinimumWidth(int minWidth) {
        this.mMinWidth = minWidth;
        this.requestLayout();
    }

    public int getMinimumHeight() {
        return this.mMinHeight;
    }

    public void setMinimumHeight(int minHeight) {
        this.mMinHeight = minHeight;
        this.requestLayout();
    }

    @Nullable
    public final ViewParent getParent() {
        return this.mParent;
    }

    final void assignParent(@Nullable ViewParent parent) {
        if (this.mParent == null) {
            this.mParent = parent;
        } else if (parent == null) {
            this.mParent = null;
        } else {
            throw new IllegalStateException("The parent of view " + this + " has been assigned");
        }
    }

    @ApiStatus.Internal
    public void setIsRootNamespace(boolean isRoot) {
        this.mPrivateFlags = isRoot ? (this.mPrivateFlags |= 8) : (this.mPrivateFlags &= 0xFFFFFFF7);
    }

    @ApiStatus.Internal
    public boolean isRootNamespace() {
        return (this.mPrivateFlags & 8) != 0;
    }

    public int getId() {
        return this.mID;
    }

    public void setId(int id2) {
        this.mID = id2;
    }

    public static int generateViewId() {
        int newValue;
        int result;
        do {
            if ((newValue = (result = sNextGeneratedId.get()) + 1) <= 0xFFFFFF) continue;
            newValue = 65536;
        } while (!sNextGeneratedId.compareAndSet(result, newValue));
        return result;
    }

    @Nullable
    public Object getTag(int key) {
        if (this.mKeyedTags != null) {
            return this.mKeyedTags.get(key);
        }
        return null;
    }

    public void setTag(int key, Object tag) {
        if ((key & 0xFF000000) == 0) {
            throw new IllegalArgumentException("The key must be a valid resource id.");
        }
        if (this.mKeyedTags == null) {
            this.mKeyedTags = new SparseArray(2);
        }
        this.mKeyedTags.put(key, tag);
    }

    public int getVisibility() {
        return this.mViewFlags & 0xC;
    }

    public void setVisibility(int visibility) {
        this.setFlags(visibility, 12);
    }

    public boolean isEnabled() {
        return (this.mViewFlags & 0x20) == 0;
    }

    public void setEnabled(boolean enabled) {
        if (enabled == this.isEnabled()) {
            return;
        }
        this.setFlags(enabled ? 0 : 32, 32);
        this.refreshDrawableState();
        this.invalidate();
        if (!enabled) {
            this.cancelPendingInputEvents();
        }
    }

    public final boolean isFocusable() {
        return (this.mViewFlags & 1) == 1;
    }

    public int getFocusable() {
        return (this.mViewFlags & 0x10) > 0 ? 16 : this.mViewFlags & 1;
    }

    public void setFocusable(boolean focusable) {
        this.setFocusable(focusable ? 1 : 0);
    }

    public void setFocusable(int focusable) {
        if ((focusable & 0x11) == 0) {
            this.setFlags(0, 262144);
        }
        this.setFlags(focusable, 17);
    }

    public final boolean isFocusableInTouchMode() {
        return (this.mViewFlags & 0x40000) == 262144;
    }

    public void setFocusableInTouchMode(boolean focusableInTouchMode) {
        this.setFlags(focusableInTouchMode ? 262144 : 0, 262144);
        if (focusableInTouchMode) {
            this.setFlags(1, 17);
        }
    }

    public boolean isClickable() {
        return (this.mViewFlags & 0x4000) == 16384;
    }

    public void setClickable(boolean clickable) {
        this.setFlags(clickable ? 16384 : 0, 16384);
    }

    public boolean isLongClickable() {
        return (this.mViewFlags & 0x200000) == 0x200000;
    }

    public void setLongClickable(boolean longClickable) {
        this.setFlags(longClickable ? 0x200000 : 0, 0x200000);
    }

    public boolean isContextClickable() {
        return (this.mViewFlags & 0x800000) == 0x800000;
    }

    public void setContextClickable(boolean contextClickable) {
        this.setFlags(contextClickable ? 0x800000 : 0, 0x800000);
    }

    private void setPressed(float x, float y) {
        this.drawableHotspotChanged(x, y);
        this.setPressed(true);
    }

    public void setPressed(boolean pressed) {
        boolean needsRefresh;
        boolean bl = needsRefresh = pressed != ((this.mPrivateFlags & 0x4000) == 16384);
        this.mPrivateFlags = pressed ? (this.mPrivateFlags |= 0x4000) : (this.mPrivateFlags &= 0xFFFFBFFF);
        if (needsRefresh) {
            this.refreshDrawableState();
        }
        this.dispatchSetPressed(pressed);
    }

    protected void dispatchSetPressed(boolean pressed) {
    }

    public boolean isPressed() {
        return (this.mPrivateFlags & 0x4000) == 16384;
    }

    public void setSelected(boolean selected) {
        if ((this.mPrivateFlags & 4) != 0 != selected) {
            this.mPrivateFlags = this.mPrivateFlags & 0xFFFFFFFB | (selected ? 4 : 0);
            if (!selected) {
                this.resetPressedState();
            }
            this.invalidate();
            this.refreshDrawableState();
            this.dispatchSetSelected(selected);
        }
    }

    protected void dispatchSetSelected(boolean selected) {
    }

    public boolean isSelected() {
        return (this.mPrivateFlags & 4) != 0;
    }

    public void setActivated(boolean activated) {
        if ((this.mPrivateFlags & 0x40000000) != 0 != activated) {
            this.mPrivateFlags = this.mPrivateFlags & 0xBFFFFFFF | (activated ? 0x40000000 : 0);
            this.invalidate();
            this.refreshDrawableState();
            this.dispatchSetActivated(activated);
        }
    }

    protected void dispatchSetActivated(boolean activated) {
    }

    public boolean isActivated() {
        return (this.mPrivateFlags & 0x40000000) != 0;
    }

    private boolean hasSize() {
        return this.mBottom > this.mTop && this.mRight > this.mLeft;
    }

    private boolean canTakeFocus() {
        return (this.mViewFlags & 0xC) == 0 && (this.mViewFlags & 1) == 1 && (this.mViewFlags & 0x20) == 0 && (!this.isLayoutValid() || this.hasSize());
    }

    void setFlags(int flags, int mask) {
        int newVisibility;
        int old = this.mViewFlags;
        this.mViewFlags = this.mViewFlags & ~mask | flags & mask;
        int changed = this.mViewFlags ^ old;
        if (changed == 0) {
            return;
        }
        int privateFlags = this.mPrivateFlags;
        boolean shouldNotifyFocusableAvailable = false;
        if ((this.mViewFlags & 0x10) != 0 && (changed & 0x4011) != 0) {
            int newFocus = (this.mViewFlags & 0x4000) != 0 ? 1 : 0;
            this.mViewFlags = this.mViewFlags & 0xFFFFFFFE | newFocus;
            int focusableChangedByAuto = old & 1 ^ newFocus & 1;
            changed = changed & 0xFFFFFFFE | focusableChangedByAuto;
        }
        if ((changed & 1) != 0 && (privateFlags & 0x10) != 0) {
            if ((old & 1) == 1 && (privateFlags & 2) != 0) {
                this.clearFocus();
            } else if ((old & 1) == 0 && (privateFlags & 2) == 0 && this.mParent != null) {
                shouldNotifyFocusableAvailable = this.canTakeFocus();
            }
        }
        if ((newVisibility = flags & 0xC) == 0 && (changed & 0xC) != 0) {
            this.mPrivateFlags |= 0x20;
            this.invalidate();
            shouldNotifyFocusableAvailable = this.hasSize();
        }
        if ((changed & 0x20) != 0) {
            if ((this.mViewFlags & 0x20) == 0) {
                shouldNotifyFocusableAvailable = this.canTakeFocus();
            } else if (this.isFocused()) {
                this.clearFocus();
            }
        }
        if (shouldNotifyFocusableAvailable && this.mParent != null) {
            this.mParent.focusableViewAvailable(this);
        }
        if ((changed & 8) != 0) {
            this.requestLayout();
            if ((this.mViewFlags & 0xC) == 8) {
                if (this.hasFocus()) {
                    this.clearFocus();
                }
                if (this.mParent instanceof View) {
                    ((View)((Object)this.mParent)).invalidate();
                }
                this.mPrivateFlags |= 0x20;
            }
            if (this.mAttachInfo != null) {
                this.mAttachInfo.mViewVisibilityChanged = true;
            }
        }
        if ((changed & 4) != 0) {
            this.mPrivateFlags |= 0x20;
            if ((this.mViewFlags & 0xC) == 4 && this.getRootView() != this && this.hasFocus()) {
                this.clearFocus();
            }
            if (this.mAttachInfo != null) {
                this.mAttachInfo.mViewVisibilityChanged = true;
            }
        }
        if ((changed & 0xC) != 0) {
            ViewParent viewParent;
            if (newVisibility == 0 || this.mAttachInfo != null) {
                // empty if block
            }
            if ((viewParent = this.mParent) instanceof ViewGroup) {
                ViewGroup parent = (ViewGroup)viewParent;
                parent.onChildVisibilityChanged(this, changed & 0xC, newVisibility);
                parent.invalidate();
            }
            if (this.mAttachInfo != null) {
                this.dispatchVisibilityChanged(this, newVisibility);
                if (this.mParent != null && this.getWindowVisibility() == 0 && (!(this.mParent instanceof ViewGroup) || ((ViewGroup)this.mParent).isShown())) {
                    this.dispatchVisibilityAggregated(newVisibility == 0);
                }
            }
        }
        if ((changed & 0x80) != 0) {
            this.mPrivateFlags = (this.mViewFlags & 0x80) != 0 ? (this.mBackground != null || this.mDefaultFocusHighlight != null || this.mForegroundInfo != null && this.mForegroundInfo.mDrawable != null ? (this.mPrivateFlags &= 0xFFFFFF7F) : (this.mPrivateFlags |= 0x80)) : (this.mPrivateFlags &= 0xFFFFFF7F);
            this.requestLayout();
            this.invalidate();
        }
    }

    public final void invalidate() {
        if (!((this.mViewFlags & 0xC) == 0 || this.mParent instanceof ViewGroup && ((ViewGroup)this.mParent).isViewTransitioning(this))) {
            return;
        }
        if (this.mAttachInfo != null) {
            this.mAttachInfo.mViewRoot.invalidate();
        }
    }

    @Override
    public void invalidateDrawable(@NonNull Drawable drawable) {
        if (this.verifyDrawable(drawable)) {
            this.invalidate();
        }
    }

    @Override
    public final void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
        if (this.verifyDrawable(who)) {
            long delay = when - Core.timeMillis();
            if (this.mAttachInfo != null) {
                this.mAttachInfo.mViewRoot.mChoreographer.postCallbackDelayed(1, what, who, delay);
            } else {
                this.getRunQueue().postDelayed(what, delay);
            }
        }
    }

    @Override
    public final void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
        if (this.verifyDrawable(who)) {
            if (this.mAttachInfo != null) {
                this.mAttachInfo.mViewRoot.mChoreographer.removeCallbacks(1, what, who);
            }
            if (this.mRunQueue != null) {
                this.mRunQueue.removeCallbacks(what);
            }
        }
    }

    public final void unscheduleDrawable(@Nullable Drawable who) {
        if (this.mAttachInfo != null && who != null) {
            this.mAttachInfo.mViewRoot.mChoreographer.removeCallbacks(1, null, who);
        }
    }

    @Nullable
    View findUserSetNextFocus(View root, int direction) {
        switch (direction) {
            case 17: {
                if (this.mNextFocusLeftId == -1) {
                    return null;
                }
                return this.findViewInsideOutShouldExist(root, this.mNextFocusLeftId);
            }
            case 66: {
                if (this.mNextFocusRightId == -1) {
                    return null;
                }
                return this.findViewInsideOutShouldExist(root, this.mNextFocusRightId);
            }
            case 33: {
                if (this.mNextFocusUpId == -1) {
                    return null;
                }
                return this.findViewInsideOutShouldExist(root, this.mNextFocusUpId);
            }
            case 130: {
                if (this.mNextFocusDownId == -1) {
                    return null;
                }
                return this.findViewInsideOutShouldExist(root, this.mNextFocusDownId);
            }
            case 2: {
                if (this.mNextFocusForwardId == -1) {
                    return null;
                }
                return this.findViewInsideOutShouldExist(root, this.mNextFocusForwardId);
            }
            case 1: {
                if (this.mID == -1) {
                    return null;
                }
                View rootView = root;
                View startView = this;
                return root.findViewByPredicateInsideOut(startView, t -> this.findViewInsideOutShouldExist(rootView, (View)t, t.mNextFocusForwardId) == startView);
            }
        }
        return null;
    }

    View findUserSetNextKeyboardNavigationCluster(View root, int direction) {
        switch (direction) {
            case 2: {
                if (this.mNextClusterForwardId == -1) {
                    return null;
                }
                return this.findViewInsideOutShouldExist(root, this.mNextClusterForwardId);
            }
            case 1: {
                if (this.mID == -1) {
                    return null;
                }
                int id2 = this.mID;
                return root.findViewByPredicateInsideOut(this, t -> t.mNextClusterForwardId == id2);
            }
        }
        return null;
    }

    private View findViewInsideOutShouldExist(View root, int id2) {
        return this.findViewInsideOutShouldExist(root, this, id2);
    }

    private View findViewInsideOutShouldExist(View root, View start, int id2) {
        if (this.mMatchIdPredicate == null) {
            this.mMatchIdPredicate = new MatchIdPredicate();
        }
        this.mMatchIdPredicate.mId = id2;
        return root.findViewByPredicateInsideOut(start, this.mMatchIdPredicate);
    }

    @NonNull
    public final ArrayList<View> getFocusables(int direction) {
        ArrayList<View> result = new ArrayList<View>();
        this.addFocusables(result, direction);
        return result;
    }

    public final void addFocusables(ArrayList<View> views, int direction) {
        this.addFocusables(views, direction, this.isInTouchMode() ? 1 : 0);
    }

    public void addFocusables(@NonNull ArrayList<View> views, int direction, int focusableMode) {
        if (!this.canTakeFocus()) {
            return;
        }
        if ((focusableMode & 1) == 1 && !this.isFocusableInTouchMode()) {
            return;
        }
        views.add(this);
    }

    public void addKeyboardNavigationClusters(@NonNull Collection<View> views, int direction) {
        if (!this.isKeyboardNavigationCluster()) {
            return;
        }
        if (!this.hasFocusable()) {
            return;
        }
        views.add(this);
    }

    @NonNull
    public final ArrayList<View> getTouchables() {
        ArrayList<View> result = new ArrayList<View>();
        this.addTouchables(result);
        return result;
    }

    public void addTouchables(@NonNull ArrayList<View> views) {
        int viewFlags = this.mViewFlags;
        if (((viewFlags & 0x4000) == 16384 || (viewFlags & 0x200000) == 0x200000 || (viewFlags & 0x800000) == 0x800000) && (viewFlags & 0x20) == 0) {
            views.add(this);
        }
    }

    public final boolean requestFocus() {
        return this.requestFocus(130);
    }

    boolean restoreFocusInCluster(int direction) {
        if (this.restoreDefaultFocus()) {
            return true;
        }
        return this.requestFocus(direction);
    }

    boolean restoreFocusNotInCluster() {
        return this.requestFocus(130);
    }

    public boolean restoreDefaultFocus() {
        return this.requestFocus(130);
    }

    public final boolean requestFocus(int direction) {
        return this.requestFocus(direction, null);
    }

    public boolean requestFocus(int direction, @Nullable Rect previouslyFocusedRect) {
        return this.requestFocusNoSearch(direction, previouslyFocusedRect);
    }

    private boolean requestFocusNoSearch(int direction, @Nullable Rect previouslyFocusedRect) {
        if (!this.canTakeFocus()) {
            return false;
        }
        boolean focusableInTouchMode = this.isFocusableInTouchMode();
        if (this.isInTouchMode() && !focusableInTouchMode) {
            return false;
        }
        ViewParent ancestor = this.mParent;
        while (ancestor instanceof ViewGroup) {
            ViewGroup vgAncestor = (ViewGroup)ancestor;
            if (vgAncestor.getDescendantFocusability() == 393216 || !focusableInTouchMode && vgAncestor.shouldBlockFocusForTouchscreen()) {
                return false;
            }
            ancestor = vgAncestor.getParent();
        }
        if (!this.isLayoutValid()) {
            this.mPrivateFlags |= 1;
        } else {
            this.clearParentsWantFocus();
        }
        this.handleFocusGainInternal(direction, previouslyFocusedRect);
        return true;
    }

    void clearParentsWantFocus() {
        ViewParent viewParent = this.mParent;
        if (viewParent instanceof View) {
            View v = (View)((Object)viewParent);
            v.mPrivateFlags &= 0xFFFFFFFE;
            v.clearParentsWantFocus();
        }
    }

    void handleFocusGainInternal(int direction, @Nullable Rect previouslyFocusedRect) {
        if ((this.mPrivateFlags & 2) == 0) {
            View oldFocus;
            this.mPrivateFlags |= 2;
            View view = oldFocus = this.mAttachInfo != null ? this.getRootView().findFocus() : null;
            if (this.mParent != null) {
                this.mParent.requestChildFocus(this, this);
                this.updateFocusedInCluster(oldFocus, direction);
            }
            if (this.mAttachInfo != null) {
                this.mAttachInfo.mTreeObserver.dispatchOnGlobalFocusChange(oldFocus, this);
            }
            this.onFocusChanged(true, direction, previouslyFocusedRect);
            this.refreshDrawableState();
        }
    }

    @ApiStatus.Internal
    public final void setFocusedInCluster() {
        this.setFocusedInCluster(this.findKeyboardNavigationCluster());
    }

    private void setFocusedInCluster(View cluster) {
        if (this instanceof ViewGroup) {
            ((ViewGroup)this).mFocusedInCluster = null;
        }
        if (cluster == this) {
            return;
        }
        ViewParent parent = this.mParent;
        View child = this;
        while (parent instanceof ViewGroup) {
            ((ViewGroup)parent).mFocusedInCluster = child;
            if (parent == cluster) break;
            child = (View)((Object)parent);
            parent = parent.getParent();
        }
    }

    private void updateFocusedInCluster(View oldFocus, int direction) {
        View cluster;
        View oldCluster;
        if (oldFocus != null && (oldCluster = oldFocus.findKeyboardNavigationCluster()) != (cluster = this.findKeyboardNavigationCluster())) {
            oldFocus.setFocusedInCluster(oldCluster);
            if (!(oldFocus.mParent instanceof ViewGroup)) {
                return;
            }
            if (direction == 2 || direction == 1) {
                ((ViewGroup)oldFocus.mParent).clearFocusedInCluster(oldFocus);
            } else if (oldFocus instanceof ViewGroup && ((ViewGroup)oldFocus).getDescendantFocusability() == 262144 && ViewRoot.isViewDescendantOf(this, oldFocus)) {
                ((ViewGroup)oldFocus.mParent).clearFocusedInCluster(oldFocus);
            }
        }
    }

    public final void setRevealOnFocusHint(boolean revealOnFocus) {
        this.mPrivateFlags3 = revealOnFocus ? (this.mPrivateFlags3 &= 0xFBFFFFFF) : (this.mPrivateFlags3 |= 0x4000000);
    }

    public final boolean getRevealOnFocusHint() {
        return (this.mPrivateFlags3 & 0x4000000) == 0;
    }

    public boolean requestRectangleOnScreen(Rect rectangle) {
        return this.requestRectangleOnScreen(rectangle, false);
    }

    public boolean requestRectangleOnScreen(Rect rectangle, boolean immediate) {
        if (this.mParent == null) {
            return false;
        }
        View child = this;
        RectF position = this.mAttachInfo != null ? this.mAttachInfo.mTmpTransformRect : new RectF();
        position.set(rectangle);
        ViewParent parent = this.mParent;
        boolean scrolled = false;
        while (parent != null) {
            rectangle.set((int)position.left, (int)position.top, (int)position.right, (int)position.bottom);
            scrolled |= parent.requestChildRectangleOnScreen(child, rectangle, immediate);
            if (!(parent instanceof View)) break;
            position.offset(child.mLeft - child.getScrollX(), child.mTop - child.getScrollY());
            child = (View)((Object)parent);
            parent = child.getParent();
        }
        return scrolled;
    }

    public final boolean isFocusedByDefault() {
        return (this.mPrivateFlags3 & 0x40000) != 0;
    }

    public void setFocusedByDefault(boolean isFocusedByDefault) {
        if (isFocusedByDefault == ((this.mPrivateFlags3 & 0x40000) != 0)) {
            return;
        }
        this.mPrivateFlags3 = isFocusedByDefault ? (this.mPrivateFlags3 |= 0x40000) : (this.mPrivateFlags3 &= 0xFFFBFFFF);
        if (this.mParent instanceof ViewGroup) {
            if (isFocusedByDefault) {
                ((ViewGroup)this.mParent).setDefaultFocus(this);
            } else {
                ((ViewGroup)this.mParent).clearDefaultFocus(this);
            }
        }
    }

    boolean hasDefaultFocus() {
        return this.isFocusedByDefault();
    }

    public View keyboardNavigationClusterSearch(View currentCluster, int direction) {
        if (this.isKeyboardNavigationCluster()) {
            currentCluster = this;
        }
        if (this.isRootNamespace()) {
            return FocusFinder.getInstance().findNextKeyboardNavigationCluster(this, currentCluster, direction);
        }
        if (this.mParent != null) {
            return this.mParent.keyboardNavigationClusterSearch(currentCluster, direction);
        }
        return null;
    }

    public void clearFocus() {
        this.clearFocusInternal(null, true, !this.isInTouchMode());
    }

    void clearFocusInternal(View focused, boolean propagate, boolean refocus) {
        if ((this.mPrivateFlags & 2) != 0) {
            this.mPrivateFlags &= 0xFFFFFFFD;
            this.clearParentsWantFocus();
            if (propagate && this.mParent != null) {
                this.mParent.clearChildFocus(this);
            }
            this.onFocusChanged(false, 0, null);
            this.refreshDrawableState();
            if (!(!propagate || refocus && this.rootViewRequestFocus())) {
                this.notifyGlobalFocusCleared(this);
            }
        }
    }

    void notifyGlobalFocusCleared(View oldFocus) {
        if (oldFocus != null && this.mAttachInfo != null) {
            this.mAttachInfo.mTreeObserver.dispatchOnGlobalFocusChange(oldFocus, null);
        }
    }

    boolean rootViewRequestFocus() {
        View root = this.getRootView();
        return root != null && root.requestFocus();
    }

    void unFocus(View focused) {
        this.clearFocusInternal(focused, false, false);
    }

    public boolean hasFocus() {
        return (this.mPrivateFlags & 2) != 0;
    }

    public final boolean hasFocusable() {
        return this.hasFocusable(true, false);
    }

    public final boolean hasExplicitFocusable() {
        return this.hasFocusable(false, true);
    }

    boolean hasFocusable(boolean allowAutoFocus, boolean dispatchExplicit) {
        if (!this.isFocusableInTouchMode()) {
            ViewParent p = this.mParent;
            while (p instanceof ViewGroup) {
                ViewGroup g = (ViewGroup)p;
                if (g.shouldBlockFocusForTouchscreen()) {
                    return false;
                }
                p = p.getParent();
            }
        }
        if ((this.mViewFlags & 0xC) != 0 || (this.mViewFlags & 0x20) != 0) {
            return false;
        }
        return (allowAutoFocus || this.getFocusable() != 16) && this.isFocusable();
    }

    @CallSuper
    protected void onFocusChanged(boolean gainFocus, int direction, @Nullable Rect previouslyFocusedRect) {
        if (!gainFocus) {
            if (this.isPressed()) {
                this.setPressed(false);
            }
            this.resetPressedState();
        }
        this.invalidate();
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnFocusChangeListener != null) {
            li.mOnFocusChangeListener.onFocusChange(this, gainFocus);
        }
        if (this.mAttachInfo != null) {
            this.mAttachInfo.mKeyDispatchState.reset(this);
        }
    }

    private void resetPressedState() {
        if ((this.mViewFlags & 0x20) == 32) {
            return;
        }
        if (this.isPressed()) {
            this.setPressed(false);
            if (!this.mHasPerformedLongPress) {
                this.removeLongPressCallback();
            }
        }
    }

    public boolean isFocused() {
        return (this.mPrivateFlags & 2) != 0;
    }

    @Nullable
    public View findFocus() {
        return this.isFocused() ? this : null;
    }

    @Nullable
    public View focusSearch(int direction) {
        if (this.mParent != null) {
            return this.mParent.focusSearch(this, direction);
        }
        return null;
    }

    public final boolean isKeyboardNavigationCluster() {
        return (this.mPrivateFlags3 & 0x8000) != 0;
    }

    @Nullable
    View findKeyboardNavigationCluster() {
        if (this.mParent instanceof View) {
            View cluster = ((View)((Object)this.mParent)).findKeyboardNavigationCluster();
            if (cluster != null) {
                return cluster;
            }
            if (this.isKeyboardNavigationCluster()) {
                return this;
            }
        }
        return null;
    }

    public void setKeyboardNavigationCluster(boolean isCluster) {
        this.mPrivateFlags3 = isCluster ? (this.mPrivateFlags3 |= 0x8000) : (this.mPrivateFlags3 &= 0xFFFF7FFF);
    }

    public int getNextFocusLeftId() {
        return this.mNextFocusLeftId;
    }

    public void setNextFocusLeftId(int nextFocusLeftId) {
        this.mNextFocusLeftId = nextFocusLeftId;
    }

    public int getNextFocusRightId() {
        return this.mNextFocusRightId;
    }

    public void setNextFocusRightId(int nextFocusRightId) {
        this.mNextFocusRightId = nextFocusRightId;
    }

    public int getNextFocusUpId() {
        return this.mNextFocusUpId;
    }

    public void setNextFocusUpId(int nextFocusUpId) {
        this.mNextFocusUpId = nextFocusUpId;
    }

    public int getNextFocusDownId() {
        return this.mNextFocusDownId;
    }

    public void setNextFocusDownId(int nextFocusDownId) {
        this.mNextFocusDownId = nextFocusDownId;
    }

    public int getNextFocusForwardId() {
        return this.mNextFocusForwardId;
    }

    public void setNextFocusForwardId(int nextFocusForwardId) {
        this.mNextFocusForwardId = nextFocusForwardId;
    }

    public int getNextClusterForwardId() {
        return this.mNextClusterForwardId;
    }

    public void setNextClusterForwardId(int nextClusterForwardId) {
        this.mNextClusterForwardId = nextClusterForwardId;
    }

    public boolean isShown() {
        ViewParent parent;
        View current = this;
        do {
            if ((current.mViewFlags & 0xC) != 0) {
                return false;
            }
            parent = current.mParent;
            if (parent == null) {
                return false;
            }
            if (parent instanceof View) continue;
            return true;
        } while ((current = (View)((Object)parent)) != null);
        return false;
    }

    public void setHorizontalScrollBarEnabled(boolean enabled) {
        if (this.isHorizontalScrollBarEnabled() != enabled) {
            this.mViewFlags ^= 0x100;
            this.resolvePadding();
        }
    }

    public void setVerticalScrollBarEnabled(boolean enabled) {
        if (this.isVerticalScrollBarEnabled() != enabled) {
            this.mViewFlags ^= 0x200;
            this.resolvePadding();
        }
    }

    public boolean isHorizontalScrollBarEnabled() {
        return (this.mViewFlags & 0x100) != 0;
    }

    public boolean isVerticalScrollBarEnabled() {
        return (this.mViewFlags & 0x200) != 0;
    }

    private void initializeScrollIndicatorsInternal() {
        if (this.mScrollIndicatorDrawable == null) {
            this.mScrollIndicatorDrawable = new Drawable(){

                @Override
                public void draw(@NonNull Canvas canvas) {
                    Paint paint = Paint.obtain();
                    paint.setRGBA(0, 0, 0, 31);
                    canvas.drawRect(this.getBounds(), paint);
                    paint.recycle();
                }
            };
        }
    }

    private void initScrollCache() {
        if (this.mScrollCache == null) {
            this.mScrollCache = new ScrollCache(this);
        }
    }

    private void initializeScrollBarDrawable() {
        this.initScrollCache();
        if (this.mScrollCache.mScrollBar == null) {
            this.mScrollCache.mScrollBar = new ScrollBar();
            this.mScrollCache.mScrollBar.setState(this.getDrawableState());
            this.mScrollCache.mScrollBar.setCallback(this);
        }
    }

    public void setScrollbarFadingEnabled(boolean fadeScrollbars) {
        this.initScrollCache();
        ScrollCache scrollCache = this.mScrollCache;
        scrollCache.mFadeScrollBars = fadeScrollbars;
        scrollCache.mState = fadeScrollbars ? 0 : 1;
    }

    public boolean isScrollbarFadingEnabled() {
        return this.mScrollCache != null && this.mScrollCache.mFadeScrollBars;
    }

    private ScrollCache getScrollCache() {
        this.initScrollCache();
        return this.mScrollCache;
    }

    public int getScrollBarDefaultDelayBeforeFade() {
        return this.mScrollCache == null ? ViewConfiguration.getScrollDefaultDelay() : this.mScrollCache.mDefaultDelayBeforeFade;
    }

    public void setScrollBarDefaultDelayBeforeFade(int scrollBarDefaultDelayBeforeFade) {
        this.getScrollCache().mDefaultDelayBeforeFade = scrollBarDefaultDelayBeforeFade;
    }

    public int getScrollBarFadeDuration() {
        return this.mScrollCache == null ? ViewConfiguration.getScrollBarFadeDuration() : this.mScrollCache.mFadeDuration;
    }

    public void setScrollBarFadeDuration(int scrollBarFadeDuration) {
        this.getScrollCache().mFadeDuration = scrollBarFadeDuration;
    }

    public int getScrollBarSize() {
        return this.mScrollCache == null ? ViewConfiguration.get(this.mContext).getScaledScrollbarSize() : this.mScrollCache.mScrollBarSize;
    }

    public void setScrollBarSize(int scrollBarSize) {
        this.getScrollCache().mScrollBarSize = scrollBarSize;
    }

    public void setScrollBarStyle(int style) {
        if (style != (this.mViewFlags & 0x3000000)) {
            this.mViewFlags = this.mViewFlags & 0xFCFFFFFF | style & 0x3000000;
            this.resolvePadding();
        }
    }

    public int getScrollBarStyle() {
        return this.mViewFlags & 0x3000000;
    }

    public void setVerticalScrollbarThumbDrawable(@Nullable Drawable drawable) {
        this.initializeScrollBarDrawable();
        this.mScrollCache.mScrollBar.setVerticalThumbDrawable(drawable);
    }

    public void setVerticalScrollbarTrackDrawable(@Nullable Drawable drawable) {
        this.initializeScrollBarDrawable();
        this.mScrollCache.mScrollBar.setVerticalTrackDrawable(drawable);
    }

    public void setHorizontalScrollbarThumbDrawable(@Nullable Drawable drawable) {
        this.initializeScrollBarDrawable();
        this.mScrollCache.mScrollBar.setHorizontalThumbDrawable(drawable);
    }

    public void setHorizontalScrollbarTrackDrawable(@Nullable Drawable drawable) {
        this.initializeScrollBarDrawable();
        this.mScrollCache.mScrollBar.setHorizontalTrackDrawable(drawable);
    }

    @Nullable
    public Drawable getVerticalScrollbarThumbDrawable() {
        return this.mScrollCache != null && this.mScrollCache.mScrollBar != null ? this.mScrollCache.mScrollBar.getVerticalThumbDrawable() : null;
    }

    @Nullable
    public Drawable getVerticalScrollbarTrackDrawable() {
        return this.mScrollCache != null && this.mScrollCache.mScrollBar != null ? this.mScrollCache.mScrollBar.getVerticalTrackDrawable() : null;
    }

    @Nullable
    public Drawable getHorizontalScrollbarThumbDrawable() {
        return this.mScrollCache != null && this.mScrollCache.mScrollBar != null ? this.mScrollCache.mScrollBar.getHorizontalThumbDrawable() : null;
    }

    @Nullable
    public Drawable getHorizontalScrollbarTrackDrawable() {
        return this.mScrollCache != null && this.mScrollCache.mScrollBar != null ? this.mScrollCache.mScrollBar.getHorizontalTrackDrawable() : null;
    }

    public void scrollTo(int x, int y) {
        if (this.mScrollX != x || this.mScrollY != y) {
            int oldX = this.mScrollX;
            int oldY = this.mScrollY;
            this.mScrollX = x;
            this.mScrollY = y;
            this.onScrollChanged(this.mScrollX, this.mScrollY, oldX, oldY);
            if (!this.awakenScrollBars()) {
                this.postInvalidateOnAnimation();
            }
        }
    }

    public void scrollBy(int x, int y) {
        this.scrollTo(this.mScrollX + x, this.mScrollY + y);
    }

    protected final boolean awakenScrollBars() {
        return this.mScrollCache != null && this.awakenScrollBars(this.mScrollCache.mDefaultDelayBeforeFade);
    }

    private void initialAwakenScrollBars() {
        if (this.mScrollCache != null) {
            this.awakenScrollBars(this.mScrollCache.mDefaultDelayBeforeFade * 4);
        }
    }

    protected boolean awakenScrollBars(int startDelay) {
        ScrollCache scrollCache = this.mScrollCache;
        if (scrollCache == null || !scrollCache.mFadeScrollBars) {
            return false;
        }
        this.initializeScrollBarDrawable();
        if (this.isHorizontalScrollBarEnabled() || this.isVerticalScrollBarEnabled()) {
            long fadeStartTime;
            this.postInvalidateOnAnimation();
            startDelay = scrollCache.mState == 0 ? Math.max(1500, startDelay) : Math.max(0, startDelay);
            scrollCache.mFadeStartTime = fadeStartTime = AnimationUtils.currentAnimationTimeMillis() + (long)startDelay;
            scrollCache.mState = 1;
            if (this.mAttachInfo != null) {
                this.mAttachInfo.mHandler.removeCallbacks(scrollCache);
                this.mAttachInfo.mHandler.postAtTime(scrollCache, fadeStartTime);
            }
            return true;
        }
        return false;
    }

    public void setScrollX(int value) {
        this.scrollTo(value, this.mScrollY);
    }

    public void setScrollY(int value) {
        this.scrollTo(this.mScrollX, value);
    }

    public final int getScrollX() {
        return this.mScrollX;
    }

    public final int getScrollY() {
        return this.mScrollY;
    }

    protected int computeHorizontalScrollRange() {
        return this.getWidth();
    }

    protected int computeHorizontalScrollOffset() {
        return this.mScrollX;
    }

    protected int computeHorizontalScrollExtent() {
        return this.getWidth();
    }

    protected int computeVerticalScrollRange() {
        return this.getHeight();
    }

    protected int computeVerticalScrollOffset() {
        return this.mScrollY;
    }

    protected int computeVerticalScrollExtent() {
        return this.getHeight();
    }

    public boolean canScrollHorizontally(int direction) {
        int offset = this.computeHorizontalScrollOffset();
        int range = this.computeHorizontalScrollRange() - this.computeHorizontalScrollExtent();
        if (range == 0) {
            return false;
        }
        if (direction < 0) {
            return offset > 0;
        }
        return offset < range - 1;
    }

    public boolean canScrollVertically(int direction) {
        int offset = this.computeVerticalScrollOffset();
        int range = this.computeVerticalScrollRange() - this.computeVerticalScrollExtent();
        if (range == 0) {
            return false;
        }
        if (direction < 0) {
            return offset > 0;
        }
        return offset < range - 1;
    }

    void getScrollIndicatorBounds(@NonNull Rect out) {
        out.left = this.mScrollX;
        out.right = this.mScrollX + this.mRight - this.mLeft;
        out.top = this.mScrollY;
        out.bottom = this.mScrollY + this.mBottom - this.mTop;
    }

    private void getHorizontalScrollBarBounds(@Nullable Rect drawBounds, @Nullable Rect touchBounds) {
        int adjust;
        Rect bounds;
        Rect rect = bounds = drawBounds != null ? drawBounds : touchBounds;
        if (bounds == null) {
            return;
        }
        int inside = (this.mViewFlags & 0x2000000) == 0 ? -1 : 0;
        boolean drawVerticalScrollBar = this.isVerticalScrollBarEnabled() && !this.isVerticalScrollBarHidden();
        int size = this.getHorizontalScrollbarHeight();
        int verticalScrollBarGap = drawVerticalScrollBar ? this.getVerticalScrollbarWidth() : 0;
        int width = this.mRight - this.mLeft;
        int height = this.mBottom - this.mTop;
        bounds.top = this.mScrollY + height - size - (this.mUserPaddingBottom & inside);
        bounds.left = this.mScrollX + (this.mPaddingLeft & inside);
        bounds.right = this.mScrollX + width - (this.mUserPaddingRight & inside) - verticalScrollBarGap;
        bounds.bottom = bounds.top + size;
        if (touchBounds == null) {
            return;
        }
        if (touchBounds != bounds) {
            touchBounds.set(bounds);
        }
        int minTouchTarget = this.mScrollCache.mScrollBarMinTouchTarget;
        if (touchBounds.height() < minTouchTarget) {
            adjust = (minTouchTarget - touchBounds.height()) / 2;
            touchBounds.bottom = Math.min(touchBounds.bottom + adjust, this.mScrollY + height);
            touchBounds.top = touchBounds.bottom - minTouchTarget;
        }
        if (touchBounds.width() < minTouchTarget) {
            adjust = (minTouchTarget - touchBounds.width()) / 2;
            touchBounds.left -= adjust;
            touchBounds.right = touchBounds.left + minTouchTarget;
        }
    }

    private void getVerticalScrollBarBounds(@Nullable Rect drawBounds, @Nullable Rect touchBounds) {
        int adjust;
        Rect bounds;
        Rect rect = bounds = drawBounds != null ? drawBounds : touchBounds;
        if (bounds == null) {
            return;
        }
        int inside = (this.mViewFlags & 0x2000000) == 0 ? -1 : 0;
        int size = this.getVerticalScrollbarWidth();
        boolean layoutRtl = this.isLayoutRtl();
        int width = this.mRight - this.mLeft;
        int height = this.mBottom - this.mTop;
        bounds.left = layoutRtl ? this.mScrollX + (this.mUserPaddingLeft & inside) : this.mScrollX + width - size - (this.mUserPaddingRight & inside);
        bounds.top = this.mScrollY + (this.mPaddingTop & inside);
        bounds.right = bounds.left + size;
        bounds.bottom = this.mScrollY + height - (this.mUserPaddingBottom & inside);
        if (touchBounds == null) {
            return;
        }
        if (touchBounds != bounds) {
            touchBounds.set(bounds);
        }
        int minTouchTarget = this.mScrollCache.mScrollBarMinTouchTarget;
        if (touchBounds.width() < minTouchTarget) {
            adjust = (minTouchTarget - touchBounds.width()) / 2;
            if (layoutRtl) {
                touchBounds.left = Math.max(touchBounds.left + adjust, this.mScrollX);
                touchBounds.right = touchBounds.left + minTouchTarget;
            } else {
                touchBounds.right = Math.min(touchBounds.right + adjust, this.mScrollX + width);
                touchBounds.left = touchBounds.right - minTouchTarget;
            }
        }
        if (touchBounds.height() < minTouchTarget) {
            adjust = (minTouchTarget - touchBounds.height()) / 2;
            touchBounds.top -= adjust;
            touchBounds.bottom = touchBounds.top + minTouchTarget;
        }
    }

    @ApiStatus.Internal
    protected boolean isVerticalScrollBarHidden() {
        return false;
    }

    boolean isOnScrollbar(float x, float y) {
        boolean canScrollHorizontally;
        boolean canScrollVertically;
        if (this.mScrollCache == null) {
            return false;
        }
        x += (float)this.getScrollX();
        y += (float)this.getScrollY();
        boolean bl = canScrollVertically = this.computeVerticalScrollRange() > this.computeVerticalScrollExtent();
        if (this.isVerticalScrollBarEnabled() && !this.isVerticalScrollBarHidden() && canScrollVertically) {
            Rect touchBounds = this.mScrollCache.mScrollBarTouchBounds;
            this.getVerticalScrollBarBounds(null, touchBounds);
            if (touchBounds.contains((int)x, (int)y)) {
                return true;
            }
        }
        boolean bl2 = canScrollHorizontally = this.computeHorizontalScrollRange() > this.computeHorizontalScrollExtent();
        if (this.isHorizontalScrollBarEnabled() && canScrollHorizontally) {
            Rect touchBounds = this.mScrollCache.mScrollBarTouchBounds;
            this.getHorizontalScrollBarBounds(null, touchBounds);
            return touchBounds.contains((int)x, (int)y);
        }
        return false;
    }

    boolean isOnScrollbarThumb(float x, float y) {
        return this.isOnVerticalScrollbarThumb(x, y) || this.isOnHorizontalScrollbarThumb(x, y);
    }

    private boolean isOnVerticalScrollbarThumb(float x, float y) {
        int extent;
        if (this.mScrollCache == null || !this.isVerticalScrollBarEnabled() || this.isVerticalScrollBarHidden()) {
            return false;
        }
        int range = this.computeVerticalScrollRange();
        if (range > (extent = this.computeVerticalScrollExtent())) {
            x += (float)this.getScrollX();
            y += (float)this.getScrollY();
            Rect bounds = this.mScrollCache.mScrollBarBounds;
            Rect touchBounds = this.mScrollCache.mScrollBarTouchBounds;
            this.getVerticalScrollBarBounds(bounds, touchBounds);
            int offset = this.computeVerticalScrollOffset();
            int thumbLength = ScrollCache.getThumbLength(bounds.height(), bounds.width(), extent, range);
            int thumbOffset = ScrollCache.getThumbOffset(bounds.height(), thumbLength, extent, range, offset);
            int thumbTop = bounds.top + thumbOffset;
            int adjust = Math.max(this.mScrollCache.mScrollBarMinTouchTarget - thumbLength, 0) / 2;
            return x >= (float)touchBounds.left && x <= (float)touchBounds.right && y >= (float)(thumbTop - adjust) && y <= (float)(thumbTop + thumbLength + adjust);
        }
        return false;
    }

    private boolean isOnHorizontalScrollbarThumb(float x, float y) {
        int extent;
        if (this.mScrollCache == null || !this.isHorizontalScrollBarEnabled()) {
            return false;
        }
        int range = this.computeHorizontalScrollRange();
        if (range > (extent = this.computeHorizontalScrollExtent())) {
            x += (float)this.getScrollX();
            y += (float)this.getScrollY();
            Rect bounds = this.mScrollCache.mScrollBarBounds;
            Rect touchBounds = this.mScrollCache.mScrollBarTouchBounds;
            this.getHorizontalScrollBarBounds(bounds, touchBounds);
            int offset = this.computeHorizontalScrollOffset();
            int thumbLength = ScrollCache.getThumbLength(bounds.width(), bounds.height(), extent, range);
            int thumbOffset = ScrollCache.getThumbOffset(bounds.width(), thumbLength, extent, range, offset);
            int thumbLeft = bounds.left + thumbOffset;
            int adjust = Math.max(this.mScrollCache.mScrollBarMinTouchTarget - thumbLength, 0) / 2;
            return x >= (float)(thumbLeft - adjust) && x <= (float)(thumbLeft + thumbLength + adjust) && y >= (float)touchBounds.top && y <= (float)touchBounds.bottom;
        }
        return false;
    }

    boolean isDraggingScrollBar() {
        return this.mScrollCache != null && this.mScrollCache.mScrollBarDraggingState != 0;
    }

    public void setScrollIndicators(int indicators) {
        this.setScrollIndicators(indicators, 63);
    }

    public void setScrollIndicators(int indicators, int mask) {
        int updatedFlags;
        mask <<= 8;
        indicators <<= 8;
        if (this.mPrivateFlags3 != (updatedFlags = (indicators &= (mask &= 0x3F00)) | this.mPrivateFlags3 & ~mask)) {
            this.mPrivateFlags3 = updatedFlags;
            if (indicators != 0) {
                this.initializeScrollIndicatorsInternal();
            }
            this.invalidate();
        }
    }

    public int getScrollIndicators() {
        return (this.mPrivateFlags3 & 0x3F00) >>> 8;
    }

    public int getVerticalScrollbarWidth() {
        ScrollCache cache = this.mScrollCache;
        if (cache != null) {
            ScrollBar scrollBar = cache.mScrollBar;
            if (scrollBar != null) {
                int size = scrollBar.getSize(true);
                if (size <= 0) {
                    size = cache.mScrollBarSize;
                }
                return size;
            }
            return 0;
        }
        return 0;
    }

    protected int getHorizontalScrollbarHeight() {
        ScrollCache cache = this.mScrollCache;
        if (cache != null) {
            ScrollBar scrollBar = cache.mScrollBar;
            if (scrollBar != null) {
                int size = scrollBar.getSize(false);
                if (size <= 0) {
                    size = cache.mScrollBarSize;
                }
                return size;
            }
            return 0;
        }
        return 0;
    }

    public int getVerticalFadingEdgeLength() {
        ScrollCache cache;
        if (this.isVerticalFadingEdgeEnabled() && (cache = this.mScrollCache) != null) {
            return cache.fadingEdgeLength;
        }
        return 0;
    }

    public void computeScroll() {
    }

    public boolean isHorizontalFadingEdgeEnabled() {
        return (this.mViewFlags & 0x1000) == 4096;
    }

    public void setHorizontalFadingEdgeEnabled(boolean horizontalFadingEdgeEnabled) {
        if (this.isHorizontalFadingEdgeEnabled() != horizontalFadingEdgeEnabled) {
            if (horizontalFadingEdgeEnabled) {
                this.initScrollCache();
            }
            this.mViewFlags ^= 0x1000;
        }
    }

    public boolean isVerticalFadingEdgeEnabled() {
        return (this.mViewFlags & 0x2000) == 8192;
    }

    public void setVerticalFadingEdgeEnabled(boolean verticalFadingEdgeEnabled) {
        if (this.isVerticalFadingEdgeEnabled() != verticalFadingEdgeEnabled) {
            if (verticalFadingEdgeEnabled) {
                this.initScrollCache();
            }
            this.mViewFlags ^= 0x2000;
        }
    }

    @ApiStatus.Internal
    public int getFadingEdge() {
        return this.mViewFlags & 0x3000;
    }

    @ApiStatus.Internal
    public int getFadingEdgeLength() {
        if (this.mScrollCache != null && (this.mViewFlags & 0x3000) != 0) {
            return this.mScrollCache.fadingEdgeLength;
        }
        return 0;
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        AttachInfo ai;
        this.mBackgroundSizeChanged = true;
        this.mDefaultFocusHighlightSizeChanged = true;
        if (this.mForegroundInfo != null) {
            this.mForegroundInfo.mBoundsChanged = true;
        }
        if ((ai = this.mAttachInfo) != null) {
            ai.mViewScrollChanged = true;
        }
        if (this.mListenerInfo != null && this.mListenerInfo.mOnScrollChangeListener != null) {
            this.mListenerInfo.mOnScrollChangeListener.onScrollChange(this, l, t, oldl, oldt);
        }
    }

    protected boolean overScrollBy(int deltaX, int deltaY, int scrollX, int scrollY, int scrollRangeX, int scrollRangeY, int maxOverScrollX, int maxOverScrollY, boolean isTouchEvent) {
        int overScrollMode = this.mOverScrollMode;
        boolean canScrollHorizontal = this.computeHorizontalScrollRange() > this.computeHorizontalScrollExtent();
        boolean canScrollVertical = this.computeVerticalScrollRange() > this.computeVerticalScrollExtent();
        boolean overScrollHorizontal = overScrollMode == 0 || overScrollMode == 1 && canScrollHorizontal;
        boolean overScrollVertical = overScrollMode == 0 || overScrollMode == 1 && canScrollVertical;
        int newScrollX = scrollX + deltaX;
        if (!overScrollHorizontal) {
            maxOverScrollX = 0;
        }
        int newScrollY = scrollY + deltaY;
        if (!overScrollVertical) {
            maxOverScrollY = 0;
        }
        int left = -maxOverScrollX;
        int right = maxOverScrollX + scrollRangeX;
        int top = -maxOverScrollY;
        int bottom = maxOverScrollY + scrollRangeY;
        boolean clampedX = false;
        if (newScrollX > right) {
            newScrollX = right;
            clampedX = true;
        } else if (newScrollX < left) {
            newScrollX = left;
            clampedX = true;
        }
        boolean clampedY = false;
        if (newScrollY > bottom) {
            newScrollY = bottom;
            clampedY = true;
        } else if (newScrollY < top) {
            newScrollY = top;
            clampedY = true;
        }
        this.onOverScrolled(newScrollX, newScrollY, clampedX, clampedY);
        return clampedX || clampedY;
    }

    protected void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
    }

    public int getOverScrollMode() {
        return this.mOverScrollMode;
    }

    public void setOverScrollMode(int overScrollMode) {
        if (overScrollMode != 0 && overScrollMode != 1 && overScrollMode != 2) {
            throw new IllegalArgumentException("Invalid overscroll mode " + overScrollMode);
        }
        this.mOverScrollMode = overScrollMode;
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        if (enabled) {
            this.mPrivateFlags3 |= 0x80;
        } else if (this.isNestedScrollingEnabled()) {
            this.stopNestedScroll(0);
            this.mPrivateFlags3 &= 0xFFFFFF7F;
        }
    }

    public boolean isNestedScrollingEnabled() {
        return (this.mPrivateFlags3 & 0x80) == 128;
    }

    public boolean startNestedScroll(int axes, int type) {
        if (this.hasNestedScrollingParent(type)) {
            return true;
        }
        if (this.isNestedScrollingEnabled()) {
            View child = this;
            for (ViewParent p = this.getParent(); p != null; p = p.getParent()) {
                if (p.onStartNestedScroll(child, this, axes, type)) {
                    if (type == 1) {
                        this.mNestedScrollingParentNonTouch = p;
                    } else {
                        this.mNestedScrollingParentTouch = p;
                    }
                    p.onNestedScrollAccepted(child, this, axes, type);
                    return true;
                }
                if (!(p instanceof View)) continue;
                child = (View)((Object)p);
            }
        }
        return false;
    }

    public void stopNestedScroll(int type) {
        if (type == 1) {
            if (this.mNestedScrollingParentNonTouch != null) {
                this.mNestedScrollingParentNonTouch.onStopNestedScroll(this, type);
                this.mNestedScrollingParentNonTouch = null;
            }
        } else if (this.mNestedScrollingParentTouch != null) {
            this.mNestedScrollingParentTouch.onStopNestedScroll(this, type);
            this.mNestedScrollingParentTouch = null;
        }
    }

    public boolean hasNestedScrollingParent(int type) {
        if (type == 1) {
            return this.mNestedScrollingParentNonTouch != null;
        }
        return this.mNestedScrollingParentTouch != null;
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, @Nullable int[] offsetInWindow, int type, @NonNull int[] consumed) {
        if (this.isNestedScrollingEnabled()) {
            ViewParent parent;
            ViewParent viewParent = parent = type == 1 ? this.mNestedScrollingParentNonTouch : this.mNestedScrollingParentTouch;
            if (parent == null) {
                return false;
            }
            if (dxConsumed != 0 || dyConsumed != 0 || dxUnconsumed != 0 || dyUnconsumed != 0) {
                int startX = 0;
                int startY = 0;
                if (offsetInWindow != null) {
                    this.getLocationInWindow(offsetInWindow);
                    startX = offsetInWindow[0];
                    startY = offsetInWindow[1];
                }
                parent.onNestedScroll(this, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, type, consumed);
                if (offsetInWindow != null) {
                    this.getLocationInWindow(offsetInWindow);
                    offsetInWindow[0] = offsetInWindow[0] - startX;
                    offsetInWindow[1] = offsetInWindow[1] - startY;
                }
                return true;
            }
            if (offsetInWindow != null) {
                offsetInWindow[0] = 0;
                offsetInWindow[1] = 0;
            }
        }
        return false;
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, @Nullable int[] consumed, @Nullable int[] offsetInWindow, int type) {
        if (this.isNestedScrollingEnabled()) {
            ViewParent parent;
            ViewParent viewParent = parent = type == 1 ? this.mNestedScrollingParentNonTouch : this.mNestedScrollingParentTouch;
            if (parent == null) {
                return false;
            }
            if (dx != 0 || dy != 0) {
                int startX = 0;
                int startY = 0;
                if (offsetInWindow != null) {
                    this.getLocationInWindow(offsetInWindow);
                    startX = offsetInWindow[0];
                    startY = offsetInWindow[1];
                }
                if (consumed == null) {
                    if (this.mTempNestedScrollConsumed == null) {
                        this.mTempNestedScrollConsumed = new int[2];
                    }
                    consumed = this.mTempNestedScrollConsumed;
                }
                consumed[0] = 0;
                consumed[1] = 0;
                parent.onNestedPreScroll(this, dx, dy, consumed, type);
                if (offsetInWindow != null) {
                    this.getLocationInWindow(offsetInWindow);
                    offsetInWindow[0] = offsetInWindow[0] - startX;
                    offsetInWindow[1] = offsetInWindow[1] - startY;
                }
                return consumed[0] != 0 || consumed[1] != 0;
            }
            if (offsetInWindow != null) {
                offsetInWindow[0] = 0;
                offsetInWindow[1] = 0;
            }
        }
        return false;
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        if (this.isNestedScrollingEnabled() && this.mNestedScrollingParentTouch != null) {
            return this.mNestedScrollingParentTouch.onNestedFling(this, velocityX, velocityY, consumed);
        }
        return false;
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        if (this.isNestedScrollingEnabled() && this.mNestedScrollingParentTouch != null) {
            return this.mNestedScrollingParentTouch.onNestedPreFling(this, velocityX, velocityY);
        }
        return false;
    }

    public final int getWidth() {
        return this.mRight - this.mLeft;
    }

    public final int getHeight() {
        return this.mBottom - this.mTop;
    }

    public void getDrawingRect(@NonNull Rect outRect) {
        outRect.left = this.mScrollX;
        outRect.top = this.mScrollY;
        outRect.right = this.mScrollX + (this.mRight - this.mLeft);
        outRect.bottom = this.mScrollY + (this.mBottom - this.mTop);
    }

    public final int getLeft() {
        return this.mLeft;
    }

    public final void setLeft(int left) {
        if (left != this.mLeft) {
            this.invalidate();
            int oldWidth = this.mRight - this.mLeft;
            int height = this.mBottom - this.mTop;
            this.mLeft = left;
            this.mRenderNode.setLeft(left);
            this.sizeChange(this.mRight - this.mLeft, height, oldWidth, height);
            this.mBackgroundSizeChanged = true;
            this.mDefaultFocusHighlightSizeChanged = true;
            if (this.mForegroundInfo != null) {
                this.mForegroundInfo.mBoundsChanged = true;
            }
        }
    }

    public final int getTop() {
        return this.mTop;
    }

    public final void setTop(int top) {
        if (top != this.mTop) {
            this.invalidate();
            int width = this.mRight - this.mLeft;
            int oldHeight = this.mBottom - this.mTop;
            this.mTop = top;
            this.mRenderNode.setTop(this.mTop);
            this.sizeChange(width, this.mBottom - this.mTop, width, oldHeight);
            this.mBackgroundSizeChanged = true;
            this.mDefaultFocusHighlightSizeChanged = true;
            if (this.mForegroundInfo != null) {
                this.mForegroundInfo.mBoundsChanged = true;
            }
        }
    }

    public final int getRight() {
        return this.mRight;
    }

    public final void setRight(int right) {
        if (right != this.mRight) {
            this.invalidate();
            int oldWidth = this.mRight - this.mLeft;
            int height = this.mBottom - this.mTop;
            this.mRight = right;
            this.mRenderNode.setRight(this.mRight);
            this.sizeChange(this.mRight - this.mLeft, height, oldWidth, height);
            this.mBackgroundSizeChanged = true;
            this.mDefaultFocusHighlightSizeChanged = true;
            if (this.mForegroundInfo != null) {
                this.mForegroundInfo.mBoundsChanged = true;
            }
        }
    }

    public final int getBottom() {
        return this.mBottom;
    }

    public final void setBottom(int bottom) {
        if (bottom != this.mBottom) {
            this.invalidate();
            int width = this.mRight - this.mLeft;
            int oldHeight = this.mBottom - this.mTop;
            this.mBottom = bottom;
            this.mRenderNode.setBottom(this.mBottom);
            this.sizeChange(width, this.mBottom - this.mTop, width, oldHeight);
            this.mBackgroundSizeChanged = true;
            this.mDefaultFocusHighlightSizeChanged = true;
            if (this.mForegroundInfo != null) {
                this.mForegroundInfo.mBoundsChanged = true;
            }
        }
    }

    private void sizeChange(int newWidth, int newHeight, int oldWidth, int oldHeight) {
        this.onSizeChanged(newWidth, newHeight, oldWidth, oldHeight);
        if (!(!this.isLayoutValid() || this.mParent instanceof ViewGroup && ((ViewGroup)this.mParent).isLayoutSuppressed())) {
            if (newWidth <= 0 || newHeight <= 0) {
                if (this.hasFocus()) {
                    this.clearFocus();
                }
            } else if ((oldWidth <= 0 || oldHeight <= 0) && this.mParent != null && this.canTakeFocus()) {
                this.mParent.focusableViewAvailable(this);
            }
        }
    }

    public final Matrix getMatrix() {
        return this.mRenderNode.getMatrix();
    }

    public final Matrix getInverseMatrix() {
        return this.mRenderNode.getInverseMatrix();
    }

    public final boolean hasIdentityMatrix() {
        Matrix matrix = this.mRenderNode.getMatrix();
        return matrix == null || matrix.isIdentity();
    }

    public float getX() {
        return (float)this.mLeft + this.getTranslationX();
    }

    public void setX(float x) {
        this.setTranslationX(x - (float)this.mLeft);
    }

    public float getY() {
        return (float)this.mTop + this.getTranslationY();
    }

    public void setY(float y) {
        this.setTranslationY(y - (float)this.mTop);
    }

    public float getZ() {
        return this.getElevation() + this.getTranslationZ();
    }

    public void setZ(float z) {
        this.setTranslationZ(z - this.getElevation());
    }

    public float getElevation() {
        return this.mRenderNode.getElevation();
    }

    public void setElevation(float elevation) {
        if (this.mRenderNode.setElevation(elevation)) {
            this.invalidate();
        }
    }

    public float getTranslationX() {
        return this.mRenderNode.getTranslationX();
    }

    public void setTranslationX(float translationX) {
        if (this.mRenderNode.setTranslationX(translationX)) {
            this.invalidate();
        }
    }

    public float getTranslationY() {
        return this.mRenderNode.getTranslationY();
    }

    public void setTranslationY(float translationY) {
        if (this.mRenderNode.setTranslationY(translationY)) {
            this.invalidate();
        }
    }

    public float getTranslationZ() {
        return this.mRenderNode.getTranslationZ();
    }

    public void setTranslationZ(float translationZ) {
        if (this.mRenderNode.setTranslationZ(translationZ)) {
            this.invalidate();
        }
    }

    public float getRotation() {
        return this.mRenderNode.getRotationZ();
    }

    public void setRotation(float rotation) {
        if (this.mRenderNode.setRotationZ(rotation)) {
            this.invalidate();
        }
    }

    public float getRotationY() {
        return this.mRenderNode.getRotationY();
    }

    public void setRotationY(float rotationY) {
        if (this.mRenderNode.setRotationY(rotationY)) {
            this.invalidate();
        }
    }

    public float getRotationX() {
        return this.mRenderNode.getRotationX();
    }

    public void setRotationX(float rotationX) {
        if (this.mRenderNode.setRotationX(rotationX)) {
            this.invalidate();
        }
    }

    public float getScaleX() {
        return this.mRenderNode.getScaleX();
    }

    public void setScaleX(float scaleX) {
        if (this.mRenderNode.setScaleX(scaleX)) {
            this.invalidate();
        }
    }

    public float getScaleY() {
        return this.mRenderNode.getScaleY();
    }

    public void setScaleY(float scaleY) {
        if (this.mRenderNode.setScaleY(scaleY)) {
            this.invalidate();
        }
    }

    public float getPivotX() {
        return this.mRenderNode.getPivotX();
    }

    public void setPivotX(float pivotX) {
        if (this.mRenderNode.setPivotX(pivotX)) {
            this.invalidate();
        }
    }

    public float getPivotY() {
        return this.mRenderNode.getPivotY();
    }

    public void setPivotY(float pivotY) {
        if (this.mRenderNode.setPivotY(pivotY)) {
            this.invalidate();
        }
    }

    public boolean isPivotSet() {
        return this.mRenderNode.isPivotExplicitlySet();
    }

    public void resetPivot() {
        if (this.mRenderNode.resetPivot()) {
            this.invalidate();
        }
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    public void forceHasOverlappingRendering(boolean hasOverlappingRendering) {
        this.mPrivateFlags3 |= 0x1000000;
        this.mPrivateFlags3 = hasOverlappingRendering ? (this.mPrivateFlags3 |= 0x800000) : (this.mPrivateFlags3 &= 0xFF7FFFFF);
    }

    public final boolean getHasOverlappingRendering() {
        return (this.mPrivateFlags3 & 0x1000000) != 0 ? (this.mPrivateFlags3 & 0x800000) != 0 : this.hasOverlappingRendering();
    }

    public boolean hasOverlappingRendering() {
        return true;
    }

    public void setAlpha(float alpha) {
        if (this.mAlpha != alpha) {
            this.mAlpha = alpha;
            this.invalidate();
        }
    }

    public final void setTransitionAlpha(float alpha) {
        if (this.mTransitionAlpha != alpha) {
            this.mTransitionAlpha = alpha;
            this.invalidate();
        }
    }

    public final float getTransitionAlpha() {
        return this.mTransitionAlpha;
    }

    public final void setAnimationMatrix(@Nullable Matrix matrix) {
        this.mRenderNode.setAnimationMatrix(matrix);
    }

    @Nullable
    public final Matrix getAnimationMatrix() {
        return this.mRenderNode.getAnimationMatrix();
    }

    public StateListAnimator getStateListAnimator() {
        return this.mStateListAnimator;
    }

    public void setStateListAnimator(@Nullable StateListAnimator stateListAnimator) {
        if (this.mStateListAnimator == stateListAnimator) {
            return;
        }
        if (this.mStateListAnimator != null) {
            this.mStateListAnimator.setTarget(null);
        }
        this.mStateListAnimator = stateListAnimator;
        if (stateListAnimator != null) {
            stateListAnimator.setTarget(this);
            if (this.isAttachedToWindow()) {
                stateListAnimator.setState(this.getDrawableState());
            }
        }
    }

    int combineVisibility(int vis1, int vis2) {
        return Math.max(vis1, vis2);
    }

    void dispatchAttachedToWindow(AttachInfo info, int visibility) {
        int vis;
        CopyOnWriteArrayList<OnAttachStateChangeListener> listeners;
        this.mAttachInfo = info;
        ++this.mWindowAttachCount;
        this.mPrivateFlags |= 0x400;
        if (this.mFloatingTreeObserver != null) {
            info.mTreeObserver.merge(this.mFloatingTreeObserver);
            this.mFloatingTreeObserver = null;
        }
        if (this.mRunQueue != null) {
            this.mRunQueue.executeActions(info.mHandler);
            this.mRunQueue = null;
        }
        this.onAttachedToWindow();
        ListenerInfo li = this.mListenerInfo;
        CopyOnWriteArrayList<OnAttachStateChangeListener> copyOnWriteArrayList = listeners = li != null ? li.mOnAttachStateChangeListeners : null;
        if (listeners != null && !listeners.isEmpty()) {
            for (OnAttachStateChangeListener listener : listeners) {
                listener.onViewAttachedToWindow(this);
            }
        }
        if ((vis = info.mWindowVisibility) != 8) {
            this.onWindowVisibilityChanged(vis);
            if (this.isShown()) {
                this.onVisibilityAggregated(vis == 0);
            }
        }
        this.onVisibilityChanged(this, visibility);
        if ((this.mPrivateFlags & 0x400) != 0) {
            this.refreshDrawableState();
        }
    }

    void dispatchDetachedFromWindow() {
        ListenerInfo li;
        CopyOnWriteArrayList<OnAttachStateChangeListener> listeners;
        int vis;
        AttachInfo info = this.mAttachInfo;
        if (info != null && (vis = info.mWindowVisibility) != 8) {
            this.onWindowVisibilityChanged(8);
            if (this.isShown()) {
                this.onVisibilityAggregated(false);
            }
        }
        this.onDetachedFromWindow();
        this.mPrivateFlags &= 0xFBFFFFFF;
        this.mPrivateFlags3 &= 0xFFFFFFFB;
        this.mPrivateFlags3 &= 0xFDFFFFFF;
        this.removeUnsetPressCallback();
        this.removeLongPressCallback();
        this.removePerformClickCallback();
        this.stopNestedScroll(0);
        this.jumpDrawablesToCurrentState();
        if ((this.mViewFlags & 0x40000000) == 0x40000000) {
            this.hideTooltip();
        }
        CopyOnWriteArrayList<OnAttachStateChangeListener> copyOnWriteArrayList = listeners = (li = this.mListenerInfo) != null ? li.mOnAttachStateChangeListeners : null;
        if (listeners != null && !listeners.isEmpty()) {
            for (OnAttachStateChangeListener listener : listeners) {
                listener.onViewDetachedFromWindow(this);
            }
        }
        this.mAttachInfo = null;
    }

    @CallSuper
    protected void onAttachedToWindow() {
        this.mPrivateFlags3 &= 0xFFFFFFFB;
        this.jumpDrawablesToCurrentState();
    }

    protected void onDetachedFromWindow() {
    }

    public boolean isAttachedToWindow() {
        return this.mAttachInfo != null;
    }

    protected int getWindowAttachCount() {
        return this.mWindowAttachCount;
    }

    public boolean hasTransientState() {
        return (this.mPrivateFlags2 & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    public void setHasTransientState(boolean hasTransientState) {
        boolean oldHasTransientState = this.hasTransientState();
        int n = this.mTransientStateCount = hasTransientState ? this.mTransientStateCount + 1 : this.mTransientStateCount - 1;
        if (this.mTransientStateCount < 0) {
            this.mTransientStateCount = 0;
        } else if (hasTransientState && this.mTransientStateCount == 1 || !hasTransientState && this.mTransientStateCount == 0) {
            this.mPrivateFlags2 = this.mPrivateFlags2 & Integer.MAX_VALUE | (hasTransientState ? Integer.MIN_VALUE : 0);
            boolean newHasTransientState = this.hasTransientState();
            if (this.mParent != null && newHasTransientState != oldHasTransientState) {
                this.mParent.childHasTransientStateChanged(this, newHasTransientState);
            }
        }
    }

    @ApiStatus.Internal
    public void setHasTranslationTransientState(boolean hasTranslationTransientState) {
        this.mPrivateFlags4 = hasTranslationTransientState ? (this.mPrivateFlags4 |= 0x4000) : (this.mPrivateFlags4 &= 0xFFFFBFFF);
    }

    @ApiStatus.Internal
    public boolean hasTranslationTransientState() {
        return (this.mPrivateFlags4 & 0x4000) == 16384;
    }

    public final void cancelPendingInputEvents() {
        this.dispatchCancelPendingInputEvents();
    }

    void dispatchCancelPendingInputEvents() {
        this.mPrivateFlags3 &= 0xFFFFFFEF;
        this.onCancelPendingInputEvents();
        if ((this.mPrivateFlags3 & 0x10) != 16) {
            throw new IllegalStateException("View " + this.getClass().getSimpleName() + " did not call through to super.onCancelPendingInputEvents()");
        }
    }

    public void onCancelPendingInputEvents() {
        this.removePerformClickCallback();
        this.cancelLongPress();
        this.mPrivateFlags3 |= 0x10;
    }

    public void setDuplicateParentStateEnabled(boolean enabled) {
        this.setFlags(enabled ? 0x400000 : 0, 0x400000);
    }

    public boolean isDuplicateParentStateEnabled() {
        return (this.mViewFlags & 0x400000) == 0x400000;
    }

    public boolean isLaidOut() {
        return (this.mPrivateFlags3 & 4) == 4;
    }

    boolean isLayoutValid() {
        return this.isLaidOut() && (this.mPrivateFlags & 0x1000) == 0;
    }

    public void setWillNotDraw(boolean willNotDraw) {
        this.setFlags(willNotDraw ? 128 : 0, 128);
    }

    public boolean willNotDraw() {
        return (this.mViewFlags & 0x80) == 128;
    }

    public void setSoundEffectsEnabled(boolean soundEffectsEnabled) {
        this.setFlags(soundEffectsEnabled ? 0x8000000 : 0, 0x8000000);
    }

    public boolean isSoundEffectsEnabled() {
        return 0x8000000 == (this.mViewFlags & 0x8000000);
    }

    public void setHapticFeedbackEnabled(boolean hapticFeedbackEnabled) {
        this.setFlags(hapticFeedbackEnabled ? 0x10000000 : 0, 0x10000000);
    }

    public boolean isHapticFeedbackEnabled() {
        return 0x10000000 == (this.mViewFlags & 0x10000000);
    }

    public void playSoundEffect(int soundConstant) {
        if (this.mAttachInfo == null || this.mAttachInfo.mRootCallbacks == null || !this.isSoundEffectsEnabled()) {
            return;
        }
        this.mAttachInfo.mRootCallbacks.playSoundEffect(soundConstant);
    }

    public final boolean performHapticFeedback(int feedbackConstant) {
        return this.performHapticFeedback(feedbackConstant, 0);
    }

    public boolean performHapticFeedback(int feedbackConstant, int flags) {
        if (this.mAttachInfo == null) {
            return false;
        }
        if ((flags & 1) == 0 && !this.isHapticFeedbackEnabled()) {
            return false;
        }
        return this.mAttachInfo.mRootCallbacks.performHapticFeedback(feedbackConstant, (flags & 2) != 0);
    }

    @ApiStatus.Internal
    public final int getRawLayoutDirection() {
        return (this.mPrivateFlags2 & 0xC) >> 2;
    }

    public void setLayoutDirection(int layoutDirection) {
        if (this.getRawLayoutDirection() != layoutDirection) {
            this.mPrivateFlags2 &= 0xFFFFFFF3;
            this.resetRtlProperties();
            this.mPrivateFlags2 |= layoutDirection << 2 & 0xC;
            this.resolveRtlPropertiesIfNeeded();
            this.requestLayout();
            this.invalidate();
        }
    }

    public final int getLayoutDirection() {
        return (this.mPrivateFlags2 & 0x10) == 16 ? 1 : 0;
    }

    @ApiStatus.Internal
    public final boolean isLayoutRtl() {
        return this.getLayoutDirection() == 1;
    }

    @ApiStatus.Internal
    public boolean resolveRtlPropertiesIfNeeded() {
        if ((this.mPrivateFlags2 & 0x60010220) == 1610678816) {
            return false;
        }
        if (!this.isLayoutDirectionResolved()) {
            this.resolveLayoutDirection();
            this.resolveLayoutParams();
        }
        if (!this.isTextDirectionResolved()) {
            this.resolveTextDirection();
        }
        if (!this.isTextAlignmentResolved()) {
            this.resolveTextAlignment();
        }
        if (!this.areDrawablesResolved()) {
            this.resolveDrawables();
        }
        if (!this.isPaddingResolved()) {
            this.resolvePadding();
        }
        this.onRtlPropertiesChanged(this.getLayoutDirection());
        return true;
    }

    @ApiStatus.Internal
    void resetRtlProperties() {
        this.resetResolvedLayoutDirection();
        this.resetResolvedTextDirection();
        this.resetResolvedTextAlignment();
        this.resetResolvedPadding();
        this.resetResolvedDrawables();
    }

    protected void onRtlPropertiesChanged(int layoutDirection) {
    }

    @ApiStatus.Internal
    public boolean resolveLayoutDirection() {
        this.mPrivateFlags2 &= 0xFFFFFFCF;
        if (ModernUI.getInstance().hasRtlSupport()) {
            switch (this.getRawLayoutDirection()) {
                case 2: {
                    if (!this.canResolveLayoutDirection()) {
                        return false;
                    }
                    try {
                        if (!this.mParent.isLayoutDirectionResolved()) {
                            return false;
                        }
                        if (this.mParent.getLayoutDirection() != 1) break;
                        this.mPrivateFlags2 |= 0x10;
                    }
                    catch (AbstractMethodError e) {
                        ModernUI.LOGGER.error(VIEW_MARKER, this.mParent.getClass().getSimpleName() + " does not fully implement ViewParent", (Throwable)e);
                    }
                    break;
                }
                case 1: {
                    this.mPrivateFlags2 |= 0x10;
                    break;
                }
                case 3: {
                    if (TextUtils.getLayoutDirectionFromLocale(ModernUI.getSelectedLocale()) != 1) break;
                    this.mPrivateFlags2 |= 0x10;
                    break;
                }
            }
        }
        this.mPrivateFlags2 |= 0x20;
        return true;
    }

    public final boolean canResolveLayoutDirection() {
        if (this.isLayoutDirectionInherited()) {
            if (this.mParent != null) {
                try {
                    return this.mParent.canResolveLayoutDirection();
                }
                catch (AbstractMethodError e) {
                    ModernUI.LOGGER.error(VIEW_MARKER, this.mParent.getClass().getSimpleName() + " does not fully implement ViewParent", (Throwable)e);
                }
            }
            return false;
        }
        return true;
    }

    @ApiStatus.Internal
    void resetResolvedLayoutDirection() {
        this.mPrivateFlags2 &= 0xFFFFFFCF;
    }

    @ApiStatus.Internal
    public final boolean isLayoutDirectionInherited() {
        return this.getRawLayoutDirection() == 2;
    }

    public final boolean isLayoutDirectionResolved() {
        return (this.mPrivateFlags2 & 0x20) == 32;
    }

    @ApiStatus.Internal
    public final int getRawTextDirection() {
        return (this.mPrivateFlags2 & 0x1C0) >> 6;
    }

    public void setTextDirection(int textDirection) {
        if (this.getRawTextDirection() != textDirection) {
            this.mPrivateFlags2 &= 0xFFFFFE3F;
            this.resetResolvedTextDirection();
            this.mPrivateFlags2 |= textDirection << 6 & 0x1C0;
            this.resolveTextDirection();
            this.onRtlPropertiesChanged(this.getLayoutDirection());
            this.requestLayout();
            this.invalidate();
        }
    }

    public final int getTextDirection() {
        return (this.mPrivateFlags2 & 0x1C00) >> 10;
    }

    @ApiStatus.Internal
    public boolean resolveTextDirection() {
        this.mPrivateFlags2 &= 0xFFFFE1FF;
        if (ModernUI.getInstance().hasRtlSupport()) {
            int textDirection = this.getRawTextDirection();
            block2 : switch (textDirection) {
                case 0: {
                    int parentResolvedDirection;
                    if (!this.canResolveTextDirection()) {
                        this.mPrivateFlags2 |= 0x400;
                        return false;
                    }
                    try {
                        if (!this.mParent.isTextDirectionResolved()) {
                            this.mPrivateFlags2 |= 0x400;
                            return false;
                        }
                    }
                    catch (AbstractMethodError e) {
                        ModernUI.LOGGER.error(VIEW_MARKER, this.mParent.getClass().getSimpleName() + " does not fully implement ViewParent", (Throwable)e);
                        this.mPrivateFlags2 |= 0x600;
                        return true;
                    }
                    try {
                        parentResolvedDirection = this.mParent.getTextDirection();
                    }
                    catch (AbstractMethodError e) {
                        ModernUI.LOGGER.error(VIEW_MARKER, this.mParent.getClass().getSimpleName() + " does not fully implement ViewParent", (Throwable)e);
                        parentResolvedDirection = 3;
                    }
                    switch (parentResolvedDirection) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            this.mPrivateFlags2 |= parentResolvedDirection << 10;
                            break block2;
                        }
                    }
                    this.mPrivateFlags2 |= 0x400;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.mPrivateFlags2 |= textDirection << 10;
                    break;
                }
                default: {
                    this.mPrivateFlags2 |= 0x400;
                }
            }
        } else {
            this.mPrivateFlags2 |= 0x400;
        }
        this.mPrivateFlags2 |= 0x200;
        return true;
    }

    public final boolean canResolveTextDirection() {
        if (this.isTextDirectionInherited()) {
            if (this.mParent != null) {
                try {
                    return this.mParent.canResolveTextDirection();
                }
                catch (AbstractMethodError e) {
                    ModernUI.LOGGER.error(VIEW_MARKER, this.mParent.getClass().getSimpleName() + " does not fully implement ViewParent", (Throwable)e);
                }
            }
            return false;
        }
        return true;
    }

    @ApiStatus.Internal
    void resetResolvedTextDirection() {
        this.mPrivateFlags2 &= 0xFFFFE1FF;
        this.mPrivateFlags2 |= 0x400;
    }

    @ApiStatus.Internal
    public final boolean isTextDirectionInherited() {
        return this.getRawTextDirection() == 0;
    }

    public final boolean isTextDirectionResolved() {
        return (this.mPrivateFlags2 & 0x200) == 512;
    }

    @ApiStatus.Internal
    public final int getRawTextAlignment() {
        return (this.mPrivateFlags2 & 0xE000) >> 13;
    }

    public void setTextAlignment(int textAlignment) {
        if (textAlignment != this.getRawTextAlignment()) {
            this.mPrivateFlags2 &= 0xFFFF1FFF;
            this.resetResolvedTextAlignment();
            this.mPrivateFlags2 |= textAlignment << 13 & 0xE000;
            this.resolveTextAlignment();
            this.onRtlPropertiesChanged(this.getLayoutDirection());
            this.requestLayout();
            this.invalidate();
        }
    }

    public final int getTextAlignment() {
        return (this.mPrivateFlags2 & 0xE0000) >> 17;
    }

    @ApiStatus.Internal
    public boolean resolveTextAlignment() {
        this.mPrivateFlags2 &= 0xFFF0FFFF;
        if (ModernUI.getInstance().hasRtlSupport()) {
            int textAlignment = this.getRawTextAlignment();
            block2 : switch (textAlignment) {
                case 0: {
                    int parentResolvedTextAlignment;
                    if (!this.canResolveTextAlignment()) {
                        this.mPrivateFlags2 |= 0x20000;
                        return false;
                    }
                    try {
                        if (!this.mParent.isTextAlignmentResolved()) {
                            this.mPrivateFlags2 |= 0x20000;
                            return false;
                        }
                    }
                    catch (AbstractMethodError e) {
                        ModernUI.LOGGER.error(VIEW_MARKER, this.mParent.getClass().getSimpleName() + " does not fully implement ViewParent", (Throwable)e);
                        this.mPrivateFlags2 |= 0x30000;
                        return true;
                    }
                    try {
                        parentResolvedTextAlignment = this.mParent.getTextAlignment();
                    }
                    catch (AbstractMethodError e) {
                        ModernUI.LOGGER.error(VIEW_MARKER, this.mParent.getClass().getSimpleName() + " does not fully implement ViewParent", (Throwable)e);
                        parentResolvedTextAlignment = 1;
                    }
                    switch (parentResolvedTextAlignment) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            this.mPrivateFlags2 |= parentResolvedTextAlignment << 17;
                            break block2;
                        }
                    }
                    this.mPrivateFlags2 |= 0x20000;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    this.mPrivateFlags2 |= textAlignment << 17;
                    break;
                }
                default: {
                    this.mPrivateFlags2 |= 0x20000;
                }
            }
        } else {
            this.mPrivateFlags2 |= 0x20000;
        }
        this.mPrivateFlags2 |= 0x10000;
        return true;
    }

    public final boolean canResolveTextAlignment() {
        if (this.isTextAlignmentInherited()) {
            if (this.mParent != null) {
                try {
                    return this.mParent.canResolveTextAlignment();
                }
                catch (AbstractMethodError e) {
                    ModernUI.LOGGER.error(VIEW_MARKER, this.mParent.getClass().getSimpleName() + " does not fully implement ViewParent", (Throwable)e);
                }
            }
            return false;
        }
        return true;
    }

    @ApiStatus.Internal
    void resetResolvedTextAlignment() {
        this.mPrivateFlags2 &= 0xFFF0FFFF;
        this.mPrivateFlags2 |= 0x20000;
    }

    @ApiStatus.Internal
    public final boolean isTextAlignmentInherited() {
        return this.getRawTextAlignment() == 0;
    }

    public final boolean isTextAlignmentResolved() {
        return (this.mPrivateFlags2 & 0x10000) == 65536;
    }

    @ApiStatus.Internal
    boolean isPaddingResolved() {
        return (this.mPrivateFlags2 & 0x20000000) == 0x20000000;
    }

    @ApiStatus.Internal
    public void resolvePadding() {
        int resolvedLayoutDirection = this.getLayoutDirection();
        if (ModernUI.getInstance().hasRtlSupport()) {
            if (!(this.mBackground == null || this.mLeftPaddingDefined && this.mRightPaddingDefined)) {
                Rect padding = sThreadLocal.get();
                if (padding == null) {
                    padding = new Rect();
                    sThreadLocal.set(padding);
                }
                this.mBackground.getPadding(padding);
                if (!this.mLeftPaddingDefined) {
                    this.mUserPaddingLeftInitial = padding.left;
                }
                if (!this.mRightPaddingDefined) {
                    this.mUserPaddingRightInitial = padding.right;
                }
            }
            if (resolvedLayoutDirection == 1) {
                this.mUserPaddingRight = this.mUserPaddingStart != Integer.MIN_VALUE ? this.mUserPaddingStart : this.mUserPaddingRightInitial;
                this.mUserPaddingLeft = this.mUserPaddingEnd != Integer.MIN_VALUE ? this.mUserPaddingEnd : this.mUserPaddingLeftInitial;
            } else {
                this.mUserPaddingLeft = this.mUserPaddingStart != Integer.MIN_VALUE ? this.mUserPaddingStart : this.mUserPaddingLeftInitial;
                this.mUserPaddingRight = this.mUserPaddingEnd != Integer.MIN_VALUE ? this.mUserPaddingEnd : this.mUserPaddingRightInitial;
            }
            this.mUserPaddingBottom = this.mUserPaddingBottom >= 0 ? this.mUserPaddingBottom : this.mPaddingBottom;
        }
        this.internalSetPadding(this.mUserPaddingLeft, this.mPaddingTop, this.mUserPaddingRight, this.mUserPaddingBottom);
        this.onRtlPropertiesChanged(resolvedLayoutDirection);
        this.mPrivateFlags2 |= 0x20000000;
    }

    @ApiStatus.Internal
    void resetResolvedPadding() {
        this.mPrivateFlags2 &= 0xDFFFFFFF;
    }

    public int getBaseline() {
        return -1;
    }

    public final boolean isInLayout() {
        ViewRoot viewRoot = this.getViewRoot();
        return viewRoot != null && viewRoot.isInLayout();
    }

    @CallSuper
    public void requestLayout() {
        if (this.mAttachInfo != null && this.mAttachInfo.mViewRequestingLayout == null) {
            ViewRoot viewRoot = this.getViewRoot();
            if (viewRoot != null && viewRoot.isInLayout() && !viewRoot.requestLayoutDuringLayout(this)) {
                return;
            }
            this.mAttachInfo.mViewRequestingLayout = this;
        }
        this.mPrivateFlags |= 0x1000;
        this.mPrivateFlags |= Integer.MIN_VALUE;
        if (this.mParent != null && !this.mParent.isLayoutRequested()) {
            this.mParent.requestLayout();
        }
        if (this.mAttachInfo != null && this.mAttachInfo.mViewRequestingLayout == this) {
            this.mAttachInfo.mViewRequestingLayout = null;
        }
    }

    public boolean isLayoutRequested() {
        return (this.mPrivateFlags & 0x1000) == 4096;
    }

    public void forceLayout() {
        this.mPrivateFlags |= 0x1000;
        this.mPrivateFlags |= Integer.MIN_VALUE;
    }

    @CallSuper
    public void drawableHotspotChanged(float x, float y) {
        if (this.mBackground != null) {
            this.mBackground.setHotspot(x, y);
        }
        if (this.mDefaultFocusHighlight != null) {
            this.mDefaultFocusHighlight.setHotspot(x, y);
        }
        if (this.mForegroundInfo != null && this.mForegroundInfo.mDrawable != null) {
            this.mForegroundInfo.mDrawable.setHotspot(x, y);
        }
        this.dispatchDrawableHotspotChanged(x, y);
    }

    public void dispatchDrawableHotspotChanged(float x, float y) {
    }

    public void refreshDrawableState() {
        this.mPrivateFlags |= 0x400;
        this.drawableStateChanged();
        ViewParent parent = this.mParent;
        if (parent != null) {
            parent.childDrawableStateChanged(this);
        }
    }

    @ApiStatus.Internal
    protected void resolveDrawables() {
        int layoutDirection;
        if (!this.isLayoutDirectionResolved() && this.getRawLayoutDirection() == 2) {
            return;
        }
        int n = layoutDirection = this.isLayoutDirectionResolved() ? this.getLayoutDirection() : this.getRawLayoutDirection();
        if (this.mBackground != null) {
            this.mBackground.setLayoutDirection(layoutDirection);
        }
        if (this.mForegroundInfo != null && this.mForegroundInfo.mDrawable != null) {
            this.mForegroundInfo.mDrawable.setLayoutDirection(layoutDirection);
        }
        if (this.mDefaultFocusHighlight != null) {
            this.mDefaultFocusHighlight.setLayoutDirection(layoutDirection);
        }
        this.mPrivateFlags2 |= 0x40000000;
        this.onResolveDrawables(layoutDirection);
    }

    boolean areDrawablesResolved() {
        return (this.mPrivateFlags2 & 0x40000000) == 0x40000000;
    }

    @ApiStatus.Internal
    public void onResolveDrawables(int layoutDirection) {
    }

    @ApiStatus.Internal
    protected void resetResolvedDrawables() {
        this.resetResolvedDrawablesInternal();
    }

    void resetResolvedDrawablesInternal() {
        this.mPrivateFlags2 &= 0xBFFFFFFF;
    }

    public void setPadding(int left, int top, int right, int bottom) {
        this.resetResolvedPadding();
        this.mUserPaddingStart = Integer.MIN_VALUE;
        this.mUserPaddingEnd = Integer.MIN_VALUE;
        this.mUserPaddingLeftInitial = left;
        this.mUserPaddingRightInitial = right;
        this.mLeftPaddingDefined = true;
        this.mRightPaddingDefined = true;
        this.internalSetPadding(left, top, right, bottom);
    }

    @ApiStatus.Internal
    protected void internalSetPadding(int left, int top, int right, int bottom) {
        this.mUserPaddingLeft = left;
        this.mUserPaddingRight = right;
        this.mUserPaddingBottom = bottom;
        int viewFlags = this.mViewFlags;
        boolean changed = false;
        if ((viewFlags & 0x300) != 0) {
            if ((viewFlags & 0x200) != 0) {
                int offset;
                int n = offset = (viewFlags & 0x1000000) == 0 ? 0 : this.getVerticalScrollbarWidth();
                if (this.isLayoutRtl()) {
                    left += offset;
                } else {
                    right += offset;
                }
            }
            if ((viewFlags & 0x100) != 0) {
                bottom += (viewFlags & 0x1000000) == 0 ? 0 : this.getHorizontalScrollbarHeight();
            }
        }
        if (this.mPaddingLeft != left) {
            changed = true;
            this.mPaddingLeft = left;
        }
        if (this.mPaddingTop != top) {
            changed = true;
            this.mPaddingTop = top;
        }
        if (this.mPaddingRight != right) {
            changed = true;
            this.mPaddingRight = right;
        }
        if (this.mPaddingBottom != bottom) {
            changed = true;
            this.mPaddingBottom = bottom;
        }
        if (changed) {
            this.requestLayout();
        }
    }

    public void setPaddingRelative(int start, int top, int end, int bottom) {
        this.resetResolvedPadding();
        this.mUserPaddingStart = start;
        this.mUserPaddingEnd = end;
        this.mLeftPaddingDefined = true;
        this.mRightPaddingDefined = true;
        if (this.isLayoutRtl()) {
            this.mUserPaddingLeftInitial = end;
            this.mUserPaddingRightInitial = start;
            this.internalSetPadding(end, top, start, bottom);
        } else {
            this.mUserPaddingLeftInitial = start;
            this.mUserPaddingRightInitial = end;
            this.internalSetPadding(start, top, end, bottom);
        }
    }

    public int getPaddingTop() {
        return this.mPaddingTop;
    }

    public int getPaddingBottom() {
        return this.mPaddingBottom;
    }

    public int getPaddingLeft() {
        if (!this.isPaddingResolved()) {
            this.resolvePadding();
        }
        return this.mPaddingLeft;
    }

    public int getPaddingStart() {
        if (!this.isPaddingResolved()) {
            this.resolvePadding();
        }
        return this.getLayoutDirection() == 1 ? this.mPaddingRight : this.mPaddingLeft;
    }

    public int getPaddingRight() {
        if (!this.isPaddingResolved()) {
            this.resolvePadding();
        }
        return this.mPaddingRight;
    }

    public int getPaddingEnd() {
        if (!this.isPaddingResolved()) {
            this.resolvePadding();
        }
        return this.getLayoutDirection() == 1 ? this.mPaddingLeft : this.mPaddingRight;
    }

    public boolean isPaddingRelative() {
        return this.mUserPaddingStart != Integer.MIN_VALUE || this.mUserPaddingEnd != Integer.MIN_VALUE;
    }

    @CallSuper
    protected boolean verifyDrawable(@NonNull Drawable drawable) {
        return drawable == this.mBackground || this.mForegroundInfo != null && this.mForegroundInfo.mDrawable == drawable || this.mDefaultFocusHighlight == drawable;
    }

    @CallSuper
    protected void drawableStateChanged() {
        ScrollBar scrollBar;
        Drawable fg;
        Drawable hl;
        int[] state = this.getDrawableState();
        boolean changed = false;
        Drawable bg = this.mBackground;
        if (bg != null && bg.isStateful()) {
            changed |= bg.setState(state);
        }
        if ((hl = this.mDefaultFocusHighlight) != null && hl.isStateful()) {
            changed |= hl.setState(state);
        }
        Drawable drawable = fg = this.mForegroundInfo != null ? this.mForegroundInfo.mDrawable : null;
        if (fg != null && fg.isStateful()) {
            changed |= fg.setState(state);
        }
        if (this.mScrollCache != null && (scrollBar = this.mScrollCache.mScrollBar) != null && scrollBar.isStateful()) {
            changed |= scrollBar.setState(state) && this.mScrollCache.mState != 0;
        }
        if (this.mStateListAnimator != null) {
            this.mStateListAnimator.setState(state);
        }
        if (!this.isAggregatedVisible()) {
            this.jumpDrawablesToCurrentState();
        }
        if (changed) {
            this.invalidate();
        }
    }

    public final int[] getDrawableState() {
        if (this.mDrawableState == null || (this.mPrivateFlags & 0x400) != 0) {
            this.mDrawableState = this.onCreateDrawableState(0);
            this.mPrivateFlags &= 0xFFFFFBFF;
        }
        return this.mDrawableState;
    }

    @NonNull
    protected int[] onCreateDrawableState(int extraSpace) {
        int[] fullState;
        int privateFlags2;
        if ((this.mViewFlags & 0x400000) == 0x400000 && this.mParent instanceof View) {
            return ((View)((Object)this.mParent)).onCreateDrawableState(extraSpace);
        }
        int stateMask = 0;
        int privateFlags = this.mPrivateFlags;
        if ((privateFlags & 0x4000) != 0) {
            stateMask |= 0x10;
        }
        if ((this.mViewFlags & 0x20) == 0) {
            stateMask |= 8;
        }
        if (this.isFocused()) {
            stateMask |= 4;
        }
        if ((privateFlags & 4) != 0) {
            stateMask |= 2;
        }
        if (this.hasWindowFocus()) {
            stateMask |= 1;
        }
        if ((privateFlags & 0x40000000) != 0) {
            stateMask |= 0x20;
        }
        if ((privateFlags & 0x10000000) != 0) {
            stateMask |= 0x40;
        }
        if (((privateFlags2 = this.mPrivateFlags2) & 1) != 0) {
            stateMask |= 0x80;
        }
        if ((privateFlags2 & 2) != 0) {
            stateMask |= 0x100;
        }
        int[] drawableState = StateSet.get(stateMask);
        if (extraSpace == 0) {
            return drawableState;
        }
        if (stateMask != 0) {
            fullState = new int[drawableState.length + extraSpace];
            System.arraycopy(drawableState, 0, fullState, 0, drawableState.length);
        } else {
            fullState = new int[extraSpace];
        }
        return fullState;
    }

    @NonNull
    protected static int[] mergeDrawableStates(@NonNull int[] baseState, @NonNull int[] additionalState) {
        int i;
        for (i = baseState.length - 1; i >= 0 && baseState[i] == 0; --i) {
        }
        System.arraycopy(additionalState, 0, baseState, i + 1, additionalState.length);
        return baseState;
    }

    @CallSuper
    public void jumpDrawablesToCurrentState() {
        if (this.mBackground != null) {
            this.mBackground.jumpToCurrentState();
        }
        if (this.mStateListAnimator != null) {
            this.mStateListAnimator.jumpToCurrentState();
        }
        if (this.mDefaultFocusHighlight != null) {
            this.mDefaultFocusHighlight.jumpToCurrentState();
        }
        if (this.mForegroundInfo != null && this.mForegroundInfo.mDrawable != null) {
            this.mForegroundInfo.mDrawable.jumpToCurrentState();
        }
    }

    public void setBackground(@Nullable Drawable background) {
        if (background == this.mBackground) {
            return;
        }
        boolean requestLayout = false;
        if (this.mBackground != null) {
            if (this.isAttachedToWindow()) {
                this.mBackground.setVisible(false, false);
            }
            this.mBackground.setCallback(null);
            this.unscheduleDrawable(this.mBackground);
        }
        if (background != null) {
            Rect padding = sThreadLocal.get();
            if (padding == null) {
                padding = new Rect();
                sThreadLocal.set(padding);
            }
            this.resetResolvedDrawablesInternal();
            background.setLayoutDirection(this.getLayoutDirection());
            if (background.getPadding(padding)) {
                this.resetResolvedPadding();
                if (background.getLayoutDirection() == 1) {
                    this.mUserPaddingLeftInitial = padding.right;
                    this.mUserPaddingRightInitial = padding.left;
                    this.internalSetPadding(padding.right, padding.top, padding.left, padding.bottom);
                } else {
                    this.mUserPaddingLeftInitial = padding.left;
                    this.mUserPaddingRightInitial = padding.right;
                    this.internalSetPadding(padding.left, padding.top, padding.right, padding.bottom);
                }
                this.mLeftPaddingDefined = false;
                this.mRightPaddingDefined = false;
            }
            if (this.mBackground == null || this.mBackground.getMinimumHeight() != background.getMinimumHeight() || this.mBackground.getMinimumWidth() != background.getMinimumWidth()) {
                requestLayout = true;
            }
            this.mBackground = background;
            background.setCallback(this);
            if ((this.mPrivateFlags & 0x80) != 0) {
                this.mPrivateFlags &= 0xFFFFFF7F;
                requestLayout = true;
            }
        } else {
            this.mBackground = null;
            if ((this.mViewFlags & 0x80) != 0 && this.mDefaultFocusHighlight == null && (this.mForegroundInfo == null || this.mForegroundInfo.mDrawable == null)) {
                this.mPrivateFlags |= 0x80;
            }
            requestLayout = true;
        }
        if (requestLayout) {
            this.requestLayout();
        }
        this.mBackgroundSizeChanged = true;
        this.invalidate();
    }

    @Nullable
    public Drawable getBackground() {
        return this.mBackground;
    }

    @Nullable
    public Drawable getForeground() {
        return this.mForegroundInfo != null ? this.mForegroundInfo.mDrawable : null;
    }

    public void setForeground(@Nullable Drawable foreground) {
        if (this.mForegroundInfo == null) {
            if (foreground == null) {
                return;
            }
            this.mForegroundInfo = new ForegroundInfo();
        }
        if (foreground == this.mForegroundInfo.mDrawable) {
            return;
        }
        if (this.mForegroundInfo.mDrawable != null) {
            if (this.isAttachedToWindow()) {
                this.mForegroundInfo.mDrawable.setVisible(false, false);
            }
            this.mForegroundInfo.mDrawable.setCallback(null);
            this.unscheduleDrawable(this.mForegroundInfo.mDrawable);
        }
        this.mForegroundInfo.mDrawable = foreground;
        this.mForegroundInfo.mBoundsChanged = true;
        if (foreground != null) {
            if ((this.mPrivateFlags & 0x80) != 0) {
                this.mPrivateFlags &= 0xFFFFFF7F;
            }
            foreground.setLayoutDirection(this.getLayoutDirection());
            if (foreground.isStateful()) {
                foreground.setState(this.getDrawableState());
            }
            if (this.isAttachedToWindow()) {
                foreground.setVisible(this.getWindowVisibility() == 0 && this.isShown(), false);
            }
            foreground.setCallback(this);
        } else if ((this.mViewFlags & 0x80) != 0 && this.mBackground == null && this.mDefaultFocusHighlight == null) {
            this.mPrivateFlags |= 0x80;
        }
        this.requestLayout();
        this.invalidate();
    }

    @ApiStatus.Internal
    public boolean isForegroundInsidePadding() {
        return this.mForegroundInfo == null || this.mForegroundInfo.mInsidePadding;
    }

    public int getForegroundGravity() {
        return this.mForegroundInfo != null ? this.mForegroundInfo.mGravity : 0x800033;
    }

    public void setForegroundGravity(int gravity) {
        if (this.mForegroundInfo == null) {
            this.mForegroundInfo = new ForegroundInfo();
        }
        if (this.mForegroundInfo.mGravity != gravity) {
            if ((gravity & 0x800007) == 0) {
                gravity |= 0x800003;
            }
            if ((gravity & 0x70) == 0) {
                gravity |= 0x30;
            }
            this.mForegroundInfo.mGravity = gravity;
            this.requestLayout();
        }
    }

    @NonNull
    public final ViewTreeObserver getViewTreeObserver() {
        if (this.mAttachInfo != null) {
            return this.mAttachInfo.mTreeObserver;
        }
        if (this.mFloatingTreeObserver == null) {
            this.mFloatingTreeObserver = new ViewTreeObserver();
        }
        return this.mFloatingTreeObserver;
    }

    public final View getRootView() {
        View v;
        if (this.mAttachInfo != null && (v = this.mAttachInfo.mRootView) != null) {
            return v;
        }
        v = this;
        while (v.mParent instanceof View) {
            v = (View)((Object)v.mParent);
        }
        return v;
    }

    @ApiStatus.Internal
    public boolean toGlobalMotionEvent(@NonNull MotionEvent ev) {
        AttachInfo info = this.mAttachInfo;
        if (info == null) {
            return false;
        }
        Matrix m = info.mTmpMatrix;
        m.setIdentity();
        this.transformMatrixToGlobal(m);
        ev.transform(m);
        return true;
    }

    @ApiStatus.Internal
    public boolean toLocalMotionEvent(@NonNull MotionEvent ev) {
        AttachInfo info = this.mAttachInfo;
        if (info == null) {
            return false;
        }
        Matrix m = info.mTmpMatrix;
        m.setIdentity();
        this.transformMatrixToLocal(m);
        ev.transform(m);
        return true;
    }

    public void transformMatrixToGlobal(@NonNull Matrix matrix) {
        ViewParent parent = this.mParent;
        if (parent instanceof View) {
            View vp = (View)((Object)parent);
            vp.transformMatrixToGlobal(matrix);
            matrix.preTranslate(-vp.mScrollX, -vp.mScrollY);
        }
        matrix.preTranslate(this.mLeft, this.mTop);
        if (!this.hasIdentityMatrix()) {
            matrix.preConcat(this.getMatrix());
        }
    }

    public void transformMatrixToLocal(@NonNull Matrix matrix) {
        ViewParent parent = this.mParent;
        if (parent instanceof View) {
            View vp = (View)((Object)parent);
            vp.transformMatrixToLocal(matrix);
            matrix.postTranslate(vp.mScrollX, vp.mScrollY);
        }
        matrix.postTranslate(-this.mLeft, -this.mTop);
        if (!this.hasIdentityMatrix()) {
            matrix.postConcat(this.getInverseMatrix());
        }
    }

    public void getBoundsOnScreen(@NonNull Rect outRect) {
        this.getBoundsOnScreen(outRect, false);
    }

    public void getBoundsOnScreen(@NonNull Rect outRect, boolean clipToParent) {
        if (this.mAttachInfo == null) {
            return;
        }
        RectF position = this.mAttachInfo.mTmpTransformRect;
        position.set(0.0f, 0.0f, this.mRight - this.mLeft, this.mBottom - this.mTop);
        this.mapRectFromViewToScreenCoords(position, clipToParent);
        position.round(outRect);
    }

    public void mapRectFromViewToScreenCoords(@NonNull RectF rect, boolean clipToParent) {
        if (!this.hasIdentityMatrix()) {
            this.getMatrix().mapRect(rect);
        }
        rect.offset(this.mLeft, this.mTop);
        ViewParent parent = this.mParent;
        while (parent instanceof View) {
            View parentView = (View)((Object)parent);
            rect.offset(-parentView.mScrollX, -parentView.mScrollY);
            if (clipToParent) {
                rect.left = Math.max(rect.left, 0.0f);
                rect.top = Math.max(rect.top, 0.0f);
                rect.right = Math.min(rect.right, (float)parentView.getWidth());
                rect.bottom = Math.min(rect.bottom, (float)parentView.getHeight());
            }
            if (!parentView.hasIdentityMatrix()) {
                parentView.getMatrix().mapRect(rect);
            }
            rect.offset(parentView.mLeft, parentView.mTop);
            parent = parentView.mParent;
        }
    }

    public void getLocationOnScreen(int[] outLocation) {
        this.getLocationInWindow(outLocation);
    }

    public void getLocationInWindow(@NonNull int[] outLocation) {
        if (outLocation.length < 2) {
            throw new IllegalArgumentException("outLocation must be an array of two integers");
        }
        outLocation[0] = 0;
        outLocation[1] = 0;
        this.transformFromViewToWindowSpace(outLocation);
    }

    @ApiStatus.Internal
    public void transformFromViewToWindowSpace(@NonNull int[] inOutLocation) {
        if (inOutLocation.length < 2) {
            throw new IllegalArgumentException("inOutLocation must be an array of two integers");
        }
        if (this.mAttachInfo == null) {
            inOutLocation[1] = 0;
            inOutLocation[0] = 0;
            return;
        }
        float[] position = this.mAttachInfo.mTmpTransformLocation;
        position[0] = inOutLocation[0];
        position[1] = inOutLocation[1];
        if (!this.hasIdentityMatrix()) {
            this.getMatrix().mapPoint(position);
        }
        position[0] = position[0] + (float)this.mLeft;
        position[1] = position[1] + (float)this.mTop;
        ViewParent viewParent = this.mParent;
        while (viewParent instanceof View) {
            View view = (View)((Object)viewParent);
            position[0] = position[0] - (float)view.mScrollX;
            position[1] = position[1] - (float)view.mScrollY;
            if (!view.hasIdentityMatrix()) {
                view.getMatrix().mapPoint(position);
            }
            position[0] = position[0] + (float)view.mLeft;
            position[1] = position[1] + (float)view.mTop;
            viewParent = view.mParent;
        }
        inOutLocation[0] = Math.round(position[0]);
        inOutLocation[1] = Math.round(position[1]);
    }

    @Nullable
    public final <T extends View> T findViewById(int id2) {
        if (id2 == -1) {
            return null;
        }
        return this.findViewTraversal(id2);
    }

    @NonNull
    public final <T extends View> T requireViewById(int id2) {
        T view = this.findViewById(id2);
        if (view == null) {
            throw new IllegalArgumentException("ID does not reference a View inside this View");
        }
        return view;
    }

    @ApiStatus.Internal
    @Nullable
    protected <T extends View> T findViewTraversal(int id2) {
        if (id2 == this.mID) {
            return (T)this;
        }
        return null;
    }

    @ApiStatus.Internal
    public final <T extends View> T findViewByPredicate(@NonNull Predicate<View> predicate) {
        return this.findViewByPredicateTraversal(predicate, null);
    }

    @ApiStatus.Internal
    @Nullable
    protected <T extends View> T findViewByPredicateTraversal(@NonNull Predicate<View> predicate, @Nullable View childToSkip) {
        if (predicate.test(this)) {
            return (T)this;
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public final <T extends View> T findViewByPredicateInsideOut(@NonNull View start, Predicate<View> predicate) {
        View childToSkip = null;
        T view;
        while ((view = start.findViewByPredicateTraversal(predicate, childToSkip)) == null && start != this) {
            ViewParent parent = start.getParent();
            if (!(parent instanceof View)) {
                return null;
            }
            childToSkip = start;
            start = (View)((Object)parent);
        }
        return view;
    }

    @Nullable
    public final Handler getHandler() {
        AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo != null) {
            return attachInfo.mHandler;
        }
        return null;
    }

    @NonNull
    private HandlerActionQueue getRunQueue() {
        if (this.mRunQueue == null) {
            this.mRunQueue = new HandlerActionQueue();
        }
        return this.mRunQueue;
    }

    @Nullable
    public final ViewRoot getViewRoot() {
        if (this.mAttachInfo != null) {
            return this.mAttachInfo.mViewRoot;
        }
        return null;
    }

    public final boolean post(@NonNull Runnable action) {
        AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo != null) {
            return attachInfo.mHandler.post(action);
        }
        this.getRunQueue().post(action);
        return true;
    }

    public final boolean postDelayed(@NonNull Runnable action, long delayMillis) {
        AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo != null) {
            return attachInfo.mHandler.postDelayed(action, delayMillis);
        }
        this.getRunQueue().postDelayed(action, delayMillis);
        return true;
    }

    public final void postOnAnimation(@NonNull Runnable action) {
        AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo != null) {
            attachInfo.mViewRoot.mChoreographer.postCallback(1, action, null);
        } else {
            this.getRunQueue().post(action);
        }
    }

    public final void postOnAnimationDelayed(@NonNull Runnable action, long delayMillis) {
        AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo != null) {
            attachInfo.mViewRoot.mChoreographer.postCallbackDelayed(1, action, null, delayMillis);
        } else {
            this.getRunQueue().postDelayed(action, delayMillis);
        }
    }

    public final void removeCallbacks(@Nullable Runnable action) {
        if (action != null) {
            AttachInfo attachInfo = this.mAttachInfo;
            if (attachInfo != null) {
                attachInfo.mHandler.removeCallbacks(action);
                attachInfo.mViewRoot.mChoreographer.removeCallbacks(1, action, null);
            }
            if (this.mRunQueue != null) {
                this.mRunQueue.removeCallbacks(action);
            }
        }
    }

    public final void postInvalidate() {
        this.postInvalidateDelayed(0L);
    }

    public final void postInvalidateDelayed(long delayMilliseconds) {
        AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo != null) {
            attachInfo.mViewRoot.dispatchInvalidateDelayed(this, delayMilliseconds);
        }
    }

    public final void postInvalidateOnAnimation() {
        AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo != null) {
            attachInfo.mViewRoot.dispatchInvalidateOnAnimation(this);
        }
    }

    public final boolean startDragAndDrop(@Nullable Object localState, @Nullable DragShadow shadow, int flags) {
        if (this.mAttachInfo == null) {
            ModernUI.LOGGER.error(VIEW_MARKER, "startDragAndDrop called out of a window");
            return false;
        }
        return this.mAttachInfo.mViewRoot.startDragAndDrop(this, localState, shadow, flags);
    }

    public boolean onDragEvent(DragEvent event) {
        return true;
    }

    protected void dispatchVisibilityChanged(@NonNull View changedView, int visibility) {
        this.onVisibilityChanged(changedView, visibility);
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
    }

    public final int getWindowVisibility() {
        return this.mAttachInfo != null ? this.mAttachInfo.mWindowVisibility : 8;
    }

    public void dispatchWindowVisibilityChanged(int visibility) {
        this.onWindowVisibilityChanged(visibility);
    }

    protected void onWindowVisibilityChanged(int visibility) {
        if (visibility == 0) {
            this.initialAwakenScrollBars();
        }
    }

    boolean isAggregatedVisible() {
        return (this.mPrivateFlags3 & 0x20000000) != 0;
    }

    boolean dispatchVisibilityAggregated(boolean isVisible) {
        boolean thisVisible;
        boolean bl = thisVisible = this.getVisibility() == 0;
        if (thisVisible || !isVisible) {
            this.onVisibilityAggregated(isVisible);
        }
        return thisVisible && isVisible;
    }

    @CallSuper
    public void onVisibilityAggregated(boolean isVisible) {
        Drawable fg;
        Drawable hl;
        Drawable dr;
        boolean oldVisible = this.isAggregatedVisible();
        int n = this.mPrivateFlags3 = isVisible ? this.mPrivateFlags3 | 0x20000000 : this.mPrivateFlags3 & 0xDFFFFFFF;
        if (isVisible && this.mAttachInfo != null) {
            this.initialAwakenScrollBars();
        }
        if ((dr = this.mBackground) != null && isVisible != dr.isVisible()) {
            dr.setVisible(isVisible, false);
        }
        if ((hl = this.mDefaultFocusHighlight) != null && isVisible != hl.isVisible()) {
            hl.setVisible(isVisible, false);
        }
        Drawable drawable = fg = this.mForegroundInfo != null ? this.mForegroundInfo.mDrawable : null;
        if (fg != null && isVisible != fg.isVisible()) {
            fg.setVisible(isVisible, false);
        }
    }

    public final boolean dispatchPointerEvent(@NonNull MotionEvent event) {
        if (event.isTouchEvent()) {
            return this.dispatchTouchEvent(event);
        }
        return this.dispatchGenericMotionEvent(event);
    }

    public void dispatchWindowFocusChanged(boolean hasFocus) {
        this.onWindowFocusChanged(hasFocus);
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        if (!hasWindowFocus) {
            if (this.isPressed()) {
                this.setPressed(false);
            }
            this.mPrivateFlags3 &= 0xFFFDFFFF;
            this.removeLongPressCallback();
            this.removeTapCallback();
            this.resetPressedState();
        }
        this.refreshDrawableState();
    }

    public boolean hasWindowFocus() {
        return this.mAttachInfo != null && this.mAttachInfo.mHasWindowFocus;
    }

    public boolean dispatchGenericMotionEvent(@NonNull MotionEvent event) {
        int action = event.getAction();
        if (action == 9 || action == 7 || action == 10 ? this.dispatchHoverEvent(event) : this.dispatchGenericPointerEvent(event)) {
            return true;
        }
        return this.dispatchGenericMotionEventInternal(event);
    }

    private boolean dispatchGenericMotionEventInternal(MotionEvent event) {
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnGenericMotionListener != null && (this.mViewFlags & 0x20) == 0 && li.mOnGenericMotionListener.onGenericMotion(this, event)) {
            return true;
        }
        if (this.onGenericMotionEvent(event)) {
            return true;
        }
        int actionButton = event.getActionButton();
        switch (event.getAction()) {
            case 11: {
                if (!this.isContextClickable() || this.mInContextButtonPress || this.mHasPerformedLongPress || actionButton != 2 || !this.performContextClick(event.getX(), event.getY())) break;
                this.mInContextButtonPress = true;
                this.setPressed(event.getX(), event.getY());
                this.removeTapCallback();
                this.removeLongPressCallback();
                return true;
            }
            case 12: {
                if (!this.mInContextButtonPress || actionButton != 2) break;
                this.mInContextButtonPress = false;
                this.mIgnoreNextUpEvent = true;
            }
        }
        return false;
    }

    protected boolean dispatchHoverEvent(@NonNull MotionEvent event) {
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnHoverListener != null && (this.mViewFlags & 0x20) == 0 && li.mOnHoverListener.onHover(this, event)) {
            return true;
        }
        return this.onHoverEvent(event);
    }

    protected boolean dispatchGenericPointerEvent(@NonNull MotionEvent event) {
        return false;
    }

    public boolean onGenericMotionEvent(@NonNull MotionEvent event) {
        return false;
    }

    public boolean onHoverEvent(@NonNull MotionEvent event) {
        int action = event.getAction();
        if ((action == 9 || action == 7) && this.isOnScrollbar(event.getX(), event.getY())) {
            this.awakenScrollBars();
        }
        if (this.isHoverable() || this.isHovered()) {
            switch (action) {
                case 9: {
                    this.setHovered(true);
                    break;
                }
                case 10: {
                    this.setHovered(false);
                }
            }
            this.dispatchGenericMotionEventInternal(event);
            return true;
        }
        return false;
    }

    private boolean isHoverable() {
        int viewFlags = this.mViewFlags;
        if ((viewFlags & 0x20) == 32) {
            return false;
        }
        return (viewFlags & 0x4000) == 16384 || (viewFlags & 0x200000) == 0x200000 || (viewFlags & 0x800000) == 0x800000;
    }

    public boolean isHovered() {
        return (this.mPrivateFlags & 0x10000000) != 0;
    }

    public void setHovered(boolean hovered) {
        if (hovered) {
            if ((this.mPrivateFlags & 0x10000000) == 0) {
                this.mPrivateFlags |= 0x10000000;
                this.refreshDrawableState();
                this.onHoverChanged(true);
            }
        } else if ((this.mPrivateFlags & 0x10000000) != 0) {
            this.mPrivateFlags &= 0xEFFFFFFF;
            this.refreshDrawableState();
            this.onHoverChanged(false);
        }
    }

    public void onHoverChanged(boolean hovered) {
    }

    @NonNull
    ListenerInfo getListenerInfo() {
        if (this.mListenerInfo == null) {
            this.mListenerInfo = new ListenerInfo();
        }
        return this.mListenerInfo;
    }

    public void setOnScrollChangeListener(@Nullable OnScrollChangeListener l) {
        if (l == null && this.mListenerInfo == null) {
            return;
        }
        this.getListenerInfo().mOnScrollChangeListener = l;
    }

    public void setOnFocusChangeListener(@Nullable OnFocusChangeListener l) {
        if (l == null && this.mListenerInfo == null) {
            return;
        }
        this.getListenerInfo().mOnFocusChangeListener = l;
    }

    public void addOnLayoutChangeListener(@NonNull OnLayoutChangeListener listener) {
        ListenerInfo li = this.getListenerInfo();
        if (li.mOnLayoutChangeListeners == null) {
            li.mOnLayoutChangeListeners = new CopyOnWriteArrayList();
        }
        li.mOnLayoutChangeListeners.addIfAbsent(listener);
    }

    public void removeOnLayoutChangeListener(@NonNull OnLayoutChangeListener listener) {
        ListenerInfo li = this.mListenerInfo;
        if (li == null || li.mOnLayoutChangeListeners == null) {
            return;
        }
        li.mOnLayoutChangeListeners.remove(listener);
    }

    public void addOnAttachStateChangeListener(@NonNull OnAttachStateChangeListener listener) {
        ListenerInfo li = this.getListenerInfo();
        if (li.mOnAttachStateChangeListeners == null) {
            li.mOnAttachStateChangeListeners = new CopyOnWriteArrayList();
        }
        li.mOnAttachStateChangeListeners.add(listener);
    }

    public void removeOnAttachStateChangeListener(@NonNull OnAttachStateChangeListener listener) {
        ListenerInfo li = this.mListenerInfo;
        if (li == null || li.mOnAttachStateChangeListeners == null) {
            return;
        }
        li.mOnAttachStateChangeListeners.remove(listener);
    }

    @Nullable
    public OnFocusChangeListener getOnFocusChangeListener() {
        ListenerInfo li = this.mListenerInfo;
        return li != null ? li.mOnFocusChangeListener : null;
    }

    public void setOnClickListener(@Nullable OnClickListener l) {
        if (l == null && this.mListenerInfo == null) {
            return;
        }
        if (!this.isClickable()) {
            this.setClickable(true);
        }
        this.getListenerInfo().mOnClickListener = l;
    }

    public boolean hasOnClickListeners() {
        ListenerInfo li = this.mListenerInfo;
        return li != null && li.mOnClickListener != null;
    }

    public void setOnLongClickListener(@Nullable OnLongClickListener l) {
        if (l == null && this.mListenerInfo == null) {
            return;
        }
        if (!this.isLongClickable()) {
            this.setLongClickable(true);
        }
        this.getListenerInfo().mOnLongClickListener = l;
    }

    public boolean hasOnLongClickListeners() {
        ListenerInfo li = this.mListenerInfo;
        return li != null && li.mOnLongClickListener != null;
    }

    @ApiStatus.Internal
    @Nullable
    public OnLongClickListener getOnLongClickListener() {
        ListenerInfo li = this.mListenerInfo;
        return li != null ? li.mOnLongClickListener : null;
    }

    public void setOnContextClickListener(@Nullable OnContextClickListener l) {
        if (l == null && this.mListenerInfo == null) {
            return;
        }
        if (!this.isContextClickable()) {
            this.setContextClickable(true);
        }
        this.getListenerInfo().mOnContextClickListener = l;
    }

    public void setOnCreateContextMenuListener(@Nullable OnCreateContextMenuListener l) {
        if (l == null && this.mListenerInfo == null) {
            return;
        }
        if (!this.isLongClickable()) {
            this.setLongClickable(true);
        }
        this.getListenerInfo().mOnCreateContextMenuListener = l;
    }

    public void setOnKeyListener(@Nullable OnKeyListener l) {
        if (l == null && this.mListenerInfo == null) {
            return;
        }
        this.getListenerInfo().mOnKeyListener = l;
    }

    public void setOnTouchListener(@Nullable OnTouchListener l) {
        if (l == null && this.mListenerInfo == null) {
            return;
        }
        this.getListenerInfo().mOnTouchListener = l;
    }

    public void setOnGenericMotionListener(@Nullable OnGenericMotionListener l) {
        if (l == null && this.mListenerInfo == null) {
            return;
        }
        this.getListenerInfo().mOnGenericMotionListener = l;
    }

    public void setOnHoverListener(@Nullable OnHoverListener l) {
        if (l == null && this.mListenerInfo == null) {
            return;
        }
        this.getListenerInfo().mOnHoverListener = l;
    }

    public void setOnDragListener(@Nullable OnDragListener l) {
        if (l == null && this.mListenerInfo == null) {
            return;
        }
        this.getListenerInfo().mOnDragListener = l;
    }

    protected boolean canReceivePointerEvents() {
        return (this.mViewFlags & 0xC) == 0;
    }

    public boolean dispatchTouchEvent(@NonNull MotionEvent event) {
        int action = event.getAction();
        if (action == 0) {
            this.stopNestedScroll(0);
        }
        boolean result = (this.mViewFlags & 0x20) == 0 && this.handleScrollBarDragging(event);
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnTouchListener != null && (this.mViewFlags & 0x20) == 0 && li.mOnTouchListener.onTouch(this, event)) {
            result = true;
        }
        if (!result && this.onTouchEvent(event)) {
            result = true;
        }
        if (action == 1 || action == 3 || action == 0 && !result) {
            this.stopNestedScroll(0);
        }
        return result;
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        boolean clickable;
        float x = event.getX();
        float y = event.getY();
        int viewFlags = this.mViewFlags;
        int action = event.getAction();
        boolean bl = clickable = (viewFlags & 0x4000) == 16384 || (viewFlags & 0x200000) == 0x200000 || (viewFlags & 0x800000) == 0x800000;
        if ((viewFlags & 0x20) == 32) {
            if (action == 1 && (this.mPrivateFlags & 0x4000) != 0) {
                this.setPressed(false);
            }
            this.mPrivateFlags3 &= 0xFFFDFFFF;
            return clickable;
        }
        if (!clickable && (viewFlags & 0x40000000) != 0x40000000) {
            return false;
        }
        switch (action) {
            case 1: {
                boolean prepressed;
                this.mPrivateFlags3 &= 0xFFFDFFFF;
                if ((viewFlags & 0x40000000) == 0x40000000) {
                    this.handleTooltipUp();
                }
                if (!clickable) {
                    this.removeTapCallback();
                    this.removeLongPressCallback();
                    this.mInContextButtonPress = false;
                    this.mHasPerformedLongPress = false;
                    this.mIgnoreNextUpEvent = false;
                    break;
                }
                boolean bl2 = prepressed = (this.mPrivateFlags & 0x2000000) != 0;
                if ((this.mPrivateFlags & 0x4000) != 0 || prepressed) {
                    boolean focusTaken = false;
                    if (this.isFocusable() && this.isFocusableInTouchMode() && !this.isFocused()) {
                        focusTaken = this.requestFocus();
                    }
                    if (prepressed) {
                        this.setPressed(x, y);
                    }
                    if (!this.mHasPerformedLongPress && !this.mIgnoreNextUpEvent) {
                        this.removeLongPressCallback();
                        if (!focusTaken) {
                            if (this.mPerformClick == null) {
                                this.mPerformClick = new PerformClick();
                            }
                            if (!this.post(this.mPerformClick)) {
                                this.performClick();
                            }
                        }
                    }
                    if (this.mUnsetPressedState == null) {
                        this.mUnsetPressedState = new UnsetPressedState();
                    }
                    if (prepressed) {
                        this.postDelayed(this.mUnsetPressedState, ViewConfiguration.getPressedStateDuration());
                    } else if (!this.post(this.mUnsetPressedState)) {
                        this.mUnsetPressedState.run();
                    }
                    this.removeTapCallback();
                }
                this.mIgnoreNextUpEvent = false;
                break;
            }
            case 0: {
                this.mHasPerformedLongPress = false;
                if (!clickable) {
                    this.checkForLongClick(ViewConfiguration.getLongPressTimeout(), x, y);
                    break;
                }
                if (this.performButtonActionOnTouchDown(event)) break;
                boolean isInScrollingContainer = this.isInScrollingContainer();
                if (isInScrollingContainer) {
                    this.mPrivateFlags |= 0x2000000;
                    if (this.mPendingCheckForTap == null) {
                        this.mPendingCheckForTap = new CheckForTap();
                    }
                    this.mPendingCheckForTap.x = event.getX();
                    this.mPendingCheckForTap.y = event.getY();
                    this.postDelayed(this.mPendingCheckForTap, ViewConfiguration.getTapTimeout());
                    break;
                }
                this.setPressed(x, y);
                this.checkForLongClick(ViewConfiguration.getLongPressTimeout(), x, y);
                break;
            }
            case 3: {
                if (clickable) {
                    this.setPressed(false);
                }
                this.removeTapCallback();
                this.removeLongPressCallback();
                this.mInContextButtonPress = false;
                this.mHasPerformedLongPress = false;
                this.mIgnoreNextUpEvent = false;
                this.mPrivateFlags3 &= 0xFFFDFFFF;
                break;
            }
            case 2: {
                if (clickable) {
                    this.drawableHotspotChanged(x, y);
                }
                if (this.pointInView(x, y, ViewConfiguration.get(this.mContext).getScaledTouchSlop())) break;
                this.removeTapCallback();
                this.removeLongPressCallback();
                if ((this.mPrivateFlags & 0x4000) != 0) {
                    this.setPressed(false);
                }
                this.mPrivateFlags3 &= 0xFFFDFFFF;
            }
        }
        return true;
    }

    @ApiStatus.Internal
    protected boolean handleScrollBarDragging(MotionEvent event) {
        if (this.mScrollCache == null) {
            return false;
        }
        float x = event.getX();
        float y = event.getY();
        int action = event.getAction();
        if (this.mScrollCache.mScrollBarDraggingState == 0 && action != 0 || !event.isButtonPressed(1)) {
            this.mScrollCache.mScrollBarDraggingState = 0;
            return false;
        }
        switch (action) {
            case 2: {
                if (this.mScrollCache.mScrollBarDraggingState == 1) {
                    int newY;
                    Rect bounds = this.mScrollCache.mScrollBarBounds;
                    this.getVerticalScrollBarBounds(bounds, null);
                    int range = this.computeVerticalScrollRange();
                    int offset = this.computeVerticalScrollOffset();
                    int extent = this.computeVerticalScrollExtent();
                    int thumbLength = ScrollCache.getThumbLength(bounds.height(), bounds.width(), extent, range);
                    int thumbOffset = ScrollCache.getThumbOffset(bounds.height(), thumbLength, extent, range, offset);
                    float diff = y - this.mScrollCache.mScrollBarDraggingPos;
                    float maxThumbOffset = bounds.height() - thumbLength;
                    float newThumbOffset = Math.min(Math.max((float)thumbOffset + diff, 0.0f), maxThumbOffset);
                    int height = this.getHeight();
                    if (Math.round(newThumbOffset) != thumbOffset && maxThumbOffset > 0.0f && height > 0 && extent > 0 && (newY = Math.round((float)(range - extent) / ((float)extent / (float)height) * (newThumbOffset / maxThumbOffset))) != this.getScrollY()) {
                        this.mScrollCache.mScrollBarDraggingPos = y;
                        this.setScrollY(newY);
                    }
                    return true;
                }
                if (this.mScrollCache.mScrollBarDraggingState == 2) {
                    int newX;
                    Rect bounds = this.mScrollCache.mScrollBarBounds;
                    this.getHorizontalScrollBarBounds(bounds, null);
                    int range = this.computeHorizontalScrollRange();
                    int offset = this.computeHorizontalScrollOffset();
                    int extent = this.computeHorizontalScrollExtent();
                    int thumbLength = ScrollCache.getThumbLength(bounds.width(), bounds.height(), extent, range);
                    int thumbOffset = ScrollCache.getThumbOffset(bounds.width(), thumbLength, extent, range, offset);
                    float diff = x - this.mScrollCache.mScrollBarDraggingPos;
                    float maxThumbOffset = bounds.width() - thumbLength;
                    float newThumbOffset = Math.min(Math.max((float)thumbOffset + diff, 0.0f), maxThumbOffset);
                    int width = this.getWidth();
                    if (Math.round(newThumbOffset) != thumbOffset && maxThumbOffset > 0.0f && width > 0 && extent > 0 && (newX = Math.round((float)(range - extent) / ((float)extent / (float)width) * (newThumbOffset / maxThumbOffset))) != this.getScrollX()) {
                        this.mScrollCache.mScrollBarDraggingPos = x;
                        this.setScrollX(newX);
                    }
                    return true;
                }
            }
            case 0: {
                if (this.mScrollCache.mState == 0) {
                    return false;
                }
                if (this.isOnVerticalScrollbarThumb(x, y)) {
                    this.mScrollCache.mScrollBarDraggingState = 1;
                    this.mScrollCache.mScrollBarDraggingPos = y;
                    return true;
                }
                if (!this.isOnHorizontalScrollbarThumb(x, y)) break;
                this.mScrollCache.mScrollBarDraggingState = 2;
                this.mScrollCache.mScrollBarDraggingPos = x;
                return true;
            }
        }
        this.mScrollCache.mScrollBarDraggingState = 0;
        return false;
    }

    @ApiStatus.Internal
    public boolean isInScrollingContainer() {
        ViewParent p = this.getParent();
        while (p instanceof ViewGroup) {
            if (((ViewGroup)p).shouldDelayChildPressedState()) {
                return true;
            }
            p = p.getParent();
        }
        return false;
    }

    private void removeLongPressCallback() {
        if (this.mPendingCheckForLongPress != null) {
            this.removeCallbacks(this.mPendingCheckForLongPress);
        }
    }

    private boolean hasPendingLongPressCallback() {
        if (this.mPendingCheckForLongPress == null) {
            return false;
        }
        AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo == null) {
            return false;
        }
        return attachInfo.mHandler.hasCallbacks(this.mPendingCheckForLongPress);
    }

    private void removePerformClickCallback() {
        if (this.mPerformClick != null) {
            this.removeCallbacks(this.mPerformClick);
        }
    }

    private void removeUnsetPressCallback() {
        if ((this.mPrivateFlags & 0x4000) != 0 && this.mUnsetPressedState != null) {
            this.setPressed(false);
            this.removeCallbacks(this.mUnsetPressedState);
        }
    }

    private void removeTapCallback() {
        if (this.mPendingCheckForTap != null) {
            this.mPrivateFlags &= 0xFDFFFFFF;
            this.removeCallbacks(this.mPendingCheckForTap);
        }
    }

    public void cancelLongPress() {
        this.removeLongPressCallback();
        this.removeTapCallback();
    }

    public boolean performClick() {
        boolean result;
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnClickListener != null) {
            this.playSoundEffect(0);
            li.mOnClickListener.onClick(this);
            result = true;
        } else {
            result = false;
        }
        return result;
    }

    public boolean callOnClick() {
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnClickListener != null) {
            li.mOnClickListener.onClick(this);
            return true;
        }
        return false;
    }

    private void checkForLongClick(long delay, float x, float y) {
        if ((this.mViewFlags & 0x200000) == 0x200000 || (this.mViewFlags & 0x40000000) == 0x40000000) {
            this.mHasPerformedLongPress = false;
            if (this.mPendingCheckForLongPress == null) {
                this.mPendingCheckForLongPress = new CheckForLongPress();
            }
            this.mPendingCheckForLongPress.setAnchor(x, y);
            this.mPendingCheckForLongPress.rememberWindowAttachCount();
            this.mPendingCheckForLongPress.rememberPressedState();
            this.postDelayed(this.mPendingCheckForLongPress, delay);
        }
    }

    public boolean performLongClick() {
        return this.performLongClickInternal(this.mLongClickX, this.mLongClickY);
    }

    public boolean performLongClick(float x, float y) {
        this.mLongClickX = x;
        this.mLongClickY = y;
        boolean handled = this.performLongClick();
        this.mLongClickX = Float.NaN;
        this.mLongClickY = Float.NaN;
        return handled;
    }

    private boolean performLongClickInternal(float x, float y) {
        boolean handled = false;
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnLongClickListener != null) {
            handled = li.mOnLongClickListener.onLongClick(this);
        }
        if (!handled) {
            boolean isAnchored = !Float.isNaN(x) && !Float.isNaN(y);
            boolean bl = handled = isAnchored ? this.showContextMenu(x, y) : this.showContextMenu();
        }
        if ((this.mViewFlags & 0x40000000) == 0x40000000 && !handled) {
            handled = this.showLongClickTooltip((int)x, (int)y);
        }
        if (handled) {
            this.performHapticFeedback(0);
        }
        return handled;
    }

    public boolean performContextClick(float x, float y) {
        return this.performContextClick();
    }

    public boolean performContextClick() {
        boolean handled = false;
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnContextClickListener != null) {
            handled = li.mOnContextClickListener.onContextClick(this);
        }
        if (handled) {
            this.performHapticFeedback(6);
        }
        return handled;
    }

    @ApiStatus.Internal
    protected boolean performButtonActionOnTouchDown(@NonNull MotionEvent event) {
        if (this.isLongClickable() && (event.getButtonState() & 2) != 0) {
            this.showContextMenu(event.getX(), event.getY());
            this.mPrivateFlags |= 0x4000000;
            return true;
        }
        return false;
    }

    public final boolean showContextMenu() {
        return this.showContextMenu(Float.NaN, Float.NaN);
    }

    public boolean showContextMenu(float x, float y) {
        ViewParent parent = this.getParent();
        if (parent == null) {
            return false;
        }
        return parent.showContextMenuForChild(this, x, y);
    }

    public final ActionMode startActionMode(ActionMode.Callback callback) {
        return this.startActionMode(callback, 0);
    }

    public ActionMode startActionMode(ActionMode.Callback callback, int type) {
        ViewParent parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return parent.startActionModeForChild(this, callback, type);
    }

    public final void createContextMenu(@NonNull ContextMenu menu) {
        ContextMenu.ContextMenuInfo menuInfo = this.getContextMenuInfo();
        ((MenuBuilder)((Object)menu)).setCurrentMenuInfo(menuInfo);
        this.onCreateContextMenu(menu);
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnCreateContextMenuListener != null) {
            li.mOnCreateContextMenuListener.onCreateContextMenu(menu, this, menuInfo);
        }
        ((MenuBuilder)((Object)menu)).setCurrentMenuInfo(null);
        if (this.mParent != null) {
            this.mParent.createContextMenu(menu);
        }
    }

    protected ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return null;
    }

    protected void onCreateContextMenu(@NonNull ContextMenu menu) {
    }

    public final boolean isTemporarilyDetached() {
        return (this.mPrivateFlags3 & 0x2000000) != 0;
    }

    @CallSuper
    public void dispatchStartTemporaryDetach() {
        this.mPrivateFlags3 |= 0x2000000;
        this.onStartTemporaryDetach();
    }

    public void onStartTemporaryDetach() {
        this.removeUnsetPressCallback();
        this.mPrivateFlags |= 0x4000000;
    }

    @CallSuper
    public void dispatchFinishTemporaryDetach() {
        this.mPrivateFlags3 &= 0xFDFFFFFF;
        this.onFinishTemporaryDetach();
    }

    public void onFinishTemporaryDetach() {
    }

    @Nullable
    public final KeyEvent.DispatcherState getKeyDispatcherState() {
        return this.mAttachInfo != null ? this.mAttachInfo.mKeyDispatchState : null;
    }

    public boolean dispatchKeyEvent(@NonNull KeyEvent event) {
        ListenerInfo li = this.mListenerInfo;
        if (li != null && li.mOnKeyListener != null && (this.mViewFlags & 0x20) == 0 && li.mOnKeyListener.onKey(this, event.getKeyCode(), event)) {
            return true;
        }
        return switch (event.getAction()) {
            case 0 -> this.onKeyDown(event.getKeyCode(), event);
            case 1 -> this.onKeyUp(event.getKeyCode(), event);
            default -> false;
        };
    }

    public boolean dispatchKeyShortcutEvent(@NonNull KeyEvent event) {
        return this.onKeyShortcut(event.getKeyCode(), event);
    }

    public boolean onKeyDown(int keyCode, @NonNull KeyEvent event) {
        if (keyCode == 257 || keyCode == 335) {
            if ((this.mViewFlags & 0x20) == 32) {
                return true;
            }
            if (event.getRepeatCount() == 0) {
                boolean clickable;
                boolean bl = clickable = (this.mViewFlags & 0x4000) == 16384 || (this.mViewFlags & 0x200000) == 0x200000;
                if (clickable || (this.mViewFlags & 0x40000000) == 0x40000000) {
                    float x = (float)this.getWidth() / 2.0f;
                    float y = (float)this.getHeight() / 2.0f;
                    if (clickable) {
                        this.setPressed(true);
                    }
                    this.checkForLongClick(ViewConfiguration.getLongPressTimeout(), x, y);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean onKeyUp(int keyCode, @NonNull KeyEvent event) {
        if (keyCode == 257 || keyCode == 335) {
            if ((this.mViewFlags & 0x20) == 32) {
                return true;
            }
            if ((this.mViewFlags & 0x4000) == 16384 && this.isPressed()) {
                this.setPressed(false);
                if (!this.mHasPerformedLongPress) {
                    this.removeLongPressCallback();
                    return this.performClick();
                }
            }
        }
        if (keyCode == 348) {
            if ((this.mViewFlags & 0x20) == 32) {
                return true;
            }
            if (this.isLongClickable()) {
                this.showContextMenu();
                return true;
            }
        }
        return false;
    }

    public boolean onKeyShortcut(int keyCode, @NonNull KeyEvent event) {
        return false;
    }

    public void getHitRect(Rect outRect) {
        if (this.hasIdentityMatrix() || this.mAttachInfo == null) {
            outRect.set(this.mLeft, this.mTop, this.mRight, this.mBottom);
        } else {
            RectF tmpRect = this.mAttachInfo.mTmpTransformRect;
            tmpRect.set(0.0f, 0.0f, this.getWidth(), this.getHeight());
            this.getMatrix().mapRect(tmpRect);
            outRect.set((int)tmpRect.left + this.mLeft, (int)tmpRect.top + this.mTop, (int)tmpRect.right + this.mLeft, (int)tmpRect.bottom + this.mTop);
        }
    }

    final boolean pointInView(float localX, float localY) {
        return this.pointInView(localX, localY, 0.0f);
    }

    @ApiStatus.Internal
    public boolean pointInView(float localX, float localY, float slop) {
        return localX >= -slop && localY >= -slop && localX < (float)(this.mRight - this.mLeft) + slop && localY < (float)(this.mBottom - this.mTop) + slop;
    }

    public void getFocusedRect(@NonNull Rect r) {
        this.getDrawingRect(r);
    }

    public boolean getGlobalVisibleRect(@NonNull Rect r, @Nullable Point globalOffset) {
        int width = this.mRight - this.mLeft;
        int height = this.mBottom - this.mTop;
        if (width > 0 && height > 0) {
            r.set(0, 0, width, height);
            if (globalOffset != null) {
                globalOffset.set(-this.mScrollX, -this.mScrollY);
            }
            return this.mParent == null || this.mParent.getChildVisibleRect(this, r, globalOffset);
        }
        return false;
    }

    public final boolean getGlobalVisibleRect(@NonNull Rect r) {
        return this.getGlobalVisibleRect(r, null);
    }

    public final boolean getLocalVisibleRect(@NonNull Rect r) {
        Point offset;
        Point point = offset = this.mAttachInfo != null ? this.mAttachInfo.mPoint : new Point();
        if (this.getGlobalVisibleRect(r, offset)) {
            r.offset(-offset.x, -offset.y);
            return true;
        }
        return false;
    }

    public void offsetTopAndBottom(int offset) {
        if (offset != 0) {
            this.mTop += offset;
            this.mBottom += offset;
            this.mRenderNode.offsetTopAndBottom(offset);
            this.invalidate();
        }
    }

    public void offsetLeftAndRight(int offset) {
        if (offset != 0) {
            this.mLeft += offset;
            this.mRight += offset;
            this.mRenderNode.offsetLeftAndRight(offset);
            this.invalidate();
        }
    }

    public final Context getContext() {
        return this.mContext;
    }

    public boolean isInTouchMode() {
        if (this.mAttachInfo != null) {
            return this.mAttachInfo.mInTouchMode;
        }
        return false;
    }

    public PointerIcon onResolvePointerIcon(@NonNull MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        if (this.isDraggingScrollBar() || this.isOnScrollbarThumb(x, y)) {
            return PointerIcon.getSystemIcon(1000);
        }
        return null;
    }

    public void setTooltipText(@Nullable CharSequence tooltipText) {
        if (TextUtils.isEmpty(tooltipText)) {
            this.setFlags(0, 0x40000000);
            this.hideTooltip();
            this.mTooltipInfo = null;
        } else {
            this.setFlags(0x40000000, 0x40000000);
            if (this.mTooltipInfo == null) {
                this.mTooltipInfo = new TooltipInfo();
                this.mTooltipInfo.mShowTooltipRunnable = this::showHoverTooltip;
                this.mTooltipInfo.mHideTooltipRunnable = this::hideTooltip;
                this.mTooltipInfo.mHoverSlop = ViewConfiguration.get(this.mContext).getScaledHoverSlop();
                this.mTooltipInfo.clearAnchorPos();
            }
            this.mTooltipInfo.mTooltipText = tooltipText;
        }
    }

    @Nullable
    public CharSequence getTooltipText() {
        return this.mTooltipInfo != null ? this.mTooltipInfo.mTooltipText : null;
    }

    private boolean showTooltip(int x, int y, boolean fromLongClick) {
        if (this.mAttachInfo == null || this.mTooltipInfo == null) {
            return false;
        }
        if (fromLongClick && (this.mViewFlags & 0x20) != 0) {
            return false;
        }
        if (TextUtils.isEmpty(this.mTooltipInfo.mTooltipText)) {
            return false;
        }
        this.hideTooltip();
        this.mTooltipInfo.mTooltipFromLongClick = fromLongClick;
        this.mTooltipInfo.mTooltipPopup = new TooltipPopup(this.getContext());
        boolean fromTouch = (this.mPrivateFlags3 & 0x20000) == 131072;
        this.mTooltipInfo.mTooltipPopup.show(this, x, y, fromTouch, this.mTooltipInfo.mTooltipText);
        this.mAttachInfo.mTooltipHost = this;
        return true;
    }

    void hideTooltip() {
        if (this.mTooltipInfo == null) {
            return;
        }
        this.removeCallbacks(this.mTooltipInfo.mShowTooltipRunnable);
        if (this.mTooltipInfo.mTooltipPopup == null) {
            return;
        }
        this.mTooltipInfo.mTooltipPopup.hide();
        this.mTooltipInfo.mTooltipPopup = null;
        this.mTooltipInfo.mTooltipFromLongClick = false;
        this.mTooltipInfo.clearAnchorPos();
        if (this.mAttachInfo != null) {
            this.mAttachInfo.mTooltipHost = null;
        }
    }

    private boolean showLongClickTooltip(int x, int y) {
        this.removeCallbacks(this.mTooltipInfo.mShowTooltipRunnable);
        this.removeCallbacks(this.mTooltipInfo.mHideTooltipRunnable);
        return this.showTooltip(x, y, true);
    }

    private void showHoverTooltip() {
        this.showTooltip(this.mTooltipInfo.mAnchorX, this.mTooltipInfo.mAnchorY, false);
    }

    boolean dispatchTooltipHoverEvent(@NonNull MotionEvent event) {
        if (this.mTooltipInfo == null) {
            return false;
        }
        switch (event.getAction()) {
            case 7: {
                if ((this.mViewFlags & 0x40000000) != 0x40000000) break;
                if (!this.mTooltipInfo.mTooltipFromLongClick && this.mTooltipInfo.updateAnchorPos(event)) {
                    if (this.mTooltipInfo.mTooltipPopup == null) {
                        this.removeCallbacks(this.mTooltipInfo.mShowTooltipRunnable);
                        this.postDelayed(this.mTooltipInfo.mShowTooltipRunnable, ViewConfiguration.getHoverTooltipShowTimeout());
                    }
                    int timeout = ViewConfiguration.getHoverTooltipHideTimeout();
                    this.removeCallbacks(this.mTooltipInfo.mHideTooltipRunnable);
                    this.postDelayed(this.mTooltipInfo.mHideTooltipRunnable, timeout);
                }
                return true;
            }
            case 10: {
                this.mTooltipInfo.clearAnchorPos();
                if (this.mTooltipInfo.mTooltipFromLongClick) break;
                this.hideTooltip();
            }
        }
        return false;
    }

    void handleTooltipKey(KeyEvent event) {
        switch (event.getAction()) {
            case 0: {
                if (event.getRepeatCount() != 0) break;
                this.hideTooltip();
                break;
            }
            case 1: {
                this.handleTooltipUp();
            }
        }
    }

    private void handleTooltipUp() {
        if (this.mTooltipInfo == null || this.mTooltipInfo.mTooltipPopup == null) {
            return;
        }
        this.removeCallbacks(this.mTooltipInfo.mHideTooltipRunnable);
        this.postDelayed(this.mTooltipInfo.mHideTooltipRunnable, ViewConfiguration.getLongPressTooltipHideTimeout());
    }

    @ApiStatus.Internal
    public View getTooltipView() {
        if (this.mTooltipInfo == null || this.mTooltipInfo.mTooltipPopup == null) {
            return null;
        }
        return this.mTooltipInfo.mTooltipPopup.getContentView();
    }

    public final void setTransitionVisibility(int visibility) {
        this.mViewFlags = this.mViewFlags & 0xFFFFFFF3 | visibility;
    }

    public final void setTransitionName(String transitionName) {
        this.mTransitionName = transitionName;
    }

    public String getTransitionName() {
        return this.mTransitionName;
    }

    public String toString() {
        StringBuilder out = new StringBuilder(128);
        out.append(this.getClass().getName());
        out.append('{');
        out.append(Integer.toHexString(System.identityHashCode(this)));
        out.append(' ');
        switch (this.mViewFlags & 0xC) {
            case 0: {
                out.append('V');
                break;
            }
            case 4: {
                out.append('I');
                break;
            }
            case 8: {
                out.append('G');
                break;
            }
            default: {
                out.append('.');
            }
        }
        out.append((this.mViewFlags & 1) == 1 ? (char)'F' : '.');
        out.append((this.mViewFlags & 0x20) == 0 ? (char)'E' : '.');
        out.append((this.mViewFlags & 0x80) == 128 ? (char)'.' : 'D');
        out.append((this.mViewFlags & 0x100) != 0 ? (char)'H' : '.');
        out.append((this.mViewFlags & 0x200) != 0 ? (char)'V' : '.');
        out.append((this.mViewFlags & 0x4000) != 0 ? (char)'C' : '.');
        out.append((this.mViewFlags & 0x200000) != 0 ? (char)'L' : '.');
        out.append((this.mViewFlags & 0x800000) != 0 ? (char)'X' : '.');
        out.append(' ');
        out.append((this.mPrivateFlags & 8) != 0 ? (char)'R' : '.');
        out.append((this.mPrivateFlags & 2) != 0 ? (char)'F' : '.');
        out.append((this.mPrivateFlags & 4) != 0 ? (char)'S' : '.');
        if ((this.mPrivateFlags & 0x2000000) != 0) {
            out.append('p');
        } else {
            out.append((this.mPrivateFlags & 0x4000) != 0 ? (char)'P' : '.');
        }
        out.append((this.mPrivateFlags & 0x10000000) != 0 ? (char)'H' : '.');
        out.append((this.mPrivateFlags & 0x40000000) != 0 ? (char)'A' : '.');
        out.append((this.mPrivateFlags & Integer.MIN_VALUE) != 0 ? (char)'I' : '.');
        out.append((this.mPrivateFlags & 0x200000) != 0 ? (char)'D' : '.');
        out.append(' ');
        out.append(this.mLeft);
        out.append(',');
        out.append(this.mTop);
        out.append('-');
        out.append(this.mRight);
        out.append(',');
        out.append(this.mBottom);
        int id2 = this.getId();
        if (id2 != -1) {
            out.append(" #");
            out.append(Integer.toHexString(id2));
        }
        out.append("}");
        return out.toString();
    }

    static {
        WINDOW_FOCUSED_STATE_SET = StateSet.get(1);
        SELECTED_STATE_SET = StateSet.get(2);
        SELECTED_WINDOW_FOCUSED_STATE_SET = StateSet.get(3);
        FOCUSED_STATE_SET = StateSet.get(4);
        FOCUSED_WINDOW_FOCUSED_STATE_SET = StateSet.get(5);
        FOCUSED_SELECTED_STATE_SET = StateSet.get(6);
        FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET = StateSet.get(7);
        ENABLED_STATE_SET = StateSet.get(8);
        ENABLED_WINDOW_FOCUSED_STATE_SET = StateSet.get(9);
        ENABLED_SELECTED_STATE_SET = StateSet.get(10);
        ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET = StateSet.get(11);
        ENABLED_FOCUSED_STATE_SET = StateSet.get(12);
        ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET = StateSet.get(13);
        ENABLED_FOCUSED_SELECTED_STATE_SET = StateSet.get(14);
        ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET = StateSet.get(15);
        PRESSED_STATE_SET = StateSet.get(16);
        PRESSED_WINDOW_FOCUSED_STATE_SET = StateSet.get(17);
        PRESSED_SELECTED_STATE_SET = StateSet.get(18);
        PRESSED_SELECTED_WINDOW_FOCUSED_STATE_SET = StateSet.get(19);
        PRESSED_FOCUSED_STATE_SET = StateSet.get(20);
        PRESSED_FOCUSED_WINDOW_FOCUSED_STATE_SET = StateSet.get(21);
        PRESSED_FOCUSED_SELECTED_STATE_SET = StateSet.get(22);
        PRESSED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET = StateSet.get(23);
        PRESSED_ENABLED_STATE_SET = StateSet.get(24);
        PRESSED_ENABLED_WINDOW_FOCUSED_STATE_SET = StateSet.get(25);
        PRESSED_ENABLED_SELECTED_STATE_SET = StateSet.get(26);
        PRESSED_ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET = StateSet.get(27);
        PRESSED_ENABLED_FOCUSED_STATE_SET = StateSet.get(28);
        PRESSED_ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET = StateSet.get(29);
        PRESSED_ENABLED_FOCUSED_SELECTED_STATE_SET = StateSet.get(30);
        PRESSED_ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET = StateSet.get(31);
        sThreadLocal = ThreadLocal.withInitial(Rect::new);
        sNextGeneratedId = new AtomicInteger(65536);
        LAYOUT_DIRECTION_FLAGS = new int[]{0, 1, 2, 3};
        PFLAG2_TEXT_DIRECTION_FLAGS = new int[]{0, 64, 128, 192, 256, 320, 384, 448};
        PFLAG2_TEXT_ALIGNMENT_FLAGS = new int[]{0, 8192, 16384, 24576, 32768, 40960, 49152};
        ALPHA = new FloatProperty<View>("alpha"){

            @Override
            public void setValue(View object, float value) {
                object.setAlpha(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getAlpha());
            }
        };
        TRANSLATION_X = new FloatProperty<View>("translationX"){

            @Override
            public void setValue(View object, float value) {
                object.setTranslationX(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getTranslationX());
            }
        };
        TRANSLATION_Y = new FloatProperty<View>("translationY"){

            @Override
            public void setValue(View object, float value) {
                object.setTranslationY(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getTranslationY());
            }
        };
        TRANSLATION_Z = new FloatProperty<View>("translationZ"){

            @Override
            public void setValue(View object, float value) {
                object.setTranslationZ(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getTranslationZ());
            }
        };
        X = new FloatProperty<View>("x"){

            @Override
            public void setValue(View object, float value) {
                object.setX(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getX());
            }
        };
        Y = new FloatProperty<View>("y"){

            @Override
            public void setValue(View object, float value) {
                object.setY(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getY());
            }
        };
        Z = new FloatProperty<View>("z"){

            @Override
            public void setValue(View object, float value) {
                object.setZ(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getZ());
            }
        };
        ROTATION = new FloatProperty<View>("rotation"){

            @Override
            public void setValue(View object, float value) {
                object.setRotation(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getRotation());
            }
        };
        ROTATION_X = new FloatProperty<View>("rotationX"){

            @Override
            public void setValue(View object, float value) {
                object.setRotationX(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getRotationX());
            }
        };
        ROTATION_Y = new FloatProperty<View>("rotationY"){

            @Override
            public void setValue(View object, float value) {
                object.setRotationY(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getRotationY());
            }
        };
        SCALE_X = new FloatProperty<View>("scaleX"){

            @Override
            public void setValue(View object, float value) {
                object.setScaleX(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getScaleX());
            }
        };
        SCALE_Y = new FloatProperty<View>("scaleY"){

            @Override
            public void setValue(View object, float value) {
                object.setScaleY(value);
            }

            @Override
            public Float get(View object) {
                return Float.valueOf(object.getScaleY());
            }
        };
        LEFT = new IntProperty<View>("left"){

            @Override
            public void setValue(View object, int value) {
                object.setLeft(value);
            }

            @Override
            public Integer get(View object) {
                return object.getLeft();
            }
        };
        TOP = new IntProperty<View>("top"){

            @Override
            public void setValue(View object, int value) {
                object.setTop(value);
            }

            @Override
            public Integer get(View object) {
                return object.getTop();
            }
        };
        RIGHT = new IntProperty<View>("right"){

            @Override
            public void setValue(View object, int value) {
                object.setRight(value);
            }

            @Override
            public Integer get(View object) {
                return object.getRight();
            }
        };
        BOTTOM = new IntProperty<View>("bottom"){

            @Override
            public void setValue(View object, int value) {
                object.setBottom(value);
            }

            @Override
            public Integer get(View object) {
                return object.getBottom();
            }
        };
        SCROLL_X = new IntProperty<View>("scrollX"){

            @Override
            public void setValue(View object, int value) {
                object.setScrollX(value);
            }

            @Override
            public Integer get(View object) {
                return object.getScrollX();
            }
        };
        SCROLL_Y = new IntProperty<View>("scrollY"){

            @Override
            public void setValue(View object, int value) {
                object.setScrollY(value);
            }

            @Override
            public Integer get(View object) {
                return object.getScrollY();
            }
        };
    }

    private static class ForegroundInfo {
        private Drawable mDrawable;
        private int mGravity = 119;
        private boolean mInsidePadding = true;
        private boolean mBoundsChanged = true;
        private final Rect mSelfBounds = new Rect();
        private final Rect mOverlayBounds = new Rect();

        private ForegroundInfo() {
        }
    }

    static class ListenerInfo {
        private OnTouchListener mOnTouchListener;
        private OnHoverListener mOnHoverListener;
        private OnGenericMotionListener mOnGenericMotionListener;
        private OnKeyListener mOnKeyListener;
        private OnClickListener mOnClickListener;
        private OnLongClickListener mOnLongClickListener;
        private OnDragListener mOnDragListener;
        private OnContextClickListener mOnContextClickListener;
        private OnCreateContextMenuListener mOnCreateContextMenuListener;
        protected OnScrollChangeListener mOnScrollChangeListener;
        private OnFocusChangeListener mOnFocusChangeListener;
        private CopyOnWriteArrayList<OnLayoutChangeListener> mOnLayoutChangeListeners;
        private CopyOnWriteArrayList<OnAttachStateChangeListener> mOnAttachStateChangeListeners;

        ListenerInfo() {
        }
    }

    @FunctionalInterface
    public static interface OnLayoutChangeListener {
        public void onLayoutChange(View var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);
    }

    private static class MatchIdPredicate
    implements Predicate<View> {
        public int mId;

        private MatchIdPredicate() {
        }

        @Override
        public boolean test(View view) {
            return view.mID == this.mId;
        }
    }

    @FunctionalInterface
    public static interface OnFocusChangeListener {
        public void onFocusChange(View var1, boolean var2);
    }

    @FunctionalInterface
    public static interface OnScrollChangeListener {
        public void onScrollChange(View var1, int var2, int var3, int var4, int var5);
    }

    public static interface OnAttachStateChangeListener {
        public void onViewAttachedToWindow(View var1);

        public void onViewDetachedFromWindow(View var1);
    }

    public static class DragShadow {
        private final WeakReference<View> viewRef;

        public DragShadow(View view) {
            this.viewRef = new WeakReference<View>(view);
        }

        public DragShadow() {
            this.viewRef = new WeakReference<Object>(null);
        }

        @Nullable
        public final View getView() {
            return (View)this.viewRef.get();
        }

        public void onProvideShadowCenter(@NonNull Point outShadowCenter) {
        }

        public void onDrawShadow(@NonNull Canvas canvas) {
            View view = (View)this.viewRef.get();
            if (view != null) {
                view.onDraw(canvas);
            } else {
                ModernUI.LOGGER.error(VIEW_MARKER, "No view found on draw shadow");
            }
        }
    }

    @FunctionalInterface
    public static interface OnGenericMotionListener {
        public boolean onGenericMotion(View var1, MotionEvent var2);
    }

    @FunctionalInterface
    public static interface OnHoverListener {
        public boolean onHover(View var1, MotionEvent var2);
    }

    @FunctionalInterface
    public static interface OnClickListener {
        public void onClick(View var1);
    }

    @FunctionalInterface
    public static interface OnLongClickListener {
        public boolean onLongClick(View var1);
    }

    @FunctionalInterface
    public static interface OnContextClickListener {
        public boolean onContextClick(View var1);
    }

    @FunctionalInterface
    public static interface OnCreateContextMenuListener {
        public void onCreateContextMenu(ContextMenu var1, View var2, ContextMenu.ContextMenuInfo var3);
    }

    @FunctionalInterface
    public static interface OnKeyListener {
        public boolean onKey(View var1, int var2, KeyEvent var3);
    }

    @FunctionalInterface
    public static interface OnTouchListener {
        public boolean onTouch(View var1, MotionEvent var2);
    }

    @FunctionalInterface
    public static interface OnDragListener {
        public boolean onDrag(View var1, DragEvent var2);
    }

    private final class PerformClick
    implements Runnable {
        private PerformClick() {
        }

        @Override
        public void run() {
            View.this.performClick();
        }
    }

    private final class UnsetPressedState
    implements Runnable {
        private UnsetPressedState() {
        }

        @Override
        public void run() {
            View.this.setPressed(false);
        }
    }

    private final class CheckForTap
    implements Runnable {
        public float x;
        public float y;

        private CheckForTap() {
        }

        @Override
        public void run() {
            View.this.mPrivateFlags &= 0xFDFFFFFF;
            View.this.setPressed(this.x, this.y);
            long delay = ViewConfiguration.getLongPressTimeout() - ViewConfiguration.getTapTimeout();
            View.this.checkForLongClick(delay, this.x, this.y);
        }
    }

    private final class CheckForLongPress
    implements Runnable {
        private int mOriginalWindowAttachCount;
        private float mX;
        private float mY;
        private boolean mOriginalPressedState;

        private CheckForLongPress() {
        }

        @Override
        public void run() {
            if (this.mOriginalPressedState == View.this.isPressed() && View.this.mParent != null && this.mOriginalWindowAttachCount == View.this.mWindowAttachCount && View.this.performLongClick(this.mX, this.mY)) {
                View.this.mHasPerformedLongPress = true;
            }
        }

        public void setAnchor(float x, float y) {
            this.mX = x;
            this.mY = y;
        }

        public void rememberWindowAttachCount() {
            this.mOriginalWindowAttachCount = View.this.mWindowAttachCount;
        }

        public void rememberPressedState() {
            this.mOriginalPressedState = View.this.isPressed();
        }
    }

    private static class TooltipInfo {
        @Nullable
        CharSequence mTooltipText;
        int mAnchorX;
        int mAnchorY;
        @Nullable
        TooltipPopup mTooltipPopup;
        boolean mTooltipFromLongClick;
        Runnable mShowTooltipRunnable;
        Runnable mHideTooltipRunnable;
        int mHoverSlop;

        private TooltipInfo() {
        }

        private boolean updateAnchorPos(MotionEvent event) {
            int newAnchorX = (int)event.getX();
            int newAnchorY = (int)event.getY();
            if (Math.abs(newAnchorX - this.mAnchorX) <= this.mHoverSlop && Math.abs(newAnchorY - this.mAnchorY) <= this.mHoverSlop) {
                return false;
            }
            this.mAnchorX = newAnchorX;
            this.mAnchorY = newAnchorY;
            return true;
        }

        private void clearAnchorPos() {
            this.mAnchorX = Integer.MAX_VALUE;
            this.mAnchorY = Integer.MAX_VALUE;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NestedScrollType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScrollAxis {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScrollIndicators {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TextAlignment {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ResolvedLayoutDir {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LayoutDir {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FocusRealDirection {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FocusDirection {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FocusableMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScrollBarStyle {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Visibility {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Focusable {
    }
}

