/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.util;

import icyllis.modernui.util.DisplayMetrics;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.jetbrains.annotations.ApiStatus;

public class TypedValue {
    public static final int TYPE_NULL = 0;
    public static final int TYPE_REFERENCE = 1;
    public static final int TYPE_ATTRIBUTE = 2;
    public static final int TYPE_STRING = 3;
    public static final int TYPE_FLOAT = 4;
    public static final int TYPE_DIMENSION = 5;
    public static final int TYPE_FRACTION = 6;
    public static final int COMPLEX_UNIT_SHIFT = 0;
    public static final int COMPLEX_UNIT_MASK = 15;
    public static final int COMPLEX_UNIT_PX = 0;
    public static final int COMPLEX_UNIT_DP = 1;
    public static final int COMPLEX_UNIT_SP = 2;
    public static final int COMPLEX_UNIT_PT = 3;
    public static final int COMPLEX_UNIT_IN = 4;
    public static final int COMPLEX_UNIT_MM = 5;
    public static final int COMPLEX_UNIT_FRACTION = 0;
    public static final int COMPLEX_UNIT_FRACTION_PARENT = 1;
    public static final int COMPLEX_RADIX_SHIFT = 4;
    public static final int COMPLEX_RADIX_MASK = 3;
    public static final int COMPLEX_RADIX_23p0 = 0;
    public static final int COMPLEX_RADIX_16p7 = 1;
    public static final int COMPLEX_RADIX_8p15 = 2;
    public static final int COMPLEX_RADIX_0p23 = 3;
    public static final int COMPLEX_MANTISSA_SHIFT = 8;
    public static final int COMPLEX_MANTISSA_MASK = 0xFFFFFF;
    private static final float MANTISSA_MULT = 0.00390625f;
    private static final float[] RADIX_MULTS = new float[]{0.00390625f, 3.0517578E-5f, 1.1920929E-7f, 4.656613E-10f};

    public static float complexToFloat(int complex) {
        return (float)(complex & 0xFFFFFF00) * RADIX_MULTS[complex >> 4 & 3];
    }

    public static float complexToDimension(int data, DisplayMetrics metrics) {
        return TypedValue.applyDimension(data >> 0 & 0xF, TypedValue.complexToFloat(data), metrics);
    }

    public static int complexToDimensionPixelOffset(int data, DisplayMetrics metrics) {
        return (int)TypedValue.applyDimension(data >> 0 & 0xF, TypedValue.complexToFloat(data), metrics);
    }

    public static int complexToDimensionPixelSize(int data, DisplayMetrics metrics) {
        float value = TypedValue.complexToFloat(data);
        float f = TypedValue.applyDimension(data >> 0 & 0xF, value, metrics);
        int res = (int)(f >= 0.0f ? f + 0.5f : f - 0.5f);
        if (res != 0) {
            return res;
        }
        if (value == 0.0f) {
            return 0;
        }
        if (value > 0.0f) {
            return 1;
        }
        return -1;
    }

    public static float applyDimension(int unit, float value, DisplayMetrics metrics) {
        return switch (unit) {
            case 0 -> value;
            case 1 -> value * metrics.density;
            case 2 -> value * metrics.scaledDensity;
            case 3 -> value * metrics.xdpi * 0.013888889f;
            case 4 -> value * metrics.xdpi;
            case 5 -> value * metrics.xdpi * 0.03937008f;
            default -> 0.0f;
        };
    }

    @ApiStatus.Internal
    public static int intToComplex(int value) {
        if (value < -8388608 || value >= 0x800000) {
            throw new IllegalArgumentException("Magnitude of the value is too large: " + value);
        }
        return 0 | value << 8;
    }

    @ApiStatus.Internal
    public static int floatToComplex(float value) {
        int shift;
        int radix;
        if (value < -8388608.0f || value >= 8388607.5f) {
            throw new IllegalArgumentException("Magnitude of the value is too large: " + value);
        }
        int bits = Float.floatToRawIntBits(value) + 0xB800000;
        long mag = (long)(Float.intBitsToFloat(bits & Integer.MAX_VALUE) + 0.5f);
        if ((mag & 0x7FFFFFL) == 0L) {
            radix = 0;
            shift = 23;
        } else if ((mag & 0x7FFFFFFFFF800000L) == 0L) {
            radix = 3;
            shift = 0;
        } else if ((mag & 0x7FFFFFFF80000000L) == 0L) {
            radix = 2;
            shift = 8;
        } else if ((mag & 0x7FFFFF8000000000L) == 0L) {
            radix = 1;
            shift = 16;
        } else {
            radix = 0;
            shift = 23;
        }
        int mantissa = (int)(mag >>> shift) & 0xFFFFFF;
        if ((bits & Integer.MIN_VALUE) != 0) {
            mantissa = -mantissa;
        }
        assert (mantissa >= -8388608 && mantissa < 0x800000);
        return radix << 4 | mantissa << 8;
    }

    @ApiStatus.Internal
    public static int createComplexDimension(int value, int units) {
        if (units < 0 || units > 5) {
            throw new IllegalArgumentException("Must be a valid COMPLEX_UNIT_*: " + units);
        }
        return TypedValue.intToComplex(value) | units;
    }

    @ApiStatus.Internal
    public static int createComplexDimension(float value, int units) {
        if (units < 0 || units > 5) {
            throw new IllegalArgumentException("Must be a valid COMPLEX_UNIT_*: " + units);
        }
        return TypedValue.floatToComplex(value) | units;
    }

    public static float complexToFraction(int data, float base, float pbase) {
        return switch (data >> 0 & 0xF) {
            case 0 -> TypedValue.complexToFloat(data) * base;
            case 1 -> TypedValue.complexToFloat(data) * pbase;
            default -> 0.0f;
        };
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @ApiStatus.Internal
    public static @interface ComplexDimensionUnit {
    }
}

