/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.util;

import icyllis.modernui.util.GrowingArrayUtils;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SparseArray<E>
implements Cloneable {
    private static final Object DELETED = new Object();
    private boolean mGarbage = false;
    private int[] mKeys;
    private Object[] mValues;
    private int mSize;

    public SparseArray() {
        this(10);
    }

    public SparseArray(int initialCapacity) {
        if (initialCapacity == 0) {
            this.mKeys = IntArrays.EMPTY_ARRAY;
            this.mValues = ObjectArrays.EMPTY_ARRAY;
        } else if (initialCapacity > 0) {
            this.mKeys = new int[initialCapacity];
            this.mValues = new Object[initialCapacity];
        } else {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
    }

    public E get(int key) {
        return this.get(key, null);
    }

    public E get(int key, E defaultValue) {
        int i = Arrays.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i < 0 || this.mValues[i] == DELETED) {
            return defaultValue;
        }
        return (E)this.mValues[i];
    }

    public void delete(int key) {
        int i = Arrays.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i >= 0 && this.mValues[i] != DELETED) {
            this.mValues[i] = DELETED;
            this.mGarbage = true;
        }
    }

    public E remove(int key) {
        int i = Arrays.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i >= 0 && this.mValues[i] != DELETED) {
            Object old = this.mValues[i];
            this.mValues[i] = DELETED;
            this.mGarbage = true;
            return (E)old;
        }
        return null;
    }

    public boolean remove(int key, Object value) {
        E mapValue;
        int index = this.indexOfKey(key);
        if (index >= 0 && Objects.equals(value, mapValue = this.valueAt(index))) {
            this.deleteAt(index);
            return true;
        }
        return false;
    }

    public void deleteAt(int index) {
        Objects.checkIndex(index, this.mSize);
        if (this.mValues[index] != DELETED) {
            this.mValues[index] = DELETED;
            this.mGarbage = true;
        }
    }

    public E removeAt(int index) {
        Objects.checkIndex(index, this.mSize);
        if (this.mValues[index] != DELETED) {
            Object old = this.mValues[index];
            this.mValues[index] = DELETED;
            this.mGarbage = true;
            return (E)old;
        }
        return null;
    }

    public void removeAtRange(int index, int size) {
        Objects.checkFromIndexSize(index, size, this.mSize);
        while (size-- > 0) {
            if (this.mValues[index] != DELETED) {
                this.mValues[index] = DELETED;
                this.mGarbage = true;
            }
            ++index;
        }
    }

    @Nullable
    public E replace(int key, E value) {
        int index = this.indexOfKey(key);
        if (index >= 0) {
            Object oldValue = this.mValues[index];
            this.mValues[index] = value;
            return (E)oldValue;
        }
        return null;
    }

    public boolean replace(int key, E oldValue, E newValue) {
        Object mapValue;
        int index = this.indexOfKey(key);
        if (index >= 0 && Objects.equals(oldValue, mapValue = this.mValues[index])) {
            this.mValues[index] = newValue;
            return true;
        }
        return false;
    }

    private void gc() {
        int n = this.mSize;
        int o = 0;
        int[] keys = this.mKeys;
        Object[] values = this.mValues;
        for (int i = 0; i < n; ++i) {
            Object val = values[i];
            if (val == DELETED) continue;
            if (i != o) {
                keys[o] = keys[i];
                values[o] = val;
                values[i] = null;
            }
            ++o;
        }
        this.mGarbage = false;
        this.mSize = o;
    }

    @Nullable
    public E put(int key, E value) {
        int i = Arrays.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i >= 0) {
            Object oldValue = this.mValues[i];
            this.mValues[i] = value;
            return (E)oldValue;
        }
        if ((i ^= 0xFFFFFFFF) < this.mSize && this.mValues[i] == DELETED) {
            this.mKeys[i] = key;
            this.mValues[i] = value;
            return null;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
            i = ~Arrays.binarySearch(this.mKeys, 0, this.mSize, key);
        }
        this.mKeys = GrowingArrayUtils.insert(this.mKeys, this.mSize, i, key);
        this.mValues = GrowingArrayUtils.insert(this.mValues, this.mSize, i, value);
        ++this.mSize;
        return null;
    }

    public void putAll(@Nonnull SparseArray<? extends E> other) {
        int size = other.size();
        for (int i = 0; i < size; ++i) {
            this.put(other.keyAt(i), other.valueAt(i));
        }
    }

    @Nullable
    public E putIfAbsent(int key, E value) {
        E mapValue = this.get(key);
        if (mapValue == null) {
            this.put(key, value);
        }
        return mapValue;
    }

    public int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int keyAt(int index) {
        Objects.checkIndex(index, this.mSize);
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[index];
    }

    public E valueAt(int index) {
        Objects.checkIndex(index, this.mSize);
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[index];
    }

    public void setValueAt(int index, E value) {
        Objects.checkIndex(index, this.mSize);
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[index] = value;
    }

    public int indexOfKey(int key) {
        if (this.mGarbage) {
            this.gc();
        }
        return Arrays.binarySearch(this.mKeys, 0, this.mSize, key);
    }

    public int indexOfValue(E value) {
        if (this.mGarbage) {
            this.gc();
        }
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int indexOfValueByValue(E value) {
        if (this.mGarbage) {
            this.gc();
        }
        for (int i = 0; i < this.mSize; ++i) {
            if (!(value == null ? this.mValues[i] == null : value.equals(this.mValues[i]))) continue;
            return i;
        }
        return -1;
    }

    public boolean containsKey(int key) {
        return this.indexOfKey(key) >= 0;
    }

    public boolean containsValue(E value) {
        return this.indexOfValue(value) >= 0;
    }

    public void clear() {
        int n = this.mSize;
        Object[] values = this.mValues;
        for (int i = 0; i < n; ++i) {
            values[i] = null;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    public void append(int key, E value) {
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        this.mKeys = GrowingArrayUtils.append(this.mKeys, this.mSize, key);
        this.mValues = GrowingArrayUtils.append(this.mValues, this.mSize, value);
        ++this.mSize;
    }

    public String toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.mSize * 28);
        buffer.append('{');
        for (int i = 0; i < this.mSize; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            int key = this.keyAt(i);
            buffer.append(key);
            buffer.append('=');
            E value = this.valueAt(i);
            if (value != this) {
                buffer.append(value);
                continue;
            }
            buffer.append("(this Map)");
        }
        buffer.append('}');
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparseArray other = (SparseArray)o;
        int size = this.size();
        if (size != other.size()) {
            return false;
        }
        for (int index = 0; index < size; ++index) {
            int key = this.keyAt(index);
            if (Objects.equals(this.valueAt(index), other.get(key))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            int key = this.keyAt(index);
            E value = this.valueAt(index);
            hash = 31 * hash + Integer.hashCode(key);
            hash = 31 * hash + Objects.hashCode(value);
        }
        return hash;
    }

    public SparseArray<E> clone() {
        try {
            SparseArray clone = (SparseArray)super.clone();
            clone.mKeys = (int[])this.mKeys.clone();
            clone.mValues = (Object[])this.mValues.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }
}

