/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.text;

import com.ibm.icu.util.ULocale;
import icyllis.arc3d.core.TextBlob;
import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.annotation.Nullable;
import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.graphics.text.Font;
import icyllis.modernui.graphics.text.FontPaint;
import icyllis.modernui.graphics.text.LayoutPiece;
import icyllis.modernui.graphics.text.ShapedText;
import icyllis.modernui.text.GetChars;
import icyllis.modernui.text.MeasuredParagraph;
import icyllis.modernui.text.ParcelableSpan;
import icyllis.modernui.text.Spannable;
import icyllis.modernui.text.SpannableString;
import icyllis.modernui.text.SpannableStringBuilder;
import icyllis.modernui.text.SpannableStringInternal;
import icyllis.modernui.text.Spanned;
import icyllis.modernui.text.SpannedString;
import icyllis.modernui.text.TextDirectionHeuristic;
import icyllis.modernui.text.TextDirectionHeuristics;
import icyllis.modernui.text.TextPaint;
import icyllis.modernui.text.style.AbsoluteSizeSpan;
import icyllis.modernui.text.style.AlignmentSpan;
import icyllis.modernui.text.style.BackgroundColorSpan;
import icyllis.modernui.text.style.CharacterStyle;
import icyllis.modernui.text.style.ForegroundColorSpan;
import icyllis.modernui.text.style.LeadingMarginSpan;
import icyllis.modernui.text.style.LineBackgroundSpan;
import icyllis.modernui.text.style.LocaleSpan;
import icyllis.modernui.text.style.RelativeSizeSpan;
import icyllis.modernui.text.style.StrikethroughSpan;
import icyllis.modernui.text.style.StyleSpan;
import icyllis.modernui.text.style.SubscriptSpan;
import icyllis.modernui.text.style.SuperscriptSpan;
import icyllis.modernui.text.style.TrailingMarginSpan;
import icyllis.modernui.text.style.TypefaceSpan;
import icyllis.modernui.text.style.URLSpan;
import icyllis.modernui.text.style.UnderlineSpan;
import icyllis.modernui.util.Parcel;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;

public final class TextUtils {
    private static final char[][] sTemp = new char[4][];
    static final char ELLIPSIS_FILLER = '\ufeff';
    private static final String ELLIPSIS_NORMAL = "\u2026";
    private static final char[] ELLIPSIS_NORMAL_ARRAY = "\u2026".toCharArray();
    @ApiStatus.Internal
    public static final int FIRST_SPAN = 1;
    @ApiStatus.Internal
    public static final int ALIGNMENT_SPAN = 1;
    @ApiStatus.Internal
    public static final int FOREGROUND_COLOR_SPAN = 2;
    @ApiStatus.Internal
    public static final int RELATIVE_SIZE_SPAN = 3;
    @ApiStatus.Internal
    public static final int SCALE_X_SPAN = 4;
    @ApiStatus.Internal
    public static final int STRIKETHROUGH_SPAN = 5;
    @ApiStatus.Internal
    public static final int UNDERLINE_SPAN = 6;
    @ApiStatus.Internal
    public static final int STYLE_SPAN = 7;
    @ApiStatus.Internal
    public static final int BULLET_SPAN = 8;
    @ApiStatus.Internal
    public static final int QUOTE_SPAN = 9;
    @ApiStatus.Internal
    public static final int LEADING_MARGIN_SPAN = 10;
    @ApiStatus.Internal
    public static final int URL_SPAN = 11;
    @ApiStatus.Internal
    public static final int BACKGROUND_COLOR_SPAN = 12;
    @ApiStatus.Internal
    public static final int TYPEFACE_SPAN = 13;
    @ApiStatus.Internal
    public static final int SUPERSCRIPT_SPAN = 14;
    @ApiStatus.Internal
    public static final int SUBSCRIPT_SPAN = 15;
    @ApiStatus.Internal
    public static final int ABSOLUTE_SIZE_SPAN = 16;
    @ApiStatus.Internal
    public static final int TEXT_APPEARANCE_SPAN = 17;
    @ApiStatus.Internal
    public static final int ANNOTATION = 18;
    @ApiStatus.Internal
    public static final int SUGGESTION_SPAN = 19;
    @ApiStatus.Internal
    public static final int SPELL_CHECK_SPAN = 20;
    @ApiStatus.Internal
    public static final int SUGGESTION_RANGE_SPAN = 21;
    @ApiStatus.Internal
    public static final int EASY_EDIT_SPAN = 22;
    @ApiStatus.Internal
    public static final int LOCALE_SPAN = 23;
    @ApiStatus.Internal
    public static final int TTS_SPAN = 24;
    @ApiStatus.Internal
    public static final int ACCESSIBILITY_CLICKABLE_SPAN = 25;
    @ApiStatus.Internal
    public static final int ACCESSIBILITY_URL_SPAN = 26;
    @ApiStatus.Internal
    public static final int LINE_BACKGROUND_SPAN = 27;
    @ApiStatus.Internal
    public static final int LINE_HEIGHT_SPAN = 28;
    @ApiStatus.Internal
    public static final int ACCESSIBILITY_REPLACEMENT_SPAN = 29;
    @ApiStatus.Internal
    public static final int TRAILING_MARGIN_SPAN = 30;
    @ApiStatus.Internal
    public static final int LAST_SPAN = 30;
    private static final String[] sBinaryCompacts = new String[]{"bytes", "KB", "MB", "GB", "TB", "PB", "EB"};

    private TextUtils() {
    }

    @NonNull
    public static String getEllipsisString(@NonNull TruncateAt method) {
        return ELLIPSIS_NORMAL;
    }

    @ApiStatus.Internal
    @NonNull
    public static char[] getEllipsisChars(@NonNull TruncateAt method) {
        return ELLIPSIS_NORMAL_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NonNull
    public static char[] obtain(int len) {
        if (len > 2000) {
            return new char[len];
        }
        char[] buf = null;
        char[][] cArray = sTemp;
        synchronized (sTemp) {
            char[][] pool = sTemp;
            for (int i = pool.length - 1; i >= 0; --i) {
                buf = pool[i];
                if (buf == null || buf.length < len) continue;
                pool[i] = null;
                break;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (buf == null || buf.length < len) {
                buf = new char[len];
            }
            return buf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void recycle(@NonNull char[] temp) {
        if (temp.length > 2000) {
            return;
        }
        char[][] cArray = sTemp;
        synchronized (sTemp) {
            char[][] pool = sTemp;
            for (int i = 0; i < pool.length; ++i) {
                if (pool[i] != null) continue;
                pool[i] = temp;
                break;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static CharSequence stringOrSpannedString(CharSequence source) {
        if (source == null) {
            return null;
        }
        if (source instanceof SpannedString) {
            return source;
        }
        if (source instanceof Spanned) {
            return new SpannedString(source);
        }
        return source.toString();
    }

    public static boolean isEmpty(@Nullable CharSequence csq) {
        return csq == null || csq.isEmpty();
    }

    public static boolean contentEquals(@Nullable CharSequence a, @Nullable CharSequence b) {
        int length;
        if (a == b) {
            return true;
        }
        if (a != null && b != null && (length = a.length()) == b.length()) {
            if (a instanceof String && b instanceof String) {
                return a.equals(b);
            }
            for (int i = 0; i < length; ++i) {
                if (a.charAt(i) == b.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void getChars(@NonNull CharSequence s, int srcBegin, int srcEnd, @NonNull char[] dst, int dstBegin) {
        if (s instanceof String) {
            ((String)s).getChars(srcBegin, srcEnd, dst, dstBegin);
        } else if (s instanceof GetChars) {
            ((GetChars)s).getChars(srcBegin, srcEnd, dst, dstBegin);
        } else if (s instanceof StringBuffer) {
            ((StringBuffer)s).getChars(srcBegin, srcEnd, dst, dstBegin);
        } else if (s instanceof StringBuilder) {
            ((StringBuilder)s).getChars(srcBegin, srcEnd, dst, dstBegin);
        } else if (s instanceof CharBuffer) {
            CharBuffer buf = (CharBuffer)s;
            buf.get(buf.position() + srcBegin, dst, dstBegin, srcEnd - srcBegin);
        } else {
            for (int i = srcBegin; i < srcEnd; ++i) {
                dst[dstBegin++] = s.charAt(i);
            }
        }
    }

    @NonNull
    public static <T> List<T> removeEmptySpans(@NonNull List<T> spans, @NonNull Spanned spanned) {
        ArrayList<T> copy = null;
        for (int i = 0; i < spans.size(); ++i) {
            int end;
            T span = spans.get(i);
            int start = spanned.getSpanStart(span);
            if (start == (end = spanned.getSpanEnd(span))) {
                if (copy != null) continue;
                copy = new ArrayList<T>(i);
                for (int j = 0; j < i; ++j) {
                    copy.add(spans.get(j));
                }
                continue;
            }
            if (copy == null) continue;
            copy.add(span);
        }
        if (copy == null) {
            return spans;
        }
        return copy;
    }

    public static String substring(CharSequence source, int start, int end) {
        if (source instanceof String) {
            return ((String)source).substring(start, end);
        }
        if (source instanceof StringBuilder) {
            return ((StringBuilder)source).substring(start, end);
        }
        if (source instanceof StringBuffer) {
            return ((StringBuffer)source).substring(start, end);
        }
        if (source instanceof SpannableStringInternal) {
            return source.toString().substring(start, end);
        }
        char[] temp = TextUtils.obtain(end - start);
        TextUtils.getChars(source, start, end, temp, 0);
        String ret = new String(temp, 0, end - start);
        TextUtils.recycle(temp);
        return ret;
    }

    public static int indexOf(CharSequence s, char ch) {
        return TextUtils.indexOf(s, ch, 0);
    }

    public static int indexOf(CharSequence s, char ch, int start) {
        if (s instanceof String) {
            return ((String)s).indexOf(ch, start);
        }
        return TextUtils.indexOf(s, ch, start, s.length());
    }

    public static int indexOf(@NonNull CharSequence s, char ch, int start, int end) {
        Class<?> c = s.getClass();
        if (s instanceof GetChars || c == StringBuffer.class || c == StringBuilder.class || c == String.class || s instanceof CharBuffer) {
            char[] temp = TextUtils.obtain(500);
            while (start < end) {
                int segend = start + 500;
                if (segend > end) {
                    segend = end;
                }
                TextUtils.getChars(s, start, segend, temp, 0);
                int count = segend - start;
                for (int i = 0; i < count; ++i) {
                    if (temp[i] != ch) continue;
                    TextUtils.recycle(temp);
                    return i + start;
                }
                start = segend;
            }
            TextUtils.recycle(temp);
            return -1;
        }
        for (int i = start; i < end; ++i) {
            if (s.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence s, char ch) {
        return TextUtils.lastIndexOf(s, ch, s.length() - 1);
    }

    public static int lastIndexOf(CharSequence s, char ch, int last) {
        Class<?> c = s.getClass();
        if (c == String.class) {
            return ((String)s).lastIndexOf(ch, last);
        }
        return TextUtils.lastIndexOf(s, ch, 0, last);
    }

    public static int lastIndexOf(CharSequence s, char ch, int start, int last) {
        if (last < 0) {
            return -1;
        }
        if (last >= s.length()) {
            last = s.length() - 1;
        }
        int end = last + 1;
        Class<?> c = s.getClass();
        if (s instanceof GetChars || c == StringBuffer.class || c == StringBuilder.class || c == String.class || s instanceof CharBuffer) {
            char[] temp = TextUtils.obtain(500);
            while (start < end) {
                int segstart = end - 500;
                if (segstart < start) {
                    segstart = start;
                }
                TextUtils.getChars(s, segstart, end, temp, 0);
                int count = end - segstart;
                for (int i = count - 1; i >= 0; --i) {
                    if (temp[i] != ch) continue;
                    TextUtils.recycle(temp);
                    return i + segstart;
                }
                end = segstart;
            }
            TextUtils.recycle(temp);
            return -1;
        }
        for (int i = end - 1; i >= start; --i) {
            if (s.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public static void writeToParcel(@Nullable CharSequence cs, @NonNull Parcel dest, int flags) {
        if (cs == null) {
            dest.writeInt(0);
        } else if (cs instanceof Spanned) {
            Spanned sp = (Spanned)cs;
            dest.writeInt(2);
            dest.writeString(cs.toString());
            List<Object> os = sp.getSpans(0, cs.length(), Object.class);
            for (Object o : os) {
                Object target = o;
                if (target instanceof CharacterStyle) {
                    target = ((CharacterStyle)target).getUnderlying();
                }
                if (!(target instanceof ParcelableSpan)) continue;
                ParcelableSpan span = (ParcelableSpan)target;
                int id2 = span.getSpanTypeId();
                if (id2 < 1 || id2 > 30) {
                    throw new AssertionError(id2);
                }
                dest.writeInt(id2);
                span.writeToParcel(dest, flags);
                dest.writeInt(sp.getSpanStart(o));
                dest.writeInt(sp.getSpanEnd(o));
                dest.writeInt(sp.getSpanFlags(o));
            }
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            dest.writeString(cs.toString());
        }
    }

    @Nullable
    public static CharSequence createFromParcel(@NonNull Parcel p) {
        int type = p.readInt();
        if (type == 0) {
            return null;
        }
        String s = p.readString();
        if (type == 1) {
            return s;
        }
        assert (type == 2 && s != null);
        SpannableString sp = new SpannableString(s);
        while ((type = p.readInt()) != 0) {
            switch (type) {
                case 1: {
                    TextUtils.readSpan(p, sp, new AlignmentSpan.Standard(p));
                    break;
                }
                case 2: {
                    TextUtils.readSpan(p, sp, new ForegroundColorSpan(p));
                    break;
                }
                case 3: {
                    TextUtils.readSpan(p, sp, new RelativeSizeSpan(p));
                    break;
                }
                case 5: {
                    TextUtils.readSpan(p, sp, new StrikethroughSpan(p));
                    break;
                }
                case 6: {
                    TextUtils.readSpan(p, sp, new UnderlineSpan(p));
                    break;
                }
                case 7: {
                    TextUtils.readSpan(p, sp, new StyleSpan(p));
                    break;
                }
                case 10: {
                    TextUtils.readSpan(p, sp, new LeadingMarginSpan.Standard(p));
                    break;
                }
                case 11: {
                    TextUtils.readSpan(p, sp, new URLSpan(p));
                    break;
                }
                case 12: {
                    TextUtils.readSpan(p, sp, new BackgroundColorSpan(p));
                    break;
                }
                case 13: {
                    TextUtils.readSpan(p, sp, new TypefaceSpan(p));
                    break;
                }
                case 14: {
                    TextUtils.readSpan(p, sp, new SuperscriptSpan(p));
                    break;
                }
                case 15: {
                    TextUtils.readSpan(p, sp, new SubscriptSpan(p));
                    break;
                }
                case 16: {
                    TextUtils.readSpan(p, sp, new AbsoluteSizeSpan(p));
                    break;
                }
                case 23: {
                    TextUtils.readSpan(p, sp, new LocaleSpan(p));
                    break;
                }
                case 27: {
                    TextUtils.readSpan(p, sp, new LineBackgroundSpan.Standard(p));
                    break;
                }
                case 30: {
                    TextUtils.readSpan(p, sp, new TrailingMarginSpan.Standard(p));
                }
            }
        }
        return sp;
    }

    private static void readSpan(Parcel p, Spannable sp, Object o) {
        sp.setSpan(o, p.readInt(), p.readInt(), p.readInt());
    }

    public static void drawTextRun(@NonNull Canvas canvas, @NonNull char[] text, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, @NonNull TextPaint paint) {
        if ((start | end | contextStart | contextEnd | start - contextStart | end - start | contextEnd - end | text.length - contextEnd) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (start == end) {
            return;
        }
        TextBlob.Builder builder = new TextBlob.Builder();
        ShapedText.doLayoutRun(text, contextStart, contextEnd, start, end, isRtl, paint.getInternalPaint(), null, (piece, offsetX, fontPaint) -> TextUtils.buildTextBlob(builder, piece, offsetX, fontPaint));
        canvas.drawTextBlob(builder.build(), x, y, paint);
    }

    public static void drawTextRun(@NonNull Canvas canvas, @NonNull CharSequence text, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, @NonNull TextPaint paint) {
        if ((start | end | contextStart | contextEnd | start - contextStart | end - start | contextEnd - end | text.length() - contextEnd) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (start == end) {
            return;
        }
        TextBlob.Builder builder = new TextBlob.Builder();
        int len = contextEnd - contextStart;
        char[] buf = TextUtils.obtain(len);
        TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
        ShapedText.doLayoutRun(buf, 0, len, start - contextStart, end - contextStart, isRtl, paint.getInternalPaint(), null, (piece, offsetX, fontPaint) -> TextUtils.buildTextBlob(builder, piece, offsetX, fontPaint));
        TextUtils.recycle(buf);
        canvas.drawTextBlob(builder.build(), x, y, paint);
    }

    static void buildTextBlob(@NonNull TextBlob.Builder builder, @NonNull LayoutPiece piece, float offsetX, @NonNull FontPaint paint) {
        int nGlyphs = piece.getGlyphCount();
        if (nGlyphs == 0) {
            return;
        }
        icyllis.arc3d.core.Font nativeFont = new icyllis.arc3d.core.Font();
        paint.getNativeFont(nativeFont);
        Font lastFont = piece.getFont(0);
        int lastPos = 0;
        for (int currPos = 1; currPos <= nGlyphs; ++currPos) {
            Font currFont;
            Font font = currFont = currPos == nGlyphs ? null : piece.getFont(currPos);
            if (lastFont == currFont) continue;
            nativeFont.setTypeface(lastFont.getNativeTypeface());
            if (nativeFont.getTypeface() != null) {
                int runCount = currPos - lastPos;
                TextBlob.Builder.RunBuffer runBuffer = builder.allocRunPos(nativeFont, runCount, null);
                runBuffer.addGlyphs(piece.getGlyphs(), lastPos, runCount);
                float[] positions = piece.getPositions();
                int i = 0;
                int j = lastPos << 1;
                while (i < runCount) {
                    runBuffer.addPosition(positions[j] + offsetX, positions[j | 1]);
                    ++i;
                    j += 2;
                }
            }
            lastFont = currFont;
            lastPos = currPos;
        }
    }

    @NonNull
    public static CharSequence ellipsize(@NonNull CharSequence text, @NonNull TextPaint p, float avail, @NonNull TruncateAt where) {
        return TextUtils.ellipsize(text, p, avail, where, false, null);
    }

    @NonNull
    public static CharSequence ellipsize(@NonNull CharSequence text, @NonNull TextPaint paint, float avail, @NonNull TruncateAt where, boolean preserveLength, @Nullable EllipsizeCallback callback) {
        return TextUtils.ellipsize(text, paint, avail, where, preserveLength, callback, TextDirectionHeuristics.FIRSTSTRONG_LTR, TextUtils.getEllipsisString(where));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static CharSequence ellipsize(@NonNull CharSequence text, @NonNull TextPaint paint, float avail, @NonNull TruncateAt where, boolean preserveLength, @Nullable EllipsizeCallback callback, @NonNull TextDirectionHeuristic textDir, @NonNull String ellipsis) {
        float ellipsisWidth;
        int len = text.length();
        MeasuredParagraph mt = null;
        try {
            mt = MeasuredParagraph.buildForStaticLayout(paint, null, ellipsis, 0, ellipsis.length(), textDir, false, null);
            ellipsisWidth = mt.getAdvance(0, ellipsis.length());
        }
        finally {
            if (mt != null) {
                mt.recycle();
                mt = null;
            }
        }
        try {
            mt = MeasuredParagraph.buildForStaticLayout(paint, null, text, 0, text.length(), textDir, false, null);
            float width = mt.getAdvance(0, text.length());
            if (width <= avail) {
                if (callback != null) {
                    callback.ellipsized(0, 0);
                }
                CharSequence charSequence = text;
                return charSequence;
            }
            avail -= ellipsisWidth;
            int left = 0;
            int right = len;
            if (avail >= 0.0f) {
                if (where == TruncateAt.START) {
                    right = len - mt.breakText(len, false, avail);
                } else if (where == TruncateAt.END) {
                    left = mt.breakText(len, true, avail);
                } else {
                    right = len - mt.breakText(len, false, avail / 2.0f);
                    left = mt.breakText(right, true, avail -= mt.getAdvance(right, len));
                }
            }
            if (callback != null) {
                callback.ellipsized(left, right);
            }
            char[] buf = mt.getChars();
            Spanned sp = text instanceof Spanned ? (Spanned)text : null;
            int removed = right - left;
            int remaining = len - removed;
            if (preserveLength) {
                if (remaining > 0 && removed >= ellipsis.length()) {
                    ellipsis.getChars(0, ellipsis.length(), buf, left);
                    left += ellipsis.length();
                }
                for (int i = left; i < right; ++i) {
                    buf[i] = 65279;
                }
                String s = new String(buf, 0, len);
                if (sp == null) {
                    String string = s;
                    return string;
                }
                SpannableString ss = new SpannableString(s);
                TextUtils.copySpansFrom(sp, 0, len, Object.class, ss, 0);
                SpannableString spannableString = ss;
                return spannableString;
            }
            if (remaining == 0) {
                String s = "";
                return s;
            }
            if (sp == null) {
                String s = String.valueOf(buf, 0, left) + ellipsis + String.valueOf(buf, right, len - right);
                return s;
            }
            SpannableStringBuilder ssb = new SpannableStringBuilder();
            ssb.append(text, 0, left);
            ssb.append(ellipsis);
            ssb.append(text, right, len);
            SpannableStringBuilder spannableStringBuilder = ssb;
            return spannableStringBuilder;
        }
        finally {
            if (mt != null) {
                mt.recycle();
            }
        }
    }

    public static CharSequence concat(CharSequence ... elements) {
        if (elements.length == 0) {
            return "";
        }
        CharSequence first = elements[0];
        if (elements.length == 1) {
            return first;
        }
        boolean spanned = first instanceof Spanned;
        for (int i = 1; !spanned && i < elements.length; ++i) {
            spanned = elements[i] instanceof Spanned;
        }
        if (spanned) {
            SpannableStringBuilder ssb = new SpannableStringBuilder();
            for (CharSequence piece : elements) {
                ssb.append(piece == null ? "null" : piece);
            }
            return new SpannedString(ssb);
        }
        return String.join((CharSequence)"", elements);
    }

    public static CharSequence concat(@NonNull Iterable<? extends CharSequence> elements) {
        Iterator<? extends CharSequence> it = elements.iterator();
        if (!it.hasNext()) {
            return "";
        }
        CharSequence first = it.next();
        if (!it.hasNext()) {
            return first;
        }
        boolean spanned = first instanceof Spanned;
        while (!spanned && it.hasNext()) {
            spanned = it.next() instanceof Spanned;
        }
        if (spanned) {
            SpannableStringBuilder ssb = new SpannableStringBuilder();
            for (CharSequence charSequence : elements) {
                ssb.append(charSequence == null ? "null" : charSequence);
            }
            return new SpannedString(ssb);
        }
        return String.join((CharSequence)"", elements);
    }

    @NonNull
    public static CharSequence join(@NonNull CharSequence delimiter, CharSequence ... elements) {
        if (elements.length == 0) {
            return "";
        }
        CharSequence first = elements[0];
        if (elements.length == 1) {
            return first instanceof Spanned ? SpannedString.valueOf(first) : String.valueOf(first);
        }
        boolean spanned = first instanceof Spanned || delimiter instanceof Spanned;
        for (int i = 1; !spanned && i < elements.length; ++i) {
            spanned = elements[i] instanceof Spanned;
        }
        if (spanned) {
            SpannableStringBuilder ssb = new SpannableStringBuilder();
            ssb.append(first == null ? "null" : first);
            for (int i = 1; i < elements.length; ++i) {
                ssb.append(delimiter);
                CharSequence piece = elements[i];
                ssb.append(piece == null ? "null" : piece);
            }
            return new SpannedString(ssb);
        }
        return String.join(delimiter, elements);
    }

    @NonNull
    public static CharSequence join(@NonNull CharSequence delimiter, @NonNull Iterable<? extends CharSequence> elements) {
        boolean spanned;
        Iterator<? extends CharSequence> it = elements.iterator();
        if (!it.hasNext()) {
            return "";
        }
        CharSequence first = it.next();
        if (!it.hasNext()) {
            return first instanceof Spanned ? SpannedString.valueOf(first) : String.valueOf(first);
        }
        boolean bl = spanned = first instanceof Spanned || delimiter instanceof Spanned;
        while (!spanned && it.hasNext()) {
            spanned = it.next() instanceof Spanned;
        }
        if (spanned) {
            SpannableStringBuilder ssb = new SpannableStringBuilder();
            it = elements.iterator();
            it.next();
            ssb.append(first == null ? "null" : first);
            do {
                ssb.append(delimiter);
                CharSequence piece = it.next();
                ssb.append(piece == null ? "null" : piece);
            } while (it.hasNext());
            return new SpannedString(ssb);
        }
        return String.join(delimiter, elements);
    }

    @NonNull
    public static String binaryCompact(long num) {
        if (num <= 0L) {
            return "0 bytes";
        }
        if (num < 1024L) {
            return num + " bytes";
        }
        int i = (63 - Long.numberOfLeadingZeros(num)) / 10;
        return String.format("%.2f %s", (double)num / (double)(1L << i * 10), sBinaryCompacts[i]);
    }

    public static void binaryCompact(@NonNull Appendable a, long num) {
        try {
            if (num <= 0L) {
                a.append("0 bytes");
            } else if (num < 1024L) {
                if (a instanceof StringBuilder) {
                    ((StringBuilder)a).append(num);
                } else {
                    a.append(String.valueOf(num));
                }
                a.append(" bytes");
            } else {
                int i = (63 - Long.numberOfLeadingZeros(num)) / 10;
                new Formatter(a).format("%.2f %s", (double)num / (double)(1L << i * 10), sBinaryCompacts[i]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void copySpansFrom(@NonNull Spanned source, int start, int end, @Nullable Class<?> type, @NonNull Spannable dest, int destoff) {
        if (type == null) {
            type = Object.class;
        }
        List<?> spans = source.getSpans(start, end, type);
        for (Object span : spans) {
            int st = source.getSpanStart(span);
            int en = source.getSpanEnd(span);
            int fl = source.getSpanFlags(span);
            if (st < start) {
                st = start;
            }
            if (en > end) {
                en = end;
            }
            dest.setSpan(span, st - start + destoff, en - start + destoff, fl);
        }
    }

    static boolean couldAffectRtl(char c) {
        return '\u0590' <= c && c <= '\u08ff' || c == '\u200e' || c == '\u200f' || '\u202a' <= c && c <= '\u202e' || '\u2066' <= c && c <= '\u2069' || '\ud800' <= c && c <= '\udfff' || '\ufb1d' <= c && c <= '\ufdff' || '\ufe70' <= c && c <= '\ufefe';
    }

    public static int getLayoutDirectionFromLocale(@Nullable Locale locale) {
        return locale != null && !locale.equals(Locale.ROOT) && ULocale.forLocale((Locale)locale).isRightToLeft() ? 1 : 0;
    }

    @NonNull
    public static String validateSurrogatePairs(@NonNull String text) {
        int n = text.length();
        StringBuilder b = null;
        for (int i = 0; i < n; ++i) {
            char c1 = text.charAt(i);
            if (Character.isHighSurrogate(c1) && i + 1 < n) {
                char c2 = text.charAt(i + 1);
                if (Character.isLowSurrogate(c2)) {
                    if (b != null) {
                        b.append(c1).append(c2);
                    }
                    ++i;
                    continue;
                }
                if (b == null) {
                    b = new StringBuilder(n);
                    b.append(text, 0, i);
                }
                b.append('\ufffd');
                continue;
            }
            if (Character.isSurrogate(c1)) {
                if (b == null) {
                    b = new StringBuilder(n);
                    b.append(text, 0, i);
                }
                b.append('\ufffd');
                continue;
            }
            if (b == null) continue;
            b.append(c1);
        }
        return b != null ? b.toString() : text;
    }

    public static int distance(@NonNull CharSequence a, @NonNull CharSequence b) {
        if (a == b) {
            return 0;
        }
        int m = a.length();
        int n = b.length();
        if (m == 0 || n == 0) {
            return m | n;
        }
        return m < n ? TextUtils.distance0(b, a, n, m) : TextUtils.distance0(a, b, m, n);
    }

    private static int distance0(@NonNull CharSequence a, @NonNull CharSequence b, int m, int n) {
        int j;
        int[] d = new int[n + 1];
        for (j = 1; j <= n; ++j) {
            d[j] = j;
        }
        for (int i = 1; i <= m; ++i) {
            d[0] = i;
            int w = i - 1;
            for (j = 1; j <= n; ++j) {
                int c = Math.min(Math.min(d[j], d[j - 1]) + 1, a.charAt(i - 1) == b.charAt(j - 1) ? w : w + 1);
                w = d[j];
                d[j] = c;
            }
        }
        return d[n];
    }

    public static enum TruncateAt {
        START,
        MIDDLE,
        END,
        MARQUEE;

    }

    @FunctionalInterface
    public static interface EllipsizeCallback {
        public void ellipsized(int var1, int var2);
    }
}

