/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.text;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.ImmediateContext;
import icyllis.arc3d.engine.SamplerDesc;
import icyllis.arc3d.opengl.GLCaps;
import icyllis.arc3d.opengl.GLSampler;
import icyllis.modernui.ModernUI;
import icyllis.modernui.core.Core;
import icyllis.modernui.mc.ModernUIMod;
import icyllis.modernui.mc.MuiModApi;
import icyllis.modernui.mc.text.TextLayoutEngine;
import icyllis.modernui.mc.text.mixin.AccessBufferSource;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.lwjgl.opengl.GL33C;

public class TextRenderType
extends RenderType {
    public static final int MODE_NORMAL = 0;
    public static final int MODE_SDF_FILL = 1;
    public static final int MODE_SDF_STROKE = 2;
    public static final int MODE_SEE_THROUGH = 3;
    public static final int MODE_UNIFORM_SCALE = 4;
    private static volatile ShaderInstance sShaderNormal;
    private static volatile ShaderInstance sCurrentShaderSDFFill;
    private static volatile ShaderInstance sCurrentShaderSDFStroke;
    private static volatile ShaderInstance sShaderSDFFill;
    private static volatile ShaderInstance sShaderSDFStroke;
    @Nullable
    private static volatile ShaderInstance sShaderSDFFillSmart;
    @Nullable
    private static volatile ShaderInstance sShaderSDFStrokeSmart;
    private static boolean sSmartShadersLoaded;
    static final RenderStateShard.ShaderStateShard RENDERTYPE_MODERN_TEXT_NORMAL;
    static final RenderStateShard.ShaderStateShard RENDERTYPE_MODERN_TEXT_SDF_FILL;
    static final RenderStateShard.ShaderStateShard RENDERTYPE_MODERN_TEXT_SDF_STROKE;
    private static final ImmutableList<RenderStateShard> NORMAL_STATES;
    private static final ImmutableList<RenderStateShard> SDF_FILL_STATES;
    private static final ImmutableList<RenderStateShard> SDF_STROKE_STATES;
    static final ImmutableList<RenderStateShard> VANILLA_STATES;
    static final ImmutableList<RenderStateShard> SEE_THROUGH_STATES;
    static final ImmutableList<RenderStateShard> POLYGON_OFFSET_STATES;
    private static final Int2ObjectOpenHashMap<TextRenderType> sNormalTypes;
    private static final Int2ObjectOpenHashMap<TextRenderType> sSDFFillTypes;
    private static final Int2ObjectOpenHashMap<TextRenderType> sSDFStrokeTypes;
    private static final Int2ObjectOpenHashMap<TextRenderType> sVanillaTypes;
    private static final Int2ObjectOpenHashMap<TextRenderType> sSeeThroughTypes;
    private static final Int2ObjectOpenHashMap<TextRenderType> sPolygonOffsetTypes;
    private static TextRenderType sFirstSDFFillType;
    private static final ByteBufferBuilder sFirstSDFFillBuffer;
    private static TextRenderType sFirstSDFStrokeType;
    private static final ByteBufferBuilder sFirstSDFStrokeBuffer;
    @SharedPtr
    private static GLSampler sLinearFontSampler;

    private TextRenderType(String name, int bufferSize, Runnable setupState, Runnable clearState) {
        super(name, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, bufferSize, false, true, setupState, clearState);
    }

    @Nonnull
    public static TextRenderType getOrCreate(int texture, int mode) {
        return switch (mode) {
            case 1 -> (TextRenderType)((Object)sSDFFillTypes.computeIfAbsent(texture, TextRenderType::makeSDFFillType));
            case 2 -> (TextRenderType)((Object)sSDFStrokeTypes.computeIfAbsent(texture, TextRenderType::makeSDFStrokeType));
            case 3 -> (TextRenderType)((Object)sSeeThroughTypes.computeIfAbsent(texture, TextRenderType::makeSeeThroughType));
            default -> (TextRenderType)((Object)sNormalTypes.computeIfAbsent(texture, TextRenderType::makeNormalType));
        };
    }

    @Nonnull
    public static TextRenderType getOrCreate(int texture, Font.DisplayMode mode, boolean isBitmapFont) {
        return switch (mode) {
            case Font.DisplayMode.SEE_THROUGH -> (TextRenderType)((Object)sSeeThroughTypes.computeIfAbsent(texture, TextRenderType::makeSeeThroughType));
            case Font.DisplayMode.POLYGON_OFFSET -> (TextRenderType)((Object)sPolygonOffsetTypes.computeIfAbsent(texture, TextRenderType::makePolygonOffsetType));
            default -> isBitmapFont ? (TextRenderType)((Object)sVanillaTypes.computeIfAbsent(texture, TextRenderType::makeVanillaType)) : (TextRenderType)((Object)sNormalTypes.computeIfAbsent(texture, TextRenderType::makeNormalType));
        };
    }

    @Nonnull
    private static TextRenderType makeNormalType(int texture) {
        return new TextRenderType("modern_text_normal", 256, () -> {
            NORMAL_STATES.forEach(RenderStateShard::setupRenderState);
            RenderSystem.setShaderTexture((int)0, (int)texture);
        }, () -> NORMAL_STATES.forEach(RenderStateShard::clearRenderState));
    }

    private static void ensureLinearFontSampler() {
        if (sLinearFontSampler == null) {
            ImmediateContext context = Core.requireImmediateContext();
            sLinearFontSampler = (GLSampler)context.getResourceProvider().findOrCreateCompatibleSampler(SamplerDesc.make(1, 2));
            Objects.requireNonNull(sLinearFontSampler, "Failed to create sampler object");
        }
    }

    @Nonnull
    private static TextRenderType makeSDFFillType(int texture) {
        TextRenderType.ensureLinearFontSampler();
        TextRenderType renderType = new TextRenderType("modern_text_sdf_fill", 256, () -> {
            SDF_FILL_STATES.forEach(RenderStateShard::setupRenderState);
            RenderSystem.setShaderTexture((int)0, (int)texture);
            if (!TextLayoutEngine.sCurrentInWorldRendering || TextLayoutEngine.sUseTextShadersInWorld) {
                GL33C.glBindSampler((int)0, (int)sLinearFontSampler.getHandle());
            }
        }, () -> {
            SDF_FILL_STATES.forEach(RenderStateShard::clearRenderState);
            if (!TextLayoutEngine.sCurrentInWorldRendering || TextLayoutEngine.sUseTextShadersInWorld) {
                GL33C.glBindSampler((int)0, (int)0);
            }
        });
        if (sFirstSDFFillType == null) {
            assert (sSDFFillTypes.isEmpty());
            sFirstSDFFillType = renderType;
            if (TextLayoutEngine.sUseTextShadersInWorld) {
                try {
                    ((AccessBufferSource)Minecraft.getInstance().renderBuffers().bufferSource()).getFixedBuffers().put(renderType, sFirstSDFFillBuffer);
                }
                catch (Exception e) {
                    ModernUI.LOGGER.warn(TextLayoutEngine.MARKER, "Failed to add SDF fill to fixed buffers", (Throwable)e);
                }
            }
        }
        return renderType;
    }

    @Nonnull
    private static TextRenderType makeSDFStrokeType(int texture) {
        TextRenderType.ensureLinearFontSampler();
        TextRenderType renderType = new TextRenderType("modern_text_sdf_stroke", 256, () -> {
            SDF_STROKE_STATES.forEach(RenderStateShard::setupRenderState);
            RenderSystem.setShaderTexture((int)0, (int)texture);
            if (!TextLayoutEngine.sCurrentInWorldRendering || TextLayoutEngine.sUseTextShadersInWorld) {
                GL33C.glBindSampler((int)0, (int)sLinearFontSampler.getHandle());
            }
        }, () -> {
            SDF_STROKE_STATES.forEach(RenderStateShard::clearRenderState);
            if (!TextLayoutEngine.sCurrentInWorldRendering || TextLayoutEngine.sUseTextShadersInWorld) {
                GL33C.glBindSampler((int)0, (int)0);
            }
        });
        if (sFirstSDFStrokeType == null) {
            assert (sSDFStrokeTypes.isEmpty());
            sFirstSDFStrokeType = renderType;
            if (TextLayoutEngine.sUseTextShadersInWorld) {
                try {
                    ((AccessBufferSource)Minecraft.getInstance().renderBuffers().bufferSource()).getFixedBuffers().put(renderType, sFirstSDFStrokeBuffer);
                }
                catch (Exception e) {
                    ModernUI.LOGGER.warn(TextLayoutEngine.MARKER, "Failed to add SDF stroke to fixed buffers", (Throwable)e);
                }
            }
        }
        return renderType;
    }

    @Nonnull
    private static TextRenderType makeVanillaType(int texture) {
        return new TextRenderType("modern_text_vanilla", 256, () -> {
            VANILLA_STATES.forEach(RenderStateShard::setupRenderState);
            RenderSystem.setShaderTexture((int)0, (int)texture);
        }, () -> VANILLA_STATES.forEach(RenderStateShard::clearRenderState));
    }

    @Nonnull
    private static TextRenderType makeSeeThroughType(int texture) {
        return new TextRenderType("modern_text_see_through", 256, () -> {
            SEE_THROUGH_STATES.forEach(RenderStateShard::setupRenderState);
            RenderSystem.setShaderTexture((int)0, (int)texture);
        }, () -> SEE_THROUGH_STATES.forEach(RenderStateShard::clearRenderState));
    }

    @Nonnull
    private static TextRenderType makePolygonOffsetType(int texture) {
        return new TextRenderType("modern_text_polygon_offset", 256, () -> {
            POLYGON_OFFSET_STATES.forEach(RenderStateShard::setupRenderState);
            RenderSystem.setShaderTexture((int)0, (int)texture);
        }, () -> POLYGON_OFFSET_STATES.forEach(RenderStateShard::clearRenderState));
    }

    @Nullable
    public static TextRenderType getFirstSDFFillType() {
        return sFirstSDFFillType;
    }

    @Nullable
    public static TextRenderType getFirstSDFStrokeType() {
        return sFirstSDFStrokeType;
    }

    public static synchronized void clear(boolean cleanup) {
        AccessBufferSource access;
        if (sFirstSDFFillType != null) {
            assert (!sSDFFillTypes.isEmpty());
            access = (AccessBufferSource)Minecraft.getInstance().renderBuffers().bufferSource();
            try {
                access.getFixedBuffers().remove((Object)sFirstSDFFillType, sFirstSDFFillBuffer);
            }
            catch (Exception exception) {
                // empty catch block
            }
            sFirstSDFFillType = null;
        }
        if (sFirstSDFStrokeType != null) {
            assert (!sSDFStrokeTypes.isEmpty());
            access = (AccessBufferSource)Minecraft.getInstance().renderBuffers().bufferSource();
            try {
                access.getFixedBuffers().remove((Object)sFirstSDFStrokeType, sFirstSDFStrokeBuffer);
            }
            catch (Exception exception) {
                // empty catch block
            }
            sFirstSDFStrokeType = null;
        }
        sNormalTypes.clear();
        sSDFFillTypes.clear();
        sSDFStrokeTypes.clear();
        sVanillaTypes.clear();
        sSeeThroughTypes.clear();
        sPolygonOffsetTypes.clear();
        sFirstSDFFillBuffer.clear();
        sFirstSDFStrokeBuffer.clear();
        if (cleanup) {
            sLinearFontSampler = RefCnt.move(sLinearFontSampler);
            if (sShaderNormal != null) {
                sShaderNormal.close();
            }
            if (sShaderSDFFill != null) {
                sShaderSDFFill.close();
            }
            if (sShaderSDFStroke != null) {
                sShaderSDFStroke.close();
            }
            if (sShaderSDFFillSmart != null) {
                sShaderSDFFillSmart.close();
            }
            if (sShaderSDFStrokeSmart != null) {
                sShaderSDFStrokeSmart.close();
            }
            sShaderNormal = null;
            sShaderSDFFill = null;
            sShaderSDFStroke = null;
            sShaderSDFFillSmart = null;
            sShaderSDFStrokeSmart = null;
            sCurrentShaderSDFFill = null;
            sCurrentShaderSDFStroke = null;
        }
    }

    public static ShaderInstance getShaderNormal() {
        if (TextLayoutEngine.sCurrentInWorldRendering && !TextLayoutEngine.sUseTextShadersInWorld) {
            return GameRenderer.getRendertypeTextShader();
        }
        return sShaderNormal;
    }

    public static ShaderInstance getShaderSDFFill() {
        if (TextLayoutEngine.sCurrentInWorldRendering && !TextLayoutEngine.sUseTextShadersInWorld) {
            return GameRenderer.getRendertypeTextShader();
        }
        return sCurrentShaderSDFFill;
    }

    public static ShaderInstance getShaderSDFStroke() {
        return sCurrentShaderSDFStroke;
    }

    public static synchronized void toggleSDFShaders(boolean smart) {
        if (smart) {
            if (!sSmartShadersLoaded) {
                sSmartShadersLoaded = true;
                if (((GLCaps)Core.requireImmediateContext().getCaps()).getGLSLVersion() >= 400) {
                    ResourceProvider provider = TextRenderType.obtainResourceProvider();
                    try {
                        sShaderSDFFillSmart = MuiModApi.get().makeShaderInstance(provider, ModernUIMod.location("rendertype_modern_text_sdf_fill_400"), DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
                        sShaderSDFStrokeSmart = MuiModApi.get().makeShaderInstance(provider, ModernUIMod.location("rendertype_modern_text_sdf_stroke_400"), DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
                        ModernUI.LOGGER.info(TextLayoutEngine.MARKER, "Loaded smart SDF text shaders");
                    }
                    catch (IOException e) {
                        ModernUI.LOGGER.error(TextLayoutEngine.MARKER, "Failed to load smart SDF text shaders", (Throwable)e);
                    }
                } else {
                    ModernUI.LOGGER.info(TextLayoutEngine.MARKER, "No GLSL 400, smart SDF text shaders disabled");
                }
            }
            if (sShaderSDFStrokeSmart != null) {
                sCurrentShaderSDFFill = sShaderSDFFillSmart;
                sCurrentShaderSDFStroke = sShaderSDFStrokeSmart;
                return;
            }
        }
        sCurrentShaderSDFFill = sShaderSDFFill;
        sCurrentShaderSDFStroke = sShaderSDFStroke;
    }

    public static synchronized void preloadShaders() {
        if (sShaderNormal != null) {
            return;
        }
        ResourceProvider provider = TextRenderType.obtainResourceProvider();
        try {
            sShaderNormal = MuiModApi.get().makeShaderInstance(provider, ModernUIMod.location("rendertype_modern_text_normal"), DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
            sShaderSDFFill = MuiModApi.get().makeShaderInstance(provider, ModernUIMod.location("rendertype_modern_text_sdf_fill"), DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
            sShaderSDFStroke = MuiModApi.get().makeShaderInstance(provider, ModernUIMod.location("rendertype_modern_text_sdf_stroke"), DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        }
        catch (IOException e) {
            throw new IllegalStateException("Bad text shaders", e);
        }
        TextRenderType.toggleSDFShaders(false);
        ModernUI.LOGGER.info(TextLayoutEngine.MARKER, "Preloaded modern text shaders");
    }

    @Nonnull
    private static ResourceProvider obtainResourceProvider() {
        VanillaPackResources source = Minecraft.getInstance().getVanillaPackResources();
        ResourceProvider fallback = source.asProvider();
        return location -> {
            InputStream stream = TextRenderType.class.getResourceAsStream("/assets/" + location.getNamespace() + "/" + location.getPath());
            if (stream == null) {
                return fallback.getResource(location);
            }
            return Optional.of(new Resource((PackResources)source, () -> stream));
        };
    }

    static {
        sSmartShadersLoaded = false;
        RENDERTYPE_MODERN_TEXT_NORMAL = new RenderStateShard.ShaderStateShard(TextRenderType::getShaderNormal);
        RENDERTYPE_MODERN_TEXT_SDF_FILL = new RenderStateShard.ShaderStateShard(TextRenderType::getShaderSDFFill);
        RENDERTYPE_MODERN_TEXT_SDF_STROKE = new RenderStateShard.ShaderStateShard(TextRenderType::getShaderSDFStroke);
        sNormalTypes = new Int2ObjectOpenHashMap();
        sSDFFillTypes = new Int2ObjectOpenHashMap();
        sSDFStrokeTypes = new Int2ObjectOpenHashMap();
        sVanillaTypes = new Int2ObjectOpenHashMap();
        sSeeThroughTypes = new Int2ObjectOpenHashMap();
        sPolygonOffsetTypes = new Int2ObjectOpenHashMap();
        sFirstSDFFillBuffer = new ByteBufferBuilder(131072);
        sFirstSDFStrokeBuffer = new ByteBufferBuilder(131072);
        NORMAL_STATES = ImmutableList.of((Object)RENDERTYPE_MODERN_TEXT_NORMAL, (Object)TRANSLUCENT_TRANSPARENCY, (Object)LEQUAL_DEPTH_TEST, (Object)CULL, (Object)LIGHTMAP, (Object)NO_OVERLAY, (Object)NO_LAYERING, (Object)MAIN_TARGET, (Object)DEFAULT_TEXTURING, (Object)COLOR_DEPTH_WRITE, (Object)DEFAULT_LINE);
        SDF_FILL_STATES = ImmutableList.of((Object)RENDERTYPE_MODERN_TEXT_SDF_FILL, (Object)TRANSLUCENT_TRANSPARENCY, (Object)LEQUAL_DEPTH_TEST, (Object)CULL, (Object)LIGHTMAP, (Object)NO_OVERLAY, (Object)POLYGON_OFFSET_LAYERING, (Object)MAIN_TARGET, (Object)DEFAULT_TEXTURING, (Object)COLOR_DEPTH_WRITE, (Object)DEFAULT_LINE);
        SDF_STROKE_STATES = ImmutableList.of((Object)RENDERTYPE_MODERN_TEXT_SDF_STROKE, (Object)TRANSLUCENT_TRANSPARENCY, (Object)LEQUAL_DEPTH_TEST, (Object)CULL, (Object)LIGHTMAP, (Object)NO_OVERLAY, (Object)POLYGON_OFFSET_LAYERING, (Object)MAIN_TARGET, (Object)DEFAULT_TEXTURING, (Object)COLOR_DEPTH_WRITE, (Object)DEFAULT_LINE);
        VANILLA_STATES = ImmutableList.of((Object)RENDERTYPE_TEXT_SHADER, (Object)TRANSLUCENT_TRANSPARENCY, (Object)LEQUAL_DEPTH_TEST, (Object)CULL, (Object)LIGHTMAP, (Object)NO_OVERLAY, (Object)NO_LAYERING, (Object)MAIN_TARGET, (Object)DEFAULT_TEXTURING, (Object)COLOR_DEPTH_WRITE, (Object)DEFAULT_LINE);
        SEE_THROUGH_STATES = ImmutableList.of((Object)RENDERTYPE_TEXT_SEE_THROUGH_SHADER, (Object)TRANSLUCENT_TRANSPARENCY, (Object)NO_DEPTH_TEST, (Object)CULL, (Object)LIGHTMAP, (Object)NO_OVERLAY, (Object)NO_LAYERING, (Object)MAIN_TARGET, (Object)DEFAULT_TEXTURING, (Object)COLOR_WRITE, (Object)DEFAULT_LINE);
        POLYGON_OFFSET_STATES = ImmutableList.of((Object)RENDERTYPE_TEXT_SHADER, (Object)TRANSLUCENT_TRANSPARENCY, (Object)LEQUAL_DEPTH_TEST, (Object)CULL, (Object)LIGHTMAP, (Object)NO_OVERLAY, (Object)POLYGON_OFFSET_LAYERING, (Object)MAIN_TARGET, (Object)DEFAULT_TEXTURING, (Object)COLOR_DEPTH_WRITE, (Object)DEFAULT_LINE);
    }
}

