/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.text;

import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import org.joml.Matrix4f;

public class TextRenderEffect {
    private static final float UNDERLINE_OFFSET = 0.6666667f;
    private static final float STRIKETHROUGH_OFFSET = -3.5f;
    private static final float UNDERLINE_THICKNESS = 0.75f;
    private static final float STRIKETHROUGH_THICKNESS = 0.75f;
    public static final float EFFECT_DEPTH = 0.01f;

    private TextRenderEffect() {
    }

    public static void drawUnderline(@Nonnull VertexConsumer builder, float start, float end, float baseline, int r, int g, int b, int a) {
        builder.addVertex(start, (baseline += 0.6666667f) + 0.75f, 0.01f).setColor(r, g, b, a);
        builder.addVertex(end, baseline + 0.75f, 0.01f).setColor(r, g, b, a);
        builder.addVertex(end, baseline, 0.01f).setColor(r, g, b, a);
        builder.addVertex(start, baseline, 0.01f).setColor(r, g, b, a);
    }

    public static void drawUnderline(@Nonnull Matrix4f matrix, @Nonnull VertexConsumer builder, float start, float end, float baseline, int r, int g, int b, int a, int light) {
        builder.addVertex(matrix, start, (baseline += 0.6666667f) + 0.75f, 0.01f).setColor(r, g, b, a).setUv(0.0f, 1.0f).setLight(light);
        builder.addVertex(matrix, end, baseline + 0.75f, 0.01f).setColor(r, g, b, a).setUv(1.0f, 1.0f).setLight(light);
        builder.addVertex(matrix, end, baseline, 0.01f).setColor(r, g, b, a).setUv(1.0f, 0.0f).setLight(light);
        builder.addVertex(matrix, start, baseline, 0.01f).setColor(r, g, b, a).setUv(0.0f, 0.0f).setLight(light);
    }

    public static void drawStrikethrough(@Nonnull VertexConsumer builder, float start, float end, float baseline, int r, int g, int b, int a) {
        builder.addVertex(start, (baseline += -3.5f) + 0.75f, 0.01f).setColor(r, g, b, a);
        builder.addVertex(end, baseline + 0.75f, 0.01f).setColor(r, g, b, a);
        builder.addVertex(end, baseline, 0.01f).setColor(r, g, b, a);
        builder.addVertex(start, baseline, 0.01f).setColor(r, g, b, a);
    }

    public static void drawStrikethrough(@Nonnull Matrix4f matrix, @Nonnull VertexConsumer builder, float start, float end, float baseline, int r, int g, int b, int a, int light) {
        builder.addVertex(matrix, start, (baseline += -3.5f) + 0.75f, 0.01f).setColor(r, g, b, a).setUv(0.0f, 1.0f).setLight(light);
        builder.addVertex(matrix, end, baseline + 0.75f, 0.01f).setColor(r, g, b, a).setUv(1.0f, 1.0f).setLight(light);
        builder.addVertex(matrix, end, baseline, 0.01f).setColor(r, g, b, a).setUv(1.0f, 0.0f).setLight(light);
        builder.addVertex(matrix, start, baseline, 0.01f).setColor(r, g, b, a).setUv(0.0f, 0.0f).setLight(light);
    }
}

