/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.text;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import icyllis.arc3d.core.ColorInfo;
import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.engine.ImageDesc;
import icyllis.arc3d.engine.ImmediateContext;
import icyllis.arc3d.opengl.GLDevice;
import icyllis.arc3d.opengl.GLTexture;
import icyllis.modernui.annotation.RenderThread;
import icyllis.modernui.core.Core;
import icyllis.modernui.mc.text.TextRenderType;
import java.nio.ByteBuffer;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EffectRenderType
extends RenderType {
    private static GLTexture WHITE;
    private static final EffectRenderType TYPE;
    private static final EffectRenderType SEE_THROUGH_TYPE;
    private static final EffectRenderType POLYGON_OFFSET_TYPE;

    private EffectRenderType(String name, int bufferSize, Runnable setupState, Runnable clearState) {
        super(name, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, bufferSize, false, true, setupState, clearState);
    }

    @Nonnull
    @RenderThread
    public static EffectRenderType getRenderType(boolean seeThrough, boolean polygonOffset) {
        if (WHITE == null) {
            EffectRenderType.makeWhiteTexture();
        }
        return polygonOffset ? POLYGON_OFFSET_TYPE : (seeThrough ? SEE_THROUGH_TYPE : TYPE);
    }

    @Nonnull
    @RenderThread
    public static EffectRenderType getRenderType(Font.DisplayMode mode) {
        return switch (mode) {
            case Font.DisplayMode.SEE_THROUGH -> SEE_THROUGH_TYPE;
            case Font.DisplayMode.POLYGON_OFFSET -> POLYGON_OFFSET_TYPE;
            default -> TYPE;
        };
    }

    public static void clear() {
        WHITE = RefCnt.move(WHITE);
    }

    private static void makeWhiteTexture() {
        ImmediateContext context = Core.requireImmediateContext();
        int width = 8;
        int height = 8;
        int colorType = 6;
        ImageDesc desc = context.getCaps().getDefaultColorImageDesc(1, 6, 8, 8, 1, 8);
        Objects.requireNonNull(desc);
        WHITE = (GLTexture)context.getResourceProvider().findOrCreateImage(desc, false, "WhiteTexture");
        Objects.requireNonNull(WHITE);
        try (MemoryStack stack = MemoryStack.stackPush();){
            int bpp = ColorInfo.bytesPerPixel(6);
            ByteBuffer pixels = stack.malloc(64 * bpp);
            MemoryUtil.memSet((ByteBuffer)pixels, (int)255);
            boolean res = ((GLDevice)context.getDevice()).writePixels(WHITE, 0, 0, 8, 8, 6, 6, 8 * bpp, MemoryUtil.memAddress((ByteBuffer)pixels));
            assert (res);
            int boundTexture = GL33C.glGetInteger((int)32873);
            GL33C.glBindTexture((int)3553, (int)WHITE.getHandle());
            GL33C.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL33C.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL33C.glBindTexture((int)3553, (int)boundTexture);
        }
    }

    static {
        TYPE = new EffectRenderType("modern_text_effect", 256, () -> {
            TextRenderType.VANILLA_STATES.forEach(RenderStateShard::setupRenderState);
            RenderSystem.setShaderTexture((int)0, (int)WHITE.getHandle());
        }, () -> TextRenderType.VANILLA_STATES.forEach(RenderStateShard::clearRenderState));
        SEE_THROUGH_TYPE = new EffectRenderType("modern_text_effect_see_through", 256, () -> {
            TextRenderType.SEE_THROUGH_STATES.forEach(RenderStateShard::setupRenderState);
            RenderSystem.setShaderTexture((int)0, (int)WHITE.getHandle());
        }, () -> TextRenderType.SEE_THROUGH_STATES.forEach(RenderStateShard::clearRenderState));
        POLYGON_OFFSET_TYPE = new EffectRenderType("modern_text_effect_polygon_offset", 256, () -> {
            TextRenderType.POLYGON_OFFSET_STATES.forEach(RenderStateShard::setupRenderState);
            RenderSystem.setShaderTexture((int)0, (int)WHITE.getHandle());
        }, () -> TextRenderType.POLYGON_OFFSET_STATES.forEach(RenderStateShard::clearRenderState));
    }
}

