/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.neoforge;

import icyllis.modernui.fragment.Fragment;
import icyllis.modernui.mc.MuiScreen;
import icyllis.modernui.mc.ScreenCallback;
import icyllis.modernui.mc.UIManager;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

final class MenuScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T>
implements MuiScreen {
    private final UIManager mHost;
    private final Fragment mFragment;
    @Nullable
    private final ScreenCallback mCallback;

    MenuScreen(UIManager host, Fragment fragment, @Nullable ScreenCallback callback, T menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        ScreenCallback cbk;
        this.mHost = host;
        this.mFragment = Objects.requireNonNull(fragment);
        this.mCallback = callback != null ? callback : (fragment instanceof ScreenCallback ? (cbk = (ScreenCallback)((Object)fragment)) : null);
    }

    protected void init() {
        super.init();
        this.mHost.initScreen(this);
    }

    public void resize(@Nonnull Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
    }

    public void render(@Nonnull GuiGraphics gr, int mouseX, int mouseY, float deltaTick) {
        ScreenCallback callback = this.getCallback();
        if (callback == null || callback.hasDefaultBackground()) {
            this.renderBackground(gr, mouseX, mouseY, deltaTick);
        }
        this.mHost.render(gr, mouseX, mouseY, deltaTick);
    }

    protected void renderBg(@Nonnull GuiGraphics gr, float deltaTick, int x, int y) {
    }

    public void removed() {
        super.removed();
        this.mHost.removed((Screen)this);
    }

    @Override
    @Nonnull
    public Screen self() {
        return this;
    }

    @Override
    @Nonnull
    public Fragment getFragment() {
        return this.mFragment;
    }

    @Override
    @Nullable
    public ScreenCallback getCallback() {
        return this.mCallback;
    }

    @Override
    @Nullable
    public Screen getPreviousScreen() {
        return null;
    }

    @Override
    public boolean isMenuScreen() {
        return true;
    }

    @Override
    public void onBackPressed() {
        this.mHost.getOnBackPressedDispatcher().onBackPressed();
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.mHost.onHoverMove(true);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double deltaX, double deltaY) {
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.mHost.onScroll(deltaX, deltaY);
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        this.mHost.onKeyPress(keyCode, scanCode, modifiers);
        return false;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        this.mHost.onKeyRelease(keyCode, scanCode, modifiers);
        return false;
    }

    public boolean charTyped(char ch, int modifiers) {
        return this.mHost.onCharTyped(ch);
    }
}

