/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.neoforge;

import com.mojang.blaze3d.platform.Monitor;
import com.mojang.blaze3d.platform.VideoMode;
import com.mojang.blaze3d.platform.Window;
import icyllis.modernui.ModernUI;
import icyllis.modernui.core.Core;
import icyllis.modernui.core.Handler;
import icyllis.modernui.graphics.Color;
import icyllis.modernui.mc.BlurHandler;
import icyllis.modernui.mc.FontResourceManager;
import icyllis.modernui.mc.ModernUIClient;
import icyllis.modernui.mc.ModernUIMod;
import icyllis.modernui.mc.TooltipRenderer;
import icyllis.modernui.mc.UIManager;
import icyllis.modernui.mc.neoforge.ServerHandler;
import icyllis.modernui.mc.text.GLFontAtlas;
import icyllis.modernui.mc.text.GlyphManager;
import icyllis.modernui.mc.text.ModernTextRenderer;
import icyllis.modernui.mc.text.TextLayout;
import icyllis.modernui.mc.text.TextLayoutEngine;
import icyllis.modernui.mc.text.TextLayoutProcessor;
import icyllis.modernui.mc.text.TextRenderType;
import icyllis.modernui.resources.Resources;
import icyllis.modernui.util.DisplayMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.resources.language.I18n;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.glfw.GLFW;

@ApiStatus.Internal
public final class Config {
    public static Client CLIENT;
    private static ModConfigSpec CLIENT_SPEC;
    public static Common COMMON;
    private static ModConfigSpec COMMON_SPEC;
    public static Text TEXT;
    public static ModConfigSpec TEXT_SPEC;

    private static void init(boolean isClient, BiConsumer<ModConfig.Type, ModConfigSpec> registerConfig) {
    }

    public static void initClientConfig(Consumer<ModConfigSpec> registerConfig) {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        CLIENT = new Client(builder);
        CLIENT_SPEC = builder.build();
        registerConfig.accept(CLIENT_SPEC);
    }

    public static void initCommonConfig(Consumer<ModConfigSpec> registerConfig) {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        COMMON = new Common(builder);
        COMMON_SPEC = builder.build();
        registerConfig.accept(COMMON_SPEC);
    }

    public static void initTextConfig(Consumer<ModConfigSpec> registerConfig) {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        TEXT = new Text(builder);
        TEXT_SPEC = builder.build();
        registerConfig.accept(TEXT_SPEC);
    }

    public static void reloadCommon(@Nonnull ModConfig config) {
        IConfigSpec spec = config.getSpec();
        if (spec == COMMON_SPEC) {
            COMMON.reload();
            ModernUIMod.LOGGER.debug(ModernUIMod.MARKER, "Modern UI common config loaded/reloaded");
        }
    }

    public static void reloadAnyClient(@Nonnull ModConfig config) {
        IConfigSpec spec = config.getSpec();
        if (spec == CLIENT_SPEC) {
            CLIENT.reload();
            ModernUIMod.LOGGER.debug(ModernUIMod.MARKER, "Modern UI client config loaded/reloaded");
        } else if (spec == TEXT_SPEC) {
            TEXT.reload();
            ModernUIMod.LOGGER.debug(ModernUIMod.MARKER, "Modern UI text config loaded/reloaded");
        }
    }

    public static class Client {
        public static final int ANIM_DURATION_MIN = 0;
        public static final int ANIM_DURATION_MAX = 800;
        public static final int BLUR_RADIUS_MIN = 0;
        public static final int BLUR_RADIUS_MAX = 18;
        public static final float FONT_SCALE_MIN = 0.5f;
        public static final float FONT_SCALE_MAX = 2.0f;
        public static final int TOOLTIP_BORDER_COLOR_ANIM_MIN = 0;
        public static final int TOOLTIP_BORDER_COLOR_ANIM_MAX = 5000;
        public static final float TOOLTIP_BORDER_WIDTH_MIN = 0.5f;
        public static final float TOOLTIP_BORDER_WIDTH_MAX = 2.5f;
        public static final float TOOLTIP_CORNER_RADIUS_MIN = 0.0f;
        public static final float TOOLTIP_CORNER_RADIUS_MAX = 8.0f;
        public static final float TOOLTIP_SHADOW_RADIUS_MIN = 0.0f;
        public static final float TOOLTIP_SHADOW_RADIUS_MAX = 32.0f;
        public static final int TOOLTIP_ARROW_SCROLL_FACTOR_MIN = 0;
        public static final int TOOLTIP_ARROW_SCROLL_FACTOR_MAX = 320;
        public final ModConfigSpec.BooleanValue mBlurEffect;
        public final ModConfigSpec.BooleanValue mOverrideVanillaBlur;
        public final ModConfigSpec.IntValue mBackgroundDuration;
        public final ModConfigSpec.IntValue mBlurRadius;
        public final ModConfigSpec.ConfigValue<List<? extends String>> mBackgroundColor;
        public final ModConfigSpec.BooleanValue mInventoryPause;
        public final ModConfigSpec.BooleanValue mTooltip;
        public final ModConfigSpec.BooleanValue mRoundedTooltip;
        public final ModConfigSpec.BooleanValue mCenterTooltipTitle;
        public final ModConfigSpec.BooleanValue mTooltipTitleBreak;
        public final ModConfigSpec.BooleanValue mExactTooltipPositioning;
        public final ModConfigSpec.ConfigValue<List<? extends String>> mTooltipFill;
        public final ModConfigSpec.ConfigValue<List<? extends String>> mTooltipStroke;
        public final ModConfigSpec.IntValue mTooltipCycle;
        public final ModConfigSpec.DoubleValue mTooltipWidth;
        public final ModConfigSpec.DoubleValue mTooltipRadius;
        public final ModConfigSpec.DoubleValue mTooltipShadowRadius;
        public final ModConfigSpec.DoubleValue mTooltipShadowAlpha;
        public final ModConfigSpec.BooleanValue mAdaptiveTooltipColors;
        public final ModConfigSpec.IntValue mTooltipArrowScrollFactor;
        public final ModConfigSpec.BooleanValue mDing;
        public final ModConfigSpec.BooleanValue mZoom;
        public final ModConfigSpec.BooleanValue mForceRtl;
        public final ModConfigSpec.DoubleValue mFontScale;
        public final ModConfigSpec.EnumValue<WindowMode> mWindowMode;
        public final ModConfigSpec.BooleanValue mUseNewGuiScale;
        public final ModConfigSpec.BooleanValue mRemoveTelemetry;
        public final ModConfigSpec.IntValue mFramerateInactive;
        public final ModConfigSpec.IntValue mFramerateMinimized;
        public final ModConfigSpec.DoubleValue mMasterVolumeInactive;
        public final ModConfigSpec.DoubleValue mMasterVolumeMinimized;
        public final ModConfigSpec.IntValue mScrollbarSize;
        public final ModConfigSpec.IntValue mTouchSlop;
        public final ModConfigSpec.IntValue mMinScrollbarTouchTarget;
        public final ModConfigSpec.IntValue mMinimumFlingVelocity;
        public final ModConfigSpec.IntValue mMaximumFlingVelocity;
        public final ModConfigSpec.IntValue mOverscrollDistance;
        public final ModConfigSpec.IntValue mOverflingDistance;
        public final ModConfigSpec.DoubleValue mVerticalScrollFactor;
        public final ModConfigSpec.DoubleValue mHorizontalScrollFactor;
        private final ModConfigSpec.ConfigValue<List<? extends String>> mBlurBlacklist;
        public final ModConfigSpec.ConfigValue<String> mFirstFontFamily;
        public final ModConfigSpec.ConfigValue<List<? extends String>> mFallbackFontFamilyList;
        public final ModConfigSpec.ConfigValue<List<? extends String>> mFontRegistrationList;
        public final ModConfigSpec.BooleanValue mUseColorEmoji;
        public final ModConfigSpec.BooleanValue mEmojiShortcodes;
        public WindowMode mLastWindowMode = WindowMode.NORMAL;

        private Client(@Nonnull ModConfigSpec.Builder builder) {
            builder.comment("Screen Config").push("screen");
            this.mBackgroundDuration = builder.comment("The duration of GUI background color and blur radius animation in milliseconds. (0 = OFF)").defineInRange("animationDuration", 200, 0, 800);
            this.mBackgroundColor = builder.comment(new String[]{"The GUI background color in #RRGGBB or #AARRGGBB format. Default value: #99000000", "Can be one to four values representing top left, top right, bottom right and bottom left color.", "Multiple values produce a gradient effect, whereas one value produce a solid color.", "When values is less than 4, the rest of the corner color will be replaced by the last value."}).defineList("backgroundColor", () -> {
                ArrayList<String> list = new ArrayList<String>();
                list.add("#99000000");
                return list;
            }, o -> true);
            this.mBlurEffect = builder.comment(new String[]{"Add Gaussian blur effect to GUI background when opened.", "Disable this if you run into a problem or are on low-end PCs"}).define("blurEffect", true);
            this.mOverrideVanillaBlur = builder.comment(new String[]{"Whether to replace Vanilla 3-pass box blur with Modern UI Gaussian blur.", "This gives you better quality and performance, recommend setting this to true."}).define("overrideVanillaBlur", true);
            this.mBlurRadius = builder.comment(new String[]{"The kernel radius for gaussian convolution blur effect, 0 = disable.", "samples per pixel = ((radius * 2) + 1) * 2, sigma = radius / 2."}).defineInRange("blurRadius", 7, 0, 18);
            this.mBlurBlacklist = builder.comment("A list of GUI screen superclasses that won't activate blur effect when opened.").defineList("blurBlacklist", () -> {
                ArrayList<String> list = new ArrayList<String>();
                list.add(ChatScreen.class.getName());
                return list;
            }, o -> true);
            this.mInventoryPause = builder.comment("(Beta) Pause the game when inventory (also includes creative mode) opened.").define("inventoryPause", false);
            this.mFramerateInactive = builder.comment("Framerate limit on window inactive (out of focus or minimized), 0 = no change.").defineInRange("framerateInactive", 30, 0, 255);
            this.mFramerateMinimized = builder.comment(new String[]{"Framerate limit on window minimized, 0 = same as framerate inactive.", "This value will be no greater than framerate inactive."}).defineInRange("framerateMinimized", 0, 0, 255);
            this.mMasterVolumeInactive = builder.comment("Master volume multiplier on window inactive (out of focus or minimized), 1 = no change.").defineInRange("masterVolumeInactive", 0.5, 0.0, 1.0);
            this.mMasterVolumeMinimized = builder.comment(new String[]{"Master volume multiplier on window minimized, 1 = same as master volume inactive.", "This value will be no greater than master volume inactive."}).defineInRange("masterVolumeMinimized", 0.25, 0.0, 1.0);
            builder.pop();
            builder.comment("Tooltip Config").push("tooltip");
            this.mTooltip = builder.comment("Whether to enable Modern UI enhanced tooltip, or back to vanilla default.").define("enable", !ModernUIMod.isLegendaryTooltipsLoaded());
            this.mRoundedTooltip = builder.comment("Whether to use rounded tooltip shapes, or to use vanilla style.").define("roundedShape", true);
            this.mCenterTooltipTitle = builder.comment(new String[]{"True to center the tooltip title if rendering an item's tooltip.", "Following lines are not affected by this option."}).define("centerTitle", true);
            this.mTooltipTitleBreak = builder.comment(new String[]{"True to add a title break below the tooltip title line.", "TitleBreak and CenterTitle will work/appear at the same time."}).define("titleBreak", true);
            this.mExactTooltipPositioning = builder.comment("True to exactly position tooltip to pixel grid, smoother movement.").define("exactPositioning", true);
            this.mTooltipFill = builder.comment(new String[]{"The tooltip background color in #RRGGBB or #AARRGGBB format. Default: #E6000000", "Can be one to four values representing top left, top right, bottom right and bottom left color.", "Multiple values produce a gradient effect, whereas one value produces a solid color.", "If less than 4 are provided, repeat the last value."}).defineList("colorFill", () -> {
                ArrayList<String> list = new ArrayList<String>();
                list.add("#E6000000");
                return list;
            }, $ -> true);
            this.mTooltipStroke = builder.comment(new String[]{"The tooltip border color in #RRGGBB or #AARRGGBB format. Default: #F0AADCF0, #F0DAD0F4, #F0FFC3F7 and #F0DAD0F4", "Can be one to four values representing top left, top right, bottom right and bottom left color.", "Multiple values produce a gradient effect, whereas one value produces a solid color.", "If less than 4 are provided, repeat the last value."}).defineList("colorStroke", () -> {
                ArrayList<String> list = new ArrayList<String>();
                list.add("#FFC2D0D6");
                list.add("#FFE7DAE5");
                list.add("#FFCCDAC8");
                list.add("#FFC8B9AC");
                return list;
            }, $ -> true);
            this.mTooltipCycle = builder.comment("The cycle time of tooltip border color in milliseconds. (0 = OFF)").defineInRange("borderCycleTime", 1000, 0, 5000);
            this.mTooltipWidth = builder.comment("The width of tooltip border, if rounded, in GUI Scale Independent Pixels.").defineInRange("borderWidth", 1.3333333333333333, 0.5, 2.5);
            this.mTooltipRadius = builder.comment("The corner radius of tooltip border, if rounded, in GUI Scale Independent Pixels.").defineInRange("cornerRadius", 4.0, 0.0, 8.0);
            this.mTooltipShadowRadius = builder.comment(new String[]{"The shadow radius of tooltip, if rounded, in GUI Scale Independent Pixels.", "No impact on performance."}).defineInRange("shadowRadius", 10.0, 0.0, 32.0);
            this.mTooltipShadowAlpha = builder.comment("The shadow opacity of tooltip, if rounded. No impact on performance.").defineInRange("shadowOpacity", 0.25, 0.0, 1.0);
            this.mAdaptiveTooltipColors = builder.comment("When true, tooltip border colors adapt to item's name and rarity.").define("adaptiveColors", true);
            this.mTooltipArrowScrollFactor = builder.comment("Amount to scroll the tooltip in response to a arrow key pressed event.").defineInRange("arrowScrollFactor", 60, 0, 320);
            builder.pop();
            builder.comment("General Config").push("general");
            this.mDing = builder.comment("Play a sound effect when the game is loaded.").define("ding", true);
            this.mZoom = builder.comment(new String[]{"Press 'C' key (by default) to zoom 4x, the same as OptiFine's.", "This is auto disabled when OptiFine is installed."}).define("zoom", true);
            this.mWindowMode = builder.comment("Control the window mode, normal mode does nothing.").defineEnum("windowMode", (Enum)WindowMode.NORMAL);
            this.mUseNewGuiScale = builder.comment("Whether to replace vanilla GUI scale button to slider with tips.").define("useNewGuiScale", true);
            this.mRemoveTelemetry = builder.comment("Remove telemetry event of client behaviors.").define("removeTelemetry", false);
            this.mEmojiShortcodes = builder.comment("Allow Slack or Discord shortcodes to replace Unicode Emoji Sequences in chat.").define("emojiShortcodes", true);
            builder.pop();
            builder.comment("View system config, currently not working.").push("view");
            this.mForceRtl = builder.comment("Force layout direction to RTL, otherwise, the current Locale setting.").define("forceRtl", false);
            this.mFontScale = builder.comment("The global font scale used with sp units.").defineInRange("fontScale", 1.0, 0.5, 2.0);
            this.mScrollbarSize = builder.comment("Default scrollbar size in dips.").defineInRange("scrollbarSize", 8, 0, 1024);
            this.mTouchSlop = builder.comment("Distance a touch can wander before we think the user is scrolling in dips.").defineInRange("touchSlop", 4, 0, 1024);
            this.mMinScrollbarTouchTarget = builder.comment("Minimum size of the touch target for a scrollbar in dips.").defineInRange("minScrollbarTouchTarget", 16, 0, 1024);
            this.mMinimumFlingVelocity = builder.comment("Minimum velocity to initiate a fling in dips per second.").defineInRange("minimumFlingVelocity", 50, 0, Short.MAX_VALUE);
            this.mMaximumFlingVelocity = builder.comment("Maximum velocity to initiate a fling in dips per second.").defineInRange("maximumFlingVelocity", 8000, 0, Short.MAX_VALUE);
            this.mOverscrollDistance = builder.comment("Max distance in dips to overscroll for edge effects.").defineInRange("overscrollDistance", 0, 0, 1024);
            this.mOverflingDistance = builder.comment("Max distance in dips to overfling for edge effects.").defineInRange("overflingDistance", 12, 0, 1024);
            this.mVerticalScrollFactor = builder.comment("Amount to scroll in response to a vertical scroll event, in dips per axis value.").defineInRange("verticalScrollFactor", 64.0, 0.0, 1024.0);
            this.mHorizontalScrollFactor = builder.comment("Amount to scroll in response to a horizontal scroll event, in dips per axis value.").defineInRange("horizontalScrollFactor", 64.0, 0.0, 1024.0);
            builder.pop();
            builder.comment("Font Config").push("font");
            this.mFirstFontFamily = builder.comment("The first font family to use. See fallbackFontFamilyList").define("firstFontFamily", (Object)"Source Han Sans CN Medium");
            this.mFallbackFontFamilyList = builder.comment(new String[]{"A set of fallback font families to determine the typeface to use.", "The order is first > fallbacks. TrueType & OpenType are supported.", "Each element can be one of the following two cases:", "1) Name of registered font family, for instance: Segoe UI", "2) Path of font files on your PC, for instance: /usr/shared/fonts/x.otf", "Registered font families include:", "1) OS builtin fonts.", "2) Font files in fontRegistrationList.", "3) Font files in '/resourcepacks' directory.", "4) Font files under 'modernui:font' in resource packs.", "Note that for TTC/OTC font, you should register it and select one of font families.", "Otherwise, only the first font family from the TrueType/OpenType Collection will be used.", "This is only read once when the game is loaded, you can reload via in-game GUI."}).defineList("fallbackFontFamilyList", () -> {
                ArrayList<String> list = new ArrayList<String>();
                list.add("Noto Sans");
                list.add("Segoe UI Variable");
                list.add("Segoe UI");
                list.add("San Francisco");
                list.add("Open Sans");
                list.add("SimHei");
                list.add("STHeiti");
                list.add("Segoe UI Symbol");
                list.add("mui-i18n-compat");
                return list;
            }, s -> true);
            this.mFontRegistrationList = builder.comment(new String[]{"A set of additional font files (or directories) to register.", "For TrueType/OpenType Collections, all contained font families will be registered.", "Registered fonts can be referenced in Modern UI and Minecraft (Modern Text Engine).", "For example, \"E:/Fonts\" means all font files in that directory will be registered.", "System requires random access to these files, you should not remove them while running.", "This is only read once when the game is loaded, i.e. registration."}).defineList("fontRegistrationList", ArrayList::new, s -> true);
            this.mUseColorEmoji = builder.comment(new String[]{"Whether to use Google Noto Color Emoji, otherwise grayscale emoji (faster).", "See Unicode 15.0 specification for details on how this affects text layout."}).define("useColorEmoji", true);
            builder.pop();
        }

        public void saveAsync() {
            Util.ioPool().execute(() -> CLIENT_SPEC.save());
        }

        public void saveAndReloadAsync() {
            Util.ioPool().execute(() -> CLIENT_SPEC.save());
            this.reload();
        }

        private void reload() {
            Handler handler;
            String s;
            int i;
            BlurHandler.sBlurEffect = (Boolean)this.mBlurEffect.get();
            BlurHandler.sOverrideVanillaBlur = (Boolean)this.mOverrideVanillaBlur.get();
            BlurHandler.sBackgroundDuration = (Integer)this.mBackgroundDuration.get();
            BlurHandler.sBlurRadius = (Integer)this.mBlurRadius.get();
            BlurHandler.sFramerateInactive = (Integer)this.mFramerateInactive.get();
            BlurHandler.sFramerateMinimized = Math.min((Integer)this.mFramerateMinimized.get(), BlurHandler.sFramerateInactive);
            BlurHandler.sMasterVolumeInactive = ((Double)this.mMasterVolumeInactive.get()).floatValue();
            BlurHandler.sMasterVolumeMinimized = Math.min(((Double)this.mMasterVolumeMinimized.get()).floatValue(), BlurHandler.sMasterVolumeInactive);
            List inColors = (List)this.mBackgroundColor.get();
            int[] resultColors = new int[4];
            int color = -1728053248;
            for (i = 0; i < 4; ++i) {
                if (inColors != null && i < inColors.size()) {
                    s = (String)inColors.get(i);
                    try {
                        color = Color.parseColor(s);
                    }
                    catch (Exception e) {
                        ModernUIMod.LOGGER.error(ModernUIMod.MARKER, "Wrong color format for screen background, index: {}", (Object)i, (Object)e);
                    }
                }
                resultColors[i] = color;
            }
            BlurHandler.sBackgroundColor = resultColors;
            BlurHandler.INSTANCE.loadBlacklist((List)this.mBlurBlacklist.get());
            ModernUIClient.sInventoryPause = (Boolean)this.mInventoryPause.get();
            ModernUIClient.sRemoveTelemetrySession = (Boolean)this.mRemoveTelemetry.get();
            TooltipRenderer.sTooltip = (Boolean)this.mTooltip.get();
            inColors = (List)this.mTooltipFill.get();
            color = -1;
            for (i = 0; i < 4; ++i) {
                if (inColors != null && i < inColors.size()) {
                    s = (String)inColors.get(i);
                    try {
                        color = Color.parseColor(s);
                    }
                    catch (Exception e) {
                        ModernUIMod.LOGGER.error(ModernUIMod.MARKER, "Wrong color format for tooltip background, index: {}", (Object)i, (Object)e);
                    }
                }
                TooltipRenderer.sFillColor[i] = color;
            }
            inColors = (List)this.mTooltipStroke.get();
            color = -1;
            for (i = 0; i < 4; ++i) {
                if (inColors != null && i < inColors.size()) {
                    s = (String)inColors.get(i);
                    try {
                        color = Color.parseColor(s);
                    }
                    catch (Exception e) {
                        ModernUIMod.LOGGER.error(ModernUIMod.MARKER, "Wrong color format for tooltip border, index: {}", (Object)i, (Object)e);
                    }
                }
                TooltipRenderer.sStrokeColor[i] = color;
            }
            TooltipRenderer.sBorderColorCycle = (Integer)this.mTooltipCycle.get();
            TooltipRenderer.sExactPositioning = (Boolean)this.mExactTooltipPositioning.get();
            TooltipRenderer.sRoundedShapes = (Boolean)this.mRoundedTooltip.get();
            TooltipRenderer.sCenterTitle = (Boolean)this.mCenterTooltipTitle.get();
            TooltipRenderer.sTitleBreak = (Boolean)this.mTooltipTitleBreak.get();
            TooltipRenderer.sBorderWidth = ((Double)this.mTooltipWidth.get()).floatValue();
            TooltipRenderer.sCornerRadius = ((Double)this.mTooltipRadius.get()).floatValue();
            TooltipRenderer.sShadowRadius = ((Double)this.mTooltipShadowRadius.get()).floatValue();
            TooltipRenderer.sShadowAlpha = ((Double)this.mTooltipShadowAlpha.get()).floatValue();
            TooltipRenderer.sAdaptiveColors = (Boolean)this.mAdaptiveTooltipColors.get();
            TooltipRenderer.sArrowScrollFactor = (Integer)this.mTooltipArrowScrollFactor.get();
            UIManager.sDingEnabled = (Boolean)this.mDing.get();
            UIManager.sZoomEnabled = (Boolean)this.mZoom.get() != false && !ModernUIMod.isOptiFineLoaded();
            WindowMode windowMode = (WindowMode)((Object)this.mWindowMode.get());
            if (this.mLastWindowMode != windowMode) {
                this.mLastWindowMode = windowMode;
                Minecraft.getInstance().tell(() -> this.mLastWindowMode.apply());
            }
            if ((handler = Core.getUiHandlerAsync()) != null) {
                handler.post(() -> {
                    UIManager.getInstance().updateLayoutDir((Boolean)this.mForceRtl.get());
                    ModernUIClient.sFontScale = ((Double)this.mFontScale.get()).floatValue();
                    ModernUI ctx = ModernUI.getInstance();
                    if (ctx != null) {
                        Resources res = ctx.getResources();
                        DisplayMetrics metrics = new DisplayMetrics();
                        metrics.setTo(res.getDisplayMetrics());
                        metrics.scaledDensity = ModernUIClient.sFontScale * metrics.density;
                        res.updateMetrics(metrics);
                    }
                });
            }
            ModernUIClient.sUseColorEmoji = (Boolean)this.mUseColorEmoji.get();
            ModernUIClient.sEmojiShortcodes = (Boolean)this.mEmojiShortcodes.get();
            ModernUIClient.sFirstFontFamily = (String)this.mFirstFontFamily.get();
            ModernUIClient.sFallbackFontFamilyList = (List)this.mFallbackFontFamilyList.get();
            ModernUIClient.sFontRegistrationList = (List)this.mFontRegistrationList.get();
        }

        public static enum WindowMode {
            NORMAL,
            FULLSCREEN,
            FULLSCREEN_BORDERLESS,
            MAXIMIZED,
            MAXIMIZED_BORDERLESS,
            WINDOWED,
            WINDOWED_BORDERLESS;


            public void apply() {
                if (this == NORMAL) {
                    return;
                }
                Window window = Minecraft.getInstance().getWindow();
                switch (this.ordinal()) {
                    case 1: {
                        if (window.isFullscreen()) break;
                        window.toggleFullScreen();
                        break;
                    }
                    case 2: {
                        if (window.isFullscreen()) {
                            window.toggleFullScreen();
                        }
                        GLFW.glfwRestoreWindow((long)window.getWindow());
                        GLFW.glfwSetWindowAttrib((long)window.getWindow(), (int)131077, (int)0);
                        Monitor monitor = window.findBestMonitor();
                        if (monitor != null) {
                            VideoMode videoMode = monitor.getCurrentMode();
                            int x = monitor.getX();
                            int y = monitor.getY();
                            int width = videoMode.getWidth();
                            int height = videoMode.getHeight();
                            GLFW.glfwSetWindowMonitor((long)window.getWindow(), (long)0L, (int)x, (int)y, (int)width, (int)height, (int)-1);
                            break;
                        }
                        GLFW.glfwMaximizeWindow((long)window.getWindow());
                        break;
                    }
                    case 3: {
                        if (window.isFullscreen()) {
                            window.toggleFullScreen();
                        }
                        GLFW.glfwRestoreWindow((long)window.getWindow());
                        GLFW.glfwSetWindowAttrib((long)window.getWindow(), (int)131077, (int)1);
                        GLFW.glfwMaximizeWindow((long)window.getWindow());
                        break;
                    }
                    case 4: {
                        if (window.isFullscreen()) {
                            window.toggleFullScreen();
                        }
                        GLFW.glfwRestoreWindow((long)window.getWindow());
                        GLFW.glfwSetWindowAttrib((long)window.getWindow(), (int)131077, (int)0);
                        GLFW.glfwMaximizeWindow((long)window.getWindow());
                        break;
                    }
                    case 5: {
                        if (window.isFullscreen()) {
                            window.toggleFullScreen();
                        }
                        GLFW.glfwSetWindowAttrib((long)window.getWindow(), (int)131077, (int)1);
                        GLFW.glfwRestoreWindow((long)window.getWindow());
                        break;
                    }
                    case 6: {
                        if (window.isFullscreen()) {
                            window.toggleFullScreen();
                        }
                        GLFW.glfwSetWindowAttrib((long)window.getWindow(), (int)131077, (int)0);
                        GLFW.glfwRestoreWindow((long)window.getWindow());
                    }
                }
            }

            @Nonnull
            public String toString() {
                return I18n.get((String)("modernui.windowMode." + this.name().toLowerCase(Locale.ROOT)), (Object[])new Object[0]);
            }
        }
    }

    public static class Common {
        public final ModConfigSpec.BooleanValue developerMode;
        public final ModConfigSpec.IntValue oneTimeEvents;
        public final ModConfigSpec.BooleanValue autoShutdown;
        public final ModConfigSpec.ConfigValue<List<? extends String>> shutdownTimes;

        private Common(@Nonnull ModConfigSpec.Builder builder) {
            builder.comment("Developer Config").push("developer");
            this.developerMode = builder.comment("Whether to enable developer mode.").define("enableDeveloperMode", false);
            this.oneTimeEvents = builder.defineInRange("oneTimeEvents", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Auto Shutdown Config").push("autoShutdown");
            this.autoShutdown = builder.comment("Enable auto-shutdown for server.").define("enable", false);
            this.shutdownTimes = builder.comment("The time points of when server will auto-shutdown. Format: HH:mm.").defineList("times", () -> {
                ArrayList<String> list = new ArrayList<String>();
                list.add("04:00");
                list.add("16:00");
                return list;
            }, s -> true);
            builder.pop();
        }

        public void saveAndReloadAsync() {
            Util.ioPool().execute(() -> COMMON_SPEC.save());
            this.reload();
        }

        private void reload() {
            ModernUIMod.sDeveloperMode = (Boolean)this.developerMode.get();
            ServerHandler.INSTANCE.determineShutdownTime();
        }
    }

    public static class Text {
        public static final float BASE_FONT_SIZE_MIN = 6.5f;
        public static final float BASE_FONT_SIZE_MAX = 9.5f;
        public static final float BASELINE_MIN = 4.0f;
        public static final float BASELINE_MAX = 10.0f;
        public static final float SHADOW_OFFSET_MIN = 0.2f;
        public static final float SHADOW_OFFSET_MAX = 2.0f;
        public static final float OUTLINE_OFFSET_MIN = 0.2f;
        public static final float OUTLINE_OFFSET_MAX = 2.0f;
        public static final int LIFESPAN_MIN = 2;
        public static final int LIFESPAN_MAX = 15;
        public final ModConfigSpec.BooleanValue mAllowShadow;
        public final ModConfigSpec.BooleanValue mFixedResolution;
        public final ModConfigSpec.DoubleValue mBaseFontSize;
        public final ModConfigSpec.DoubleValue mBaselineShift;
        public final ModConfigSpec.DoubleValue mShadowOffset;
        public final ModConfigSpec.DoubleValue mOutlineOffset;
        public final ModConfigSpec.IntValue mCacheLifespan;
        public final ModConfigSpec.EnumValue<TextDirection> mTextDirection;
        public final ModConfigSpec.BooleanValue mUseTextShadersInWorld;
        public final ModConfigSpec.EnumValue<DefaultFontBehavior> mDefaultFontBehavior;
        public final ModConfigSpec.ConfigValue<List<? extends String>> mDefaultFontRuleSet;
        public final ModConfigSpec.BooleanValue mUseComponentCache;
        public final ModConfigSpec.BooleanValue mAllowAsyncLayout;
        public final ModConfigSpec.EnumValue<LineBreakStyle> mLineBreakStyle;
        public final ModConfigSpec.EnumValue<LineBreakWordStyle> mLineBreakWordStyle;
        public final ModConfigSpec.BooleanValue mSmartSDFShaders;
        public final ModConfigSpec.BooleanValue mComputeDeviceFontSize;
        public final ModConfigSpec.BooleanValue mAllowSDFTextIn2D;
        public final ModConfigSpec.BooleanValue mTweakExperienceText;
        public final ModConfigSpec.BooleanValue mAntiAliasing;
        public final ModConfigSpec.BooleanValue mLinearMetrics;
        public final ModConfigSpec.IntValue mMinPixelDensityForSDF;
        public final ModConfigSpec.BooleanValue mLinearSamplingA8Atlas;

        private Text(@Nonnull ModConfigSpec.Builder builder) {
            builder.comment("Text Engine Config").push("text");
            this.mAllowShadow = builder.comment("Allow text renderer to drop shadow, setting to false can improve performance.").define("allowShadow", true);
            this.mFixedResolution = builder.comment(new String[]{"Fix resolution level at 2. When the GUI scale increases, the resolution level remains.", "Then GUI scale should be even numbers (2, 4, 6...), based on Minecraft GUI system.", "If your fonts are not bitmap fonts, then you should keep this setting false."}).define("fixedResolution", false);
            this.mBaseFontSize = builder.comment(new String[]{"Control base font size, in GUI scaled pixels. The default and vanilla value is 8.", "For bitmap fonts, 8 represents a glyph size of 8x or 16x if fixed resolution.", "This option only applies to TrueType fonts."}).defineInRange("baseFontSize", 8.0, 6.5, 9.5);
            this.mBaselineShift = builder.comment(new String[]{"Control vertical baseline for vanilla text layout, in GUI scaled pixels.", "The vanilla default value is 7."}).defineInRange("baselineShift", 7.0, 4.0, 10.0);
            this.mShadowOffset = builder.comment("Control the text shadow offset for vanilla text rendering, in GUI scaled pixels.").defineInRange("shadowOffset", 0.5, (double)0.2f, 2.0);
            this.mOutlineOffset = builder.comment("Control the text outline offset for vanilla text rendering, in GUI scaled pixels.").defineInRange("outlineOffset", 0.5, (double)0.2f, 2.0);
            this.mCacheLifespan = builder.comment("Set the recycle time of layout cache in seconds, using least recently used algorithm.").defineInRange("cacheLifespan", 6, 2, 15);
            this.mTextDirection = builder.comment(new String[]{"The bidirectional text heuristic algorithm. The default is FirstStrong (Locale).", "This will affect which BiDi algorithm to use during text layout."}).defineEnum("textDirection", (Enum)TextDirection.FIRST_STRONG);
            this.mUseTextShadersInWorld = builder.comment(new String[]{"Whether to use Modern UI text rendering pipeline in 3D world.", "Disabling this means that SDF text and rendering optimization are no longer effective.", "But text rendering can be compatible with OptiFine Shaders and Iris Shaders.", "This does not affect text rendering in GUI.", "This option only applies to TrueType fonts."}).define("useTextShadersInWorld", true);
            this.mDefaultFontBehavior = builder.comment(new String[]{"For \"minecraft:default\" font, should we keep some glyph providers of them?", "Ignore All: Only use Modern UI typeface list.", "Keep ASCII: Include minecraft:font/ascii.png, minecraft:font/accented.png, minecraft:font/nonlatin_european.png", "Keep Other: Include providers other than ASCII and Unicode font.", "Keep All: Include all except Unicode font.", "Only Include: Only include providers that specified by defaultFontRuleSet.", "Only Exclude: Only exclude providers that specified by defaultFontRuleSet."}).defineEnum("defaultFontBehavior", (Enum)DefaultFontBehavior.ONLY_EXCLUDE);
            this.mDefaultFontRuleSet = builder.comment(new String[]{"Used when defaultFontBehavior is either ONLY_INCLUDE or ONLY_EXCLUDE.", "This specifies a set of regular expressions to match the glyph provider name.", "For bitmap providers, this is the texture path without 'textures/'.", "For TTF providers, this is the TTF file path without 'font/'.", "For space providers, this is \"font_name / minecraft:space\",", "where font_name is font definition path without 'font/'."}).defineList("defaultFontRuleSet", () -> {
                ArrayList<String> rules = new ArrayList<String>();
                rules.add("^minecraft:font\\/(nonlatin_european|accented|ascii|element_ideographs|cjk_punctuations|ellipsis|2em_dash)\\.png$");
                rules.add("^minecraft:include\\/space \\/ minecraft:space$");
                rules.add("^minecraft:font\\/(mcsans|emoji)_05_00\\d.png$");
                return rules;
            }, s -> true);
            this.mUseComponentCache = builder.comment(new String[]{"Whether to use text component object as hash key to lookup in layout cache.", "If you find that Modern UI text rendering is not compatible with some mods,", "you can disable this option for compatibility, but this will decrease performance a bit.", "Modern UI will use another cache strategy if this is disabled."}).define("useComponentCache", !ModernUIMod.isUntranslatedItemsLoaded());
            this.mAllowAsyncLayout = builder.comment(new String[]{"Allow text layout to be computed from background threads (not cached).", "Otherwise, block the current thread and wait for main thread."}).define("allowAsyncLayout", true);
            this.mLineBreakStyle = builder.comment("See CSS line-break property, https://developer.mozilla.org/en-US/docs/Web/CSS/line-break").defineEnum("lineBreakStyle", (Enum)LineBreakStyle.AUTO);
            this.mLineBreakWordStyle = builder.defineEnum("lineBreakWordStyle", (Enum)LineBreakWordStyle.AUTO);
            this.mSmartSDFShaders = builder.comment(new String[]{"When enabled, Modern UI will compute texel density in device-space to determine whether to use SDF text or bilinear sampling.", "This feature requires GLSL 400 or has no effect.", "This generally decreases performance but provides better rendering quality.", "This option only applies to TrueType fonts. May not be compatible with OptiFine."}).define("smartSDFShaders", !ModernUIMod.isOptiFineLoaded());
            this.mComputeDeviceFontSize = builder.comment(new String[]{"When rendering in 2D, this option allows Modern UI to exactly compute font size in device-space from the current coordinate transform matrix.", "This provides perfect text rendering for scaling-down texts in vanilla, but may increase GPU memory usage.", "When disabled, Modern UI will use SDF text rendering if appropriate.", "This option only applies to TrueType fonts."}).define("computeDeviceFontSize", true);
            this.mAllowSDFTextIn2D = builder.comment(new String[]{"When enabled, Modern UI will use SDF text rendering if appropriate.", "Otherwise, it uses nearest-neighbor or bilinear sampling based on texel density.", "This option only applies to TrueType fonts."}).define("allowSDFTextIn2D", true);
            this.mTweakExperienceText = builder.comment("When enabled, the outline of the experience level text will be tweaked.").define("tweakExperienceText", true);
            this.mAntiAliasing = builder.comment("Control the anti-aliasing of raw glyph rasterization.").define("antiAliasing", true);
            this.mLinearMetrics = builder.comment(new String[]{"Control the FreeType linear metrics and font hinting of raw glyph metrics.", "Disable if on low-res monitor; enable for linear text."}).define("linearMetrics", true);
            this.mMinPixelDensityForSDF = builder.comment(new String[]{"Control the minimum pixel density for SDF text and text in 3D world rendering.", "This value will be no less than current GUI scale.", "Recommend setting a higher value on high-res monitor and powerful PC hardware."}).defineInRange("minPixelDensityForSDF", 4, 4, 10);
            this.mLinearSamplingA8Atlas = builder.comment(new String[]{"Enable linear sampling for A8 font atlases with mipmaps, mag filter will be always NEAREST.", "We prefer computeDeviceFontSize and allowSDFTextIn2D, then setting this to false can improve performance.", "If either of the above two is false or Shaders are active, then setting this to true can improve quality."}).define("linearSamplingA8Atlas", false);
            builder.pop();
        }

        public void saveAsync() {
            Util.ioPool().execute(() -> TEXT_SPEC.save());
        }

        public void saveAndReloadAsync() {
            Util.ioPool().execute(() -> TEXT_SPEC.save());
            this.reload();
        }

        void reload() {
            List defaultFontRuleSet;
            boolean reload = false;
            boolean reloadStrike = false;
            ModernTextRenderer.sAllowShadow = (Boolean)this.mAllowShadow.get();
            if (TextLayoutEngine.sFixedResolution != (Boolean)this.mFixedResolution.get()) {
                TextLayoutEngine.sFixedResolution = (Boolean)this.mFixedResolution.get();
                reload = true;
            }
            if ((double)TextLayoutProcessor.sBaseFontSize != (Double)this.mBaseFontSize.get()) {
                TextLayoutProcessor.sBaseFontSize = ((Double)this.mBaseFontSize.get()).floatValue();
                reloadStrike = true;
            }
            TextLayout.sBaselineOffset = ((Double)this.mBaselineShift.get()).floatValue();
            ModernTextRenderer.sShadowOffset = ((Double)this.mShadowOffset.get()).floatValue();
            ModernTextRenderer.sOutlineOffset = ((Double)this.mOutlineOffset.get()).floatValue();
            TextLayoutEngine.sCacheLifespan = (Integer)this.mCacheLifespan.get();
            if (TextLayoutEngine.sTextDirection != ((TextDirection)((Object)this.mTextDirection.get())).key) {
                TextLayoutEngine.sTextDirection = ((TextDirection)((Object)this.mTextDirection.get())).key;
                reload = true;
            }
            if (TextLayoutEngine.sDefaultFontBehavior != ((DefaultFontBehavior)((Object)this.mDefaultFontBehavior.get())).key) {
                TextLayoutEngine.sDefaultFontBehavior = ((DefaultFontBehavior)((Object)this.mDefaultFontBehavior.get())).key;
                reload = true;
            }
            if (!Objects.equals(TextLayoutEngine.sDefaultFontRuleSet, defaultFontRuleSet = (List)this.mDefaultFontRuleSet.get())) {
                TextLayoutEngine.sDefaultFontRuleSet = defaultFontRuleSet;
                reload = true;
            }
            TextLayoutEngine.sRawUseTextShadersInWorld = (Boolean)this.mUseTextShadersInWorld.get();
            TextLayoutEngine.sUseComponentCache = (Boolean)this.mUseComponentCache.get();
            TextLayoutEngine.sAllowAsyncLayout = (Boolean)this.mAllowAsyncLayout.get();
            if (TextLayoutProcessor.sLbStyle != ((LineBreakStyle)((Object)this.mLineBreakStyle.get())).key) {
                TextLayoutProcessor.sLbStyle = ((LineBreakStyle)((Object)this.mLineBreakStyle.get())).key;
                reload = true;
            }
            if (TextLayoutProcessor.sLbWordStyle != ((LineBreakWordStyle)((Object)this.mLineBreakWordStyle.get())).key) {
                TextLayoutProcessor.sLbWordStyle = ((LineBreakWordStyle)((Object)this.mLineBreakWordStyle.get())).key;
                reload = true;
            }
            boolean smartShaders = (Boolean)this.mSmartSDFShaders.get();
            Minecraft.getInstance().submit(() -> TextRenderType.toggleSDFShaders(smartShaders));
            ModernTextRenderer.sComputeDeviceFontSize = (Boolean)this.mComputeDeviceFontSize.get();
            ModernTextRenderer.sAllowSDFTextIn2D = (Boolean)this.mAllowSDFTextIn2D.get();
            ModernTextRenderer.sTweakExperienceText = (Boolean)this.mTweakExperienceText.get();
            if (GlyphManager.sAntiAliasing != (Boolean)this.mAntiAliasing.get()) {
                GlyphManager.sAntiAliasing = (Boolean)this.mAntiAliasing.get();
                reloadStrike = true;
            }
            if (GlyphManager.sFractionalMetrics != (Boolean)this.mLinearMetrics.get()) {
                GlyphManager.sFractionalMetrics = (Boolean)this.mLinearMetrics.get();
                reloadStrike = true;
            }
            if (TextLayoutEngine.sMinPixelDensityForSDF != (Integer)this.mMinPixelDensityForSDF.get()) {
                TextLayoutEngine.sMinPixelDensityForSDF = (Integer)this.mMinPixelDensityForSDF.get();
                reload = true;
            }
            if (GLFontAtlas.sLinearSamplingA8Atlas != (Boolean)this.mLinearSamplingA8Atlas.get()) {
                GLFontAtlas.sLinearSamplingA8Atlas = (Boolean)this.mLinearSamplingA8Atlas.get();
                reloadStrike = true;
            }
            if (reloadStrike) {
                Minecraft.getInstance().submit(() -> FontResourceManager.getInstance().reloadAll());
            } else if (reload && ModernUIMod.isTextEngineEnabled()) {
                Minecraft.getInstance().submit(() -> {
                    try {
                        TextLayoutEngine.getInstance().reload();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
        }

        public static enum TextDirection {
            FIRST_STRONG(1, "FirstStrong"),
            ANY_RTL(2, "AnyRTL-LTR"),
            LTR(3, "LTR"),
            RTL(4, "RTL"),
            LOCALE(5, "Locale"),
            FIRST_STRONG_LTR(6, "FirstStrong-LTR"),
            FIRST_STRONG_RTL(7, "FirstStrong-RTL");

            private final int key;
            private final String text;

            private TextDirection(int key, String text) {
                this.key = key;
                this.text = text;
            }

            public String toString() {
                return this.text;
            }
        }

        public static enum DefaultFontBehavior {
            IGNORE_ALL(0),
            KEEP_ASCII(1),
            KEEP_OTHER(2),
            KEEP_ALL(3),
            ONLY_INCLUDE(4),
            ONLY_EXCLUDE(5);

            private final int key;

            private DefaultFontBehavior(int key) {
                this.key = key;
            }

            @Nonnull
            public String toString() {
                return I18n.get((String)("modernui.defaultFontBehavior." + this.name().toLowerCase(Locale.ROOT)), (Object[])new Object[0]);
            }
        }

        public static enum LineBreakStyle {
            AUTO(0, "Auto"),
            LOOSE(1, "Loose"),
            NORMAL(2, "Normal"),
            STRICT(3, "Strict");

            private final int key;
            private final String text;

            private LineBreakStyle(int key, String text) {
                this.key = key;
                this.text = text;
            }

            public String toString() {
                return this.text;
            }
        }

        public static enum LineBreakWordStyle {
            AUTO(0, "Auto"),
            PHRASE(1, "Phrase-based");

            private final int key;
            private final String text;

            private LineBreakWordStyle(int key, String text) {
                this.key = key;
                this.text = text;
            }

            public String toString() {
                return this.text;
            }
        }
    }
}

