/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.mixin;

import com.ibm.icu.text.BreakIterator;
import icyllis.modernui.ModernUI;
import icyllis.modernui.text.method.WordIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Locale;
import net.minecraft.client.StringSplitter;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StringSplitter.class})
public class MixinStringSplitter {
    @Inject(method={"getWordPosition(Ljava/lang/String;IIZ)I"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getWordPosition(String value, int dir, int cursor, boolean withEndSpace, CallbackInfoReturnable<Integer> cir) {
        if (dir == -1 || dir == 1) {
            int offset;
            if (withEndSpace) {
                WordIterator wordIterator = new WordIterator();
                wordIterator.setCharSequence(value, cursor, cursor);
                offset = dir == -1 ? wordIterator.preceding(cursor) : wordIterator.following(cursor);
            } else {
                BreakIterator wordIterator = BreakIterator.getWordInstance((Locale)ModernUI.getSelectedLocale());
                wordIterator.setText((CharacterIterator)new StringCharacterIterator(value, cursor));
                offset = dir == -1 ? wordIterator.preceding(cursor) : wordIterator.following(cursor);
            }
            if (offset != -1) {
                cir.setReturnValue((Object)offset);
            } else {
                cir.setReturnValue((Object)cursor);
            }
        }
    }
}

