/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.mixin;

import icyllis.modernui.mc.BlurHandler;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public class MixinGameRenderer {
    @Shadow
    @Nullable
    private PostChain blurEffect;

    @Inject(method={"resize(II)V"}, at={@At(value="TAIL")})
    private void onResize(int width, int height, CallbackInfo ci) {
        BlurHandler.INSTANCE.resize(width, height);
    }

    @Inject(method={"loadBlurEffect(Lnet/minecraft/server/packs/resources/ResourceProvider;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onLoadBlurEffect(ResourceProvider resourceProvider, CallbackInfo ci) {
        if (BlurHandler.sOverrideVanillaBlur) {
            if (this.blurEffect != null) {
                this.blurEffect.close();
            }
            this.blurEffect = null;
            ci.cancel();
        }
    }

    @Inject(method={"processBlurEffect(F)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onProcessBlurEffect(float partialTick, CallbackInfo ci) {
        if (BlurHandler.sOverrideVanillaBlur) {
            BlurHandler.INSTANCE.processBlurEffect(partialTick);
            ci.cancel();
        }
    }
}

