/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;

public final class StillAlive {
    private final SoundManager mSoundManager;
    private final List<Track> mTracks = new ArrayList<Track>();
    private volatile boolean mPlaying;
    private volatile long mStartTimeNanos;
    private static volatile StillAlive sInstance;

    private static short note(int key, int tick) {
        return (short)(tick << 5 | key);
    }

    /*
     * Opcode count of 13946 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private StillAlive() {
        this.mTracks.add(new Track(NoteBlockInstrument.FLUTE, 1.0f, 0.0f, new short[]{275, 338, 400, 464, 530, 1225, 1299, 1362, 1424, 1488, 1618, 1806, 1936, 1993, 2505, 2576, 2706, 2771, 2960, 3021, 3150, 3344, 3465, 3529, 3666, 4371, 4434, 4496, 4560, 4626, 5321, 5395, 5458, 5520, 5584, 5778, 5838, 6032, 6089, 6672, 6802, 6867, 7056, 7117, 7310, 7376, 7497, 7566, 7632, 7697, 7760, 7822, 7884, 8073, 8138, 8204, 8337, 8464, 8526, 8590, 8652, 8718, 8780, 8844, 8972, 9097, 9162, 9228, 9361, 9491, 9553, 9616, 9678, 9742, 9808, 9873, 10001, 10131, 10197, 10262, 10259, 10326, 10389, 10385, 10515, 10512, 10641, 10707, 10773, 10769, 10837, 10899, 10896, 11025, 11022, 11150, 11212, 11278, 11345, 11409, 11472, 11600, 11666, 11730, 13513, 13587, 13650, 13712, 13776, 13842, 14611, 14674, 14736, 14800, 14994, 15054, 15184, 15305, 15888, 16018, 16083, 16272, 16397, 16526, 16592, 16777, 16841, 16978, 17609, 17683, 17746, 17808, 17872, 17938, 18633, 18707, 18770, 18832, 18896, 19090, 19150, 19344, 19401, 19984, 20114, 20179, 20368, 20493, 20622, 20688, 20809, 20878, 20944, 21009, 21072, 21134, 21196, 21258, 21385, 21450, 21513, 21516, 21649, 21644, 21772, 21776, 21838, 21902, 21964, 22026, 22030, 22092, 22154, 22156, 22281, 22284, 22409, 22474, 22540, 22537, 22673, 22668, 22803, 22800, 22865, 22928, 22990, 23050, 23054, 23120, 23178, 23185, 23308, 23313, 23443, 23509, 23574, 23569, 23633, 23638, 23697, 23701, 23827, 23824, 23953, 24019, 24081, 24085, 24149, 24145, 24208, 24211, 24273, 24334, 24337, 24462, 24524, 24590, 24657, 24721, 24784, 24845, 24909, 24912, 24978, 25042, 26899, 26962, 27024, 27088, 27218, 27849, 27923, 27986, 28048, 28112, 28306, 28366, 28560, 28617, 29200, 29330, 29395, 29584, 29709, 29838, 29904, 30089, 30153, 30290, 30995, 31058, 31120, 31184, 31314, 32019, 32082, 32144, 32208, 32402, 32462, 32656, 32713, -32240, -32110, -32045, -31856, -31731, -31602, -31536, -31415, -31346, -31280, -31210, -31215, -31152, -31087, -31082, -31090, -31023, -31018, -31028, -30839, -30774, -30708, -30711, -30575, -30580, -30448, -30386, -30322, -30260, -30198, -30194, -30132, -30070, -30068, -29940, -29943, -29815, -29750, -29684, -29687, -29556, -29551, -29421, -29428, -29359, -29296, -29234, -29174, -29170, -29104, -29046, -29039, -28911, -28916, -28781, -28715, -28650, -28655, -28591, -28586, -28523, -28527, -28461, -28400, -28397, -28271, -28205, -28139, -28143, -28075, -28079, -28013, -28016, -27951, -27890, -27887, -27762, -27700, -27634, -27567, -27503, -27440, -27379, -27315, -27312, -27246, -27182, -26731, -26667, -26601, -26610, -26539, -26478, -26418, -26288, -26222, -26158, -25771, -25707, -25643, -25577, -25586, -25515, -25454, -25394, -25264, -25198, -25134, -24747, -24683, -24619, -24553, -24562, -24491, -24430, -24370, -24240, -24174, -24110, -23659, -23595, -23529, -23538, -23467, -23406, -23346, -23216, -23150, -23086, -22699, -22635, -22571, -22505, -22514, -22443, -22382, -22322, -22192, -22126, -22062, -21677, -21611, -21547, -21165, -21102, -21038}));
        this.mTracks.add(new Track(NoteBlockInstrument.HARP, 1.0f, 0.0f, new short[]{521, 590, 658, 718, 779, 846, 914, 974, 1033, 1102, 1170, 1230, 1291, 1358, 1426, 1486, 1545, 1614, 1682, 1742, 1803, 1870, 1938, 1998, 2057, 2126, 2194, 2254, 2315, 2382, 2450, 2510, 2571, 2640, 2707, 2768, 2827, 2896, 2963, 3024, 3081, 3152, 3219, 3280, 3337, 3408, 3475, 3536, 3593, 3662, 3730, 3790, 3851, 3918, 3986, 4046, 4105, 4174, 4242, 4302, 4363, 4430, 4498, 4558, 4617, 4686, 4754, 4814, 4875, 4942, 5010, 5070, 5129, 5198, 5266, 5326, 5387, 5454, 5522, 5582, 5641, 5710, 5778, 5838, 5899, 5966, 6034, 6094, 6153, 6222, 6290, 6350, 6411, 6478, 6546, 6606, 6667, 6736, 6803, 6864, 6923, 6992, 7059, 7120, 7177, 7248, 7315, 7376, 7433, 7504, 7571, 7632, 7690, 7758, 7825, 7894, 8209, 8268, 8341, 8401, 8460, 8467, 8595, 8714, 8721, 8726, 8849, 8854, 8906, 8977, 8981, 9100, 9105, 9233, 9237, 9361, 9365, 9368, 9420, 9491, 9484, 9496, 9500, 9624, 9683, 9738, 9745, 9750, 9873, 9878, 9930, 10008, 10005, 10001, 10129, 10133, 10247, 10257, 10266, 10262, 10394, 10454, 10515, 10508, 10520, 10643, 10648, 10769, 10773, 10776, 10896, 10904, 11022, 11029, 11274, 11281, 11286, 11409, 11414, 11418, 11529, 11541, 11545, 11605, 11609, 11664, 11785, 11854, 11922, 11913, 11982, 12043, 12110, 12171, 12178, 12238, 12297, 12366, 12434, 12425, 12494, 12555, 12622, 12690, 12683, 12750, 12809, 12878, 12946, 12937, 13006, 13067, 13134, 13202, 13195, 13262, 13321, 13390, 13458, 13518, 13579, 13591, 13707, 13842, 13897, 13966, 13978, 14025, 14098, 14103, 14150, 14226, 14234, 14283, 14357, 14409, 14478, 14482, 14537, 14549, 14615, 14662, 14731, 14790, 14866, 14921, 14994, 14990, 15049, 15127, 15174, 15243, 15250, 15302, 15433, 15506, 15502, 15561, 15630, 15686, 15762, 15758, 15819, 15893, 15898, 15952, 16085, 16090, 16144, 16213, 16277, 16282, 16400, 16405, 16592, 16597, 16653, 16720, 16777, 16914, 16969, 17038, 17042, 17097, 17175, 17222, 17298, 17306, 17355, 17429, 17481, 17550, 17554, 17609, 17687, 17734, 17749, 17803, 17811, 17862, 17875, 17941, 17993, 18062, 18130, 18121, 18199, 18246, 18322, 18330, 18379, 18453, 18505, 18578, 18574, 18633, 18711, 18758, 18773, 18827, 18835, 18886, 18899, 19017, 19086, 19093, 19154, 19145, 19270, 19339, 19347, 19398, 19406, 19529, 19602, 19598, 19657, 19726, 19782, 19858, 19854, 19915, 19989, 19994, 20048, 20181, 20186, 20240, 20309, 20373, 20378, 20496, 20501, 20688, 20693, 20697, 20749, 20873, 20885, 20941, 21002, 21009, 21014, 21018, 21130, 21137, 21142, 21258, 21265, 21393, 21386, 21521, 21644, 21653, 21705, 21779, 21836, 21907, 21904, 21964, 22033, 22161, 22218, 22289, 22409, 22417, 22476, 22545, 22673, 22668, 22677, 22729, 22803, 22808, 22860, 22931, 22928, 22988, 23057, 23185, 23178, 23317, 23433, 23445, 23500, 23562, 23578, 23642, 23706, 23754, 23832, 23884, 23960, 24012, 24081, 24088, 24208, 24216, 24334, 24341, 24467, 24460, 24593, 24586, 24598, 24721, 24726, 24841, 24853, 24917, 24976, 25097, 25166, 25234, 25225, 25294, 25355, 25422, 25490, 25483, 25550, 25609, 25678, 25746, 25737, 25806, 25867, 25934, 26002, 25995, 26062, 26121, 26190, 26258, 26249, 26318, 26379, 26446, 26514, 26507, 26574, 26633, 26702, 26770, 26830, 26891, 26958, 27026, 27086, 27145, 27214, 27282, 27342, 27403, 27470, 27538, 27598, 27657, 27726, 27794, 27854, 27915, 27982, 28050, 28110, 28169, 28238, 28306, 28366, 28427, 28494, 28562, 28622, 28681, 28750, 28818, 28878, 28939, 29006, 29074, 29134, 29195, 29264, 29331, 29392, 29451, 29520, 29587, 29648, 29705, 29776, 29843, 29904, 29961, 30032, 30099, 30160, 30217, 30286, 30354, 30414, 30475, 30542, 30610, 30670, 30729, 30798, 30866, 30926, 30987, 31054, 31122, 31182, 31241, 31310, 31378, 31438, 31499, 31566, 31634, 31694, 31753, 31822, 31890, 31950, 32011, 32078, 32146, 32206, 32265, 32334, 32402, 32462, 32523, 32590, 32658, 32718, -32759, -32690, -32622, -32562, -32501, -32434, -32366, -32306, -32247, -32178, -32112, -32050, -31991, -31922, -31856, -31794, -31735, -31667, -31600, -31539, -31479, -31411, -31344, -31283, -31222, -31151, -30954, -30883, -30703, -30639, -30583, -30571, -30516, -30445, -30388, -30320, -30317, -30260, -30191, -30134, -30063, -30006, -29935, -29871, -29815, -29807, -29748, -29679, -29551, -29556, -29547, -29495, -29421, -29369, -29296, -29293, -29236, -29167, -29039, -28907, -28791, -28779, -28724, -28662, -28646, -28582, -28518, -28470, -28392, -28340, -28264, -28212, -28143, -28136, -28072, -28016, -28008, -27890, -27883, -27764, -27759, -27631, -27638, -27626, -27503, -27498, -27383, -27371, -27307, -27248, -27058, -26990, -26930, -26810, -26741, -26682, -26551, -26482, -26423, -26298, -26285, -26229, -26219, -26170, -26155, -26039, -25970, -25966, -25911, -25786, -25717, -25658, -25527, -25458, -25399, -25274, -25261, -25205, -25195, -25146, -25131, -25015, -24946, -24939, -24934, -24887, -24762, -24693, -24634, -24503, -24434, -24375, -24250, -24237, -24181, -24171, -24122, -24107, -23991, -23922, -23915, -23863, -23738, -23669, -23610, -23479, -23410, -23351, -23226, -23213, -23157, -23147, -23098, -23083, -22967, -22898, -22891, -22839, -22714, -22645, -22586, -22455, -22386, -22327, -22202, -22189, -22133, -22123, -22074, -22059, -21943, -21874, -21815, -21690, -21621, -21562, -21431, -21362, -21303, -21178, -21109, -21050}));
        this.mTracks.add(new Track(NoteBlockInstrument.BASS, 1.2f, 0.0f, new short[]{11669, 11790, 11982, 12043, 12235, 12302, 12494, 12555, 12747, 12814, 13006, 13067, 13259, 13326, 13518, 13579, 13673, 13702, 13769, 13838, 14030, 14091, 14283, 14350, 14542, 14603, 14795, 14862, 15054, 15115, 15307, 15374, 15566, 15627, 15819, 15888, 16144, 16210, 16275, 16393, 16649, 16715, 16781, 16910, 17102, 17163, 17355, 17422, 17614, 17675, 17867, 17934, 18126, 18187, 18379, 18446, 18638, 18699, 18891, 18958, 19150, 19211, 19403, 19470, 19662, 19723, 19915, 19984, 20240, 20306, 20371, 20489, 20745, 20811, 20877, 21002, 21130, 21258, 21386, 21521, 21713, 21772, 21964, 22026, 22218, 22289, 22481, 22545, 22737, 22796, 22988, 23050, 23242, 23313, 23441, 23562, 23690, 23820, 23948, 24081, 24208, 24334, 24460, 24586, 24721, 24841, 24976, 25102, 25294, 25355, 25547, 25614, 25806, 25867, 26059, 26126, 26318, 26379, 26571, 26638, 26830, 26891, 26985, 27014, 27081, 27150, 31246, 31438, 31499, 31691, 31758, 31950, 32011, 32203, 32270, 32462, 32523, 32715, -32754, -32562, -32501, -32309, -32240, -31984, -31918, -31853, -31735, -31479, -31413, -31347, -31222, -30966, -30838, -30703, -30511, -30452, -30260, -30198, -30006, -29935, -29743, -29679, -29487, -29428, -29236, -29174, -28982, -28911, -28783, -28662, -28534, -28404, -28272, -28143, -28016, -27890, -27764, -27638, -27503, -27383, -27248, -27122, -26930, -26869, -26677, -26610, -26418, -26357, -26165, -26098, -25906, -25845, -25653, -25586, -25394, -25333, -25141, -25074, -24882, -24821, -24629, -24562, -24370, -24309, -24117, -24050, -23858, -23797, -23605, -23538, -23346, -23285, -23093, -23026, -22834, -22773, -22581, -22514, -22322, -22261, -22069, -22002, -21810, -21749, -21557, -21490, -21298, -21237}));
        this.mTracks.add(new Track(NoteBlockInstrument.CHIME, 0.4f, -30.0f, new short[]{8213, 8268, 8344, 8396, 8467, 8524, 8600, 8652, 8726, 8782, 8789, 8851, 8913, 8981, 9036, 9105, 9164, 9237, 9292, 9361, 9368, 9420, 9491, 9548, 9616, 9624, 9676, 9750, 9742, 9813, 9875, 9870, 9937, 10005, 10060, 10129, 10188, 10262, 10259, 10318, 10385, 10389, 10444, 10515, 10512, 10572, 10641, 10707, 10769, 10773, 10828, 10896, 10899, 10956, 11022, 11025, 11081, 11150, 11143, 11212, 11274, 11342, 11409, 11470, 11529, 11600, 11666, 11730, 11785, 11854, 11922, 11982, 12043, 12110, 12178, 12238, 12297, 12366, 12434, 12494, 12555, 12622, 12690, 12750, 12809, 12878, 12946, 13006, 13067, 13134, 13202, 13262, 13321, 13390, 13458, 13518, 13579, 13833}));
        this.mTracks.add(new Track(NoteBlockInstrument.BELL, 0.5f, 22.0f, new short[]{8213, 8268, 8344, 8396, 8467, 8524, 8600, 8652, 8726, 8782, 8789, 8851, 8913, 8981, 9036, 9105, 9164, 9237, 9292, 9361, 9368, 9420, 9491, 9548, 9616, 9624, 9676, 9750, 9742, 9813, 9875, 9870, 9937, 10005, 10060, 10129, 10188, 10262, 10259, 10318, 10385, 10389, 10444, 10515, 10512, 10572, 10641, 10707, 10769, 10773, 10828, 10896, 10899, 10956, 11022, 11025, 11081, 11150, 11143, 11212, 11274, 11342, 11409, 11470, 11529, 11600, 11666, 11730, 11785, 11854, 11922, 11982, 12043, 12110, 12178, 12238, 12297, 12366, 12434, 12494, 12555, 12622, 12690, 12750, 12809, 12878, 12946, 13006, 13067, 13134, 13202, 13262, 13321, 13390, 13458, 13518, 13579, 13833, 26899, 26962, 27024, 27088, 27218, 27849, 27923, 27986, 28048, 28112, 28306, 28366, 28560, 28617, 29200, 29330, 29395, 29584, 29709, 29838, 29904, 30089, 30153, 30290, 30995, 31058, 31120, 31184, 31314, 32019, 32082, 32144, 32208, 32402, 32462, 32656, 32713, -32242, -32240, -32247, -32110, -32114, -32119, -32050, -32045, -32055, -31858, -31856, -31863, -31731, -31740, -31602, -31610, -31536, -31545, -31415, -31346, -31280, -31215, -31152, -31090, -31028, -21677, -21611, -21547, -21165, -21102, -21038}));
        this.mTracks.add(new Track(NoteBlockInstrument.BIT, 0.6f, 0.0f, new short[]{21393, 21459, 21525, 21656, 21910, 21973, 22038, 22101, 22165, 22293, 22419, 22481, 22540, 22677, 22806, 22869, 22931, 22993, 23057, 23123, 23189, 23317, 23446, 23512, 23578, 23704, 23832, 23957, 24022, 24088, 24214, 24341, 24467, 24529, 24590, 24721, 24784, 24915, 24981, 25045, -30831, -30765, -30699, -30568, -30314, -30251, -30186, -30123, -30059, -29931, -29805, -29743, -29684, -29547, -29418, -29355, -29293, -29231, -29167, -29101, -29035, -28907, -28778, -28712, -28646, -28520, -28392, -28267, -28202, -28136, -28010, -27883, -27757, -27695, -27634, -27503, -27440, -27309, -27243, -27179}));
        short[] guitar = new short[]{11790, 12107, 12302, 12619, 12814, 13131, 13326, 13643, 13838, 14155, 14350, 14667, 14862, 15179, 15374, 15691, 15888, 16080, 16208, 16336, 16393, 16910, 17227, 17422, 17739, 17934, 18187, 18446, 18763, 18958, 19275, 19470, 19787, 19984, 20176, 20304, 20432, 20489, 21006, 21516, 21521, 21713, 21708, 21779, 21784, 21772, 21971, 21964, 21976, 22033, 22026, 22038, 22218, 22230, 22225, 22289, 22284, 22481, 22476, 22545, 22540, 22737, 22732, 22803, 22796, 22808, 22995, 22988, 23000, 23050, 23057, 23062, 23242, 23254, 23249, 23308, 23313, 23441, 23436, 23562, 23569, 23574, 23827, 23832, 23820, 23960, 23948, 23955, 24088, 24081, 24093, 24208, 24216, 24220, 24334, 24341, 24346, 24472, 24460, 24586, 24598, 24593, 24714, 24726, 24721, 24848, 24841, 24853, 24969, 24981, 24976, 25109, 25114, 25102, 25419, 25614, 25882, 25877, 25867, 26138, 26126, 26379, 26638, 26955, 31246, 31563, 31758, 32075, 32270, 32587, -32754, -32437, -32240, -32048, -31920, -31792, -31735, -31222, -31218, -30708, -30715, -30703, -30511, -30523, -30516, -30445, -30440, -30452, -30253, -30260, -30248, -30191, -30198, -30186, -30006, -29994, -29999, -29935, -29940, -29947, -29743, -29748, -29755, -29679, -29691, -29684, -29487, -29499, -29492, -29421, -29428, -29416, -29229, -29236, -29224, -29174, -29167, -29162, -28982, -28970, -28975, -28916, -28911, -28923, -28783, -28788, -28795, -28662, -28655, -28650, -28397, -28392, -28404, -28264, -28276, -28269, -28136, -28143, -28131, -28016, -28008, -28004, -27890, -27883, -27878, -27752, -27764, -27638, -27626, -27631, -27510, -27498, -27503, -27376, -27383, -27371, -27255, -27243, -27248, -27115, -27110, -27122, -26342, -26347, -26337, -26274, -26148, -26086, -26098};
        this.mTracks.add(new Track(NoteBlockInstrument.GUITAR, 0.8f, -10.0f, guitar));
        this.mTracks.add(new Track(NoteBlockInstrument.DIDGERIDOO, 0.8f, 10.0f, guitar));
        this.mTracks.add(new Track(NoteBlockInstrument.IRON_XYLOPHONE, 0.4f, -40.0f, new short[]{11785, 11790, 11792, 11922, 12107, 12110, 12115, 12178, 12240, 12297, 12302, 12304, 12434, 12619, 12622, 12627, 12690, 12752, 12809, 12814, 12816, 12946, 13131, 13134, 13139, 13202, 13264, 13321, 13326, 13328, 13458, 13643, 13646, 13651, 13714, 13776, 13833, 13838, 13840, 13970, 14155, 14158, 14163, 14226, 14288, 14345, 14350, 14352, 14482, 14667, 14670, 14675, 14738, 14800, 14857, 14862, 14864, 14994, 15179, 15182, 15187, 15250, 15312, 15369, 15374, 15376, 15506, 15691, 15694, 15699, 15762, 15824, 15881, 15883, 15888, 16073, 16075, 16080, 16265, 16267, 16272, 16393, 16397, 16400, 16521, 16589, 16585, 16592, 16713, 16777, 16781, 16784, 16905, 16910, 16912, 17042, 17227, 17230, 17235, 17298, 17360, 17417, 17422, 17424, 17554, 17739, 17742, 17747, 17810, 17872, 17929, 17934, 17936, 18066, 18251, 18254, 18259, 18322, 18384, 18441, 18446, 18448, 18578, 18763, 18766, 18771, 18834, 18896, 18953, 18958, 18960, 19090, 19275, 19278, 19283, 19346, 19408, 19465, 19470, 19472, 19602, 19787, 19790, 19795, 19858, 19920, 19977, 19979, 19984, 20169, 20171, 20176, 20361, 20363, 20368, 20489, 20493, 20496, 20617, 20685, 20681, 20688, 20809, 20873, 20877, 20880, 21002, 21006, 21009, 25097, 25102, 25104, 25234, 25419, 25422, 25427, 25490, 25552, 25609, 25614, 25616, 25746, 25867, 25870, 25939, 26002, 26064, 26121, 26126, 26128, 26258, 26443, 26446, 26451, 26514, 26576, 26633, 26638, 26640, 26770, 26955, 26958, 26963, 27026, 27088, 27145, 27214, 27282, 27342, 27403, 27470, 27538, 27598, 27657, 27726, 27794, 27854, 27915, 27982, 28050, 28110, 28169, 28238, 28306, 28366, 28427, 28494, 28562, 28622, 28681, 28750, 28818, 28878, 28939, 29006, 29074, 29134, 29195, 29264, 29331, 29392, 29451, 29520, 29587, 29648, 29705, 29776, 29843, 29904, 29961, 30032, 30099, 30160, 30217, 30286, 30354, 30414, 30475, 30542, 30610, 30670, 30729, 30798, 30866, 30926, 30987, 31054, 31122, 31182, 31241, 31246, 31248, 31378, 31563, 31566, 31571, 31634, 31696, 31753, 31758, 31760, 31890, 32075, 32078, 32083, 32146, 32208, 32265, 32270, 32272, 32402, 32587, 32590, 32595, 32658, 32720, -32759, -32754, -32752, -32622, -32437, -32434, -32429, -32366, -32304, -32240, -32247, -32245, -32055, -32053, -32048, -31863, -31861, -31856, -31735, -31731, -31728, -31607, -31539, -31543, -31536, -31415, -31351, -31347, -31344, -31222, -31218, -27127, -27058, -26990, -26930, -26869, -26802, -26734, -26674, -26615, -26546, -26478, -26418, -26357, -26290, -26222, -26162, -26103, -26034, -25966, -25906, -25845, -25778, -25710, -25650, -25591, -25522, -25454, -25394, -25333, -25266, -25198, -25138, -25079, -25010, -24942, -24882, -24821, -24754, -24686, -24626, -24567, -24498, -24430, -24370, -24309, -24242, -24174, -24114, -24055, -23986, -23918, -23858, -23797, -23730, -23662, -23602, -23543, -23474, -23406, -23346, -23285, -23218, -23150, -23090, -23031, -22962, -22894, -22834, -22773, -22706, -22638, -22578, -22519, -22450, -22382, -22322, -22261, -22194, -22126, -22066, -22007, -21938, -21870, -21810, -21749, -21682, -21614, -21554, -21495, -21426, -21358, -21298, -21237, -21170, -21102, -21042}));
        this.mTracks.add(new Track(NoteBlockInstrument.PLING, 0.4f, 40.0f, new short[]{11785, 11854, 11922, 11982, 12043, 12110, 12178, 12238, 12297, 12366, 12434, 12494, 12555, 12622, 12690, 12750, 12809, 12878, 12946, 13006, 13067, 13134, 13202, 13262, 13321, 13390, 13458, 13518, 13579, 13646, 13714, 13774, 13833, 13902, 13970, 14030, 14091, 14158, 14226, 14286, 14345, 14414, 14482, 14542, 14603, 14670, 14738, 14798, 14857, 14926, 14994, 15054, 15115, 15182, 15250, 15310, 15369, 15438, 15506, 15566, 15627, 15694, 15762, 15822, 15881, 15950, 16016, 16078, 16147, 16208, 16270, 16336, 16393, 16461, 16528, 16589, 16659, 16720, 16781, 16848, 16905, 16974, 17042, 17102, 17163, 17230, 17298, 17358, 17417, 17486, 17554, 17614, 17675, 17742, 17810, 17870, 17929, 17998, 18066, 18126, 18187, 18254, 18322, 18382, 18441, 18510, 18578, 18638, 18699, 18766, 18834, 18894, 18953, 19022, 19090, 19150, 19211, 19278, 19346, 19406, 19465, 19534, 19602, 19662, 19723, 19790, 19858, 19918, 19977, 20046, 20112, 20174, 20243, 20304, 20366, 20432, 20489, 20557, 20624, 20685, 20755, 20816, 20877, 20944, 21002, 21006, 25097, 25166, 25234, 25294, 25355, 25422, 25490, 25550, 25609, 25678, 25746, 25806, 25867, 25934, 26002, 26062, 26121, 26190, 26258, 26318, 26379, 26446, 26514, 26574, 26633, 26702, 26770, 26830, 26891, 26958, 27026, 27086, 30217, 30286, 30354, 30414, 30475, 30542, 30610, 30670, 30729, 30798, 30866, 30926, 30987, 31054, 31122, 31182, 31241, 31310, 31378, 31438, 31499, 31566, 31634, 31694, 31753, 31822, 31890, 31950, 32011, 32078, 32146, 32206, 32265, 32334, 32402, 32462, 32523, 32590, 32658, 32718, -32759, -32690, -32622, -32562, -32501, -32434, -32366, -32306, -32247, -32178, -32112, -32050, -31981, -31920, -31858, -31792, -31735, -31667, -31600, -31539, -31469, -31408, -31347, -31280, -31218, -31222, -31094, -31090, -30966, -30962, -30838, -30834, -27127, -27058, -26990, -26930, -26869, -26802, -26734, -26674, -26615, -26546, -26478, -26418, -26357, -26290, -26222, -26162, -26103, -26034, -25966, -25906, -25845, -25778, -25710, -25650, -25591, -25522, -25454, -25394, -25333, -25266, -25198, -25138, -25079, -25010, -24942, -24882, -24821, -24754, -24686, -24626, -24567, -24498, -24430, -24370, -24309, -24242, -24174, -24114, -24055, -23986, -23918, -23858, -23797, -23730, -23662, -23602, -23543, -23474, -23406, -23346, -23285, -23218, -23150, -23090, -23031, -22962, -22894, -22834, -22773, -22706, -22638, -22578, -22519, -22450, -22382, -22322, -22261, -22194, -22126, -22066, -22007, -21938, -21870, -21810, -21749, -21682, -21614, -21554, -21495, -21426, -21358, -21298, -21237, -21170, -21102, -21042}));
        this.mTracks.add(new Track(NoteBlockInstrument.BASEDRUM, 1.0f, 0.0f, new short[]{8204, 8396, 8460, 8716, 8908, 8972, 9228, 9420, 9484, 9740, 9932, 9996, 10252, 10444, 10508, 10764, 10956, 11020, 11276, 11468, 11532, 11788, 11980, 12044, 12300, 12492, 12556, 12812, 13004, 13068, 13324, 13516, 13580, 13772, 13836, 14028, 14092, 14348, 14540, 14604, 14860, 15052, 15116, 15372, 15564, 15628, 15884, 16076, 16140, 16396, 16588, 16652, 16908, 17100, 17164, 17420, 17612, 17676, 17932, 18124, 18188, 18444, 18636, 18700, 18956, 19148, 19212, 19468, 19660, 19724, 19980, 20172, 20236, 20492, 20684, 20748, 21004, 21196, 21260, 21516, 21708, 21772, 21964, 22028, 22220, 22284, 22476, 22540, 22732, 22796, 22988, 23052, 23244, 23308, 23372, 23564, 23756, 23820, 24012, 24076, 24268, 24332, 24524, 24588, 24780, 24844, 24972, 25100, 25292, 25356, 25612, 25804, 25868, 26124, 26316, 26380, 26636, 26828, 26892, 26988, 31116, 31244, 31436, 31500, 31756, 31948, 32012, 32268, 32460, 32524, -32756, -32564, -32500, -32244, -32052, -31988, -31732, -31540, -31476, -31220, -31028, -30964, -30836, -30708, -30516, -30452, -30260, -30196, -30004, -29940, -29748, -29684, -29492, -29428, -29236, -29172, -28980, -28916, -28724, -28660, -28468, -28404, -28212, -28148, -27956, -27892, -27700, -27636, -27444, -27380, -27124, -26932, -26868, -26676, -26612, -26420, -26356, -26100, -25908, -25844, -25588, -25396, -25268, -25204, -25076, -24884, -24820, -24564, -24372, -24308, -24052, -23860, -23796, -23540, -23348, -23284, -23028, -22836, -22772, -22516, -22324, -22260, -22004, -21812, -21748, -21492, -21300, -21236}));
        this.mTracks.add(new Track(NoteBlockInstrument.SNARE, 0.9f, 0.0f, new short[]{11916, 12172, 12428, 12684, 12940, 13196, 13452, 13676, 13708, 13964, 14220, 14476, 14732, 14988, 15244, 15500, 15756, 16012, 16268, 16524, 16780, 17036, 17292, 17548, 17804, 18060, 18316, 18572, 18828, 19084, 19340, 19596, 19852, 20108, 20364, 20620, 20876, 21132, 21388, 21644, 21900, 22156, 22412, 22668, 22924, 23180, 23404, 23436, 23500, 23692, 23948, 24204, 24460, 24716, 24940, 24972, 25036, 25228, 25484, 25740, 25996, 26252, 26508, 26764, 27020, 31116, 31372, 31628, 31884, 32140, 32396, 32652, -32628, -32372, -32116, -31860, -31604, -31348, -31092, -30836, -30580, -30324, -30068, -29812, -29556, -29300, -29044, -28852, -28788, -28756, -28724, -28532, -28276, -28020, -27764, -27508, -27380, -27284, -27252, -26996, -26740, -26484, -26228, -25972, -25716, -25460, -25332, -25204, -25140, -25108, -24948, -24692, -24436, -24180, -23924, -23668, -23412, -23156, -22900, -22644, -22388, -22132, -21876, -21620, -21364}));
        this.mTracks.add(new Track(NoteBlockInstrument.HAT, 0.9f, 0.0f, new short[]{8344, 8600, 8856, 9112, 9368, 9624, 9880, 10136, 10392, 10648, 10904, 11160, 11416, 11672, 11788, 11852, 11916, 11980, 12044, 12108, 12172, 12236, 12300, 12364, 12428, 12492, 12556, 12620, 12684, 12748, 12812, 12876, 12940, 13004, 13068, 13132, 13196, 13260, 13324, 13388, 13452, 13516, 13586, 13836, 13900, 13964, 14028, 14092, 14156, 14220, 14284, 14348, 14412, 14476, 14540, 14604, 14668, 14732, 14796, 14860, 14924, 14988, 15052, 15116, 15180, 15244, 15308, 15372, 15436, 15500, 15564, 15628, 15692, 15756, 15820, 15884, 15948, 16012, 16076, 16140, 16204, 16268, 16332, 16396, 16460, 16524, 16588, 16652, 16716, 16780, 16844, 16908, 16972, 17036, 17100, 17164, 17228, 17292, 17356, 17420, 17484, 17548, 17612, 17676, 17740, 17804, 17868, 17932, 17996, 18060, 18124, 18188, 18252, 18316, 18380, 18444, 18508, 18572, 18636, 18700, 18764, 18828, 18892, 18956, 19020, 19084, 19148, 19212, 19276, 19340, 19404, 19468, 19532, 19596, 19660, 19724, 19788, 19852, 19916, 19980, 20044, 20108, 20172, 20236, 20300, 20364, 20428, 20492, 20556, 20620, 20684, 20748, 20812, 20876, 20940, 21004, 21068, 21132, 21196, 21260, 21324, 21388, 21452, 21522, 21650, 21778, 21906, 22034, 22162, 22290, 22418, 22546, 22674, 22802, 22930, 23058, 23186, 23314, 23570, 23698, 23826, 23954, 24082, 24210, 24338, 24466, 24594, 24722, 24850, 25100, 25164, 25228, 25292, 25356, 25420, 25484, 25548, 25612, 25676, 25740, 25804, 25868, 25932, 25996, 26060, 26124, 26188, 26252, 26316, 26380, 26444, 26508, 26572, 26636, 26700, 26764, 26828, 26892, 27020, 31122, 31244, 31308, 31372, 31436, 31500, 31564, 31628, 31692, 31756, 31820, 31884, 31948, 32012, 32076, 32140, 32204, 32268, 32332, 32396, 32460, 32524, 32588, 32652, 32716, -32756, -32692, -32628, -32564, -32500, -32436, -32372, -32308, -32244, -32180, -32116, -32052, -31988, -31924, -31860, -31796, -31732, -31668, -31604, -31540, -31476, -31412, -31348, -31284, -31220, -31156, -31092, -31028, -30964, -30900, -30830, -30702, -30574, -30446, -30318, -30190, -30062, -29934, -29806, -29678, -29550, -29422, -29294, -29166, -29038, -28910, -28654, -28526, -28398, -28270, -28142, -28014, -27886, -27758, -27630, -27502, -27374, -27246, -27124, -27060, -26996, -26932, -26868, -26804, -26740, -26676, -26612, -26548, -26484, -26420, -26356, -26292, -26228, -26164, -26100, -26036, -25972, -25908, -25844, -25780, -25716, -25652, -25588, -25524, -25460, -25396, -25332, -25262, -25076, -25012, -24948, -24884, -24820, -24756, -24692, -24628, -24564, -24500, -24436, -24372, -24308, -24244, -24180, -24116, -24052, -23988, -23924, -23860, -23796, -23732, -23668, -23604, -23540, -23476, -23412, -23348, -23284, -23220, -23156, -23092, -23028, -22964, -22900, -22836, -22772, -22708, -22644, -22580, -22516, -22452, -22388, -22324, -22260, -22196, -22132, -22068, -22004, -21940, -21876, -21812, -21748, -21684, -21620, -21556, -21492, -21428, -21364, -21300, -21236}));
        this.mSoundManager = Minecraft.getInstance().getSoundManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StillAlive getInstance() {
        if (sInstance != null) return sInstance;
        Class<StillAlive> clazz = StillAlive.class;
        synchronized (StillAlive.class) {
            if (sInstance != null) return sInstance;
            sInstance = new StillAlive();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public static void tick() {
        if (sInstance != null) {
            sInstance.onTick();
        }
    }

    public void start() {
        this.mPlaying = true;
        this.mStartTimeNanos = System.nanoTime();
        this.mTracks.forEach(Track::rewind);
    }

    public void stop() {
        this.mPlaying = false;
    }

    void onTick() {
        if (this.mPlaying) {
            long now = System.nanoTime();
            boolean stop = true;
            for (Track track : this.mTracks) {
                short note;
                long time;
                while (track.mPosition < track.mNotes.length && now >= (time = this.mStartTimeNanos + (long)((note = track.mNotes[track.mPosition]) & 0xFFE0) * 3906250L)) {
                    this.playNode(track.mInstrument, track.mVolume, track.mX, track.mZ, note & 0x1F);
                    ++track.mPosition;
                }
                stop &= track.mPosition == track.mNotes.length;
            }
            if (stop) {
                this.stop();
            }
        }
    }

    void playNode(NoteBlockInstrument instrument, float volume, double x, double z, int key) {
        float pitch = (float)Math.pow(2.0, (double)(key - 18) / 12.0);
        SimpleSoundInstance soundInstance = new SimpleSoundInstance(((SoundEvent)instrument.getSoundEvent().value()).getLocation(), SoundSource.MASTER, volume, pitch, SoundInstance.createUnseededRandom(), false, 0, SoundInstance.Attenuation.NONE, x, 0.0, z, true);
        this.mSoundManager.play((SoundInstance)soundInstance);
    }

    private static class Track {
        final NoteBlockInstrument mInstrument;
        final float mVolume;
        final double mX;
        final double mZ;
        final short[] mNotes;
        int mPosition;

        Track(NoteBlockInstrument instrument, float volume, float pan, short[] notes) {
            this.mInstrument = instrument;
            this.mVolume = volume;
            this.mX = Math.sin(Math.toRadians(pan));
            this.mZ = Math.cos(Math.toRadians(pan));
            this.mNotes = notes;
        }

        void rewind() {
            this.mPosition = 0;
        }
    }
}

