/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc;

import icyllis.modernui.animation.TimeInterpolator;
import icyllis.modernui.mc.UIManager;
import javax.annotation.Nonnull;
import net.minecraft.util.Mth;

public class ScrollController {
    private float startValue;
    private float targetValue;
    private float maxValue;
    private float currValue;
    private long startTime;
    private int duration;
    @Nonnull
    private final IListener listener;

    public ScrollController(@Nonnull IListener listener) {
        this.listener = listener;
    }

    public void update(long time) {
        if (this.currValue != this.targetValue) {
            float p = Math.min((float)(time - this.startTime) / (float)this.duration, 1.0f);
            p = TimeInterpolator.DECELERATE.getInterpolation(p);
            this.currValue = Mth.lerp((float)p, (float)this.startValue, (float)this.targetValue);
            this.listener.onScrollAmountUpdated(this, this.currValue);
        }
    }

    public void setMaxScroll(float max) {
        this.maxValue = max;
    }

    public void setStartValue(float start) {
        this.startValue = start;
    }

    public float getCurrValue() {
        return this.currValue;
    }

    public int getDuration() {
        return this.duration;
    }

    public void scrollBy(float delta, int duration) {
        this.scrollTo(this.targetValue + delta, duration);
    }

    public boolean scrollBy(float delta) {
        return this.scrollTo(this.targetValue + delta);
    }

    public void scrollTo(float target, int duration) {
        this.startTime = UIManager.getElapsedTime();
        this.startValue = this.currValue;
        this.targetValue = Mth.clamp((float)target, (float)0.0f, (float)this.maxValue);
        this.duration = duration;
    }

    public boolean scrollTo(float target) {
        float lastTime = this.startTime;
        this.startTime = UIManager.getElapsedTime();
        this.startValue = this.currValue;
        this.targetValue = Mth.clamp((float)target, (float)0.0f, (float)this.maxValue);
        if (this.startValue == this.targetValue) {
            return false;
        }
        float dis = Math.abs(this.targetValue - this.currValue);
        this.duration = (double)dis > 120.0 ? (int)(Math.sqrt((double)dis / 120.0) * 200.0) : 200;
        float det = (float)this.startTime - lastTime;
        if ((double)det < 120.0) {
            this.duration = (int)((float)this.duration * (det / 600.0f + 0.8f));
        }
        return true;
    }

    public void abortAnimation() {
        this.currValue = this.targetValue;
        this.listener.onScrollAmountUpdated(this, this.currValue);
    }

    public boolean isScrolling() {
        return this.currValue != this.targetValue;
    }

    @FunctionalInterface
    public static interface IListener {
        public void onScrollAmountUpdated(ScrollController var1, float var2);
    }
}

