/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.VertexFormat;
import icyllis.modernui.ModernUI;
import icyllis.modernui.annotation.MainThread;
import icyllis.modernui.annotation.RenderThread;
import icyllis.modernui.core.Core;
import icyllis.modernui.fragment.Fragment;
import icyllis.modernui.graphics.MathUtil;
import icyllis.modernui.graphics.text.GraphemeBreak;
import icyllis.modernui.mc.MuiScreen;
import icyllis.modernui.mc.ScreenCallback;
import icyllis.modernui.mc.UIManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Rarity;

public abstract class MuiModApi {
    static final CopyOnWriteArrayList<OnScreenChangeListener> sOnScreenChangeListeners = new CopyOnWriteArrayList();
    static final CopyOnWriteArrayList<OnWindowResizeListener> sOnWindowResizeListeners = new CopyOnWriteArrayList();
    static final CopyOnWriteArrayList<OnDebugDumpListener> sOnDebugDumpListeners = new CopyOnWriteArrayList();
    static final CopyOnWriteArrayList<OnPreKeyInputListener> sOnPreKeyInputListeners = new CopyOnWriteArrayList();
    static final MuiModApi INSTANCE = ServiceLoader.load(MuiModApi.class).findFirst().orElseThrow();
    public static final int MAX_GUI_SCALE = 8;
    public static final Pattern EMOJI_SHORTCODE_PATTERN = Pattern.compile("(:(\\w|\\+|-)+:)(?=|[!.?]|$)");
    private static final ChatFormatting[] FORMATTING_TABLE = new ChatFormatting[128];

    public static MuiModApi get() {
        return INSTANCE;
    }

    @MainThread
    public static void openScreen(@Nonnull Fragment fragment) {
        UIManager.getInstance().open(fragment);
    }

    @Nonnull
    public final <T extends Screen> T createScreen(@Nonnull Fragment fragment) {
        return this.createScreen(fragment, null, null, null);
    }

    @Nonnull
    public final <T extends Screen> T createScreen(@Nonnull Fragment fragment, @Nullable ScreenCallback callback) {
        return this.createScreen(fragment, callback, null, null);
    }

    @Nonnull
    public final <T extends Screen> T createScreen(@Nonnull Fragment fragment, @Nullable ScreenCallback callback, @Nullable Screen previousScreen) {
        return this.createScreen(fragment, callback, previousScreen, null);
    }

    @Nonnull
    public abstract <T extends Screen> T createScreen(@Nonnull Fragment var1, @Nullable ScreenCallback var2, @Nullable Screen var3, @Nullable CharSequence var4);

    @Nonnull
    public abstract <T extends AbstractContainerMenu, U extends Screen & MuiScreen> U createMenuScreen(@Nonnull Fragment var1, @Nullable ScreenCallback var2, @Nonnull T var3, @Nonnull Inventory var4, @Nonnull Component var5);

    @RenderThread
    public static long getElapsedTime() {
        return UIManager.getElapsedTime();
    }

    @RenderThread
    public static long getFrameTime() {
        return MuiModApi.getFrameTimeNanos() / 1000000L;
    }

    @RenderThread
    public static long getFrameTimeNanos() {
        return UIManager.getFrameTimeNanos();
    }

    public static void postToUiThread(@Nonnull Runnable r) {
        Core.getUiHandlerAsync().post(r);
    }

    public static int calcGuiScales() {
        return MuiModApi.calcGuiScales(Minecraft.getInstance().getWindow());
    }

    public static int calcGuiScales(@Nonnull Window window) {
        return MuiModApi.calcGuiScales(window.getWidth(), window.getHeight());
    }

    public static int calcGuiScales(int framebufferWidth, int framebufferHeight) {
        int auto;
        double w = (double)framebufferWidth / 16.0;
        double h = (double)framebufferHeight / 9.0;
        double base = Math.min(w, h);
        int det = (int)(Math.min((double)framebufferWidth, h * 12.0) / 320.0);
        int min = det >= 2 ? MathUtil.clamp((int)(base / 64.0), 2, 8) : 2;
        int max = MathUtil.clamp(det, 2, 8);
        if (min >= 2) {
            double step = base > 216.0 ? 42.0 : (base > 120.0 ? 36.0 : 30.0);
            int i = (int)(base / step);
            int j = (int)(Math.max(w, h) / step);
            double v1 = base / ((double)i * 30.0);
            auto = v1 > 1.4 || j > i ? MathUtil.clamp(i + 1, min, max) : MathUtil.clamp(i, min, max);
        } else {
            auto = 2;
        }
        assert (min <= auto && auto <= max);
        return min << 8 | auto << 4 | max;
    }

    public static int offsetByGrapheme(String value, int cursor, int dir) {
        int op = dir < 0 ? 2 : (dir == 0 ? 3 : 0);
        int offset = Util.offsetByCodepoints((String)value, (int)cursor, (int)dir);
        cursor = GraphemeBreak.getTextRunCursor(value, ModernUI.getSelectedLocale(), 0, value.length(), cursor, op);
        if (dir > 0) {
            return Math.max(offset, cursor);
        }
        return Math.min(offset, cursor);
    }

    @Nullable
    public static ChatFormatting getFormattingByCode(char code) {
        return code < '\u0080' ? FORMATTING_TABLE[code] : null;
    }

    public abstract boolean isGLVersionPromoted();

    public abstract void loadEffect(GameRenderer var1, ResourceLocation var2);

    public abstract ShaderInstance makeShaderInstance(ResourceProvider var1, ResourceLocation var2, VertexFormat var3) throws IOException;

    public abstract boolean isKeyBindingMatches(KeyMapping var1, InputConstants.Key var2);

    public abstract Style applyRarityTo(Rarity var1, Style var2);

    public static void addOnScreenChangeListener(@Nonnull OnScreenChangeListener listener) {
        sOnScreenChangeListeners.addIfAbsent(listener);
    }

    public static void removeOnScreenChangeListener(@Nonnull OnScreenChangeListener listener) {
        sOnScreenChangeListeners.remove(listener);
    }

    public static void addOnWindowResizeListener(@Nonnull OnWindowResizeListener listener) {
        sOnWindowResizeListeners.addIfAbsent(listener);
    }

    public static void removeOnWindowResizeListener(@Nonnull OnWindowResizeListener listener) {
        sOnWindowResizeListeners.remove(listener);
    }

    public static void addOnDebugDumpListener(@Nonnull OnDebugDumpListener listener) {
        sOnDebugDumpListeners.addIfAbsent(listener);
    }

    public static void removeOnDebugDumpListener(@Nonnull OnDebugDumpListener listener) {
        sOnDebugDumpListeners.remove(listener);
    }

    public static void addOnPreKeyInputListener(@Nonnull OnPreKeyInputListener listener) {
        sOnPreKeyInputListeners.addIfAbsent(listener);
    }

    public static void removeOnPreKeyInputListener(@Nonnull OnPreKeyInputListener listener) {
        sOnPreKeyInputListeners.remove(listener);
    }

    public static void dispatchOnScreenChange(@Nullable Screen oldScreen, @Nullable Screen newScreen) {
        for (OnScreenChangeListener l : sOnScreenChangeListeners) {
            l.onScreenChange(oldScreen, newScreen);
        }
    }

    public static void dispatchOnWindowResize(int width, int height, int guiScale, int oldGuiScale) {
        for (OnWindowResizeListener l : sOnWindowResizeListeners) {
            l.onWindowResize(width, height, guiScale, oldGuiScale);
        }
    }

    public static void dispatchOnDebugDump(@Nonnull PrintWriter writer) {
        for (OnDebugDumpListener l : sOnDebugDumpListeners) {
            l.onDebugDump(writer);
        }
    }

    public static void dispatchOnPreKeyInput(long window, int keyCode, int scanCode, int action, int mods) {
        for (OnPreKeyInputListener l : sOnPreKeyInputListeners) {
            l.onPreKeyInput(window, keyCode, scanCode, action, mods);
        }
    }

    static {
        ChatFormatting[] chatFormattingArray = ChatFormatting.values();
        int n = chatFormattingArray.length;
        for (int i = 0; i < n; ++i) {
            ChatFormatting f;
            MuiModApi.FORMATTING_TABLE[f.getChar()] = f = chatFormattingArray[i];
            MuiModApi.FORMATTING_TABLE[Character.toUpperCase((char)f.getChar())] = f;
        }
    }

    @FunctionalInterface
    public static interface OnScreenChangeListener {
        public void onScreenChange(@Nullable Screen var1, @Nullable Screen var2);
    }

    @FunctionalInterface
    public static interface OnWindowResizeListener {
        public void onWindowResize(int var1, int var2, int var3, int var4);
    }

    @FunctionalInterface
    public static interface OnDebugDumpListener {
        public void onDebugDump(@Nonnull PrintWriter var1);
    }

    @FunctionalInterface
    public static interface OnPreKeyInputListener {
        public void onPreKeyInput(long var1, int var3, int var4, int var5, int var6);
    }
}

