/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc;

import icyllis.modernui.annotation.FloatRange;
import icyllis.modernui.annotation.RenderThread;
import icyllis.modernui.core.Context;
import icyllis.modernui.mc.MinecraftDrawHandler;
import icyllis.modernui.mc.UIManager;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewRoot;
import icyllis.modernui.view.ViewTreeObserver;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;

public class MinecraftSurfaceView
extends View {
    private final WeakReference<MinecraftSurfaceView> mThisWeakRef = new WeakReference<MinecraftSurfaceView>(this);
    volatile Renderer mRenderer;
    private MinecraftDrawHandler mDrawHandler;
    private final ViewTreeObserver.OnScrollChangedListener mScrollChangedListener = this::updateSurface;
    private final ViewTreeObserver.OnPreDrawListener mDrawListener = () -> {
        this.mHaveFrame = this.getWidth() > 0 && this.getHeight() > 0;
        this.updateSurface();
        return true;
    };
    private boolean mGlobalListenersAdded;
    private boolean mAttachedToWindow;
    final int[] mLocation = new int[2];
    boolean mRequestedVisible = false;
    boolean mViewVisibility = false;
    float mAlpha = 1.0f;
    boolean mHaveFrame = false;
    boolean mVisible = false;
    int mWindowSpaceLeft = -1;
    int mWindowSpaceTop = -1;
    int mSurfaceWidth = -1;
    int mSurfaceHeight = -1;

    public MinecraftSurfaceView(Context context) {
        super(context);
        this.setWillNotDraw(true);
    }

    public void setRenderer(Renderer renderer) {
        this.mRenderer = renderer;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mRequestedVisible = this.mViewVisibility = this.getVisibility() == 0;
        this.mAttachedToWindow = true;
        if (!this.mGlobalListenersAdded) {
            ViewTreeObserver observer = this.getViewTreeObserver();
            observer.addOnScrollChangedListener(this.mScrollChangedListener);
            observer.addOnPreDrawListener(this.mDrawListener);
            this.mGlobalListenersAdded = true;
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        this.mAttachedToWindow = false;
        if (this.mGlobalListenersAdded) {
            ViewTreeObserver observer = this.getViewTreeObserver();
            observer.removeOnScrollChangedListener(this.mScrollChangedListener);
            observer.removeOnPreDrawListener(this.mDrawListener);
            this.mGlobalListenersAdded = false;
        }
        this.mRequestedVisible = false;
        this.updateSurface();
        this.mAlpha = 1.0f;
        if (this.mDrawHandler != null) {
            ViewRoot viewRoot = this.getViewRoot();
            if (viewRoot instanceof UIManager.ViewRootImpl) {
                UIManager.ViewRootImpl viewRoot2 = (UIManager.ViewRootImpl)viewRoot;
                viewRoot2.addRawDrawHandlerOperation(new MinecraftDrawHandler.Operation(1, this.mDrawHandler));
            }
            this.mDrawHandler = null;
        }
        this.mHaveFrame = false;
        super.onDetachedFromWindow();
    }

    @Override
    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        boolean newRequestedVisible = this.mViewVisibility = visibility == 0;
        if (newRequestedVisible != this.mRequestedVisible) {
            this.requestLayout();
        }
        this.mRequestedVisible = newRequestedVisible;
        this.updateSurface();
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.updateSurface();
    }

    protected void updateSurface() {
        boolean positionChanged;
        if (!this.mHaveFrame) {
            return;
        }
        ViewRoot viewRoot = this.getViewRoot();
        if (!(viewRoot instanceof UIManager.ViewRootImpl)) {
            return;
        }
        UIManager.ViewRootImpl viewRoot2 = (UIManager.ViewRootImpl)viewRoot;
        int myWidth = this.getWidth();
        int myHeight = this.getHeight();
        float alpha = this.getAlpha();
        boolean visibleChanged = this.mVisible != this.mRequestedVisible;
        boolean alphaChanged = this.mAlpha != alpha;
        boolean creating = this.mDrawHandler == null && this.mAttachedToWindow;
        boolean layoutSizeChanged = this.mSurfaceWidth != myWidth || this.mSurfaceHeight != myHeight;
        this.getLocationInWindow(this.mLocation);
        boolean bl = positionChanged = this.mWindowSpaceLeft != this.mLocation[0] || this.mWindowSpaceTop != this.mLocation[1];
        if (creating || visibleChanged || alphaChanged || layoutSizeChanged || positionChanged || !this.mAttachedToWindow) {
            this.mVisible = this.mRequestedVisible;
            this.mWindowSpaceLeft = this.mLocation[0];
            this.mWindowSpaceTop = this.mLocation[1];
            this.mSurfaceWidth = myWidth;
            this.mSurfaceHeight = myHeight;
            this.mAlpha = alpha;
            if (creating) {
                this.mDrawHandler = new MinecraftDrawHandler(this.mThisWeakRef);
                viewRoot2.addRawDrawHandlerOperation(new MinecraftDrawHandler.Operation(0, this.mDrawHandler));
            } else if (this.mDrawHandler == null) {
                return;
            }
            MinecraftDrawHandler.Properties p = this.mDrawHandler.mStagingProperties;
            p.mHidden = !this.mVisible;
            p.mAlpha = this.mAlpha;
            p.mPositionLeft = this.mWindowSpaceLeft;
            p.mPositionTop = this.mWindowSpaceTop;
            p.mSurfaceWidth = this.mSurfaceWidth;
            p.mSurfaceHeight = this.mSurfaceHeight;
            viewRoot2.addRawDrawHandlerOperation(new MinecraftDrawHandler.Operation(2, this.mDrawHandler));
        }
    }

    @RenderThread
    public static interface Renderer {
        public void onSurfaceChanged(int var1, int var2);

        public void onDraw(@Nonnull GuiGraphics var1, int var2, int var3, float var4, double var5, @FloatRange(from=0.0, to=1.0) float var7);
    }
}

